/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.plot2d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import javax.swing.JFrame;
import jsc.swt.plot.AxisModel;
import jsc.swt.plot.LinearAxisModel;
import jsc.swt.plot.PiAxisModel;
import jsc.swt.plot.PlotFunction;
import jsc.swt.plot2d.AxesPlot;
import jsc.swt.plot2d.PlotShape;
import jsc.swt.virtualgraphics.Path;
import jsc.util.Scale;

public class FunctionPlot2D
extends AxesPlot {
    public FunctionPlot2D(AxisModel axisModel, AxisModel axisModel2, String string) {
        super(axisModel, axisModel2, string);
    }

    public FunctionPlot2D(AxisModel axisModel, AxisModel axisModel2, double d, double d2, String string) {
        super(axisModel, axisModel2, d, d2, string);
    }

    public PlotShape addFunction(PlotFunction plotFunction, int n, Color color) {
        return this.addFunction(plotFunction, this.horizontalAxis.getMin(), this.horizontalAxis.getMax(), n, color, PlotShape.defaultStroke, PlotShape.defaultPaint, false);
    }

    public PlotShape addFunction(PlotFunction plotFunction, int n, Color color, Stroke stroke) {
        return this.addFunction(plotFunction, this.horizontalAxis.getMin(), this.horizontalAxis.getMax(), n, color, stroke, PlotShape.defaultPaint, false);
    }

    public PlotShape addFunction(PlotFunction plotFunction, double d, double d2, int n, Color color) {
        return this.addFunction(plotFunction, d, d2, n, color, PlotShape.defaultStroke, color, false);
    }

    public PlotShape addFunction(PlotFunction plotFunction, double d, double d2, int n, Color color, Stroke stroke) {
        return this.addFunction(plotFunction, d, d2, n, color, stroke, PlotShape.defaultPaint, false);
    }

    public PlotShape addFunction(PlotFunction plotFunction, double d, double d2, int n, Color color, boolean bl) {
        return this.addFunction(plotFunction, d, d2, n, color, PlotShape.defaultStroke, color, bl);
    }

    public PlotShape addFunction(PlotFunction plotFunction, double d, double d2, int n, Color color, Stroke stroke, Paint paint, boolean bl) {
        PlotShape plotShape;
        double d3 = (d2 - d) / ((double)n - 1.0);
        Path path = new Path(n);
        boolean bl2 = true;
        int n2 = 0;
        while (n2 < n) {
            double d4 = d + (double)n2 * d3;
            double d5 = plotFunction.getOrdinate(d4);
            if (Double.isNaN(d5)) {
                bl2 = true;
            } else if (bl2) {
                path.moveTo(d4, d5);
                bl2 = false;
            } else {
                path.lineTo(d4, d5);
            }
            ++n2;
        }
        if (bl) {
            path.lineTo(d2, 0.0);
            path.lineTo(d, 0.0);
            path.closePath();
            plotShape = new PlotShape((Shape)path, paint);
        } else {
            plotShape = new PlotShape(path, color, stroke);
        }
        this.addObject(plotShape);
        this.repaint();
        return plotShape;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 100;
            JFrame jFrame = new JFrame("FunctionPlot2D Test");
            PiAxisModel piAxisModel = new PiAxisModel("Angle", -5, 5, 2);
            LinearAxisModel linearAxisModel = new LinearAxisModel("", new Scale(-1.0, 1.0, 3, false), "##.#");
            FunctionPlot2D functionPlot2D = new FunctionPlot2D(piAxisModel, linearAxisModel, 0.0, 0.0, "Plot of sine and cosine functions");
            functionPlot2D.setZoomable(true);
            functionPlot2D.setFocusable(true);
            functionPlot2D.addFunction(new Sin(), n, Color.blue);
            functionPlot2D.addFunction(new Cos(), n, Color.red);
            Container container = jFrame.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)functionPlot2D, "Center");
            jFrame.setVisible(true);
            jFrame.setDefaultCloseOperation(3);
            jFrame.pack();
        }

        static class Sin
        implements PlotFunction {
            Sin() {
            }

            public double getOrdinate(double d) {
                return Math.sin(d);
            }
        }

        static class Cos
        implements PlotFunction {
            Cos() {
            }

            public double getOrdinate(double d) {
                return Math.cos(d);
            }
        }
    }
}

