/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.text;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import jsc.swt.text.RealFormat;
import jsc.swt.text.SigFigFormat;

public class MaxWidthFormat
extends RealFormat {
    int maxWidth;

    public MaxWidthFormat(int n) {
        this(n, Locale.getDefault());
    }

    public MaxWidthFormat(int n, Locale locale) {
        super(locale);
        this.decimalFormat.setMinimumIntegerDigits(1);
        this.setMaximumWidth(n);
    }

    public String format(double d) {
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (Math.abs(d) == 0.0) {
            return "0";
        }
        String string = this.decimalFormat.format(d);
        if (string.length() <= this.maxWidth) {
            return string;
        }
        int n = this.maxWidth;
        SigFigFormat sigFigFormat = new SigFigFormat(n);
        do {
            sigFigFormat.setSignificantDigits(n--);
        } while ((string = sigFigFormat.format(d)).length() > this.maxWidth);
        return string;
    }

    public Number parse(String string) throws ParseException {
        try {
            return this.decimalFormat.parse(string);
        }
        catch (ParseException parseException) {
            return this.scientificFormat.parse(string);
        }
    }

    public void setMaximumWidth(int n) {
        if (n < 7) {
            throw new IllegalArgumentException("Width must be at least 7.");
        }
        this.maxWidth = n;
        this.decimalFormat.setMaximumFractionDigits(n - 2);
        StringBuffer stringBuffer = new StringBuffer("0.");
        int n2 = 0;
        while (n2 < n - 6) {
            stringBuffer.append('#');
            ++n2;
        }
        stringBuffer.append("E0");
        this.scientificFormat.applyPattern(stringBuffer.toString());
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{1.0E-5, 1.2E-4, 0.00123, 0.01234, 0.12345, 0.123456, 1.23456, 12.3456, 12345.0, 123456.0, 100000.0, 0.0};
            int n = 7;
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setMaximumFractionDigits(16);
            decimalFormat.setMaximumIntegerDigits(16);
            MaxWidthFormat maxWidthFormat = new MaxWidthFormat(n);
            int n2 = 0;
            while (n2 < dArray.length) {
                int n3 = 0;
                while (n3 < 2) {
                    block4: {
                        Number number;
                        double d = n3 == 0 ? dArray[n2] : -dArray[n2];
                        String string = maxWidthFormat.format(d);
                        System.out.println(decimalFormat.format(d) + " formatted to " + n + " characters is " + string);
                        try {
                            number = maxWidthFormat.parse(string);
                        }
                        catch (ParseException parseException) {
                            System.out.println("Cannot parse " + string);
                            break block4;
                        }
                        System.out.println(" " + string + " parsed is " + decimalFormat.format(number.doubleValue()));
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }
}

