/*
 * Decompiled with CFR 0.152.
 */
package jsc.correlation;

import jsc.datastructures.PairedData;
import jsc.distributions.HotellingPabstS;
import jsc.tests.H1;
import jsc.tests.SignificanceTest;
import jsc.util.Rank;

public class SpearmanCorrelation
implements SignificanceTest {
    static final int N_EXACT = 10;
    private final int n;
    private final double r;
    private double S;
    private double SP;

    public SpearmanCorrelation(PairedData pairedData, H1 h1, double d, boolean bl) {
        this.n = pairedData.getN();
        Rank rank = new Rank(pairedData.getX(), d);
        Rank rank2 = new Rank(pairedData.getY(), d);
        double[] dArray = rank.getRanks();
        double[] dArray2 = rank2.getRanks();
        this.S = 0.0;
        int n = 0;
        while (n < this.n) {
            this.S += (dArray[n] - dArray2[n]) * (dArray[n] - dArray2[n]);
            ++n;
        }
        double d2 = this.n * this.n * this.n - this.n - rank.getCorrectionFactor1();
        double d3 = this.n * this.n * this.n - this.n - rank2.getCorrectionFactor1();
        this.r = (d2 + d3 - this.S * 12.0) / (2.0 * Math.sqrt(d2 * d3));
        this.SP = h1 == H1.LESS_THAN ? HotellingPabstS.upperTailProb(this.n, (int)Math.round(this.S), bl) : (h1 == H1.GREATER_THAN ? HotellingPabstS.lowerTailProb(this.n, (int)Math.round(this.S), bl) : (this.r < 0.0 ? 2.0 * HotellingPabstS.upperTailProb(this.n, (int)Math.round(this.S), bl) : (this.r > 0.0 ? 2.0 * HotellingPabstS.lowerTailProb(this.n, (int)Math.round(this.S), bl) : 1.0)));
        if (this.SP > 1.0) {
            this.SP = 1.0;
        }
    }

    public SpearmanCorrelation(PairedData pairedData, H1 h1, double d) {
        this(pairedData, h1, d, pairedData.getN() > 10);
    }

    public SpearmanCorrelation(PairedData pairedData, H1 h1) {
        this(pairedData, h1, 0.0, pairedData.getN() > 10);
    }

    public SpearmanCorrelation(PairedData pairedData) {
        this(pairedData, H1.NOT_EQUAL, 0.0, pairedData.getN() > 10);
    }

    public int getN() {
        return this.n;
    }

    public double getR() {
        return this.r;
    }

    public double getS() {
        return this.S;
    }

    public double getSP() {
        return this.SP;
    }

    public double getTestStatistic() {
        return this.r;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0};
            double[] dArray2 = new double[]{124.0, 117.0, 117.0, 120.0, 120.0, 114.0, 114.0};
            double[] dArray3 = new double[]{131.0, 125.0, 116.0, 113.0, 124.0, 118.0, 102.0};
            double[] dArray4 = new double[]{100.0, 97.0, 103.0, 108.0, 106.0, 95.0, 96.0};
            SpearmanCorrelation spearmanCorrelation = new SpearmanCorrelation(new PairedData(dArray, dArray2), H1.LESS_THAN);
            System.out.println("n = " + spearmanCorrelation.getN() + " r = " + spearmanCorrelation.getR() + " SP = " + spearmanCorrelation.getSP());
            spearmanCorrelation = new SpearmanCorrelation(new PairedData(dArray, dArray3), H1.LESS_THAN);
            System.out.println("n = " + spearmanCorrelation.getN() + " r = " + spearmanCorrelation.getR() + " SP = " + spearmanCorrelation.getSP());
            spearmanCorrelation = new SpearmanCorrelation(new PairedData(dArray, dArray4), H1.LESS_THAN);
            System.out.println("n = " + spearmanCorrelation.getN() + " r = " + spearmanCorrelation.getR() + " SP = " + spearmanCorrelation.getSP());
        }
    }
}

