/*
 * Decompiled with CFR 0.152.
 */
package jsc.descriptive;

import jsc.descriptive.AbstractFrequencyTable;
import jsc.descriptive.DoubleFrequencyTable;
import jsc.util.Scale;

public class FrequencyTable
extends AbstractFrequencyTable
implements DoubleFrequencyTable,
Cloneable {
    Scale scale;

    public FrequencyTable(String string, int n, double[] dArray) {
        this(string, n, dArray, false);
    }

    public FrequencyTable(String string, int n, double[] dArray, boolean bl) {
        super(string);
        this.numberOfBins = n;
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n2 = 0;
        while (n2 < dArray.length) {
            if (dArray[n2] < d) {
                d = dArray[n2];
            }
            if (dArray[n2] > d2) {
                d2 = dArray[n2];
            }
            ++n2;
        }
        this.scale = new Scale(d, d2, n + 1, true, false);
        if (this.scale.getStep() == 0.0) {
            throw new IllegalArgumentException("Constant data");
        }
        if (bl) {
            double d3 = 0.5 * this.scale.getStep();
            this.scale = new Scale(this.scale.getFirstTickValue() - d3, this.scale.getLastTickValue() + d3, n, false, false);
        }
        this.n = 0;
        this.freq = new int[n];
        n2 = 0;
        while (n2 < n) {
            this.freq[n2] = 0;
            ++n2;
        }
        n2 = 0;
        while (n2 < dArray.length) {
            this.addValue(dArray[n2]);
            ++n2;
        }
        if (this.n < 1) {
            throw new IllegalArgumentException("No data values.");
        }
    }

    public FrequencyTable(String string, double d, double d2, double d3) {
        super(string);
        if (d3 <= 0.0 || d2 <= d) {
            throw new IllegalArgumentException("Invalid bins");
        }
        this.numberOfBins = (int)Math.ceil((d2 - d) / d3);
        this.scale = new Scale(d, d2, this.numberOfBins + 1, false, false);
        this.n = 0;
        this.freq = new int[this.numberOfBins];
        int n = 0;
        while (n < this.numberOfBins) {
            this.freq[n] = 0;
            ++n;
        }
    }

    public FrequencyTable(String string, double d, double d2, double d3, double[] dArray) {
        super(string);
        if (d3 <= 0.0 || d2 <= d) {
            throw new IllegalArgumentException("Invalid bins");
        }
        this.numberOfBins = (int)Math.ceil((d2 - d) / d3);
        this.scale = new Scale(d, d2, this.numberOfBins + 1, false, false);
        this.n = 0;
        this.freq = new int[this.numberOfBins];
        int n = 0;
        while (n < this.numberOfBins) {
            this.freq[n] = 0;
            ++n;
        }
        n = 0;
        while (n < dArray.length) {
            this.addValue(dArray[n]);
            ++n;
        }
        if (this.n < 1) {
            throw new IllegalArgumentException("No data values.");
        }
    }

    public FrequencyTable(String string, double d, double d2, int[] nArray) {
        super(string);
        if (d2 <= d) {
            throw new IllegalArgumentException("Invalid bins");
        }
        this.numberOfBins = nArray.length;
        this.scale = new Scale(d, d2, this.numberOfBins + 1, false);
        this.n = 0;
        this.freq = new int[this.numberOfBins];
        int n = 0;
        while (n < this.numberOfBins) {
            this.freq[n] = nArray[n];
            this.n += nArray[n];
            ++n;
        }
        if (this.n < 1) {
            throw new IllegalArgumentException("No data values.");
        }
    }

    public int addValue(double d) {
        if (d >= this.scale.getFirstTickValue() && d <= this.scale.getLastTickValue()) {
            ++this.n;
            int n = (int)Math.floor((d - this.scale.getFirstTickValue()) / this.scale.getStep());
            if (n < 0) {
                n = 0;
            } else if (n >= this.numberOfBins) {
                n = this.numberOfBins - 1;
            }
            int n2 = n;
            this.freq[n2] = this.freq[n2] + 1;
            return n;
        }
        return -1;
    }

    public int addValues(double[] dArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            if (this.addValue(dArray[n2]) >= 0) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public double getBinWidth() {
        return this.scale.getStep();
    }

    public double getBoundary(int n) {
        return this.scale.getTickValue(n);
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("FrequencyTable can't clone");
        }
        return object;
    }

    public double getMaximumNormalizedFreq() {
        double d;
        int n = this.getMaximumFreq();
        if (n > 0 && (d = (double)this.n * this.scale.getStep()) > 0.0) {
            return (double)n / d;
        }
        return 1.0;
    }

    public double getNormalizedFrequency(int n) {
        double d = (double)this.n * this.scale.getStep();
        if (d > 0.0) {
            return (double)this.freq[n] / d;
        }
        return 0.0;
    }

    public Scale getScale() {
        return this.scale;
    }

    public double getScaleMax() {
        return this.scale.getLastTickValue();
    }

    public double getScaleMin() {
        return this.scale.getFirstTickValue();
    }

    public String toString() {
        return "FrequencyTable: " + super.toString() + " " + this.scale.toString();
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{39.0, 41.0, 41.0, 41.0, 41.0, 43.0, 43.0, 45.0, 45.0, 48.0, 69.0, 83.0, 83.0, 83.0, 83.0, 91.0, 179.0, 238.0, 241.0, 253.0, 47.0, 274.0, 280.0, 394.0, 501.0, 503.0, 509.0, 511.0, 513.0, 515.0, 518.0, 518.0, 520.0, 522.0, 522.0, 522.0, 525.0, 527.0, 527.0, 527.0, 529.0, 529.0, 531.0, 531.0, 533.0, 535.0, 538.0, 538.0, 541.0, 543.0, 545.0, 547.0, 547.0, 549.0, 549.0, 549.0, 549.0, 551.0, 553.0, 555.0, 555.0, 555.0, 557.0, 560.0, 560.0, 562.0, 564.0, 568.0, 570.0, 572.0, 574.0, 576.0, 579.0, 581.0, 583.0, 585.0, 578.0, 578.0, 589.0, 590.0, 592.0, 592.0, 596.0, 598.0, 598.0, 598.0, 301.0, 601.0, 606.0, 609.0, 611.0, 615.0, 617.0, 617.0, 619.0, 621.0, 623.0, 623.0, 626.0, 626.0, 628.0, 630.0, 630.0, 630.0, 630.0, 630.0, 632.0, 634.0, 636.0, 638.0, 640.0, 640.0, 642.0, 644.0, 644.0, 646.0, 648.0, 648.0, 648.0, 650.0, 652.0, 655.0, 657.0, 659.0, 661.0, 661.0, 663.0, 665.0, 670.0, 673.0, 675.0, 677.0, 679.0, 681.0, 683.0, 909.0, 911.0, 907.0, 555.0, 555.0, 692.0, 694.0, 657.0};
            FrequencyTable frequencyTable = new FrequencyTable("Table", 9, dArray, false);
            System.out.println("Frequency table " + frequencyTable.getN() + " values");
            int n = 0;
            while (n < frequencyTable.getNumberOfBins()) {
                System.out.println(frequencyTable.getBoundary(n) + " to " + frequencyTable.getBoundary(n + 1) + ", Freq = " + frequencyTable.getFrequency(n) + ", % = " + frequencyTable.getPercentage(n));
                ++n;
            }
        }
    }
}

