/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.AbstractDistribution;
import jsc.goodnessfit.KolmogorovTest;
import jsc.tests.H1;

public class Cauchy
extends AbstractDistribution {
    private double location;
    private double scale;

    public Cauchy(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.location = d;
        this.scale = d2;
    }

    public Cauchy() {
        this(0.0, 1.0);
    }

    public double cdf(double d) {
        return 0.5 + Math.atan((d - this.location) / this.scale) / Math.PI;
    }

    public double getLocation() {
        return this.location;
    }

    public double getScale() {
        return this.scale;
    }

    public double inverseCdf(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        if (d == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.location + this.scale * Math.tan(Math.PI * (d - 0.5));
    }

    public double mean() {
        return Double.NaN;
    }

    public double pdf(double d) {
        double d2 = (d - this.location) / this.scale;
        return 1.0 / (Math.PI * this.scale * (1.0 + d2 * d2));
    }

    public double random() {
        double d;
        while ((d = this.rand.nextGaussian()) == 0.0) {
        }
        return this.location + this.scale * (this.rand.nextGaussian() / d);
    }

    public String toString() {
        return new String("Cauchy distribution: location = " + this.location + ", scale = " + this.scale + ".");
    }

    public double variance() {
        return Double.NaN;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double d = 2.0;
            double d2 = 3.0;
            Cauchy cauchy = new Cauchy(d, d2);
            int n = 100000;
            cauchy = new Cauchy(2.0, 3.0);
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = cauchy.random();
                ++n2;
            }
            KolmogorovTest kolmogorovTest = new KolmogorovTest(dArray, cauchy, H1.NOT_EQUAL, false);
            System.out.println("n = " + n + " D = " + kolmogorovTest.getTestStatistic() + " SP = " + kolmogorovTest.getSP());
        }
    }
}

