/*
 * Decompiled with CFR 0.152.
 */
package jsc.numerical;

import jsc.numerical.Function;
import jsc.numerical.IntegratingFunction;

public class ExtendedTrapezoidalRule
implements IntegratingFunction {
    private double s;

    public double getIntegral(Function function, double d, double d2, int n) {
        if (n == 1) {
            this.s = 0.5 * (d2 - d) * (function.function(d) + function.function(d2));
            return this.s;
        }
        int n2 = 1;
        int n3 = 1;
        while (n3 < n - 1) {
            n2 <<= 1;
            ++n3;
        }
        double d3 = n2;
        double d4 = (d2 - d) / d3;
        double d5 = d + 0.5 * d4;
        double d6 = 0.0;
        n3 = 1;
        while (n3 <= n2) {
            d6 += function.function(d5);
            ++n3;
            d5 += d4;
        }
        this.s = 0.5 * (this.s + (d2 - d) * d6 / d3);
        return this.s;
    }
}

