/*
 * Decompiled with CFR 0.152.
 */
package jsc.onesample;

import jsc.descriptive.MeanVar;
import jsc.distributions.StudentsT;
import jsc.tests.H1;
import jsc.tests.SignificanceTest;

public class Ttest
implements SignificanceTest {
    protected int n;
    private final double t;
    private final MeanVar mv;
    private final double SP;

    public Ttest(double[] dArray, double d, H1 h1) {
        this.mv = new MeanVar(dArray);
        this.n = this.mv.getN();
        this.t = (this.mv.getMean() - d) / (this.mv.getSd() / Math.sqrt(this.n));
        double d2 = StudentsT.tailProb(this.t, this.n - 1);
        this.SP = h1 == H1.NOT_EQUAL ? d2 + d2 : (h1 == H1.LESS_THAN ? (this.t < 0.0 ? d2 : 1.0 - d2) : (this.t > 0.0 ? d2 : 1.0 - d2));
    }

    public Ttest(double[] dArray, double d) {
        this(dArray, d, H1.NOT_EQUAL);
    }

    public double getMean() {
        return this.mv.getMean();
    }

    public int getN() {
        return this.n;
    }

    public double getSd() {
        return this.mv.getSd();
    }

    public double getSP() {
        return this.SP;
    }

    public double getStatistic() {
        return this.t;
    }

    public double getTestStatistic() {
        return this.t;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{4.9, 5.1, 4.6, 5.0, 5.1, 4.7, 4.4, 4.7, 4.6};
            double d = 5.0;
            Ttest ttest = new Ttest(dArray, d, H1.NOT_EQUAL);
            System.out.println("H1: mu <> " + d + " t = " + ttest.getTestStatistic() + " SP = " + ttest.getSP());
            Ttest ttest2 = new Ttest(dArray, d, H1.LESS_THAN);
            System.out.println("H1: mu < " + d + " t = " + ttest2.getTestStatistic() + " SP = " + ttest2.getSP());
            Ttest ttest3 = new Ttest(dArray, d, H1.GREATER_THAN);
            System.out.println("H1: mu > " + d + " t = " + ttest3.getTestStatistic() + " SP = " + ttest3.getSP());
        }
    }
}

