/*
 * Decompiled with CFR 0.152.
 */
package jsc.regression;

import jsc.datastructures.PairedData;
import jsc.regression.PearsonCorrelation;
import jsc.util.Rank;

public class ImanConoverMonotonic {
    private final int n;
    private final double a;
    private final double b;
    private final double[] x;
    private final double[] y;
    private final double[] py;
    private final Rank rankX;
    private final Rank rankY;

    public ImanConoverMonotonic(PairedData pairedData) {
        this.n = pairedData.getN();
        this.x = new double[this.n];
        this.y = new double[this.n];
        this.py = new double[this.n];
        System.arraycopy(pairedData.getX(), 0, this.x, 0, this.n);
        System.arraycopy(pairedData.getY(), 0, this.y, 0, this.n);
        this.rankX = new Rank(this.x, 0.0);
        this.rankY = new Rank(this.y, 0.0);
        double[] dArray = this.rankX.getRanks();
        double[] dArray2 = this.rankY.getRanks();
        int[] nArray = this.rankY.getSortIndexes();
        PearsonCorrelation pearsonCorrelation = new PearsonCorrelation(new PairedData(dArray, dArray2));
        this.b = pearsonCorrelation.getR();
        this.a = 0.5 * ((double)this.n + 1.0) * (1.0 - this.b);
        int n = 0;
        while (n < this.n) {
            double d = this.b * dArray[n] + this.a;
            this.py[n] = this.interpol(this.n, d, dArray2, this.y, nArray);
            ++n;
        }
    }

    public int getN() {
        return this.n;
    }

    public double[] getPredY() {
        return this.py;
    }

    public double getPredY(double d) {
        double d2 = this.interpol(this.n, d, this.x, this.rankX.getRanks(), this.rankX.getSortIndexes());
        double d3 = this.b * d2 + this.a;
        return this.interpol(this.n, d3, this.rankY.getRanks(), this.y, this.rankY.getSortIndexes());
    }

    public Rank getRankX() {
        return this.rankX;
    }

    public Rank getRankY() {
        return this.rankY;
    }

    public double getSortedPredY(int n) {
        return this.py[this.rankX.getSortIndex(n)];
    }

    public double getSortedResidual(int n) {
        int n2 = this.rankX.getSortIndex(n);
        return this.y[n2] - this.py[n2];
    }

    public double getSortedX(int n) {
        return this.x[this.rankX.getSortIndex(n)];
    }

    public double[] getX() {
        return this.x;
    }

    public double[] getY() {
        return this.y;
    }

    public double getSpearmanCoeff() {
        return this.b;
    }

    double interpol(int n, double d, double[] dArray, double[] dArray2, int[] nArray) {
        if (n < 1) {
            throw new IllegalArgumentException("No data");
        }
        int n2 = nArray[0];
        int n3 = nArray[n - 1];
        if (d < dArray[n2]) {
            return dArray2[n2];
        }
        if (d > dArray[n3]) {
            return dArray2[n3];
        }
        if (d == dArray[n2]) {
            return dArray2[n2];
        }
        int n4 = 1;
        while (n4 < n) {
            n2 = nArray[n4 - 1];
            n3 = nArray[n4];
            if (dArray[n2] > dArray[n3]) {
                throw new IllegalArgumentException("X-values not in ascending order.");
            }
            if (d <= dArray[n3]) {
                return dArray2[n2] + (dArray2[n3] - dArray2[n2]) * (d - dArray[n2]) / (dArray[n3] - dArray[n2]);
            }
            ++n4;
        }
        return dArray2[n3];
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{104.0, 161.0, 156.0, 96.0, 149.0, 143.0, 113.0, 142.0, 115.0, 175.0, 135.0, 145.0, 137.0, 151.0, 126.0};
            double[] dArray2 = new double[]{25.0, 47.0, 40.0, 17.0, 49.0, 39.0, 33.0, 30.0, 31.0, 44.0, 34.0, 43.0, 35.0, 42.0, 36.0};
            ImanConoverMonotonic imanConoverMonotonic = new ImanConoverMonotonic(new PairedData(dArray, dArray2));
            System.out.println("n = " + imanConoverMonotonic.getN());
            System.out.println("Spearman coeff = " + imanConoverMonotonic.getSpearmanCoeff());
            int n = 0;
            while (n < imanConoverMonotonic.getN()) {
                System.out.println("X = " + imanConoverMonotonic.getSortedX(n) + " Y = " + imanConoverMonotonic.getSortedPredY(n));
                ++n;
            }
            double d = 120.0;
            System.out.println("Estimated Y for x = " + d + " is " + imanConoverMonotonic.getPredY(d));
        }
    }
}

