/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.plot2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import jsc.swt.plot2d.PlotObject;
import jsc.swt.virtualgraphics.VPoint;
import jsc.swt.virtualgraphics.VirtualTransform;

public abstract class Marker
implements PlotObject {
    static Color defaultColour = Color.black;
    static int defaultSize = 7;
    static Stroke defaultStroke = new BasicStroke();
    boolean filled = false;
    VPoint p;
    int size;
    float halfSize;
    Color colour;
    Stroke stroke;

    public Marker(VPoint vPoint) {
        this(vPoint, defaultSize, defaultColour, defaultStroke);
    }

    public Marker(VPoint vPoint, int n) {
        this(vPoint, n, defaultColour, defaultStroke);
    }

    public Marker(VPoint vPoint, int n, Color color) {
        this(vPoint, n, color, defaultStroke);
    }

    public Marker(VPoint vPoint, int n, Color color, Stroke stroke) {
        this.p = vPoint;
        this.setSize(n);
        this.colour = color;
        this.stroke = stroke;
    }

    public boolean contains(Point2D point2D, VirtualTransform virtualTransform) {
        Point2D.Float float_ = new Point2D.Float();
        virtualTransform.transform(point2D, float_);
        return this.getBoundary(float_).contains(point2D);
    }

    public void draw(Graphics2D graphics2D, VirtualTransform virtualTransform) {
        Point2D.Float float_ = new Point2D.Float();
        virtualTransform.transform(this.p, float_);
        graphics2D.setColor(this.colour);
        graphics2D.setStroke(this.stroke);
        if (this.filled) {
            graphics2D.fill(this.getShape(float_));
        } else {
            graphics2D.draw(this.getShape(float_));
        }
    }

    public Shape getBoundary(Point2D.Float float_) {
        Shape shape = this.getShape(float_);
        if (shape instanceof GeneralPath) {
            return shape.getBounds2D();
        }
        return shape;
    }

    public Color getColour() {
        return this.colour;
    }

    public void setColour(Color color) {
        this.colour = color;
    }

    public VPoint getLocation() {
        return this.p;
    }

    public void setLocation(VPoint vPoint) {
        this.p = vPoint;
    }

    public abstract Shape getShape(Point2D.Float var1);

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
        this.halfSize = 0.5f * (float)n;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setFilled(boolean bl) {
        this.filled = bl;
    }

    public void setType(int n) {
    }

    public static void setDefaultColour(Color color) {
        defaultColour = color;
    }

    public static void setDefaultSize(int n) {
        defaultSize = n;
    }

    public static void setDefaultStroke(Stroke stroke) {
        defaultStroke = stroke;
    }
}

