/*
 * Decompiled with CFR 0.152.
 */
package jsc.util;

public class Scale {
    private int n;
    private boolean extend;
    private double step;
    private double valmin;
    private double valmax;

    public Scale() {
        this(0.0, 1.0, 2, false, false);
    }

    public Scale(double d, double d2, int n, boolean bl) {
        this(d, d2, n, bl, false);
    }

    public Scale(double d, double d2, int n, boolean bl, boolean bl2) {
        this.extend = bl;
        if (bl) {
            this.scale(n, d, d2, bl2);
        } else {
            if (d2 <= d || n <= 1) {
                throw new IllegalArgumentException("Invalid scale values.");
            }
            this.n = n;
            this.valmin = d;
            this.valmax = d2;
            this.step = (d2 - d) / ((double)n - 1.0);
        }
    }

    public double getFirstTickValue() {
        return this.valmin;
    }

    public double getLastTickValue() {
        return this.valmax;
    }

    public double getLength() {
        return this.extend ? this.valmax - this.valmin + this.step : this.valmax - this.valmin;
    }

    public double getMax() {
        return this.extend ? this.valmax + 0.5 * this.step : this.valmax;
    }

    public double getMin() {
        return this.extend ? this.valmin - 0.5 * this.step : this.valmin;
    }

    public int getNumberOfTicks() {
        return this.n;
    }

    public double getStep() {
        return this.step;
    }

    public double getTickValue(int n) {
        return this.valmin + (double)n * this.step;
    }

    public void scale(int n, double d, double d2, boolean bl) {
        double[] dArray = new double[]{1.0, 1.2, 1.6, 2.0, 2.5, 3.0, 4.0, 5.0, 6.0, 8.0, 10.0};
        int n2 = dArray.length;
        double[] dArray2 = new double[]{1.0, 2.0, 2.5, 5.0, 10.0};
        int n3 = dArray2.length;
        if (d2 < d || n <= 1) {
            throw new IllegalArgumentException("Invalid axis values.");
        }
        this.n = n;
        double d3 = n - 1;
        double d4 = Math.abs(d2);
        if (d4 == 0.0) {
            d4 = 1.0;
        }
        if ((d2 - d) / d4 <= 1.0E-8) {
            if (d2 < 0.0) {
                d2 = 0.0;
            } else if (d2 == 0.0) {
                d2 = 1.0;
            } else {
                d = 0.0;
            }
        }
        double d5 = this.step = (d2 - d) / d3;
        while (d5 < 1.0) {
            d5 *= 10.0;
        }
        while (d5 >= 10.0) {
            d5 /= 10.0;
        }
        d4 = d5 - 1.0E-4;
        if (bl) {
            int n4 = 0;
            while (n4 < n3) {
                if (d4 <= dArray2[n4]) break;
                ++n4;
            }
            this.step *= dArray2[n4] / d5;
        } else {
            int n5 = 0;
            while (n5 < n2) {
                if (d4 <= dArray[n5]) break;
                ++n5;
            }
            this.step *= dArray[n5] / d5;
        }
        double d6 = this.step * d3;
        d4 = 0.5 * (1.0 + (d + d2 - d6) / this.step);
        int n6 = (int)(d4 - 1.0E-4);
        if (d4 < 0.0) {
            --n6;
        }
        this.valmin = this.step * (double)n6;
        if (d >= 0.0 && d6 >= d2) {
            this.valmin = 0.0;
        }
        this.valmax = this.valmin + d6;
        if (d2 > 0.0 || d6 < -d) {
            return;
        }
        this.valmax = 0.0;
        this.valmin = -d6;
    }

    public String toString() {
        return "Scale: " + this.n + " tick marks at " + this.step + " intervals. Min = " + this.getMin() + ", max = " + this.getMax() + ". First tick mark at " + this.valmin + ". Last tick mark at " + this.valmax;
    }
}

