/*
 * Decompiled with CFR 0.152.
 */
package Graph;

import Graph.Node;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class CircleNode
implements Node {
    private int x = 0;
    private int y = 0;
    private int size = 20;
    private Color color;
    private static final int DEFAULT_SIZE = 20;

    public CircleNode(Color aColor) {
        this.color = aColor;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            return null;
        }
    }

    @Override
    public void draw(Graphics2D g2) {
        Ellipse2D.Double circle = new Ellipse2D.Double(this.x, this.y, this.size, this.size);
        Color oldColor = g2.getColor();
        g2.setColor(this.color);
        g2.fill(circle);
        g2.setColor(oldColor);
        g2.draw(circle);
    }

    @Override
    public void translate(double dx, double dy) {
        this.x = (int)((double)this.x + dx);
        this.y = (int)((double)this.y + dy);
    }

    @Override
    public boolean contains(Point2D p) {
        Ellipse2D.Double circle = new Ellipse2D.Double(this.x, this.y, this.size, this.size);
        return circle.contains(p);
    }

    @Override
    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(this.x, this.y, this.size, this.size);
    }

    @Override
    public Point2D getConnectionPoint(Point2D other) {
        double dy;
        double centerX = this.x + this.size / 2;
        double centerY = this.y + this.size / 2;
        double dx = other.getX() - centerX;
        double distance = Math.sqrt(dx * dx + (dy = other.getY() - centerY) * dy);
        if (distance == 0.0) {
            return other;
        }
        return new Point2D.Double(centerX + dx * (double)(this.size / 2) / distance, centerY + dy * (double)(this.size / 2) / distance);
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double(this.x, this.y);
    }
}

