/*
 * Decompiled with CFR 0.152.
 */
package Graph;

import Graph.Edge;
import Graph.Node;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class Graph
implements Serializable {
    private ArrayList nodes = new ArrayList();
    private ArrayList edges = new ArrayList();

    public boolean connect(Edge e, Point2D p1, Point2D p2) {
        Node n1 = this.findNode(p1);
        Node n2 = this.findNode(p2);
        if (n1 != null && n2 != null) {
            e.connect(n1, n2);
            this.edges.add(e);
            return true;
        }
        return false;
    }

    public boolean add(Node n, Point2D p) {
        Rectangle2D bounds = n.getBounds();
        n.translate(p.getX() - bounds.getX(), p.getY() - bounds.getY());
        this.nodes.add(n);
        return true;
    }

    public Node findNode(Point2D p) {
        int i = this.nodes.size() - 1;
        while (i >= 0) {
            Node n = (Node)this.nodes.get(i);
            if (n.contains(p)) {
                return n;
            }
            --i;
        }
        return null;
    }

    public Edge findEdge(Point2D p) {
        int i = this.edges.size() - 1;
        while (i >= 0) {
            Edge e = (Edge)this.edges.get(i);
            if (e.contains(p)) {
                return e;
            }
            --i;
        }
        return null;
    }

    public void draw(Graphics2D g2) {
        int i = 0;
        while (i < this.nodes.size()) {
            Node n = (Node)this.nodes.get(i);
            n.draw(g2);
            ++i;
        }
        i = 0;
        while (i < this.edges.size()) {
            Edge e = (Edge)this.edges.get(i);
            e.draw(g2);
            ++i;
        }
    }

    public void removeNode(Node n) {
        int i = this.edges.size() - 1;
        while (i >= 0) {
            Edge e = (Edge)this.edges.get(i);
            if (e.getStart() == n || e.getEnd() == n) {
                this.edges.remove(e);
            }
            --i;
        }
        this.nodes.remove(n);
    }

    public void removeEdge(Edge e) {
        this.edges.remove(e);
    }

    public Rectangle2D getBounds(Graphics2D g2) {
        Rectangle2D r = null;
        int i = 0;
        while (i < this.nodes.size()) {
            Node n = (Node)this.nodes.get(i);
            Rectangle2D b = n.getBounds();
            if (r == null) {
                r = b;
            } else {
                r.add(b);
            }
            ++i;
        }
        i = 0;
        while (i < this.edges.size()) {
            Edge e = (Edge)this.edges.get(i);
            r.add(e.getBounds(g2));
            ++i;
        }
        return r == null ? new Rectangle2D.Double() : r;
    }

    public abstract Node[] getNodePrototypes();

    public abstract Edge[] getEdgePrototypes();

    public List getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public List getEdges() {
        return Collections.unmodifiableList(this.edges);
    }
}

