/*
 * Decompiled with CFR 0.152.
 */
package PBN;

import PBN.BitSetPBN;
import PBN.PBN;
import PBN.StateBit;
import functionLib.AssaException;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import parser.Model;

public class BDDPBN
extends BitSetPBN {
    private Model model;
    private boolean JDDinitialised = false;
    private JDDVars vars;
    private JDDNode cube;

    public BDDPBN(int n) {
        super(n);
        this.initialiseJDD();
    }

    public BDDPBN(Model model) {
        BitSetPBN pbn = null;
        try {
            pbn = model.convertToBitSetPBN();
        }
        catch (AssaException e) {
            e.printStackTrace();
        }
        this.setN(pbn.getN());
        this.setNf(pbn.getNf());
        this.setNv(pbn.getNv());
        this.setPerturbation(pbn.getPerturbation());
        this.setF(pbn.getF());
        this.setvarF(pbn.getVarF());
        this.setCij(pbn.getCij());
        this.setModel(model);
        this.setNpNode(pbn.npNode());
        pbn = null;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public Model getModel() {
        return this.model;
    }

    public void initialiseJDD() {
        this.vars = new JDDVars();
        int i = 0;
        while (i < this.n) {
            this.vars.addVar(JDD.Var(i));
            ++i;
        }
        this.JDDinitialised = true;
    }

    public void closeJDD() {
        if (this.vars != null) {
            this.vars.derefAll();
        }
        this.JDDinitialised = false;
    }

    public boolean getNextNodeValueBDD(int indexVarF, StateBit currentState) {
        if (!this.JDDinitialised) {
            this.initialiseJDD();
        }
        int[] elementVarFInt = (int[])this.varFInt.get(indexVarF);
        this.cube = null;
        this.cube = currentState.get(elementVarFInt[0]) ? JDD.Var(elementVarFInt[0]) : JDD.Not(JDD.Var(elementVarFInt[0]));
        int i = 1;
        while (i < elementVarFInt.length) {
            this.cube = currentState.get(elementVarFInt[i]) ? JDD.And(this.cube, JDD.Var(elementVarFInt[i])) : JDD.And(this.cube, JDD.Not(JDD.Var(elementVarFInt[i])));
            ++i;
        }
        JDDNode function = this.model.getBDDFunctions().getVar(indexVarF);
        JDD.Ref(function);
        this.cube = JDD.Restrict(function, this.cube);
        boolean res = this.cube.getValue() > 0.5;
        JDD.Deref(this.cube);
        return res;
    }

    @Override
    public PBN copy() {
        try {
            return this.model.convertToBDDPBN();
        }
        catch (AssaException e) {
            e.printStackTrace();
            return null;
        }
    }
}

