/*
 * Decompiled with CFR 0.152.
 */
package PBN;

import PBN.BitSetEngine;
import PBN.PBN;
import PBN.StateBit;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import simulator.AliasMethod;

public class BitSetEngineBDD
extends BitSetEngine {
    public BitSetEngineBDD(PBN pbn) {
        super(pbn);
    }

    @Override
    public int pbnNextState(StateBit st) throws Exception {
        int n = this.pbn.getN();
        if (st.getN() != n) {
            throw new Exception("State size does not coinside with the PBN!");
        }
        this.copySt.clear();
        this.copySt.or(st);
        boolean perturbation = false;
        List<Integer> npNode = this.pbn.npNode();
        int start = 0;
        for (int element : npNode) {
            int i = start;
            while (i < element) {
                if (this.pbn.getPerturbation() > ThreadLocalRandom.current().nextDouble()) {
                    st.flip(i);
                    perturbation = true;
                }
                ++i;
            }
            start = element + 1;
        }
        if (perturbation) {
            return 1;
        }
        this.generateAlias();
        int[] cumNf = this.pbn.buildCumNf();
        int indexCij = 0;
        int i = 0;
        while (i < n) {
            AliasMethod alias = (AliasMethod)this.aliasMethodList.get(i);
            indexCij = alias.next();
            st.set(i, this.pbn.getNextNodeValue(cumNf[i] + indexCij, this.copySt));
            ++i;
        }
        return 1;
    }
}

