/*
 * Decompiled with CFR 0.152.
 */
package PBN;

import PBN.BitSetEngine;
import PBN.OptimizePBN;
import PBN.PBN;
import PBN.StateBit;
import functionLib.Parameters;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import jdd.JDDNode;
import jdd.JDDPBN;
import jdd.JDDVars;
import simulator.AliasMethod;

public class BitSetEnginePara
extends BitSetEngine {
    private static int numLeaves;
    private double noPerturbation;
    private static List<StateBit[]> groupState;
    private static List<short[]> groupFunctionIndex;
    private static List<int[]> varGroup;
    private static List<AliasMethod> amList;
    private int num_groups;
    private static int[] groupCijSize;
    private static int[] cumGroupCijSize;
    private static int[] cumGroup;
    private int numOneFunction = 0;
    private int numOneFunctionGroup = 0;
    private int sizeOneFunctionGroup = 10;
    private int sizeLastFunctionGroup = 10;
    private static List<int[]> varOneFunctionGroup;
    private static List<short[]> groupOneFunctionIndex;
    private static List<StateBit[]> groupOneFunctionState;
    private int groupFunctionStore = 0;
    private static JDDVars groupFunctionBDD;
    private int[][] P_shift;
    private int[] P_statearrayIndex;
    private JDDNode cube;
    private final int generateSteps = 100;
    private int[][][] P_next;
    private int[][][] F_next;
    private int nextIndex = 0;
    private int numParallel = Parameters.NUM_PARALLEL;
    long[][] globalStatearray;
    StateBit copystate;
    int[] para;
    private static JDDVars oneFunctionBDD;

    public BitSetEnginePara(PBN pbn) {
        super(pbn);
    }

    public void setNumLeaves(int numLeaves) {
        BitSetEnginePara.numLeaves = numLeaves;
        this.noPerturbation = Math.pow(1.0 - this.pbn.getPerturbation(), numLeaves);
    }

    @Override
    public void initialiseStateArray() {
    }

    public void setPara(OptimizePBN opt) {
        groupState = opt.getGroupState();
        groupFunctionIndex = opt.getGroupFunctionIndex();
        this.groupFunctionStore = opt.getGroupFunctionStore();
        varGroup = opt.getVarGroup();
        amList = opt.getAmList();
        this.num_groups = opt.getNumGroups();
        groupCijSize = opt.getGroupCijSize();
        if (groupCijSize != null) {
            cumGroupCijSize = new int[groupCijSize.length + 1];
            BitSetEnginePara.cumGroupCijSize[0] = 0;
            int i = 1;
            while (i < cumGroupCijSize.length) {
                BitSetEnginePara.cumGroupCijSize[i] = cumGroupCijSize[i - 1] + groupCijSize[i - 1];
                ++i;
            }
        }
        cumGroup = opt.getCumGroup();
        this.numOneFunctionGroup = opt.getNumOneFunctionGroup();
        this.sizeOneFunctionGroup = opt.getSizeOneFunctionGroup();
        this.sizeLastFunctionGroup = opt.getSizeLastFunctionGroup();
        varOneFunctionGroup = opt.getVarOneFunctionGroup();
        groupOneFunctionIndex = opt.getGroupOneFunctionIndex();
        groupOneFunctionState = opt.getGroupOneFunctionState();
        groupFunctionBDD = opt.getGroupFunctionBDD();
        oneFunctionBDD = opt.oneFunctionBDD;
        this.sizeStateArray = (int)Math.ceil((double)this.pbn.getN() / 64.0);
        this.shift = new int[this.num_groups + this.numOneFunctionGroup][2];
        this.statearrayIndex = new int[this.num_groups + this.numOneFunctionGroup + 1];
        int index = 0;
        int sum = 0;
        int count64 = 0;
        int i = 0;
        while (i < this.num_groups) {
            if ((sum += cumGroup[i + 1] - cumGroup[i]) > 64) {
                this.statearrayIndex[i] = index++;
                this.shift[i][0] = cumGroup[i] - count64 * 64;
                this.shift[i][1] = cumGroup[i + 1] - cumGroup[i] - (sum -= 64);
                ++count64;
            } else if (sum == 64) {
                sum -= 64;
                this.statearrayIndex[i] = index++;
                this.shift[i][0] = cumGroup[i] - count64 * 64;
                ++count64;
            } else {
                this.statearrayIndex[i] = index;
                this.shift[i][0] = cumGroup[i] - count64 * 64;
                this.shift[i][1] = 0;
            }
            ++i;
        }
        int begin = 0;
        begin = cumGroup == null ? 0 : cumGroup[this.num_groups];
        int i2 = 0;
        while (i2 < this.numOneFunctionGroup - 1) {
            if ((sum += this.sizeOneFunctionGroup) > 64) {
                this.statearrayIndex[i2 + this.num_groups] = index++;
                this.shift[i2 + this.num_groups][0] = begin + i2 * this.sizeOneFunctionGroup - count64 * 64;
                this.shift[i2 + this.num_groups][1] = this.sizeOneFunctionGroup - (sum -= 64);
                ++count64;
            } else if (sum == 64) {
                sum -= 64;
                this.statearrayIndex[i2 + this.num_groups] = index++;
                this.shift[i2 + this.num_groups][0] = begin + i2 * this.sizeOneFunctionGroup - count64 * 64;
                ++count64;
            } else {
                this.statearrayIndex[i2 + this.num_groups] = index;
                this.shift[i2 + this.num_groups][0] = begin + i2 * this.sizeOneFunctionGroup - count64 * 64;
            }
            ++i2;
        }
        i2 = this.numOneFunctionGroup - 1 + this.num_groups;
        if ((sum += this.sizeLastFunctionGroup) > 64) {
            this.statearrayIndex[i2] = index++;
            this.shift[i2][0] = begin + (i2 - this.num_groups) * this.sizeOneFunctionGroup - count64 * 64;
            this.shift[i2][1] = this.sizeLastFunctionGroup - (sum -= 64);
            ++count64;
        } else if (sum == 64) {
            sum -= 64;
            this.statearrayIndex[i2] = index++;
            this.shift[i2][0] = begin + (i2 - this.num_groups) * this.sizeOneFunctionGroup - count64 * 64;
            ++count64;
        } else {
            this.statearrayIndex[i2] = index;
            this.shift[i2][0] = begin + (i2 - this.num_groups) * this.sizeOneFunctionGroup - count64 * 64;
        }
        this.statearrayIndex[i2 + 1] = index;
        this.P_shift = new int[this.pbn.getP_groupNum()][2];
        this.P_statearrayIndex = new int[this.pbn.getP_groupNum() + 1];
        sum = 0;
        index = 0;
        i2 = 0;
        while (i2 < this.pbn.getP_groupNum() - 1) {
            this.P_shift[i2][0] = i2 * Parameters.P_GROUPSIZE % 64;
            if ((sum += Parameters.P_GROUPSIZE) > 64) {
                this.P_shift[i2][1] = Parameters.P_GROUPSIZE - (sum -= 64);
            } else if (sum == 64) {
                sum -= 64;
                this.P_shift[i2][1] = 0;
                ++index;
            } else {
                this.P_shift[i2][1] = 0;
            }
            this.P_statearrayIndex[i2] = ++index;
            ++i2;
        }
        this.P_shift[i2][0] = i2 * Parameters.P_GROUPSIZE % 64;
        if ((sum += this.pbn.getP_lastSize()) > 64) {
            this.P_shift[i2][1] = this.pbn.getP_lastSize() - (sum -= 64);
        } else if (sum == 64) {
            sum -= 64;
            this.P_shift[i2][1] = 0;
            ++index;
        } else {
            this.P_shift[i2][1] = 0;
        }
        this.P_statearrayIndex[this.pbn.getP_groupNum()] = ++index;
        this.P_next = new int[100][this.numParallel][this.pbn.getP_groupNum()];
        this.F_next = new int[100][this.numParallel][this.num_groups];
        this.globalStatearray = new long[this.numParallel][this.sizeStateArray];
        this.copystate = new StateBit(this.pbn.getN());
        this.para = new int[this.numParallel];
        if (opt.getGroupFunctionStore() == 1) {
            JDDPBN.initialiseJDD(this.num_groups, this.numOneFunctionGroup, groupFunctionBDD, oneFunctionBDD, cumGroupCijSize);
            JDDPBN.initialiseStateArray(this.shift, this.statearrayIndex);
        }
        this.generateRandom();
    }

    public int pbnNextStateBack(StateBit st) throws Exception {
        StateBit[] stsElement;
        int next;
        int n = this.pbn.getN();
        if (st.getN() != n) {
            throw new Exception("State size does not coinside with the PBN!");
        }
        boolean perturbation = false;
        int groupSize = this.pbn.getP_groupNum() - 1;
        int firstSize = (int)Math.pow(2.0, this.pbn.getP_firstSize());
        int[] Mask = this.pbn.getP_Mask();
        List<StateBit[]> sts = this.pbn.getSts();
        AliasMethod am = this.pbn.getPAm();
        int i = 0;
        while (i < groupSize) {
            next = am.next() & Mask[i];
            if (next != 0) {
                perturbation = true;
                stsElement = sts.get(i);
                st.xor(stsElement[next]);
            }
            ++i;
        }
        next = am.next();
        if ((next &= Mask[groupSize]) != 0) {
            perturbation = true;
            stsElement = sts.get(groupSize);
            st.xor(stsElement[next]);
        }
        if (perturbation) {
            return 1;
        }
        if (ThreadLocalRandom.current().nextDouble() > this.noPerturbation) {
            return 0;
        }
        StateBit copySt = (StateBit)st.clone();
        this.generateAlias();
        int[] cumNf = this.pbn.buildCumNf();
        int i2 = 0;
        while (i2 < n) {
            st.set(i2, this.pbn.getNextNodeValue(cumNf[i2] + ((AliasMethod)this.aliasMethodList.get(i2)).next(), copySt));
            ++i2;
        }
        return 1;
    }

    public int pbnNextStatePara1(StateBit st) throws Exception {
        StateBit[] stsElement;
        int next;
        int n = this.pbn.getN();
        if (st.getN() != n) {
            throw new Exception("State size does not coinside with the PBN!");
        }
        boolean perturbation = false;
        int groupSize = this.pbn.getP_groupNum() - 1;
        int firstSize = (int)Math.pow(2.0, this.pbn.getP_firstSize());
        int[] Mask = this.pbn.getP_Mask();
        List<StateBit[]> sts = this.pbn.getSts();
        AliasMethod am = this.pbn.getPAm();
        int i = 0;
        while (i < groupSize) {
            next = am.next() & Mask[i];
            if (next != 0) {
                perturbation = true;
                stsElement = sts.get(i);
                st.xor(stsElement[next]);
            }
            ++i;
        }
        next = am.next();
        if ((next &= Mask[groupSize]) != 0) {
            perturbation = true;
            stsElement = sts.get(groupSize);
            st.xor(stsElement[next]);
        }
        if (perturbation) {
            return 1;
        }
        if (ThreadLocalRandom.current().nextDouble() > this.noPerturbation) {
            return 0;
        }
        StateBit copySt = (StateBit)st.clone();
        st.clear();
        this.generateAlias();
        int[] cumNf = this.pbn.buildCumNf();
        int i2 = 0;
        while (i2 < this.num_groups) {
            am = amList.get(i2);
            int indexF = cumGroupCijSize[i2] + am.next();
            int total = cumGroupCijSize[i2 + 1] - cumGroupCijSize[i2];
            int j = cumGroup[i2];
            while (j < cumGroup[i2 + 1]) {
                int nextIndex = indexF / (total /= this.pbn.getNf()[j]);
                indexF %= total;
                st.set(j, this.pbn.getNextNodeValue(cumNf[j] + nextIndex, copySt));
                ++j;
            }
            ++i2;
        }
        i2 = cumGroup[this.num_groups];
        while (i2 < n) {
            st.set(i2, this.pbn.getNextNodeValue(cumNf[i2] + ((AliasMethod)this.aliasMethodList.get(i2)).next(), copySt));
            ++i2;
        }
        return 1;
    }

    private void generateRandom() {
        AliasMethod am = this.pbn.getPAm();
        int i = 0;
        while (i < 100) {
            int k = 0;
            while (k < this.numParallel) {
                int j = 0;
                while (j < this.pbn.getP_groupNum()) {
                    this.P_next[i][k][j] = am.next();
                    ++j;
                }
                ++k;
            }
            ++i;
        }
        int j = 0;
        while (j < this.num_groups) {
            am = amList.get(j);
            int i2 = 0;
            while (i2 < 100) {
                int k = 0;
                while (k < this.numParallel) {
                    this.F_next[i2][k][j] = am.next() + cumGroupCijSize[j];
                    ++k;
                }
                ++i2;
            }
            ++j;
        }
    }

    public int pbnNextState_newOld(StateBit st) throws Exception {
        long resu;
        if (this.groupFunctionStore == 0) {
            return this.pbnNextStateSPARSELongArray(st);
        }
        int n = this.pbn.getN();
        if (st.getN() != n) {
            throw new Exception("State size does not coinside with the PBN!");
        }
        long[] statearray = new long[this.sizeStateArray];
        boolean perturbation = false;
        int groupSize = this.pbn.getP_groupNum() - 1;
        int[] Mask = this.pbn.getP_Mask();
        AliasMethod am = this.pbn.getPAm();
        int[] next = new int[groupSize + 1];
        int i = 0;
        while (i < groupSize) {
            next[i] = am.next() & Mask[i];
            ++i;
        }
        i = 0;
        while (i < groupSize) {
            if (next[i] != 0) {
                perturbation = true;
                statearray[this.P_statearrayIndex[i]] = statearray[this.P_statearrayIndex[i]] | (long)next[i] << this.P_shift[i][0];
                if (this.P_shift[i][1] != 0) {
                    statearray[this.P_statearrayIndex[i + 1]] = statearray[this.P_statearrayIndex[i + 1]] | (long)next[i] >> this.P_shift[i][1];
                }
            }
            ++i;
        }
        next[groupSize] = next[groupSize] & Mask[groupSize];
        if (next[groupSize] != 0) {
            perturbation = true;
            statearray[this.P_statearrayIndex[groupSize]] = statearray[this.P_statearrayIndex[groupSize]] | (long)next[groupSize] << this.P_shift[groupSize][0];
            if (this.P_shift[groupSize][1] != 0) {
                statearray[this.P_statearrayIndex[groupSize + 1]] = statearray[this.P_statearrayIndex[groupSize + 1]] | (long)next[groupSize] >> this.P_shift[groupSize][1];
            }
        }
        if (perturbation) {
            st.xor(StateBit.valueOf(statearray));
            return 1;
        }
        if (ThreadLocalRandom.current().nextDouble() > this.noPerturbation) {
            return 0;
        }
        long[] state = st.toLongArray();
        int i2 = 0;
        while (i2 < this.num_groups) {
            am = amList.get(i2);
            int indexF = cumGroupCijSize[i2] + am.next();
            resu = (long)JDDPBN.GetValue(groupFunctionBDD.getVar(indexF), state);
            statearray[this.statearrayIndex[i2]] = statearray[this.statearrayIndex[i2]] | resu << this.shift[i2][0];
            if (this.shift[i2][1] != 0) {
                statearray[this.statearrayIndex[i2 + 1]] = statearray[this.statearrayIndex[i2 + 1]] | resu >> this.shift[i2][1];
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.numOneFunctionGroup) {
            short[] elementGroupFunction = groupOneFunctionIndex.get(i3);
            int[] parents = varOneFunctionGroup.get(i3);
            int indexF = 0;
            int j = 0;
            while (j < parents.length) {
                if (st.get(parents[j])) {
                    indexF |= 1 << j;
                }
                ++j;
            }
            resu = elementGroupFunction[indexF];
            int index = i3 + this.num_groups;
            statearray[this.statearrayIndex[index]] = statearray[this.statearrayIndex[index]] | resu << this.shift[index][0];
            if (this.shift[index][1] != 0) {
                statearray[this.statearrayIndex[index + 1]] = statearray[this.statearrayIndex[index + 1]] | resu >> this.shift[index][1];
            }
            ++i3;
        }
        st.clear();
        st.or(StateBit.valueOf(statearray));
        return 1;
    }

    public int[] pbnNextState(StateBit[] sts) {
        ++this.nextIndex;
        if (this.nextIndex == 100) {
            this.nextIndex = 0;
            this.generateRandom();
        }
        boolean[] perturbation = new boolean[this.numParallel];
        int groupSize = this.pbn.getP_groupNum() - 1;
        int[] Mask = this.pbn.getP_Mask();
        int i = 0;
        while (i < this.numParallel) {
            int j = 0;
            while (j < this.sizeStateArray) {
                this.globalStatearray[i][j] = 0L;
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < this.numParallel) {
            int i2 = 0;
            while (i2 < groupSize) {
                this.P_next[this.nextIndex][j][i2] = this.P_next[this.nextIndex][j][i2] & Mask[i2];
                if (this.P_next[this.nextIndex][j][i2] != 0) {
                    perturbation[j] = true;
                    this.globalStatearray[j][this.P_statearrayIndex[i2]] = this.globalStatearray[j][this.P_statearrayIndex[i2]] | (long)this.P_next[this.nextIndex][j][i2] << this.P_shift[i2][0];
                }
                if (this.P_shift[i2][1] != 0) {
                    this.globalStatearray[j][this.P_statearrayIndex[i2 + 1]] = this.globalStatearray[j][this.P_statearrayIndex[i2 + 1]] | (long)this.P_next[this.nextIndex][j][i2] >> this.P_shift[i2][1];
                }
                ++i2;
            }
            this.P_next[this.nextIndex][j][groupSize] = this.P_next[this.nextIndex][j][groupSize] & Mask[groupSize];
            if (this.P_next[this.nextIndex][j][groupSize] != 0) {
                perturbation[j] = true;
                this.globalStatearray[j][this.P_statearrayIndex[groupSize]] = this.globalStatearray[j][this.P_statearrayIndex[groupSize]] | (long)this.P_next[this.nextIndex][j][groupSize] << this.P_shift[groupSize][0];
                if (this.P_shift[groupSize][1] != 0) {
                    this.globalStatearray[j][this.P_statearrayIndex[groupSize + 1]] = this.globalStatearray[j][this.P_statearrayIndex[groupSize + 1]] | (long)this.P_next[this.nextIndex][j][groupSize] >> this.P_shift[groupSize][1];
                }
            }
            ++j;
        }
        int j2 = 0;
        while (j2 < this.numParallel) {
            if (perturbation[j2]) {
                sts[j2].xor(StateBit.valueOf(this.globalStatearray[j2]));
                this.para[j2] = 1;
            } else if (ThreadLocalRandom.current().nextDouble() > this.noPerturbation) {
                this.para[j2] = 0;
                perturbation[j2] = true;
            } else {
                this.para[j2] = 1;
                int i3 = 0;
                while (i3 < this.num_groups) {
                    int indexF = this.F_next[this.nextIndex][j2][i3];
                    int[] parents = varGroup.get(indexF);
                    int indexF1 = 0;
                    int l = 0;
                    while (l < parents.length) {
                        if (sts[j2].get(parents[l])) {
                            indexF1 |= 1 << l;
                        }
                        ++l;
                    }
                    short[] elementGroupFunction = groupFunctionIndex.get(indexF);
                    long resu = elementGroupFunction[indexF1];
                    this.globalStatearray[j2][this.statearrayIndex[i3]] = this.globalStatearray[j2][this.statearrayIndex[i3]] | resu << this.shift[i3][0];
                    if (this.shift[i3][1] != 0) {
                        this.globalStatearray[j2][this.statearrayIndex[i3 + 1]] = this.globalStatearray[j2][this.statearrayIndex[i3 + 1]] | resu >> this.shift[i3][1];
                    }
                    ++i3;
                }
            }
            ++j2;
        }
        int i4 = 0;
        while (i4 < this.numOneFunctionGroup) {
            short[] elementGroupFunction = groupOneFunctionIndex.get(i4);
            int[] parents = varOneFunctionGroup.get(i4);
            int index = i4 + this.num_groups;
            int k = 0;
            while (k < this.numParallel) {
                if (!perturbation[k]) {
                    int indexF = 0;
                    int j3 = 0;
                    while (j3 < parents.length) {
                        if (sts[k].get(parents[j3])) {
                            indexF |= 1 << j3;
                        }
                        ++j3;
                    }
                    long resu = elementGroupFunction[indexF];
                    this.globalStatearray[k][this.statearrayIndex[index]] = this.globalStatearray[k][this.statearrayIndex[index]] | resu << this.shift[index][0];
                    if (this.shift[index][1] != 0) {
                        this.globalStatearray[k][this.statearrayIndex[index + 1]] = this.globalStatearray[k][this.statearrayIndex[index + 1]] | resu >> this.shift[index][1];
                    }
                }
                ++k;
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < this.numParallel) {
            if (!perturbation[i4]) {
                sts[i4].clear();
                sts[i4].or(StateBit.valueOf(this.globalStatearray[i4]));
            }
            ++i4;
        }
        return this.para;
    }

    public int[] pbnNextState_oldWrongFunction(StateBit[] sts) {
        ++this.nextIndex;
        if (this.nextIndex == 100) {
            this.nextIndex = 0;
            this.generateRandom();
        }
        boolean[] perturbation = new boolean[this.numParallel];
        int groupSize = this.pbn.getP_groupNum() - 1;
        int[] Mask = this.pbn.getP_Mask();
        int i = 0;
        while (i < this.numParallel) {
            int j = 0;
            while (j < this.sizeStateArray) {
                this.globalStatearray[i][j] = 0L;
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < this.numParallel) {
            int i2 = 0;
            while (i2 < groupSize) {
                this.P_next[this.nextIndex][j][i2] = this.P_next[this.nextIndex][j][i2] & Mask[i2];
                if (this.P_next[this.nextIndex][j][i2] != 0) {
                    perturbation[j] = true;
                    this.globalStatearray[j][this.P_statearrayIndex[i2]] = this.globalStatearray[j][this.P_statearrayIndex[i2]] | (long)this.P_next[this.nextIndex][j][i2] << this.P_shift[i2][0];
                }
                if (this.P_shift[i2][1] != 0) {
                    this.globalStatearray[j][this.P_statearrayIndex[i2 + 1]] = this.globalStatearray[j][this.P_statearrayIndex[i2 + 1]] | (long)this.P_next[this.nextIndex][j][i2] >> this.P_shift[i2][1];
                }
                ++i2;
            }
            this.P_next[this.nextIndex][j][groupSize] = this.P_next[this.nextIndex][j][groupSize] & Mask[groupSize];
            if (this.P_next[this.nextIndex][j][groupSize] != 0) {
                perturbation[j] = true;
                this.globalStatearray[j][this.P_statearrayIndex[groupSize]] = this.globalStatearray[j][this.P_statearrayIndex[groupSize]] | (long)this.P_next[this.nextIndex][j][groupSize] << this.P_shift[groupSize][0];
                if (this.P_shift[groupSize][1] != 0) {
                    this.globalStatearray[j][this.P_statearrayIndex[groupSize + 1]] = this.globalStatearray[j][this.P_statearrayIndex[groupSize + 1]] | (long)this.P_next[this.nextIndex][j][groupSize] >> this.P_shift[groupSize][1];
                }
            }
            ++j;
        }
        int j2 = 0;
        while (j2 < this.numParallel) {
            if (perturbation[j2]) {
                sts[j2].xor(StateBit.valueOf(this.globalStatearray[j2]));
                this.para[j2] = 1;
            } else if (ThreadLocalRandom.current().nextDouble() > this.noPerturbation) {
                this.para[j2] = 0;
                perturbation[j2] = true;
            } else {
                this.para[j2] = 1;
                int i3 = 0;
                while (i3 < this.num_groups) {
                    int indexF = this.F_next[this.nextIndex][j2][i3];
                    int[] parents = varGroup.get(indexF);
                    int indexF1 = 0;
                    int l = 0;
                    while (l < parents.length) {
                        if (sts[j2].get(parents[l])) {
                            indexF1 |= 1 << l;
                        }
                        ++l;
                    }
                    short[] elementGroupFunction = groupFunctionIndex.get(indexF);
                    long resu = elementGroupFunction[indexF1];
                    this.globalStatearray[j2][this.statearrayIndex[i3]] = this.globalStatearray[j2][this.statearrayIndex[i3]] | resu << this.shift[i3][0];
                    if (this.shift[i3][1] != 0) {
                        this.globalStatearray[j2][this.statearrayIndex[i3 + 1]] = this.globalStatearray[j2][this.statearrayIndex[i3 + 1]] | resu >> this.shift[i3][1];
                    }
                    ++i3;
                }
            }
            ++j2;
        }
        int i4 = 0;
        while (i4 < this.numOneFunctionGroup) {
            short[] elementGroupFunction = groupOneFunctionIndex.get(i4);
            int[] parents = varOneFunctionGroup.get(i4);
            int index = i4 + this.num_groups;
            int k = 0;
            while (k < this.numParallel) {
                if (!perturbation[k]) {
                    int indexF = 0;
                    int j3 = 0;
                    while (j3 < parents.length) {
                        if (sts[k].get(parents[j3])) {
                            indexF |= 1 << j3;
                        }
                        ++j3;
                    }
                    long resu = elementGroupFunction[indexF];
                    this.globalStatearray[k][this.statearrayIndex[index]] = this.globalStatearray[k][this.statearrayIndex[index]] | resu << this.shift[index][0];
                    if (this.shift[index][1] != 0) {
                        this.globalStatearray[k][this.statearrayIndex[index + 1]] = this.globalStatearray[k][this.statearrayIndex[index + 1]] | resu >> this.shift[index][1];
                    }
                }
                ++k;
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < this.numParallel) {
            if (!perturbation[i4]) {
                sts[i4].clear();
                sts[i4].or(StateBit.valueOf(this.globalStatearray[i4]));
            }
            ++i4;
        }
        return this.para;
    }

    @Override
    public int pbnNextState(StateBit st) throws Exception {
        long resu;
        if (this.groupFunctionStore == 0) {
            return this.pbnNextStateSPARSELongArray_noPreRandom(st);
        }
        ++this.nextIndex;
        if (this.nextIndex == 100) {
            this.nextIndex = 0;
            this.generateRandom();
        }
        int n = this.pbn.getN();
        if (st.getN() != n) {
            throw new Exception("State size does not coinside with the PBN!");
        }
        long[] statearray = new long[this.sizeStateArray];
        boolean perturbation = false;
        int groupSize = this.pbn.getP_groupNum() - 1;
        int[] Mask = this.pbn.getP_Mask();
        int i = 0;
        while (i < groupSize) {
            this.P_next[this.nextIndex][0][i] = this.P_next[this.nextIndex][0][i] & Mask[i];
            if (this.P_next[this.nextIndex][0][i] != 0) {
                perturbation = true;
                statearray[this.P_statearrayIndex[i]] = statearray[this.P_statearrayIndex[i]] | (long)this.P_next[this.nextIndex][0][i] << this.P_shift[i][0];
                if (this.P_shift[i][1] != 0) {
                    statearray[this.P_statearrayIndex[i + 1]] = statearray[this.P_statearrayIndex[i + 1]] | (long)this.P_next[this.nextIndex][0][i] >> this.P_shift[i][1];
                }
            }
            ++i;
        }
        this.P_next[this.nextIndex][0][groupSize] = this.P_next[this.nextIndex][0][groupSize] & Mask[groupSize];
        if (this.P_next[this.nextIndex][0][groupSize] != 0) {
            perturbation = true;
            statearray[this.P_statearrayIndex[groupSize]] = statearray[this.P_statearrayIndex[groupSize]] | (long)this.P_next[this.nextIndex][0][groupSize] << this.P_shift[groupSize][0];
            if (this.P_shift[groupSize][1] != 0) {
                statearray[this.P_statearrayIndex[groupSize + 1]] = statearray[this.P_statearrayIndex[groupSize + 1]] | (long)this.P_next[this.nextIndex][0][groupSize] >> this.P_shift[groupSize][1];
            }
        }
        if (perturbation) {
            st.xor(StateBit.valueOf(statearray));
            return 1;
        }
        if (ThreadLocalRandom.current().nextDouble() > this.noPerturbation) {
            return 0;
        }
        long[] state = st.toLongArray();
        int i2 = 0;
        while (i2 < this.num_groups) {
            int indexF = this.F_next[this.nextIndex][0][i2];
            resu = (long)JDDPBN.GetValue(groupFunctionBDD.getVar(indexF), state);
            statearray[this.statearrayIndex[i2]] = statearray[this.statearrayIndex[i2]] | resu << this.shift[i2][0];
            if (this.shift[i2][1] != 0) {
                statearray[this.statearrayIndex[i2 + 1]] = statearray[this.statearrayIndex[i2 + 1]] | resu >> this.shift[i2][1];
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.numOneFunctionGroup) {
            int indexF = 0;
            resu = (long)JDDPBN.GetValue(oneFunctionBDD.getVar(indexF), state);
            int index = i3 + this.num_groups;
            statearray[this.statearrayIndex[index]] = statearray[this.statearrayIndex[index]] | resu << this.shift[index][0];
            if (this.shift[index][1] != 0) {
                statearray[this.statearrayIndex[index + 1]] = statearray[this.statearrayIndex[index + 1]] | resu >> this.shift[index][1];
            }
            ++i3;
        }
        st.clear();
        st.or(StateBit.valueOf(statearray));
        return 1;
    }

    public int pbnNextState_old(StateBit st) throws Exception {
        long resu;
        int next;
        if (this.groupFunctionStore == 0) {
            return this.pbnNextStateSPARSELongArray(st);
        }
        int n = this.pbn.getN();
        if (st.getN() != n) {
            throw new Exception("State size does not coinside with the PBN!");
        }
        long[] statearray = new long[this.sizeStateArray];
        boolean perturbation = false;
        int groupSize = this.pbn.getP_groupNum() - 1;
        int[] Mask = this.pbn.getP_Mask();
        AliasMethod am = this.pbn.getPAm();
        int i = 0;
        while (i < groupSize) {
            next = am.next() & Mask[i];
            if (next != 0) {
                perturbation = true;
                statearray[this.P_statearrayIndex[i]] = statearray[this.P_statearrayIndex[i]] | (long)next << this.P_shift[i][0];
                if (this.P_shift[i][1] != 0) {
                    statearray[this.P_statearrayIndex[i + 1]] = statearray[this.P_statearrayIndex[i + 1]] | (long)next >> this.P_shift[i][1];
                }
            }
            ++i;
        }
        next = am.next();
        if ((next &= Mask[groupSize]) != 0) {
            perturbation = true;
            statearray[this.P_statearrayIndex[groupSize]] = statearray[this.P_statearrayIndex[groupSize]] | (long)next << this.P_shift[groupSize][0];
            if (this.P_shift[groupSize][1] != 0) {
                statearray[this.P_statearrayIndex[groupSize + 1]] = statearray[this.P_statearrayIndex[groupSize + 1]] | (long)next >> this.P_shift[groupSize][1];
            }
        }
        if (perturbation) {
            st.xor(StateBit.valueOf(statearray));
            return 1;
        }
        if (ThreadLocalRandom.current().nextDouble() > this.noPerturbation) {
            return 0;
        }
        long[] state = st.toLongArray();
        int i2 = 0;
        while (i2 < this.num_groups) {
            am = amList.get(i2);
            int indexF = cumGroupCijSize[i2] + am.next();
            resu = (long)JDDPBN.GetValue(groupFunctionBDD.getVar(indexF), state);
            statearray[this.statearrayIndex[i2]] = statearray[this.statearrayIndex[i2]] | resu << this.shift[i2][0];
            if (this.shift[i2][1] != 0) {
                statearray[this.statearrayIndex[i2 + 1]] = statearray[this.statearrayIndex[i2 + 1]] | resu >> this.shift[i2][1];
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.numOneFunctionGroup) {
            short[] elementGroupFunction = groupOneFunctionIndex.get(i3);
            int[] parents = varOneFunctionGroup.get(i3);
            int indexF = 0;
            int j = 0;
            while (j < parents.length) {
                if (st.get(parents[j])) {
                    indexF |= 1 << j;
                }
                ++j;
            }
            resu = elementGroupFunction[indexF];
            int index = i3 + this.num_groups;
            statearray[this.statearrayIndex[index]] = statearray[this.statearrayIndex[index]] | resu << this.shift[index][0];
            if (this.shift[index][1] != 0) {
                statearray[this.statearrayIndex[index + 1]] = statearray[this.statearrayIndex[index + 1]] | resu >> this.shift[index][1];
            }
            ++i3;
        }
        st.clear();
        st.or(StateBit.valueOf(statearray));
        return 1;
    }

    private int pbnNextStateSPARSE(StateBit st) throws Exception {
        StateBit result;
        int[] parents;
        int next;
        int n = this.pbn.getN();
        if (st.getN() != n) {
            throw new Exception("State size does not coinside with the PBN!");
        }
        long[] statearray = new long[this.sizeStateArray];
        boolean perturbation = false;
        int groupSize = this.pbn.getP_groupNum() - 1;
        int[] Mask = this.pbn.getP_Mask();
        AliasMethod am = this.pbn.getPAm();
        int i = 0;
        while (i < groupSize) {
            next = am.next() & Mask[i];
            if (next != 0) {
                perturbation = true;
                statearray[this.P_statearrayIndex[i]] = statearray[this.P_statearrayIndex[i]] | (long)next << this.P_shift[i][0];
                if (this.P_shift[i][1] != 0) {
                    statearray[this.P_statearrayIndex[i + 1]] = statearray[this.P_statearrayIndex[i + 1]] | (long)next >> this.P_shift[i][1];
                }
            }
            ++i;
        }
        next = am.next();
        if ((next &= Mask[groupSize]) != 0) {
            perturbation = true;
            statearray[this.P_statearrayIndex[groupSize]] = statearray[this.P_statearrayIndex[groupSize]] | (long)next << this.P_shift[groupSize][0];
            if (this.P_shift[groupSize][1] != 0) {
                statearray[this.P_statearrayIndex[groupSize + 1]] = statearray[this.P_statearrayIndex[groupSize + 1]] | (long)next >> this.P_shift[groupSize][1];
            }
        }
        if (perturbation) {
            st.xor(StateBit.valueOf(statearray));
            return 1;
        }
        if (ThreadLocalRandom.current().nextDouble() > this.noPerturbation) {
            return 0;
        }
        this.copySt.clear();
        this.copySt.xor(st);
        st.clear();
        i = 0;
        while (i < this.num_groups) {
            am = amList.get(i);
            int indexF = cumGroupCijSize[i] + am.next();
            parents = varGroup.get(indexF);
            short[] elementGroupFunction = groupFunctionIndex.get(indexF);
            indexF = 0;
            int j = 0;
            while (j < parents.length) {
                if (this.copySt.get(parents[j])) {
                    indexF |= 1 << j;
                }
                ++j;
            }
            indexF = elementGroupFunction[indexF];
            result = groupState.get(i)[indexF];
            st.or(result);
            ++i;
        }
        i = 0;
        while (i < this.numOneFunctionGroup) {
            short[] elementGroupFunction = groupOneFunctionIndex.get(i);
            parents = varOneFunctionGroup.get(i);
            int indexF = 0;
            int j = 0;
            while (j < parents.length) {
                if (this.copySt.get(parents[j])) {
                    indexF |= 1 << j;
                }
                ++j;
            }
            indexF = elementGroupFunction[indexF];
            result = groupOneFunctionState.get(i)[indexF];
            st.or(result);
            ++i;
        }
        return 1;
    }

    private int pbnNextStateSPARSELongArray_new(StateBit st) throws Exception {
        int j;
        ++this.nextIndex;
        if (this.nextIndex == 100) {
            this.nextIndex = 0;
            this.generateRandom();
        }
        int n = this.pbn.getN();
        if (st.getN() != n) {
            throw new Exception("State size does not coinside with the PBN!");
        }
        boolean[] perturbation = new boolean[this.numParallel];
        int groupSize = this.pbn.getP_groupNum() - 1;
        int[] Mask = this.pbn.getP_Mask();
        int i = 0;
        while (i < this.numParallel) {
            j = 0;
            while (j < this.sizeStateArray) {
                this.globalStatearray[i][j] = 0L;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < groupSize) {
            j = 0;
            while (j < this.numParallel) {
                this.P_next[this.nextIndex][j][i] = this.P_next[this.nextIndex][j][i] & Mask[i];
                if (this.P_next[this.nextIndex][j][i] != 0) {
                    perturbation[j] = true;
                    this.globalStatearray[j][this.P_statearrayIndex[i]] = this.globalStatearray[j][this.P_statearrayIndex[i]] | (long)this.P_next[this.nextIndex][j][i] << this.P_shift[i][0];
                    if (this.P_shift[i][1] != 0) {
                        this.globalStatearray[j][this.P_statearrayIndex[i + 1]] = this.globalStatearray[j][this.P_statearrayIndex[i + 1]] | (long)this.P_next[this.nextIndex][j][i] >> this.P_shift[i][1];
                    }
                }
                ++j;
            }
            ++i;
        }
        this.P_next[this.nextIndex][0][groupSize] = this.P_next[this.nextIndex][0][groupSize] & Mask[groupSize];
        int j2 = 0;
        while (j2 < this.numParallel) {
            if (this.P_next[this.nextIndex][0][groupSize] != 0) {
                perturbation[j2] = true;
                this.globalStatearray[j2][this.P_statearrayIndex[groupSize]] = this.globalStatearray[j2][this.P_statearrayIndex[groupSize]] | (long)this.P_next[this.nextIndex][0][groupSize] << this.P_shift[groupSize][1];
                if (this.P_shift[groupSize][1] != 0) {
                    this.globalStatearray[j2][this.P_statearrayIndex[groupSize + 1]] = this.globalStatearray[j2][this.P_statearrayIndex[groupSize + 1]] | (long)this.P_next[this.nextIndex][j2][groupSize] >> this.P_shift[groupSize][1];
                }
            }
            ++j2;
        }
        if (perturbation[0]) {
            j2 = 1;
            while (j2 < this.numParallel) {
                this.copystate.xor(StateBit.valueOf(this.globalStatearray[j2]));
                ++j2;
            }
            st.xor(StateBit.valueOf(this.globalStatearray[0]));
            return 1;
        }
        if (ThreadLocalRandom.current().nextDouble() > this.noPerturbation) {
            return 0;
        }
        int i2 = 0;
        while (i2 < this.num_groups) {
            int k = 0;
            while (k < this.numParallel) {
                int indexF = this.F_next[this.nextIndex][k][i2];
                int[] parents = varGroup.get(indexF);
                int indexF1 = 0;
                int j3 = 0;
                while (j3 < parents.length) {
                    if (st.get(parents[j3])) {
                        indexF1 |= 1 << j3;
                    }
                    ++j3;
                }
                short[] elementGroupFunction = groupFunctionIndex.get(indexF);
                long resu = elementGroupFunction[indexF1];
                this.globalStatearray[k][this.statearrayIndex[i2]] = this.globalStatearray[k][this.statearrayIndex[i2]] | resu << this.shift[i2][0];
                if (this.shift[i2][1] != 0) {
                    this.globalStatearray[k][this.statearrayIndex[i2 + 1]] = this.globalStatearray[k][this.statearrayIndex[i2 + 1]] | resu >> this.shift[i2][1];
                }
                ++k;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.numOneFunctionGroup) {
            short[] elementGroupFunction = groupOneFunctionIndex.get(i2);
            int[] parents = varOneFunctionGroup.get(i2);
            int k = 0;
            while (k < this.numParallel) {
                int indexF = 0;
                int j4 = 0;
                while (j4 < parents.length) {
                    if (st.get(parents[j4])) {
                        indexF |= 1 << j4;
                    }
                    ++j4;
                }
                long resu = elementGroupFunction[indexF];
                int index = i2 + this.num_groups;
                this.globalStatearray[k][this.statearrayIndex[index]] = this.globalStatearray[k][this.statearrayIndex[index]] | resu << this.shift[index][0];
                if (this.shift[index][1] != 0) {
                    this.globalStatearray[k][this.statearrayIndex[index + 1]] = this.globalStatearray[k][this.statearrayIndex[index + 1]] | resu >> this.shift[index][1];
                }
                ++k;
            }
            ++i2;
        }
        st.clear();
        st.or(StateBit.valueOf(this.globalStatearray[0]));
        return 1;
    }

    private int pbnNextStateSPARSELongArray(StateBit st) throws Exception {
        int[] parents;
        ++this.nextIndex;
        if (this.nextIndex == 100) {
            this.nextIndex = 0;
            this.generateRandom();
        }
        int n = this.pbn.getN();
        if (st.getN() != n) {
            throw new Exception("State size does not coinside with the PBN!");
        }
        long[] statearray = new long[this.sizeStateArray];
        boolean perturbation = false;
        int groupSize = this.pbn.getP_groupNum() - 1;
        int[] Mask = this.pbn.getP_Mask();
        int i = 0;
        while (i < groupSize) {
            this.P_next[this.nextIndex][0][i] = this.P_next[this.nextIndex][0][i] & Mask[i];
            if (this.P_next[this.nextIndex][0][i] != 0) {
                perturbation = true;
                statearray[this.P_statearrayIndex[i]] = statearray[this.P_statearrayIndex[i]] | (long)this.P_next[this.nextIndex][0][i] << this.P_shift[i][0];
                if (this.P_shift[i][1] != 0) {
                    statearray[this.P_statearrayIndex[i + 1]] = statearray[this.P_statearrayIndex[i + 1]] | (long)this.P_next[this.nextIndex][0][i] >> this.P_shift[i][1];
                }
            }
            ++i;
        }
        this.P_next[this.nextIndex][0][groupSize] = this.P_next[this.nextIndex][0][groupSize] & Mask[groupSize];
        if (this.P_next[this.nextIndex][0][groupSize] != 0) {
            perturbation = true;
            statearray[this.P_statearrayIndex[groupSize]] = statearray[this.P_statearrayIndex[groupSize]] | (long)this.P_next[this.nextIndex][0][groupSize] << this.P_shift[groupSize][0];
            if (this.P_shift[groupSize][1] != 0) {
                statearray[this.P_statearrayIndex[groupSize + 1]] = statearray[this.P_statearrayIndex[groupSize + 1]] | (long)this.P_next[this.nextIndex][0][groupSize] >> this.P_shift[groupSize][1];
            }
        }
        if (perturbation) {
            st.xor(StateBit.valueOf(statearray));
            return 1;
        }
        if (ThreadLocalRandom.current().nextDouble() > this.noPerturbation) {
            return 0;
        }
        int i2 = 0;
        while (i2 < this.num_groups) {
            int indexF = this.F_next[this.nextIndex][0][i2];
            parents = varGroup.get(indexF);
            int indexF1 = 0;
            int j = 0;
            while (j < parents.length) {
                if (st.get(parents[j])) {
                    indexF1 |= 1 << j;
                }
                ++j;
            }
            short[] elementGroupFunction = groupFunctionIndex.get(indexF);
            long resu = elementGroupFunction[indexF1];
            statearray[this.statearrayIndex[i2]] = statearray[this.statearrayIndex[i2]] | resu << this.shift[i2][0];
            if (this.shift[i2][1] != 0) {
                statearray[this.statearrayIndex[i2 + 1]] = statearray[this.statearrayIndex[i2 + 1]] | resu >> this.shift[i2][1];
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.numOneFunctionGroup) {
            short[] elementGroupFunction = groupOneFunctionIndex.get(i2);
            parents = varOneFunctionGroup.get(i2);
            int indexF = 0;
            int j = 0;
            while (j < parents.length) {
                if (st.get(parents[j])) {
                    indexF |= 1 << j;
                }
                ++j;
            }
            long resu = elementGroupFunction[indexF];
            int index = i2 + this.num_groups;
            statearray[this.statearrayIndex[index]] = statearray[this.statearrayIndex[index]] | resu << this.shift[index][0];
            if (this.shift[index][1] != 0) {
                statearray[this.statearrayIndex[index + 1]] = statearray[this.statearrayIndex[index + 1]] | resu >> this.shift[index][1];
            }
            ++i2;
        }
        st.clear();
        st.or(StateBit.valueOf(statearray));
        return 1;
    }

    private int pbnNextStateSPARSELongArray_noPreRandom(StateBit st) throws Exception {
        int j;
        int[] parents;
        int next;
        int n = this.pbn.getN();
        if (st.getN() != n) {
            throw new Exception("State size does not coinside with the PBN!");
        }
        long[] statearray = new long[this.sizeStateArray];
        int i = 0;
        while (i < this.sizeStateArray) {
            statearray[i] = 0L;
            ++i;
        }
        boolean perturbation = false;
        int groupSize = this.pbn.getP_groupNum() - 1;
        int[] Mask = this.pbn.getP_Mask();
        AliasMethod am = this.pbn.getPAm();
        int i2 = 0;
        while (i2 < groupSize) {
            next = am.next() & Mask[i2];
            if (next != 0) {
                perturbation = true;
                statearray[this.P_statearrayIndex[i2]] = statearray[this.P_statearrayIndex[i2]] | (long)next << this.P_shift[i2][0];
                if (this.P_shift[i2][1] != 0) {
                    statearray[this.P_statearrayIndex[i2 + 1]] = statearray[this.P_statearrayIndex[i2 + 1]] | (long)next >> this.P_shift[i2][1];
                }
            }
            ++i2;
        }
        next = am.next();
        if ((next &= Mask[groupSize]) != 0) {
            perturbation = true;
            statearray[this.P_statearrayIndex[groupSize]] = statearray[this.P_statearrayIndex[groupSize]] | (long)next << this.P_shift[groupSize][0];
            if (this.P_shift[groupSize][1] != 0) {
                statearray[this.P_statearrayIndex[groupSize + 1]] = statearray[this.P_statearrayIndex[groupSize + 1]] | (long)next >> this.P_shift[groupSize][1];
            }
        }
        if (perturbation) {
            st.xor(StateBit.valueOf(statearray));
            return 1;
        }
        if (ThreadLocalRandom.current().nextDouble() > this.noPerturbation) {
            return 0;
        }
        int i3 = 0;
        while (i3 < this.num_groups) {
            am = amList.get(i3);
            int indexF = cumGroupCijSize[i3] + am.next();
            parents = varGroup.get(indexF);
            short[] elementGroupFunction = groupFunctionIndex.get(indexF);
            indexF = 0;
            j = 0;
            while (j < parents.length) {
                if (st.get(parents[j])) {
                    indexF |= 1 << j;
                }
                ++j;
            }
            long resu = elementGroupFunction[indexF];
            statearray[this.statearrayIndex[i3]] = statearray[this.statearrayIndex[i3]] | resu << this.shift[i3][0];
            if (this.shift[i3][1] != 0) {
                statearray[this.statearrayIndex[i3 + 1]] = statearray[this.statearrayIndex[i3 + 1]] | resu >> this.shift[i3][1];
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < this.numOneFunctionGroup) {
            short[] elementGroupFunction = groupOneFunctionIndex.get(i3);
            parents = varOneFunctionGroup.get(i3);
            int indexF = 0;
            j = 0;
            while (j < parents.length) {
                if (st.get(parents[j])) {
                    indexF |= 1 << j;
                }
                ++j;
            }
            long resu = elementGroupFunction[indexF];
            int index = i3 + this.num_groups;
            statearray[this.statearrayIndex[index]] = statearray[this.statearrayIndex[index]] | resu << this.shift[index][0];
            if (this.shift[index][1] != 0) {
                statearray[this.statearrayIndex[index + 1]] = statearray[this.statearrayIndex[index + 1]] | resu >> this.shift[index][1];
            }
            ++i3;
        }
        st.clear();
        st.or(StateBit.valueOf(statearray));
        return 1;
    }

    private int pbnNextStateSPARSELongArray_useGlobalRandom(StateBit st, int num) throws Exception {
        int j;
        int[] parents;
        int next;
        int n = this.pbn.getN();
        if (st.getN() != n) {
            throw new Exception("State size does not coinside with the PBN!");
        }
        long[] statearray = new long[this.sizeStateArray];
        boolean perturbation = false;
        int groupSize = this.pbn.getP_groupNum() - 1;
        int[] Mask = this.pbn.getP_Mask();
        int i = 0;
        while (i < groupSize) {
            next = this.P_next[this.nextIndex][num][i] & Mask[i];
            if (next != 0) {
                perturbation = true;
                statearray[this.P_statearrayIndex[i]] = statearray[this.P_statearrayIndex[i]] | (long)next << this.P_shift[i][0];
                if (this.P_shift[i][1] != 1) {
                    statearray[this.P_statearrayIndex[i + 1]] = statearray[this.P_statearrayIndex[i + 1]] | (long)next >> this.P_shift[i][1];
                }
            }
            ++i;
        }
        next = this.P_next[this.nextIndex][num][groupSize];
        if ((next &= Mask[groupSize]) != 0) {
            perturbation = true;
            statearray[this.P_statearrayIndex[groupSize]] = statearray[this.P_statearrayIndex[groupSize]] | (long)next << this.P_shift[groupSize][0];
            if (this.P_shift[groupSize][1] != 1) {
                statearray[this.P_statearrayIndex[groupSize + 1]] = statearray[this.P_statearrayIndex[groupSize + 1]] | (long)next >> this.P_shift[groupSize][1];
            }
        }
        if (perturbation) {
            st.xor(StateBit.valueOf(statearray));
            return 1;
        }
        if (ThreadLocalRandom.current().nextDouble() > this.noPerturbation) {
            return 0;
        }
        int i2 = 0;
        while (i2 < this.num_groups) {
            int indexF = this.F_next[this.nextIndex][num][i2];
            parents = varGroup.get(indexF);
            short[] elementGroupFunction = groupFunctionIndex.get(indexF);
            indexF = 0;
            j = 0;
            while (j < parents.length) {
                if (st.get(parents[j])) {
                    indexF |= 1 << j;
                }
                ++j;
            }
            long resu = elementGroupFunction[indexF];
            statearray[this.statearrayIndex[i2]] = statearray[this.statearrayIndex[i2]] | resu << this.shift[i2][0];
            if (this.shift[i2][1] != 0) {
                statearray[this.statearrayIndex[i2 + 1]] = statearray[this.statearrayIndex[i2 + 1]] | resu >> this.shift[i2][1];
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.numOneFunctionGroup) {
            short[] elementGroupFunction = groupOneFunctionIndex.get(i2);
            parents = varOneFunctionGroup.get(i2);
            int indexF = 0;
            j = 0;
            while (j < parents.length) {
                if (st.get(parents[j])) {
                    indexF |= 1 << j;
                }
                ++j;
            }
            long resu = elementGroupFunction[indexF];
            int index = i2 + this.num_groups;
            statearray[this.statearrayIndex[index]] = statearray[this.statearrayIndex[index]] | resu << this.shift[index][0];
            if (this.shift[index][1] != 0) {
                statearray[this.statearrayIndex[index + 1]] = statearray[this.statearrayIndex[index + 1]] | resu >> this.shift[index][1];
            }
            ++i2;
        }
        st.clear();
        st.or(StateBit.valueOf(statearray));
        return 1;
    }
}

