/*
 * Decompiled with CFR 0.152.
 */
package PBN;

import PBN.PBN;
import PBN.StateBit;
import cern.colt.bitvector.BitVector;
import functionLib.Parameters;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import simulator.AliasMethod;

public class BitSetPBN
extends PBN {
    public BitSetPBN() {
    }

    public BitSetPBN(int n) {
        this.n = n;
        this.nf = new int[n];
        this.nv = new ArrayList();
        this.F = new ArrayList();
        this.varF = new ArrayList();
        this.cij = new ArrayList();
        this.perturbation = 0.0;
        this.npNode = new ArrayList();
        this.npNode.add(n);
    }

    public double density() throws Exception {
        this.buildCumNf();
        double total = 0.0;
        int i = 0;
        while (i < this.cumNf[this.n]) {
            total += (double)((Integer)this.nv.get(i)).intValue();
            ++i;
        }
        return total / (double)this.n;
    }

    @Override
    public int[] buildCumNf() throws Exception {
        if (this.nf == null) {
            throw new Exception("Cannot build cumNf before nf is initilised.");
        }
        if (this.cumNf != null) {
            return this.cumNf;
        }
        this.cumNf = new int[this.n + 1];
        this.cumNf[0] = 0;
        int i = 0;
        while (i < this.nf.length) {
            this.cumNf[i + 1] = this.cumNf[i] + this.nf[i];
            ++i;
        }
        return this.cumNf;
    }

    @Override
    public void setNf(int[] nf) {
        this.nf = nf;
    }

    @Override
    public void setNv(List<Integer> nv) {
        this.nv = nv;
    }

    @Override
    public void setF(List<boolean[]> F) {
        this.F = F;
    }

    @Override
    public void setvarF(List<BitSet> varF) {
        this.varF = varF;
        this.setvarFInt();
    }

    public void setCij(List<double[]> cij) {
        this.cij = cij;
    }

    @Override
    public void setPerturbation(double perturbation) {
        this.perturbation = perturbation;
        try {
            this.computeParallelP();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getN() {
        return this.n;
    }

    @Override
    public int[] getNf() {
        return this.nf;
    }

    @Override
    public List<Integer> getNv() {
        return this.nv;
    }

    @Override
    public List<boolean[]> getF() {
        return this.F;
    }

    @Override
    public List<BitSet> getVarF() {
        return this.varF;
    }

    @Override
    public double getPerturbation() {
        return this.perturbation;
    }

    @Override
    public boolean getNextNodeValue(int indexVarF, StateBit currentState) {
        int[] elementVarFInt = (int[])this.varFInt.get(indexVarF);
        int indexF = 0;
        int i = 0;
        while (i < elementVarFInt.length) {
            if (currentState.get(elementVarFInt[i])) {
                indexF |= 1 << i;
            }
            ++i;
        }
        return ((boolean[])this.F.get(indexVarF))[indexF];
    }

    public boolean getNextNodeValue_tmp(int indexVarF, StateBit currentState) {
        BitSet elementVarF = (BitSet)this.varF.get(indexVarF);
        boolean[] elementF = (boolean[])this.F.get(indexVarF);
        StateBit copyCurrentState = (StateBit)currentState.clone();
        copyCurrentState.and(elementVarF);
        BitVector bitVector = new BitVector(elementVarF.cardinality());
        int index = -1;
        int count = 0;
        while ((index = elementVarF.nextSetBit(index + 1)) != -1) {
            bitVector.put(count, copyCurrentState.get(index));
            ++count;
        }
        return elementF[(int)bitVector.getLongFromTo(0, bitVector.size() - 1)];
    }

    public void tmp(BitSet elementVarF, StateBit copyCurrentState, BitVector bitVector) {
        int index = -1;
        int count = 0;
        while ((index = elementVarF.nextSetBit(index + 1)) != -1) {
            if (copyCurrentState.get(index)) {
                bitVector.set(count);
            }
            ++count;
        }
    }

    public void tmpput(int count, int index, StateBit copyCurrentState, BitVector bitVector) {
        boolean value = copyCurrentState.get(index);
        bitVector.put(count, value);
    }

    @Override
    public int getStateLength() {
        return this.getN();
    }

    public void computeParallelPOld() throws Exception {
        this.P_groupNum = (int)Math.ceil((double)this.n / 10.0);
        this.P_firstSize = (int)Math.ceil((double)this.n / (double)this.P_groupNum);
        this.P_lastSize = this.P_firstSize - this.P_firstSize * this.P_groupNum + this.n;
        double[] p_cij = new double[(int)Math.pow(2.0, this.P_firstSize)];
        int[] column = new int[p_cij.length];
        this.sts = new ArrayList();
        StateBit[] stsElement = new StateBit[p_cij.length];
        int i = 0;
        while (i < column.length) {
            column[i] = i;
            int count = this.count_one(i);
            p_cij[i] = Math.pow(1.0 - this.perturbation, this.P_firstSize - count) * Math.pow(this.perturbation, count);
            stsElement[i] = new StateBit(this.n);
            stsElement[i].putLongFromTo(i, 0, this.n - 1);
            ++i;
        }
        this.sts.add(stsElement);
        i = 1;
        while (i < this.P_groupNum) {
            stsElement = new StateBit[p_cij.length];
            int j = 0;
            while (j < p_cij.length) {
                stsElement[j] = new StateBit(this.n);
                stsElement[j].putLongFromTo(j, this.P_firstSize * i, this.n - 1);
                ++j;
            }
            this.sts.add(stsElement);
            ++i;
        }
        this.am = new AliasMethod(p_cij, column);
    }

    public void computeParallelP() throws Exception {
        this.P_groupNum = (int)Math.ceil((double)this.n / (double)Parameters.P_GROUPSIZE);
        this.P_firstSize = Parameters.P_GROUPSIZE = (int)Math.ceil((double)this.n / (double)this.P_groupNum);
        this.P_lastSize = this.P_firstSize - this.P_firstSize * this.P_groupNum + this.n;
        this.p_cij = new double[(int)Math.pow(2.0, this.P_firstSize)];
        int[] column = new int[this.p_cij.length];
        int i = 0;
        while (i < column.length) {
            column[i] = i;
            int count = this.count_one(i);
            this.p_cij[i] = Math.pow(1.0 - this.perturbation, this.P_firstSize - count) * Math.pow(this.perturbation, count);
            ++i;
        }
        this.am = new AliasMethod(this.p_cij, column);
        this.P_Mask = new int[this.P_groupNum];
        i = 0;
        while (i < this.P_groupNum - 1) {
            int shift = i * this.P_firstSize;
            int j = 0;
            while (j < this.P_firstSize) {
                if (!this.npNode.contains(shift + j)) {
                    this.P_Mask[i] = this.P_Mask[i] | 1 << j;
                }
                ++j;
            }
            ++i;
        }
        int shift = (this.P_groupNum - 1) * this.P_firstSize;
        int i2 = 0;
        while (i2 < this.P_lastSize) {
            if (!this.npNode.contains(shift + i2)) {
                this.P_Mask[this.P_groupNum - 1] = this.P_Mask[this.P_groupNum - 1] | 1 << i2;
            }
            ++i2;
        }
        if (Parameters.printlevel == 0) {
            this.assalog.println(String.valueOf(this.P_groupNum) + " groups are set for perturbation.");
        }
    }

    private int count_one(int x) {
        x = (x & 0x55555555) + (x >> 1 & 0x55555555);
        x = (x & 0x33333333) + (x >> 2 & 0x33333333);
        x = (x & 0xF0F0F0F) + (x >> 4 & 0xF0F0F0F);
        x = (x & 0xFF00FF) + (x >> 8 & 0xFF00FF);
        x = (x & 0xFFFF) + (x >> 16 & 0xFFFF);
        return x;
    }

    @Override
    public PBN copy() {
        Object newt;
        BitSetPBN newPBN = new BitSetPBN(this.n);
        newPBN.assalog = this.assalog;
        int[] newNf = (int[])this.nf.clone();
        ((PBN)newPBN).setNf(newNf);
        ArrayList<Integer> newNv = new ArrayList<Integer>();
        for (Integer t : this.nv) {
            newNv.add((int)t);
        }
        ((PBN)newPBN).setNv(newNv);
        ArrayList<boolean[]> newF = new ArrayList<boolean[]>();
        for (boolean[] t : this.F) {
            newt = (boolean[])t.clone();
            newF.add((boolean[])newt);
        }
        ((PBN)newPBN).setF(newF);
        ArrayList<BitSet> newVarF = new ArrayList<BitSet>();
        newt = this.varF.iterator();
        while (newt.hasNext()) {
            BitSet bs = (BitSet)newt.next();
            BitSet newbs = (BitSet)bs.clone();
            newVarF.add(newbs);
        }
        ((PBN)newPBN).setvarF(newVarF);
        ArrayList<double[]> newcij = new ArrayList<double[]>();
        for (double[] t : this.cij) {
            double[] tt = (double[])t.clone();
            newcij.add(tt);
        }
        newPBN.setCij(newcij);
        ((PBN)newPBN).setPerturbation(this.perturbation);
        ArrayList<Integer> newNpNode = new ArrayList<Integer>();
        for (Integer t : this.npNode) {
            newNpNode.add((int)t);
        }
        newPBN.setNpNode(newNpNode);
        return newPBN;
    }
}

