/*
 * Decompiled with CFR 0.152.
 */
package PBN;

import PBN.ContextPBN;
import PBN.Engine;
import PBN.PBN;
import PBN.StateBit;
import cern.colt.bitvector.BitVector;
import functionLib.RandomProvider;
import java.util.List;
import simulator.AliasMethod;

public class ContextEngine
extends Engine {
    private boolean switchFirst;
    private double[] swi;
    private AliasMethod am;

    public ContextEngine(PBN pbn) {
        this.pbn = pbn;
        this.random = RandomProvider.getInstance().getRandom();
        this.switchFirst = ((ContextPBN)pbn).getSwitchFirst();
        this.swi = ((ContextPBN)pbn).getSwi();
        int[] column = new int[this.swi.length];
        int i = 0;
        while (i < this.swi.length) {
            column[i] = i - 1;
            ++i;
        }
        this.am = new AliasMethod(this.swi, this.random, column);
    }

    @Override
    public int pbnNextState(StateBit st) throws Exception {
        if (this.switchFirst) {
            this.switchBN(st);
            this.updateState(st);
        } else {
            this.updateState(st);
            this.switchBN(st);
        }
        return 1;
    }

    private void switchBN(StateBit st) throws Exception {
        int bn = this.am.next();
        if (bn == -1) {
            return;
        }
        st.putLongFromTo(bn, this.pbn.getN(), st.getN() - 1);
    }

    private void updateState(StateBit st) throws Exception {
        int n = this.pbn.getN();
        if (st.getN() <= n) {
            throw new Exception("State size does not coinside with the PBN!");
        }
        StateBit copySt = (StateBit)st.clone();
        boolean perturbation = false;
        List<Integer> npNode = this.pbn.npNode();
        int start = 0;
        for (int element : npNode) {
            int i = start;
            while (i < element) {
                if (this.pbn.getPerturbation() > this.random.nextDouble()) {
                    st.flip(i);
                    perturbation = true;
                }
                ++i;
            }
            start = element + 1;
        }
        if (perturbation) {
            return;
        }
        int[] cumNf = this.pbn.buildCumNf();
        start = (int)st.getLongFromTo(this.pbn.getN(), st.getN());
        int[] index = ((ContextPBN)this.pbn).getBN().get(start);
        BitVector elementBNindex = ((ContextPBN)this.pbn).getBNindex().get(start);
        start = 0;
        int end = elementBNindex.size() - 1;
        while (start <= end) {
            if ((start = elementBNindex.indexOfFromTo(start, end, true)) < 0) break;
            st.set(start, this.pbn.getNextNodeValue(cumNf[start] + index[start], copySt));
            ++start;
        }
    }
}

