/*
 * Decompiled with CFR 0.152.
 */
package PBN;

import PBN.BDDPBN;
import PBN.BitSetPBN;
import PBN.BitSetPBNIO;
import PBN.PBN;
import PBN.ParseProperty;
import PBN.Property;
import PBN.StateBit;
import SCC.Digraph;
import SCC.In;
import SCC.TarjanBlock;
import cern.colt.bitvector.BitVector;
import functionLib.AssaException;
import functionLib.Parameters;
import functionLib.QuickSort;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDPBN;
import jdd.JDDVars;
import org.apache.commons.lang3.ArrayUtils;
import parser.Model;
import simulator.AliasMethod;
import userInterface.AssaConsoleLog;
import userInterface.AssaLog;

public class OptimizePBN {
    private PBN pbn;
    private int[] order;
    private int[] nf;
    private int[] originalNf;
    private int[] cumNf;
    private int num_groups;
    private int[] group;
    private int[] cumGroup;
    private int[] groupCijSize;
    private List<double[]> newCij;
    private int index_newCij;
    private List<AliasMethod> amList;
    private String graphFileName;
    private int[] index;
    private String PBNFile;
    private Property property;
    private String propertyFile;
    private int numLeaves;
    private List<StateBit[]> groupState;
    private List<short[]> groupFunctionIndex;
    private List<List<short[]>> groupFunctionIndex2D;
    private List<int[]> varGroup;
    private JDDVars groupFunctionBDD;
    public JDDVars oneFunctionBDD;
    public static final int SPARSE = 0;
    public static final int MTBDD = 1;
    private int groupFunctionStore = 0;
    private int numOneFunction = 0;
    private int numOneFunctionGroup = 0;
    private int sizeOneFunctionGroup = Parameters.SIZE_ONE_FUNCTION_GROUP;
    private int sizeLastFunctionGroup = 10;
    private List<int[]> varOneFunctionGroup;
    private List<short[]> groupOneFunctionIndex;
    private List<List<short[]>> groupOneFunctionIndex2D;
    private List<StateBit[]> groupOneFunctionState;
    private int maxNumberElements = Parameters.DEFAULT_SPARSE_NUMBER;
    private boolean performGroup = true;
    private List<Integer> npNodes;
    AssaLog assalog;

    public OptimizePBN(String PBNFile2, AssaLog assalog) {
        this.PBNFile = PBNFile2;
        this.assalog = assalog;
        BitSetPBNIO io = new BitSetPBNIO(assalog);
        try {
            this.pbn = io.loadPBN(PBNFile2, 1);
            this.initialiseOrder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OptimizePBN(PBN pbn, String PBNFile2, AssaLog assalog) {
        this.PBNFile = PBNFile2;
        this.assalog = assalog;
        this.pbn = pbn;
        try {
            this.initialiseOrder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setGroupFunctionStore(int groupFunctionStore) {
        this.groupFunctionStore = groupFunctionStore;
        switch (groupFunctionStore) {
            case 0: {
                this.maxNumberElements = Parameters.DEFAULT_SPARSE_NUMBER;
                break;
            }
            case 1: {
                this.maxNumberElements = Parameters.DEFAULT_MTBDD_NUMBER;
                break;
            }
        }
    }

    public void initialiseOrder() throws Exception {
        this.order = new int[this.pbn.getN()];
        int i = 0;
        while (i < this.pbn.getN()) {
            this.order[i] = i;
            ++i;
        }
        int n = this.pbn.getN();
        this.originalNf = new int[n];
        System.arraycopy(this.pbn.getNf(), 0, this.originalNf, 0, n);
        this.cumNf = this.pbn.buildCumNf();
    }

    public void setGraphFile(String graphFileName) {
        this.graphFileName = graphFileName;
    }

    public void setPropertyFile(String propertyFile) {
        this.propertyFile = propertyFile;
    }

    public String getPropertyFile() {
        return this.propertyFile;
    }

    public int getNumLeaves() {
        return this.numLeaves;
    }

    public List<StateBit[]> getGroupState() {
        return this.groupState;
    }

    public List<StateBit[]> getGroupOneFunctionState() {
        return this.groupOneFunctionState;
    }

    public List<short[]> getGroupFunctionIndex() {
        return this.groupFunctionIndex;
    }

    public List<List<short[]>> getGroupFunctionIndex2D() {
        return this.groupFunctionIndex2D;
    }

    public int getGroupFunctionStore() {
        return this.groupFunctionStore;
    }

    public List<short[]> getGroupOneFunctionIndex() {
        return this.groupOneFunctionIndex;
    }

    public List<List<short[]>> getGroupOneFunctionIndex2D() {
        return this.groupOneFunctionIndex2D;
    }

    public List<int[]> getVarGroup() {
        return this.varGroup;
    }

    public List<int[]> getVarOneFunctionGroup() {
        return this.varOneFunctionGroup;
    }

    public int[] getGroupCijSize() {
        return this.groupCijSize;
    }

    public List<AliasMethod> getAmList() {
        return this.amList;
    }

    public int getNumGroups() {
        return this.num_groups;
    }

    public int[] getCumGroup() {
        return this.cumGroup;
    }

    public JDDVars getGroupFunctionBDD() {
        return this.groupFunctionBDD;
    }

    public int getNumOneFunctionGroup() {
        return this.numOneFunctionGroup;
    }

    public int getSizeOneFunctionGroup() {
        return this.sizeOneFunctionGroup;
    }

    public int getSizeLastFunctionGroup() {
        return this.sizeLastFunctionGroup;
    }

    public void setPerformGroup(boolean performGroup) {
        this.performGroup = performGroup;
    }

    public void detectLeaves() throws NumberFormatException, IOException, AssaException {
        TarjanBlock block = new TarjanBlock(new Digraph(new In(this.graphFileName)));
        this.property = ParseProperty.getProperties(this.pbn, this.propertyFile).get(0);
        block.removingLeaves(this.property);
        List<Integer> leaves = block.getLeaves();
        List positiveIndex = this.property.getPositiveIndex();
        List negativeIndex = this.property.getNegativeIndex();
        int n = this.pbn.getN();
        this.npNodes = this.pbn.npNode;
        int count = 0;
        int i = 0;
        while (i < leaves.size()) {
            int number = leaves.get(i);
            ++count;
            this.order[number] = -1;
            int ind = this.npNodes.indexOf(number);
            if (ind != -1) {
                this.npNodes.remove(ind);
            }
            int j = number + 1;
            while (j < n) {
                this.order[j] = this.order[j] - 1;
                ++j;
            }
            ++i;
        }
        this.assalog.println(String.valueOf(count) + " leave(s) is/are removed!");
        this.numLeaves = count;
        this.nf = this.pbn.getNf();
        if (this.originalNf == null) {
            this.originalNf = new int[n];
            System.arraycopy(this.nf, 0, this.originalNf, 0, n);
        }
        this.nf = new int[n - count];
        i = 0;
        while (i < n) {
            if (this.order[i] != -1) {
                this.nf[this.order[i]] = this.originalNf[i];
            }
            ++i;
        }
        if (this.pbn instanceof BDDPBN) {
            Model m = ((BDDPBN)this.pbn).getModel();
            m.setLeaves(leaves);
        } else {
            this.shufferCijLeaves(n - count);
        }
        ArrayList<Integer> tmpIndex = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < positiveIndex.size()) {
            tmpIndex.add(this.order[(Integer)positiveIndex.get(i2)]);
            ++i2;
        }
        positiveIndex.clear();
        i2 = 0;
        while (i2 < negativeIndex.size()) {
            positiveIndex.add(this.order[(Integer)negativeIndex.get(i2)]);
            ++i2;
        }
        this.property.setExpressions(tmpIndex, positiveIndex);
        this.assalog.println("Finish processing leaves!");
    }

    public void computeNewCij(List<double[]> cij, double[] newCijElement, int startNode, int endNode, int depth, double currentValue, List<Integer> funIndex) throws Exception {
        int[] cumNf = this.pbn.buildCumNf();
        if (depth == endNode - startNode) {
            ArrayList<Integer> tmpParent = new ArrayList<Integer>();
            List<int[]> varF = this.pbn.getVarFInt();
            List<boolean[]> F = this.pbn.getF();
            BitVector result = new BitVector(depth + 1);
            short[] elementGFI = null;
            ArrayList<short[]> elementGFI2D = null;
            short[] elementEGFI2D = null;
            int i = 0;
            while (i < this.nf[endNode]) {
                int ee;
                newCijElement[this.index_newCij] = currentValue * cij.get(endNode)[i];
                tmpParent.clear();
                for (int e : funIndex) {
                    int[] nArray = varF.get(e);
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ee = nArray[n2];
                        if (!tmpParent.contains(ee)) {
                            tmpParent.add(ee);
                        }
                        ++n2;
                    }
                }
                int[] nArray = varF.get(cumNf[endNode] + i);
                ee = nArray.length;
                int n = 0;
                while (n < ee) {
                    int ee2 = nArray[n];
                    if (!tmpParent.contains(ee2)) {
                        tmpParent.add(ee2);
                    }
                    ++n;
                }
                int[] parent = ArrayUtils.toPrimitive((Integer[])tmpParent.toArray(new Integer[tmpParent.size()]));
                Arrays.sort(parent);
                this.varGroup.add(parent);
                if (Parameters.enable2D) {
                    elementGFI2D = new ArrayList<short[]>();
                    elementEGFI2D = new short[Parameters.size2D];
                } else {
                    elementGFI = new short[(int)Math.pow(2.0, parent.length)];
                }
                BitVector bt = new BitVector(parent.length);
                BitVector bt2 = new BitVector(parent.length);
                int count2D = 0;
                int j = 0;
                while ((double)j < Math.pow(2.0, parent.length)) {
                    result.clear();
                    bt.putLongFromTo((long)j, 0, parent.length - 1);
                    int count = 0;
                    int index = 0;
                    int resultIndex = 0;
                    for (int e : funIndex) {
                        bt2.clear();
                        count = 0;
                        index = 0;
                        int[] nArray2 = varF.get(e);
                        int n3 = nArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int ee3 = nArray2[n4];
                            while (parent[count] != ee3) {
                                ++count;
                            }
                            if (bt.get(count)) {
                                bt2.set(index);
                            }
                            ++index;
                            ++n4;
                        }
                        result.put(resultIndex, F.get(e)[(int)bt2.getLongFromTo(0, index - 1)]);
                        ++resultIndex;
                    }
                    bt2.clear();
                    count = 0;
                    index = 0;
                    int[] nArray3 = varF.get(cumNf[endNode] + i);
                    int n5 = nArray3.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        int ee4 = nArray3[n6];
                        while (parent[count] != ee4) {
                            ++count;
                        }
                        if (bt.get(count)) {
                            bt2.set(index);
                        }
                        ++index;
                        ++n6;
                    }
                    result.put(resultIndex, F.get(cumNf[endNode] + i)[(int)bt2.getLongFromTo(0, index - 1)]);
                    if (Parameters.enable2D) {
                        elementEGFI2D[count2D] = (short)result.getLongFromTo(0, depth);
                        if (count2D == Parameters.size2D - 1) {
                            elementGFI2D.add(elementEGFI2D);
                            elementEGFI2D = new short[Parameters.size2D];
                            count2D = 0;
                        } else {
                            ++count2D;
                        }
                    } else {
                        elementGFI[j] = (short)result.getLongFromTo(0, depth);
                    }
                    ++j;
                }
                if (Parameters.enable2D) {
                    this.groupFunctionIndex2D.add(elementGFI2D);
                    if (count2D != Parameters.size2D - 1) {
                        elementGFI2D.add(elementEGFI2D);
                    }
                } else {
                    this.groupFunctionIndex.add(elementGFI);
                }
                ++this.index_newCij;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.nf[startNode + depth]) {
                funIndex.add(cumNf[startNode + depth] + i);
                this.computeNewCij(cij, newCijElement, startNode, endNode, depth + 1, currentValue * cij.get(startNode + depth)[i], funIndex);
                funIndex.remove(funIndex.size() - 1);
                ++i;
            }
        }
    }

    public void computeNewCij(List<double[]> cij, double[] newCijElement, int startNode, int endNode, int depth, double currentValue, List<Integer> funIndex, boolean type) throws Exception {
        int[] cumNf = this.pbn.buildCumNf();
        if (depth == endNode - startNode) {
            ArrayList<Integer> tmpParent = new ArrayList<Integer>();
            List<int[]> varF = this.pbn.getVarFInt();
            List<boolean[]> F = this.pbn.getF();
            JDDNode elementFunJDD = null;
            BDDPBN BDDpbn = null;
            if (!(this.pbn instanceof BDDPBN)) {
                throw new AssaException("PBN must be loaded in BDDPBN format!");
            }
            BDDpbn = (BDDPBN)this.pbn;
            Model model = BDDpbn.getModel();
            JDDVars vars = model.getBDDFunctions();
            int i = 0;
            while (i < this.nf[endNode]) {
                newCijElement[this.index_newCij] = currentValue * cij.get(endNode)[i];
                tmpParent.clear();
                int j = 1;
                elementFunJDD = null;
                for (int e : funIndex) {
                    JDDNode tmpNode = vars.getVar(e);
                    JDD.Ref(tmpNode);
                    JDDNode constant = JDD.Constant(j);
                    j *= 2;
                    tmpNode = JDD.Apply(3, tmpNode, constant);
                    elementFunJDD = elementFunJDD == null ? tmpNode : JDD.Apply(1, tmpNode, elementFunJDD);
                    int[] nArray = varF.get(e);
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int ee = nArray[n2];
                        if (!tmpParent.contains(ee)) {
                            tmpParent.add(ee);
                        }
                        ++n2;
                    }
                }
                JDDNode tmpNode = vars.getVar(cumNf[endNode] + i);
                JDD.Ref(tmpNode);
                JDDNode constant = JDD.Constant(j);
                tmpNode = JDD.Apply(3, tmpNode, constant);
                elementFunJDD = elementFunJDD == null ? tmpNode : JDD.Apply(1, tmpNode, elementFunJDD);
                int[] nArray = varF.get(cumNf[endNode] + i);
                int n = nArray.length;
                int n3 = 0;
                while (n3 < n) {
                    int ee = nArray[n3];
                    if (!tmpParent.contains(ee)) {
                        tmpParent.add(ee);
                    }
                    ++n3;
                }
                int[] parent = ArrayUtils.toPrimitive((Integer[])tmpParent.toArray(new Integer[tmpParent.size()]));
                Arrays.sort(parent);
                this.varGroup.add(parent);
                this.groupFunctionBDD.addVar(elementFunJDD);
                ++this.index_newCij;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.nf[startNode + depth]) {
                funIndex.add(cumNf[startNode + depth] + i);
                this.computeNewCij(cij, newCijElement, startNode, endNode, depth + 1, currentValue * cij.get(startNode + depth)[i], funIndex, true);
                funIndex.remove(funIndex.size() - 1);
                ++i;
            }
        }
    }

    public void computeNewCij(List<double[]> cij, double[] newCijElement, int startNode, int endNode, int depth, double currentValue) throws Exception {
        if (depth == endNode - startNode) {
            int i = 0;
            while (i < this.nf[endNode]) {
                newCijElement[this.index_newCij] = currentValue * cij.get(endNode)[i];
                ++this.index_newCij;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.nf[startNode + depth]) {
                this.computeNewCij(cij, newCijElement, startNode, endNode, depth + 1, currentValue * cij.get(startNode + depth)[i]);
                ++i;
            }
        }
    }

    public void run(String graphFileName) throws Exception {
        ThreadMXBean thread = ManagementFactory.getThreadMXBean();
        long cpu = thread.getCurrentThreadCpuTime();
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        Parameters.printlevel = 3;
        this.setGraphFile(graphFileName);
        this.detectLeaves();
        double rnd = Math.random();
        try {
            io.exportPBN((BitSetPBN)this.pbn, String.valueOf(this.PBNFile) + rnd + ".noleave.pbn", false);
            this.pbn = io.loadPBN(String.valueOf(this.PBNFile) + rnd + ".noleave.pbn", 1);
            io.delete(String.valueOf(this.PBNFile) + rnd + ".noleave.pbn");
            this.initialiseOrder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.performGroup) {
            this.sort();
            this.PBNFile = String.valueOf(this.PBNFile) + rnd + "_re.pbn";
            try {
                if (this.pbn instanceof BDDPBN) {
                    io.exportPBN((BDDPBN)this.pbn, this.PBNFile, this.order);
                } else {
                    this.shufferCij();
                    io.exportPBN((BitSetPBN)this.pbn, this.PBNFile, true);
                }
                this.pbn = io.loadPBN(this.PBNFile, 1);
                io.delete(this.PBNFile);
                this.initialiseOrder();
                this.nf = this.pbn.getNf();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                switch (this.groupFunctionStore) {
                    case 0: {
                        this.divideNodes(this.maxNumberElements);
                        break;
                    }
                    case 1: {
                        this.divideNodes(this.maxNumberElements);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.pbn.setNpNode(this.npNodes);
            try {
                if (this.pbn instanceof BDDPBN) {
                    io.exportPBN((BDDPBN)this.pbn, this.PBNFile, this.order);
                } else {
                    this.shufferCij();
                    io.exportPBN((BitSetPBN)this.pbn, this.PBNFile, true);
                }
                this.pbn = io.loadPBN(this.PBNFile, 1);
                this.nf = this.pbn.getNf();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            List<double[]> cij = ((BitSetPBN)this.pbn).getCij();
            this.newCij = new ArrayList<double[]>();
            this.amList = new ArrayList<AliasMethod>();
            ArrayList<Integer> funIndex = new ArrayList<Integer>();
            this.groupState = new ArrayList<StateBit[]>();
            this.groupFunctionIndex = new ArrayList<short[]>();
            this.groupFunctionIndex2D = new ArrayList<List<short[]>>();
            this.groupFunctionBDD = new JDDVars();
            this.varGroup = new ArrayList<int[]>();
            this.assalog.println("Computing combined Boolean functions.");
            int i = 1;
            while (i <= this.num_groups) {
                this.index_newCij = 0;
                int startNode = this.cumGroup[i - 1];
                int endNode = this.cumGroup[i] - 1;
                double[] newCijElement = new double[this.groupCijSize[i - 1]];
                int[] column = new int[this.groupCijSize[i - 1]];
                int j = 0;
                while (j < this.groupCijSize[i - 1]) {
                    column[j] = j;
                    ++j;
                }
                funIndex.clear();
                switch (this.groupFunctionStore) {
                    case 0: {
                        this.computeNewCij(cij, newCijElement, startNode, endNode, 0, 1.0, funIndex);
                        break;
                    }
                    case 1: {
                        this.computeNewCij(cij, newCijElement, startNode, endNode, 0, 1.0, funIndex, true);
                        break;
                    }
                    default: {
                        this.computeNewCij(cij, newCijElement, startNode, endNode, 0, 1.0, funIndex);
                        this.index_newCij = 0;
                        funIndex.clear();
                        this.computeNewCij(cij, newCijElement, startNode, endNode, 0, 1.0, funIndex, true);
                    }
                }
                this.newCij.add(newCijElement);
                AliasMethod am = new AliasMethod(newCijElement, column);
                this.amList.add(am);
                this.assalog.println("Number compined Boolean functions in group " + i + " is " + am.getAliasArray().length + ".");
                ++i;
            }
        } else {
            this.PBNFile = String.valueOf(this.PBNFile) + ".noleave.pbn";
        }
        this.exportNewProperty();
        if (this.performGroup) {
            // empty if block
        }
        if (this.groupFunctionStore == 0) {
            this.groupOneFunctionNode();
        } else {
            this.groupOneFunctionNodeMTBDD();
        }
        if (this.groupFunctionStore == 1) {
            JDDPBN.initialiseAm(this.pbn.getN(), this.newCij);
        }
        this.assalog.println("Cleaning temperal files.");
        double cpucost = (double)(thread.getCurrentThreadCpuTime() - cpu) / 1.0E9;
        this.assalog.println("Finish optimizing model. Time cost: " + cpucost + "s.");
        Parameters.printlevel = 1;
    }

    private void groupOneFunctionNodeMTBDD() throws AssaException {
        this.numOneFunctionGroup = (int)Math.ceil((double)this.numOneFunction / (double)Parameters.MAX_JDD_NODE);
        this.sizeOneFunctionGroup = (int)Math.ceil((double)this.numOneFunction / (double)this.numOneFunctionGroup);
        this.sizeLastFunctionGroup = this.numOneFunction - this.sizeOneFunctionGroup * (this.numOneFunctionGroup - 1);
        int startNode = this.cumGroup[this.num_groups];
        int endNode = startNode + this.sizeOneFunctionGroup;
        this.oneFunctionBDD = new JDDVars();
        if (endNode >= this.pbn.getN() - 1) {
            endNode = this.pbn.getN() - 1;
        }
        boolean notDone = true;
        JDDNode elementFunJDD = null;
        BDDPBN BDDpbn = null;
        if (!(this.pbn instanceof BDDPBN)) {
            throw new AssaException("PBN must be loaded in BDDPBN format!");
        }
        BDDpbn = (BDDPBN)this.pbn;
        Model model = BDDpbn.getModel();
        JDDVars vars = model.getBDDFunctions();
        while (notDone) {
            double d_const = 1.0;
            elementFunJDD = null;
            int i = startNode;
            while (i <= endNode) {
                JDDNode tmpNode = vars.getVar(this.cumNf[i]);
                JDD.Ref(tmpNode);
                JDDNode constant = JDD.Constant(d_const);
                d_const *= 2.0;
                tmpNode = JDD.Apply(3, tmpNode, constant);
                elementFunJDD = elementFunJDD == null ? tmpNode : JDD.Apply(1, tmpNode, elementFunJDD);
                JDD.PrintInfo(elementFunJDD, 0);
                ++i;
            }
            this.oneFunctionBDD.addVar(elementFunJDD);
            startNode = endNode + 1;
            if (startNode >= this.pbn.getN()) {
                notDone = false;
            }
            if ((endNode += this.sizeOneFunctionGroup) < this.pbn.getN() - 1) continue;
            endNode = this.pbn.getN() - 1;
        }
    }

    private void groupOneFunctionNode() throws Exception {
        if (this.numOneFunction == 0) {
            this.numOneFunctionGroup = 0;
            this.sizeOneFunctionGroup = 0;
            this.sizeLastFunctionGroup = 0;
            this.varOneFunctionGroup = new ArrayList<int[]>();
            return;
        }
        boolean notDone = true;
        while (notDone) {
            int n;
            int[] parent;
            int e;
            int n2;
            this.numOneFunctionGroup = (int)Math.ceil((double)this.numOneFunction / (double)this.sizeOneFunctionGroup);
            this.sizeOneFunctionGroup = (int)Math.ceil((double)this.numOneFunction / (double)this.numOneFunctionGroup);
            this.sizeLastFunctionGroup = this.numOneFunction - this.sizeOneFunctionGroup * (this.numOneFunctionGroup - 1);
            this.varOneFunctionGroup = new ArrayList<int[]>();
            if (Parameters.enable2D) {
                this.groupOneFunctionIndex2D = new ArrayList<List<short[]>>();
            } else {
                this.groupOneFunctionIndex = new ArrayList<short[]>();
            }
            this.groupOneFunctionState = new ArrayList<StateBit[]>();
            this.assalog.println("Trying: " + this.numOneFunction + " one function node(s) is/are divided into " + this.numOneFunctionGroup + " group(s).");
            ArrayList<Integer> tmpParent = new ArrayList<Integer>();
            List<int[]> varF = this.pbn.getVarFInt();
            int[] cumNf = this.pbn.buildCumNf();
            int startNode = this.cumGroup == null ? 0 : this.cumGroup[this.num_groups];
            int endNode = startNode + this.sizeOneFunctionGroup;
            boolean needBreak = false;
            int i = 0;
            while (i < this.numOneFunctionGroup - 1) {
                tmpParent.clear();
                int j = startNode;
                while (j < endNode) {
                    int[] nArray = varF.get(cumNf[j]);
                    int n3 = nArray.length;
                    n2 = 0;
                    while (n2 < n3) {
                        e = nArray[n2];
                        if (!tmpParent.contains(e)) {
                            tmpParent.add(e);
                        }
                        ++n2;
                    }
                    ++j;
                }
                parent = ArrayUtils.toPrimitive((Integer[])tmpParent.toArray(new Integer[tmpParent.size()]));
                if (parent.length > Parameters.MAX_PARENT_NUM) {
                    --this.sizeOneFunctionGroup;
                    notDone = true;
                    needBreak = true;
                    break;
                }
                this.assalog.println("One function node group " + i + ": " + this.sizeOneFunctionGroup + " nodes, " + parent.length + " parent nodes.");
                Arrays.sort(parent);
                this.varOneFunctionGroup.add(parent);
                startNode = endNode;
                endNode = startNode + this.sizeOneFunctionGroup;
                ++i;
            }
            if (needBreak) continue;
            endNode = startNode + this.sizeLastFunctionGroup;
            tmpParent.clear();
            int j = startNode;
            while (j < endNode) {
                int[] nArray = varF.get(cumNf[j]);
                n2 = nArray.length;
                e = 0;
                while (e < n2) {
                    int e2 = nArray[e];
                    if (!tmpParent.contains(e2)) {
                        tmpParent.add(e2);
                    }
                    ++e;
                }
                ++j;
            }
            parent = ArrayUtils.toPrimitive((Integer[])tmpParent.toArray(new Integer[tmpParent.size()]));
            if (parent.length > Parameters.MAX_PARENT_NUM) {
                --this.sizeOneFunctionGroup;
                notDone = true;
                continue;
            }
            this.assalog.println("One function node group " + (this.numOneFunctionGroup - 1) + ": " + this.sizeLastFunctionGroup + " nodes, " + parent.length + " parent nodes.");
            Arrays.sort(parent);
            this.varOneFunctionGroup.add(parent);
            startNode = this.cumGroup == null ? 0 : this.cumGroup[this.num_groups];
            endNode = startNode + this.sizeOneFunctionGroup;
            BitVector result = new BitVector(this.sizeOneFunctionGroup);
            List<boolean[]> F = this.pbn.getF();
            int i2 = 0;
            while (i2 < this.numOneFunctionGroup - 1) {
                parent = this.varOneFunctionGroup.get(i2);
                short[] elementGFI = null;
                ArrayList<short[]> elementGFI2D = new ArrayList<short[]>();
                short[] elementEGFI2D = null;
                int count2D = 0;
                if (Parameters.enable2D) {
                    elementGFI2D = new ArrayList();
                    elementEGFI2D = new short[Parameters.size2D];
                } else {
                    elementGFI = new short[(int)Math.pow(2.0, parent.length)];
                }
                BitVector bt = new BitVector(parent.length);
                BitVector bt2 = new BitVector(parent.length);
                int j2 = 0;
                while ((double)j2 < Math.pow(2.0, parent.length)) {
                    result.clear();
                    bt.putLongFromTo((long)j2, 0, parent.length - 1);
                    int count = 0;
                    int index = 0;
                    int resultIndex = 0;
                    int k = startNode;
                    while (k < endNode) {
                        bt2.clear();
                        count = 0;
                        index = 0;
                        int[] nArray = varF.get(cumNf[k]);
                        int n4 = nArray.length;
                        n = 0;
                        while (n < n4) {
                            int ee = nArray[n];
                            while (parent[count] != ee) {
                                ++count;
                            }
                            if (bt.get(count)) {
                                bt2.set(index);
                            }
                            ++index;
                            ++n;
                        }
                        result.put(resultIndex, F.get(cumNf[k])[(int)bt2.getLongFromTo(0, index - 1)]);
                        ++resultIndex;
                        ++k;
                    }
                    if (Parameters.enable2D) {
                        elementEGFI2D[count2D] = (short)result.getLongFromTo(0, this.sizeOneFunctionGroup - 1);
                        if (count2D == Parameters.size2D - 1) {
                            elementGFI2D.add(elementEGFI2D);
                            elementEGFI2D = new short[Parameters.size2D];
                            count2D = 0;
                        } else {
                            ++count2D;
                        }
                    } else {
                        elementGFI[j2] = (short)result.getLongFromTo(0, this.sizeOneFunctionGroup - 1);
                    }
                    ++j2;
                }
                if (Parameters.enable2D) {
                    this.groupOneFunctionIndex2D.add(elementGFI2D);
                    if (count2D != Parameters.size2D - 1) {
                        elementGFI2D.add(elementEGFI2D);
                    }
                } else {
                    this.groupOneFunctionIndex.add(elementGFI);
                }
                startNode = endNode;
                endNode = startNode + this.sizeOneFunctionGroup;
                ++i2;
            }
            endNode = startNode + this.sizeLastFunctionGroup;
            result = new BitVector(this.sizeLastFunctionGroup);
            parent = this.varOneFunctionGroup.get(this.numOneFunctionGroup - 1);
            short[] elementGFI = null;
            ArrayList<short[]> elementGFI2D = new ArrayList<short[]>();
            short[] elementEGFI2D = null;
            if (Parameters.enable2D) {
                elementGFI2D = new ArrayList();
                elementEGFI2D = new short[Parameters.size2D];
            } else {
                elementGFI = new short[(int)Math.pow(2.0, parent.length)];
            }
            BitVector bt = new BitVector(parent.length);
            BitVector bt2 = new BitVector(parent.length);
            int count2D = 0;
            int j3 = 0;
            while ((double)j3 < Math.pow(2.0, parent.length)) {
                result.clear();
                bt.putLongFromTo((long)j3, 0, parent.length - 1);
                int count = 0;
                int index = 0;
                int resultIndex = 0;
                int k = startNode;
                while (k < endNode) {
                    bt2.clear();
                    count = 0;
                    index = 0;
                    int[] nArray = varF.get(cumNf[k]);
                    n = nArray.length;
                    int n5 = 0;
                    while (n5 < n) {
                        int ee = nArray[n5];
                        while (parent[count] != ee) {
                            ++count;
                        }
                        if (bt.get(count)) {
                            bt2.set(index);
                        }
                        ++index;
                        ++n5;
                    }
                    result.put(resultIndex, F.get(cumNf[k])[(int)bt2.getLongFromTo(0, index - 1)]);
                    ++resultIndex;
                    ++k;
                }
                if (Parameters.enable2D) {
                    elementEGFI2D[count2D] = (short)result.getLongFromTo(0, this.sizeLastFunctionGroup - 1);
                    if (count2D == Parameters.size2D - 1) {
                        elementGFI2D.add(elementEGFI2D);
                        elementEGFI2D = new short[Parameters.size2D];
                        count2D = 0;
                    } else {
                        ++count2D;
                    }
                } else {
                    elementGFI[j3] = (short)result.getLongFromTo(0, this.sizeLastFunctionGroup - 1);
                }
                ++j3;
            }
            if (Parameters.enable2D) {
                this.groupOneFunctionIndex2D.add(elementGFI2D);
                if (count2D != Parameters.size2D - 1) {
                    elementGFI2D.add(elementEGFI2D);
                }
            } else {
                this.groupOneFunctionIndex.add(elementGFI);
            }
            int n6 = this.pbn.getN();
            startNode = this.cumGroup == null ? 0 : this.cumGroup[this.num_groups];
            endNode = startNode + this.sizeOneFunctionGroup - 1;
            int i3 = 0;
            while (i3 < this.numOneFunctionGroup - 1) {
                StateBit[] elementSB = new StateBit[(int)Math.pow(2.0, this.sizeOneFunctionGroup)];
                int j4 = 0;
                while (j4 < elementSB.length) {
                    elementSB[j4] = new StateBit(n6);
                    elementSB[j4].putLongFromTo(j4, startNode, endNode);
                    ++j4;
                }
                this.groupOneFunctionState.add(elementSB);
                startNode = endNode + 1;
                endNode = startNode + this.sizeOneFunctionGroup - 1;
                ++i3;
            }
            endNode = startNode + this.sizeLastFunctionGroup - 1;
            StateBit[] elementSB = new StateBit[(int)Math.pow(2.0, this.sizeLastFunctionGroup)];
            int j5 = 0;
            while (j5 < elementSB.length) {
                elementSB[j5] = new StateBit(n6);
                elementSB[j5].putLongFromTo(j5, startNode, endNode);
                ++j5;
            }
            this.groupOneFunctionState.add(elementSB);
            notDone = false;
            this.assalog.println("Finish grouping nodes with only one Boolean function.");
        }
    }

    public void computeGroupBooleanFunction() {
    }

    private void computeGroupBooleanFunctionSparse() throws Exception {
        int n = this.pbn.getN();
        int i = 0;
        while (i < this.num_groups) {
            int start = this.cumGroup[i];
            int end = this.cumGroup[i + 1] - 1;
            int size = (int)Math.pow(2.0, this.cumGroup[i + 1] - this.cumGroup[i]);
            StateBit[] stGroup = new StateBit[size];
            int j = 0;
            while (j < size) {
                stGroup[j] = new StateBit(n);
                stGroup[j].putLongFromTo(j, start, end);
                ++j;
            }
            this.groupState.add(stGroup);
            ++i;
        }
    }

    public String getPBNFile() {
        return this.PBNFile;
    }

    public void exportNewProperty() throws FileNotFoundException {
        File f = new File(this.PBNFile);
        this.propertyFile = String.valueOf(this.propertyFile) + "_" + f.getName() + ".txt";
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(new File(this.propertyFile))), true);
        List positiveIndex = this.property.getPositiveIndex();
        List negativeIndex = this.property.getNegativeIndex();
        int i = 0;
        while (i < positiveIndex.size()) {
            pw.print(positiveIndex.get(i) + " ");
            ++i;
        }
        if (positiveIndex.size() == 0) {
            pw.println("-1");
        }
        pw.println();
        i = 0;
        while (i < negativeIndex.size()) {
            pw.print(negativeIndex.get(i) + " ");
            ++i;
        }
        if (negativeIndex.size() == 0) {
            pw.println("-1");
        }
        pw.close();
        this.assalog.println("\nThe new property file is exported to " + this.propertyFile);
    }

    public void sort() throws Exception {
        this.assalog.println("Start sorting nodes...");
        int n = this.pbn.getN();
        this.nf = this.pbn.getNf();
        int[] nfCopy = new int[n];
        int i = 0;
        while (i < n) {
            nfCopy[i] = this.nf[i];
            this.order[i] = -1;
            ++i;
        }
        QuickSort.quickSort(this.nf, 0, n - 1);
        int index = 0;
        int i2 = 0;
        while (i2 < n) {
            if (this.nf[i2] != 1) {
                int j = 0;
                while (j < n) {
                    if (nfCopy[j] == this.nf[i2]) {
                        this.order[index] = j;
                        nfCopy[j] = -1;
                        ++index;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        ArrayList<Integer> parent = new ArrayList<Integer>();
        List<int[]> varF = this.pbn.getVarFInt();
        int[] cumNf = this.pbn.buildCumNf();
        while (index < n) {
            int maxCredit = -1;
            int maxIndex = 0;
            int j = 0;
            while (j < n) {
                if (nfCopy[j] == 1) {
                    int indexNf = cumNf[j];
                    int[] pa = varF.get(indexNf);
                    int credit = 0;
                    int i3 = 0;
                    while (i3 < pa.length) {
                        if (parent.contains(pa[i3])) {
                            ++credit;
                        }
                        ++i3;
                    }
                    if (maxCredit < credit) {
                        maxCredit = credit;
                        maxIndex = j;
                    }
                }
                ++j;
            }
            this.order[index] = maxIndex;
            nfCopy[maxIndex] = -1;
            int indexNf = cumNf[maxIndex];
            int[] pa = varF.get(indexNf);
            int i4 = 0;
            while (i4 < pa.length) {
                if (!parent.contains(pa[i4])) {
                    parent.add(pa[i4]);
                }
                ++i4;
            }
            ++index;
        }
        List positiveIndex = this.property.getPositiveIndex();
        List negativeIndex = this.property.getNegativeIndex();
        ArrayList<Integer> newPositive = new ArrayList<Integer>();
        ArrayList<Integer> newNegative = new ArrayList<Integer>();
        ArrayList<Integer> newNpNodes = new ArrayList<Integer>();
        int i5 = 0;
        while (i5 < n) {
            if (positiveIndex.contains(this.order[i5])) {
                newPositive.add(i5);
            } else if (negativeIndex.contains(this.order[i5])) {
                newNegative.add(i5);
            }
            if (this.npNodes.contains(this.order[i5])) {
                newNpNodes.add(i5);
            }
            ++i5;
        }
        this.npNodes = newNpNodes;
        this.property.setExpressions(newPositive, newNegative);
        this.assalog.println("Finish sorting nodes.");
    }

    public double divideNodes(int maxElements) throws Exception {
        this.assalog.println("Start grouping nodes...");
        int n = this.pbn.getN();
        this.nf = this.pbn.getNf();
        this.originalNf = new int[n];
        System.arraycopy(this.nf, 0, this.originalNf, 0, n);
        int count = n - 1;
        int[] nfCopy = new int[n];
        int i = 0;
        while (i < n) {
            nfCopy[i] = this.nf[i];
            this.order[i] = -1;
            ++i;
        }
        int localindex = 0;
        List positiveIndex = this.property.getPositiveIndex();
        List negativeIndex = this.property.getNegativeIndex();
        ArrayList<Integer> newPositive = new ArrayList<Integer>();
        ArrayList<Integer> newNegative = new ArrayList<Integer>();
        double sum = 0.0;
        this.numOneFunction = 0;
        while (count >= 0 && this.nf[count] == 1) {
            --count;
            ++this.numOneFunction;
        }
        if (++count != 0) {
            int k;
            int j;
            int i2;
            this.group = new int[count];
            int[] credit = new int[count];
            int mincredit = 1;
            int minIndex = 0;
            boolean done = false;
            List<int[]> varF = this.pbn.getVarFInt();
            ArrayList parents = new ArrayList();
            this.num_groups = 1;
            while (!done) {
                List<Integer> parent;
                sum = this.num_groups;
                i2 = 0;
                while (i2 < count) {
                    this.group[i2] = -1;
                    credit[i2] = 1;
                    ++i2;
                }
                int[] parentCredit = new int[this.num_groups];
                int maxCredit = 0;
                i2 = 0;
                while (i2 < this.num_groups) {
                    parent = new ArrayList();
                    parents.add(parent);
                    ++i2;
                }
                i2 = 0;
                while (i2 < count) {
                    int[] elementVarF;
                    int maxParentCredit = 0;
                    int maxParentIndex = 0;
                    j = 0;
                    while (j < this.num_groups) {
                        parent = (List)parents.get(j);
                        parentCredit[j] = 0;
                        k = this.cumNf[i2];
                        while (k < this.cumNf[i2 + 1]) {
                            elementVarF = varF.get(k);
                            int l = 0;
                            while (l < elementVarF.length) {
                                if (parent.contains(elementVarF[l])) {
                                    int n2 = j;
                                    parentCredit[n2] = parentCredit[n2] + 1;
                                }
                                ++l;
                            }
                            ++k;
                        }
                        if (parentCredit[j] > maxParentCredit) {
                            maxParentCredit = parentCredit[j];
                            maxParentIndex = j;
                        }
                        ++j;
                    }
                    mincredit = Integer.MAX_VALUE;
                    j = 0;
                    while (j < this.num_groups) {
                        if (credit[j] < mincredit) {
                            mincredit = credit[j];
                            minIndex = j;
                        } else if (credit[j] == mincredit && parentCredit[j] > parentCredit[minIndex]) {
                            mincredit = credit[j];
                            minIndex = j;
                        }
                        ++j;
                    }
                    this.group[i2] = minIndex;
                    parent = (List)parents.get(minIndex);
                    int k2 = this.cumNf[i2];
                    while (k2 < this.cumNf[i2 + 1]) {
                        elementVarF = varF.get(k2);
                        int l = 0;
                        while (l < elementVarF.length) {
                            if (!parent.contains(elementVarF[l])) {
                                parent.add(elementVarF[l]);
                            }
                            ++l;
                        }
                        ++k2;
                    }
                    sum -= (double)credit[minIndex];
                    int n3 = minIndex;
                    credit[n3] = credit[n3] * this.nf[i2];
                    if (maxCredit < credit[minIndex]) {
                        maxCredit = credit[minIndex];
                    }
                    if ((sum += (double)credit[minIndex]) > (double)maxElements) {
                        i2 = count;
                    }
                    ++i2;
                }
                if (sum < (double)maxElements && maxCredit < Parameters.MAX_CREDIT) {
                    done = true;
                    continue;
                }
                ++this.num_groups;
            }
            this.groupCijSize = new int[this.num_groups];
            i2 = 0;
            while (i2 < this.num_groups) {
                this.groupCijSize[i2] = credit[i2];
                ++i2;
            }
            this.cumGroup = new int[this.num_groups + 1];
            i2 = 0;
            while (i2 <= this.num_groups) {
                this.cumGroup[i2] = 0;
                ++i2;
            }
            i2 = 0;
            while (i2 < count) {
                int n4 = this.group[i2] + 1;
                this.cumGroup[n4] = this.cumGroup[n4] + 1;
                ++i2;
            }
            i2 = 1;
            while (i2 <= this.num_groups) {
                this.cumGroup[i2] = this.cumGroup[i2 - 1] + this.cumGroup[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.num_groups) {
                j = 0;
                while (j < count) {
                    if (this.group[j] == i2) {
                        k = 0;
                        while (k < n) {
                            if (nfCopy[k] == this.nf[j]) {
                                this.order[localindex] = k;
                                nfCopy[k] = -1;
                                ++localindex;
                                k = n;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i2;
            }
        }
        this.preProcessOneFunctionNode(nfCopy, localindex, n);
        ArrayList<Integer> newNpNodes = new ArrayList<Integer>();
        int i3 = 0;
        while (i3 < n) {
            if (positiveIndex.contains(this.order[i3])) {
                newPositive.add(i3);
            } else if (negativeIndex.contains(this.order[i3])) {
                newNegative.add(i3);
            }
            if (this.npNodes.contains(this.order[i3])) {
                newNpNodes.add(i3);
            }
            ++i3;
        }
        this.npNodes = newNpNodes;
        this.property.setExpressions(newPositive, newNegative);
        this.assalog.println("Finish grouping nodes. The nodes with more than more Boolean functions are divided into " + this.num_groups + " groups.");
        return sum;
    }

    public double divideNodesMTBDD(int maxElements) throws Exception {
        int l;
        int[] elementVarF;
        int j;
        int maxParentIndex;
        int maxParentCredit;
        List<Integer> parent;
        int i;
        this.assalog.println("Start grouping nodes...");
        int n = this.pbn.getN();
        this.nf = this.pbn.getNf();
        this.originalNf = new int[n];
        System.arraycopy(this.nf, 0, this.originalNf, 0, n);
        int count = n - 1;
        int[] nfCopy = new int[n];
        int i2 = 0;
        while (i2 < n) {
            nfCopy[i2] = this.nf[i2];
            this.order[i2] = -1;
            ++i2;
        }
        QuickSort.quickSort(this.nf, 0, n - 1);
        this.numOneFunction = 0;
        while (this.nf[count] == 1) {
            --count;
            ++this.numOneFunction;
        }
        this.group = new int[n];
        int[] credit = new int[++count];
        int mincredit = 1;
        int minIndex = 0;
        boolean done = false;
        double sum = 0.0;
        List<int[]> varF = this.pbn.getVarFInt();
        ArrayList parents = new ArrayList();
        this.num_groups = 1;
        int[] parentCredit = null;
        while (!done) {
            sum = this.num_groups;
            i = 0;
            while (i < count) {
                this.group[i] = -1;
                credit[i] = 1;
                ++i;
            }
            parentCredit = new int[this.num_groups];
            i = 0;
            while (i < this.num_groups) {
                parent = new ArrayList();
                parents.add(parent);
                ++i;
            }
            i = 0;
            while (i < count) {
                maxParentCredit = 0;
                maxParentIndex = 0;
                j = 0;
                while (j < this.num_groups) {
                    parent = (List)parents.get(j);
                    parentCredit[j] = 0;
                    int k = this.cumNf[i];
                    while (k < this.cumNf[i + 1]) {
                        elementVarF = varF.get(k);
                        int l2 = 0;
                        while (l2 < elementVarF.length) {
                            if (parent.contains(elementVarF[l2])) {
                                int n2 = j;
                                parentCredit[n2] = parentCredit[n2] + 1;
                            }
                            ++l2;
                        }
                        ++k;
                    }
                    if (parentCredit[j] > maxParentCredit) {
                        maxParentCredit = parentCredit[j];
                        maxParentIndex = j;
                    }
                    ++j;
                }
                mincredit = Integer.MAX_VALUE;
                j = 0;
                while (j < this.num_groups) {
                    if (credit[j] < mincredit) {
                        mincredit = credit[j];
                        minIndex = j;
                    } else if (credit[j] == mincredit && parentCredit[j] > parentCredit[minIndex]) {
                        mincredit = credit[j];
                        minIndex = j;
                    }
                    ++j;
                }
                if (maxParentCredit > 2 && mincredit > 5 * (i + 1)) {
                    minIndex = maxParentIndex;
                }
                this.group[i] = minIndex;
                parent = (List)parents.get(minIndex);
                int k = this.cumNf[i];
                while (k < this.cumNf[i + 1]) {
                    elementVarF = varF.get(k);
                    l = 0;
                    while (l < elementVarF.length) {
                        if (!parent.contains(elementVarF[l])) {
                            parent.add(elementVarF[l]);
                        }
                        ++l;
                    }
                    ++k;
                }
                sum -= (double)credit[minIndex];
                int n3 = minIndex;
                credit[n3] = credit[n3] * this.nf[i];
                if ((sum += (double)credit[minIndex]) > (double)maxElements) {
                    i = count;
                }
                ++i;
            }
            if (sum < (double)maxElements) {
                done = true;
                continue;
            }
            ++this.num_groups;
        }
        i = count;
        while (i < n) {
            maxParentCredit = -1;
            maxParentIndex = 0;
            elementVarF = varF.get(this.cumNf[i]);
            j = 0;
            while (j < this.num_groups) {
                parent = (List)parents.get(j);
                parentCredit[j] = 0;
                l = 0;
                while (l < elementVarF.length) {
                    if (parent.contains(elementVarF[l])) {
                        int n4 = j;
                        parentCredit[n4] = parentCredit[n4] + 1;
                    }
                    ++l;
                }
                if (parentCredit[j] > maxParentCredit) {
                    maxParentCredit = parentCredit[j];
                    maxParentIndex = j;
                }
                ++j;
            }
            parent = (List)parents.get(maxParentIndex);
            int l3 = 0;
            while (l3 < elementVarF.length) {
                if (!parent.contains(elementVarF[l3])) {
                    parent.add(elementVarF[l3]);
                }
                ++l3;
            }
            this.group[i] = maxParentIndex;
            ++i;
        }
        this.groupCijSize = new int[this.num_groups];
        i = 0;
        while (i < this.num_groups) {
            this.groupCijSize[i] = credit[i];
            ++i;
        }
        this.cumGroup = new int[this.num_groups + 1];
        i = 0;
        while (i <= this.num_groups) {
            this.cumGroup[i] = 0;
            ++i;
        }
        i = 0;
        while (i < n) {
            int n5 = this.group[i] + 1;
            this.cumGroup[n5] = this.cumGroup[n5] + 1;
            ++i;
        }
        i = 1;
        while (i <= this.num_groups) {
            this.cumGroup[i] = this.cumGroup[i - 1] + this.cumGroup[i];
            ++i;
        }
        int index = 0;
        List positiveIndex = this.property.getPositiveIndex();
        List negativeIndex = this.property.getNegativeIndex();
        ArrayList<Integer> newPositive = new ArrayList<Integer>();
        ArrayList<Integer> newNegative = new ArrayList<Integer>();
        int i3 = 0;
        while (i3 < this.num_groups) {
            int j2 = 0;
            while (j2 < n) {
                if (this.group[j2] == i3) {
                    int k = 0;
                    while (k < n) {
                        if (nfCopy[k] == this.nf[j2]) {
                            this.order[index] = k;
                            nfCopy[k] = -1;
                            ++index;
                            k = n;
                        }
                        ++k;
                    }
                }
                ++j2;
            }
            ++i3;
        }
        ArrayList<Integer> newNpNodes = new ArrayList<Integer>();
        int i4 = 0;
        while (i4 < n) {
            if (positiveIndex.contains(this.order[i4])) {
                newPositive.add(i4);
            } else if (negativeIndex.contains(this.order[i4])) {
                newNegative.add(i4);
            }
            if (this.npNodes.contains(this.order[i4])) {
                newNpNodes.add(i4);
            }
            ++i4;
        }
        this.npNodes = newNpNodes;
        this.property.setExpressions(newPositive, newNegative);
        this.assalog.print("New positive index:");
        i4 = 0;
        while (i4 < newPositive.size()) {
            this.assalog.print(newPositive.get(i4) + " ");
            ++i4;
        }
        this.assalog.print("\nNew negative index:");
        i4 = 0;
        while (i4 < newNegative.size()) {
            this.assalog.print(newNegative.get(i4) + " ");
            ++i4;
        }
        this.assalog.println();
        this.assalog.println("Finish grouping nodes.\n");
        return sum;
    }

    private void preProcessOneFunctionNode(int[] nfCopy, int index, int n) throws Exception {
        if (this.numOneFunction == 0) {
            this.numOneFunctionGroup = 0;
            this.sizeOneFunctionGroup = 0;
            this.sizeLastFunctionGroup = 0;
            return;
        }
        this.numOneFunctionGroup = (int)Math.ceil((double)this.numOneFunction / (double)this.sizeOneFunctionGroup);
        this.sizeOneFunctionGroup = (int)Math.ceil((double)this.numOneFunction / (double)this.numOneFunctionGroup);
        this.sizeLastFunctionGroup = this.numOneFunction - this.sizeOneFunctionGroup * (this.numOneFunctionGroup - 1);
        List<int[]> varF = this.pbn.getVarFInt();
        int[] cumNf = this.pbn.buildCumNf();
        int[] groupIndex = new int[this.numOneFunctionGroup];
        int[] groupCount = new int[this.numOneFunctionGroup];
        boolean[] done = new boolean[this.numOneFunctionGroup];
        int[] credit = new int[this.numOneFunctionGroup];
        ArrayList parents = new ArrayList();
        List<Integer> parent = new ArrayList();
        parents.add(parent);
        groupIndex[0] = index;
        done[0] = false;
        credit[0] = 0;
        boolean notDone = true;
        groupCount[0] = 0;
        int i = 1;
        while (i < groupIndex.length) {
            groupIndex[i] = groupIndex[i - 1] + this.sizeOneFunctionGroup;
            parent = new ArrayList();
            parents.add(parent);
            done[i] = false;
            credit[i] = 0;
            groupCount[i] = 0;
            ++i;
        }
        while (notDone) {
            int maxIndex = -1;
            int i2 = 0;
            while (i2 < n) {
                if (nfCopy[i2] == 1) {
                    int[] elementVarF = varF.get(cumNf[i2]);
                    int max = 0;
                    maxIndex = (maxIndex + 1) % this.numOneFunctionGroup;
                    while (done[maxIndex]) {
                        maxIndex = (maxIndex + 1) % this.numOneFunctionGroup;
                    }
                    int j = 0;
                    while (j < this.numOneFunctionGroup) {
                        credit[j] = 0;
                        if (!done[j]) {
                            parent = (List)parents.get(j);
                            int k = 0;
                            while (k < elementVarF.length) {
                                if (parent.contains(elementVarF[k])) {
                                    int n2 = j;
                                    credit[n2] = credit[n2] + 1;
                                }
                                ++k;
                            }
                            if (max < credit[j]) {
                                max = credit[j];
                                maxIndex = j;
                            }
                        }
                        ++j;
                    }
                    this.order[groupIndex[maxIndex]] = i2;
                    int n3 = maxIndex;
                    groupIndex[n3] = groupIndex[n3] + 1;
                    int n4 = maxIndex;
                    groupCount[n4] = groupCount[n4] + 1;
                    parent = (List)parents.get(maxIndex);
                    int k = 0;
                    while (k < elementVarF.length) {
                        parent.add(elementVarF[k]);
                        ++k;
                    }
                    if (groupCount[maxIndex] == this.sizeOneFunctionGroup || maxIndex == this.numOneFunctionGroup - 1 && groupCount[maxIndex] == this.sizeLastFunctionGroup) {
                        done[maxIndex] = true;
                    }
                    notDone = false;
                    j = 0;
                    while (j < this.numOneFunctionGroup) {
                        if (!done[j]) {
                            notDone = true;
                            break;
                        }
                        ++j;
                    }
                    nfCopy[i2] = -1;
                }
                ++i2;
            }
        }
    }

    private void shufferCijLeaves(int newN) {
        List<double[]> cij = ((BitSetPBN)this.pbn).getCij();
        List<Integer> nv = this.pbn.getNv();
        List<boolean[]> F = this.pbn.getF();
        List<int[]> varF = this.pbn.getVarFInt();
        int n = this.pbn.getN();
        ArrayList<double[]> cijCopy = new ArrayList<double[]>(cij);
        cij.clear();
        int index = 0;
        while (index < this.nf.length) {
            int i = 0;
            while (i < n) {
                if (this.order[i] == index) {
                    cij.add((double[])cijCopy.get(i));
                    this.nf[index] = this.originalNf[i];
                    ++index;
                }
                ++i;
            }
        }
        ArrayList<Integer> nvCopy = new ArrayList<Integer>(nv);
        nv.clear();
        ArrayList<boolean[]> FCopy = new ArrayList<boolean[]>(F);
        ArrayList<int[]> varFCopy = new ArrayList<int[]>(varF);
        varF.clear();
        F.clear();
        index = 0;
        int[] orderF = new int[this.cumNf[n]];
        int i = 0;
        while (i < n) {
            if (this.order[i] != -1) {
                int j = this.cumNf[i];
                while (j < this.cumNf[i + 1]) {
                    nv.add((Integer)nvCopy.get(j));
                    F.add((boolean[])FCopy.get(j));
                    varF.add((int[])varFCopy.get(j));
                    orderF[index] = j++;
                    ++index;
                }
            }
            ++i;
        }
        i = 0;
        while (i < varF.size()) {
            int[] elementVarF = varF.get(i);
            int j = 0;
            while (j < elementVarF.length) {
                elementVarF[j] = this.order[elementVarF[j]];
                ++j;
            }
            ++i;
        }
        this.pbn.setN(newN);
        this.pbn.setNf(this.nf);
    }

    public void shufferCij() {
        List<double[]> cij = ((BitSetPBN)this.pbn).getCij();
        List<Integer> nv = this.pbn.getNv();
        List<boolean[]> F = this.pbn.getF();
        List<int[]> varF = this.pbn.getVarFInt();
        int n = this.pbn.getN();
        ArrayList<double[]> cijCopy = new ArrayList<double[]>(cij);
        cij.clear();
        int i = 0;
        while (i < n) {
            cij.add((double[])cijCopy.get(this.order[i]));
            this.nf[i] = this.originalNf[this.order[i]];
            ++i;
        }
        ArrayList<Integer> nvCopy = new ArrayList<Integer>(nv);
        nv.clear();
        ArrayList<boolean[]> FCopy = new ArrayList<boolean[]>(F);
        ArrayList<int[]> varFCopy = new ArrayList<int[]>(varF);
        varF.clear();
        F.clear();
        int index = 0;
        int[] orderF = new int[this.cumNf[n]];
        int i2 = 0;
        while (i2 < n) {
            int j = this.cumNf[this.order[i2]];
            while (j < this.cumNf[this.order[i2] + 1]) {
                nv.add((Integer)nvCopy.get(j));
                F.add((boolean[])FCopy.get(j));
                varF.add((int[])varFCopy.get(j));
                orderF[index] = j++;
                ++index;
            }
            ++i2;
        }
        int[] order_new = new int[n];
        int i3 = 0;
        while (i3 < n) {
            int j = 0;
            while (j < n) {
                if (this.order[j] == i3) {
                    order_new[i3] = j;
                }
                ++j;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < this.cumNf[n]) {
            int[] elementVarF = varF.get(i3);
            int j = 0;
            while (j < elementVarF.length) {
                elementVarF[j] = order_new[elementVarF[j]];
                ++j;
            }
            ++i3;
        }
    }

    public static void main(String[] args) {
        BitSetPBN pbn = null;
        AssaConsoleLog assalog = new AssaConsoleLog();
        BitSetPBNIO io = new BitSetPBNIO(assalog);
        String pbnFileName = "model/PBN_96_5_1.pbn";
        String graphFileName = String.valueOf(pbnFileName) + ".gra";
        String propertyFile = "model/PBN_property.txt";
        try {
            pbn = io.loadPBN(pbnFileName, 1);
            io.exportPBNtoGraph(pbn, graphFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OptimizePBN opt = new OptimizePBN(pbnFileName, assalog);
        opt.setPropertyFile(propertyFile);
        try {
            opt.run(graphFileName);
        }
        catch (IOException | NumberFormatException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

