/*
 * Decompiled with CFR 0.152.
 */
package PBN;

import PBN.StateBit;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import simulator.AliasMethod;
import userInterface.AssaLog;

public abstract class PBN {
    protected int n;
    protected int[] nf;
    protected List<Integer> nv;
    protected List<boolean[]> F;
    protected List<BitSet> varF;
    protected List<int[]> varFInt;
    protected List<double[]> cij;
    protected double perturbation;
    protected int[] cumNf;
    protected List<Integer> npNode;
    protected AssaLog assalog;
    protected List<StateBit[]> sts;
    protected AliasMethod am;
    protected int P_groupNum;
    protected int P_firstSize;
    protected int P_lastSize;
    protected int[] P_Mask;
    protected double[] p_cij;

    public int[] buildCumNf() throws Exception {
        if (this.nf == null) {
            throw new Exception("Cannot build cumNf before nf is initilised.");
        }
        if (this.cumNf != null) {
            return this.cumNf;
        }
        this.cumNf = new int[this.n + 1];
        this.cumNf[0] = 0;
        int i = 0;
        while (i < this.nf.length) {
            this.cumNf[i + 1] = this.cumNf[i] + this.nf[i];
            ++i;
        }
        return this.cumNf;
    }

    public void setAssaLog(AssaLog assalog) {
        this.assalog = assalog;
    }

    public void setN(int n) {
        this.n = n;
    }

    public void setNf(int[] nf) {
        this.nf = nf;
    }

    public void setNv(List<Integer> nv) {
        this.nv = nv;
    }

    public void setF(List<boolean[]> F) {
        this.F = F;
    }

    public void setvarF(List<BitSet> varF) {
        this.varF = varF;
        this.setvarFInt();
    }

    public void setvarFInt(List<int[]> varFInt) {
        this.varFInt = varFInt;
    }

    protected void setvarFInt() {
        this.varFInt = new ArrayList<int[]>();
        for (BitSet elementVarF : this.varF) {
            int num = elementVarF.cardinality();
            int[] elementVarFInt = new int[num];
            int index = -1;
            int count = 0;
            while ((index = elementVarF.nextSetBit(index + 1)) != -1) {
                elementVarFInt[count] = index;
                ++count;
            }
            this.varFInt.add(elementVarFInt);
        }
    }

    public void setPerturbation(double perturbation) {
        this.perturbation = perturbation;
    }

    public int getN() {
        return this.n;
    }

    public int[] getNf() {
        return this.nf;
    }

    public List<Integer> getNv() {
        return this.nv;
    }

    public List<boolean[]> getF() {
        return this.F;
    }

    public List<BitSet> getVarF() {
        return this.varF;
    }

    public List<int[]> getVarFInt() {
        return this.varFInt;
    }

    public List<double[]> getCij() {
        return this.cij;
    }

    public double getPerturbation() {
        return this.perturbation;
    }

    public void setNpNode(List<Integer> npNode) {
        if (this.npNode == null) {
            this.npNode = new ArrayList<Integer>();
        }
        if (this.npNode == npNode) {
            this.assalog.println("The given npNode is the same as the one in the PBN.");
        } else if (npNode != null) {
            this.npNode.clear();
            this.npNode.addAll(npNode);
            Collections.sort(this.npNode);
            if (!npNode.contains(this.n)) {
                this.npNode.add(this.n);
            }
            if (this.perturbation > 0.0) {
                this.setPerturbation(this.perturbation);
            }
        } else {
            this.npNode.add(this.n);
        }
    }

    public List<Integer> npNode() {
        return this.npNode;
    }

    public abstract boolean getNextNodeValue(int var1, StateBit var2);

    public abstract int getStateLength();

    public List<StateBit[]> getSts() {
        return this.sts;
    }

    public AliasMethod getPAm() {
        return this.am;
    }

    public int getP_groupNum() {
        return this.P_groupNum;
    }

    public int getP_firstSize() {
        return this.P_firstSize;
    }

    public int getP_lastSize() {
        return this.P_lastSize;
    }

    public int[] getP_Mask() {
        return this.P_Mask;
    }

    public double[] getP_cij() {
        return this.p_cij;
    }

    public abstract PBN copy();
}

