/*
 * Decompiled with CFR 0.152.
 */
package PBN;

import PBN.BDDPBN;
import PBN.BitSetPBN;
import PBN.BitSetPBNIO;
import PBN.PBN;
import PBN.ParseProperty;
import PBN.Property;
import SCC.Digraph;
import SCC.In;
import SCC.TarjanBlock;
import functionLib.AssaException;
import functionLib.Parameters;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import parser.Model;
import userInterface.AssaConsoleLog;
import userInterface.AssaLog;

public class ReducePBN {
    private PBN pbn;
    private int[] order;
    private int[] nf;
    private int[] originalNf;
    private int[] cumNf;
    private String graphFileName;
    private String PBNFile;
    private Property property;
    private String propertyFile;
    private int numLeaves;
    public static final int SPARSE = 0;
    public static final int MTBDD = 1;
    private List<Integer> npNodes;
    AssaLog assalog;

    public ReducePBN(String PBNFile2, AssaLog assalog) {
        this.PBNFile = PBNFile2;
        this.assalog = assalog;
        BitSetPBNIO io = new BitSetPBNIO(assalog);
        try {
            this.pbn = io.loadPBN(PBNFile2, 1);
            this.initialiseOrder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ReducePBN(PBN pbn, String PBNFile2, AssaLog assalog) {
        this.PBNFile = PBNFile2;
        this.assalog = assalog;
        this.pbn = pbn;
        try {
            this.initialiseOrder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initialiseOrder() throws Exception {
        this.order = new int[this.pbn.getN()];
        int i = 0;
        while (i < this.pbn.getN()) {
            this.order[i] = i;
            ++i;
        }
        int n = this.pbn.getN();
        this.originalNf = new int[n];
        System.arraycopy(this.pbn.getNf(), 0, this.originalNf, 0, n);
        this.cumNf = this.pbn.buildCumNf();
    }

    public void setGraphFile(String graphFileName) {
        this.graphFileName = graphFileName;
    }

    public void setPropertyFile(String propertyFile) {
        this.propertyFile = propertyFile;
    }

    public String getPropertyFile() {
        return this.propertyFile;
    }

    public int getNumLeaves() {
        return this.numLeaves;
    }

    public void detectLeaves() throws NumberFormatException, IOException, AssaException {
        TarjanBlock block = new TarjanBlock(new Digraph(new In(this.graphFileName)));
        this.property = ParseProperty.getProperties(this.pbn, this.propertyFile).get(0);
        block.removingLeaves(this.property);
        List<Integer> leaves = block.getLeaves();
        List positiveIndex = this.property.getPositiveIndex();
        List negativeIndex = this.property.getNegativeIndex();
        int n = this.pbn.getN();
        this.npNodes = this.pbn.npNode;
        int count = 0;
        int i = 0;
        while (i < leaves.size()) {
            int number = leaves.get(i);
            ++count;
            this.order[number] = -1;
            int ind = this.npNodes.indexOf(number);
            if (ind != -1) {
                this.npNodes.remove(ind);
            }
            int j = number + 1;
            while (j < n) {
                this.order[j] = this.order[j] - 1;
                ++j;
            }
            ++i;
        }
        this.assalog.println(String.valueOf(count) + " leave(s) is/are removed!");
        this.numLeaves = count;
        this.nf = this.pbn.getNf();
        if (this.originalNf == null) {
            this.originalNf = new int[n];
            System.arraycopy(this.nf, 0, this.originalNf, 0, n);
        }
        this.nf = new int[n - count];
        i = 0;
        while (i < n) {
            if (this.order[i] != -1) {
                this.nf[this.order[i]] = this.originalNf[i];
            }
            ++i;
        }
        if (this.pbn instanceof BDDPBN) {
            Model m = ((BDDPBN)this.pbn).getModel();
            m.setLeaves(leaves);
        } else {
            this.shufferCijLeaves(n - count);
        }
        ArrayList<Integer> tmpIndex = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < positiveIndex.size()) {
            tmpIndex.add(this.order[(Integer)positiveIndex.get(i2)]);
            ++i2;
        }
        positiveIndex.clear();
        i2 = 0;
        while (i2 < negativeIndex.size()) {
            positiveIndex.add(this.order[(Integer)negativeIndex.get(i2)]);
            ++i2;
        }
        this.property.setExpressions(tmpIndex, positiveIndex);
        this.assalog.println("Finish processing leaves!");
    }

    public void run(String graphFileName) throws Exception {
        ThreadMXBean thread = ManagementFactory.getThreadMXBean();
        long cpu = thread.getCurrentThreadCpuTime();
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        Parameters.printlevel = 3;
        this.setGraphFile(graphFileName);
        this.detectLeaves();
        double rnd = Math.random();
        try {
            this.PBNFile = String.valueOf(this.PBNFile) + rnd + ".noleave.pbn";
            io.exportPBN((BitSetPBN)this.pbn, this.PBNFile, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.exportNewProperty();
        double cpucost = (double)(thread.getCurrentThreadCpuTime() - cpu) / 1.0E9;
        this.assalog.println("Finish optimizing model. Time cost: " + cpucost + "s.");
        Parameters.printlevel = 1;
    }

    public String getPBNFile() {
        return this.PBNFile;
    }

    public void exportNewProperty() throws FileNotFoundException {
        File f = new File(this.PBNFile);
        this.propertyFile = String.valueOf(this.propertyFile) + "_" + f.getName() + ".txt";
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(new File(this.propertyFile))), true);
        List positiveIndex = this.property.getPositiveIndex();
        List negativeIndex = this.property.getNegativeIndex();
        int i = 0;
        while (i < positiveIndex.size()) {
            pw.print(positiveIndex.get(i) + " ");
            ++i;
        }
        if (positiveIndex.size() == 0) {
            pw.println("-1");
        }
        pw.println();
        i = 0;
        while (i < negativeIndex.size()) {
            pw.print(negativeIndex.get(i) + " ");
            ++i;
        }
        if (negativeIndex.size() == 0) {
            pw.println("-1");
        }
        pw.close();
        this.assalog.println("\nThe new property file is exported to " + this.propertyFile);
    }

    private void shufferCijLeaves(int newN) {
        List<double[]> cij = ((BitSetPBN)this.pbn).getCij();
        List<Integer> nv = this.pbn.getNv();
        List<boolean[]> F = this.pbn.getF();
        List<int[]> varF = this.pbn.getVarFInt();
        int n = this.pbn.getN();
        ArrayList<double[]> cijCopy = new ArrayList<double[]>(cij);
        cij.clear();
        int index = 0;
        while (index < this.nf.length) {
            int i = 0;
            while (i < n) {
                if (this.order[i] == index) {
                    cij.add((double[])cijCopy.get(i));
                    this.nf[index] = this.originalNf[i];
                    ++index;
                }
                ++i;
            }
        }
        ArrayList<Integer> nvCopy = new ArrayList<Integer>(nv);
        nv.clear();
        ArrayList<boolean[]> FCopy = new ArrayList<boolean[]>(F);
        ArrayList<int[]> varFCopy = new ArrayList<int[]>(varF);
        varF.clear();
        F.clear();
        index = 0;
        int[] orderF = new int[this.cumNf[n]];
        int i = 0;
        while (i < n) {
            if (this.order[i] != -1) {
                int j = this.cumNf[i];
                while (j < this.cumNf[i + 1]) {
                    nv.add((Integer)nvCopy.get(j));
                    F.add((boolean[])FCopy.get(j));
                    varF.add((int[])varFCopy.get(j));
                    orderF[index] = j++;
                    ++index;
                }
            }
            ++i;
        }
        i = 0;
        while (i < varF.size()) {
            int[] elementVarF = varF.get(i);
            int j = 0;
            while (j < elementVarF.length) {
                elementVarF[j] = this.order[elementVarF[j]];
                ++j;
            }
            ++i;
        }
        this.pbn.setN(newN);
        this.pbn.setNf(this.nf);
    }

    public static void main(String[] args) {
        BitSetPBN pbn = null;
        AssaConsoleLog assalog = new AssaConsoleLog();
        BitSetPBNIO io = new BitSetPBNIO(assalog);
        String pbnFileName = "model/PBN_96_5_1.pbn";
        String graphFileName = String.valueOf(pbnFileName) + ".gra";
        String propertyFile = "model/PBN_property.txt";
        try {
            pbn = io.loadPBN(pbnFileName, 1);
            io.exportPBNtoGraph(pbn, graphFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ReducePBN opt = new ReducePBN(pbnFileName, assalog);
        opt.setPropertyFile(propertyFile);
        try {
            opt.run(graphFileName);
        }
        catch (IOException | NumberFormatException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

