/*
 * Decompiled with CFR 0.152.
 */
package SCC;

import SCC.Bag;
import SCC.In;
import SCC.Stack;
import SCC.StdOut;
import java.util.InputMismatchException;
import java.util.NoSuchElementException;

public class Digraph {
    private static final String NEWLINE = System.getProperty("line.separator");
    private final int V;
    private int E;
    private Bag<Integer>[] adj;
    private int[] indegree;

    public Digraph(int V) {
        if (V < 0) {
            throw new IllegalArgumentException("Number of vertices in a Digraph must be nonnegative");
        }
        this.V = V;
        this.E = 0;
        this.indegree = new int[V];
        this.adj = new Bag[V];
        int v = 0;
        while (v < V) {
            this.adj[v] = new Bag();
            ++v;
        }
    }

    public Digraph(In in) {
        try {
            this.V = in.readInt();
            if (this.V < 0) {
                throw new IllegalArgumentException("Number of vertices in a Digraph must be nonnegative");
            }
            this.indegree = new int[this.V];
            this.adj = new Bag[this.V];
            int v = 0;
            while (v < this.V) {
                this.adj[v] = new Bag();
                ++v;
            }
            int E = in.readInt();
            if (E < 0) {
                throw new IllegalArgumentException("Number of edges in a Digraph must be nonnegative");
            }
            int i = 0;
            while (i < E) {
                int v2 = in.readInt();
                int w = in.readInt();
                this.addEdge(v2, w);
                ++i;
            }
        }
        catch (NoSuchElementException e) {
            throw new InputMismatchException("Invalid input format in Digraph constructor: " + e.getMessage());
        }
    }

    public Digraph(Digraph G) {
        this(G.V());
        this.E = G.E();
        int v = 0;
        while (v < this.V) {
            this.indegree[v] = G.indegree(v);
            ++v;
        }
        v = 0;
        while (v < G.V()) {
            Stack<Integer> reverse = new Stack<Integer>();
            for (int w : G.adj[v]) {
                reverse.push(w);
            }
            for (int w : reverse) {
                this.adj[v].add(w);
            }
            ++v;
        }
    }

    public int V() {
        return this.V;
    }

    public int E() {
        return this.E;
    }

    private void validateVertex(int v) {
        if (v < 0 || v >= this.V) {
            throw new IndexOutOfBoundsException("vertex " + v + " is not between 0 and " + (this.V - 1));
        }
    }

    public void addEdge(int v, int w) {
        this.validateVertex(v);
        this.validateVertex(w);
        this.adj[v].add(w);
        int n = w;
        this.indegree[n] = this.indegree[n] + 1;
        ++this.E;
    }

    public Iterable<Integer> adj(int v) {
        this.validateVertex(v);
        return this.adj[v];
    }

    public int outdegree(int v) {
        this.validateVertex(v);
        return this.adj[v].size();
    }

    public int indegree(int v) {
        this.validateVertex(v);
        return this.indegree[v];
    }

    public Digraph reverse() {
        Digraph R = new Digraph(this.V);
        int v = 0;
        while (v < this.V) {
            for (int w : this.adj(v)) {
                R.addEdge(w, v);
            }
            ++v;
        }
        return R;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(String.valueOf(this.V) + " vertices, " + this.E + " edges " + NEWLINE);
        int v = 0;
        while (v < this.V) {
            s.append(String.format("%d: ", v));
            for (int w : this.adj[v]) {
                s.append(String.format("%d ", w));
            }
            s.append(NEWLINE);
            ++v;
        }
        return s.toString();
    }

    public static void main(String[] args) {
        In in = new In(args[0]);
        Digraph G = new Digraph(in);
        StdOut.println(G);
    }
}

