/*
 * Decompiled with CFR 0.152.
 */
package SCC;

import SCC.StdIn;
import SCC.StdOut;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Queue<Item>
implements Iterable<Item> {
    private Node<Item> first = null;
    private Node<Item> last = null;
    private int N = 0;

    public boolean isEmpty() {
        return this.first == null;
    }

    public int size() {
        return this.N;
    }

    public Item peek() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Queue underflow");
        }
        return (Item)((Node)this.first).item;
    }

    public void enqueue(Item item) {
        Node<Item> oldlast = this.last;
        this.last = new Node();
        ((Node)this.last).item = item;
        ((Node)this.last).next = null;
        if (this.isEmpty()) {
            this.first = this.last;
        } else {
            ((Node)oldlast).next = (Node)this.last;
        }
        ++this.N;
    }

    public Item dequeue() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Queue underflow");
        }
        Object item = ((Node)this.first).item;
        this.first = ((Node)this.first).next;
        --this.N;
        if (this.isEmpty()) {
            this.last = null;
        }
        return (Item)item;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Item item : this) {
            s.append(item + " ");
        }
        return s.toString();
    }

    @Override
    public Iterator<Item> iterator() {
        return new ListIterator<Item>(this.first);
    }

    public static void main(String[] args) {
        Queue<String> q = new Queue<String>();
        while (!StdIn.isEmpty()) {
            String item = StdIn.readString();
            if (!item.equals("-")) {
                q.enqueue(item);
                continue;
            }
            if (q.isEmpty()) continue;
            StdOut.print(String.valueOf((String)q.dequeue()) + " ");
        }
        StdOut.println("(" + q.size() + " left on queue)");
    }

    private class ListIterator<Item>
    implements Iterator<Item> {
        private Node<Item> current;

        public ListIterator(Node<Item> first) {
            this.current = first;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Item next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object item = ((Node)this.current).item;
            this.current = ((Node)this.current).next;
            return (Item)item;
        }
    }

    private static class Node<Item> {
        private Item item;
        private Node<Item> next;

        private Node() {
        }
    }
}

