/*
 * Decompiled with CFR 0.152.
 */
package SCC;

import PBN.Property;
import SCC.Bag;
import SCC.Digraph;
import SCC.In;
import SCC.TarjanSCC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TarjanBlock
extends TarjanSCC {
    private final int maxSCCSize = 30;
    private final int minSCCSize = 10;
    private final int ignoreSize = 2;
    private int MAX_EXTERNAL_NODES = 3;
    protected List<List> controlNodes;
    protected List<List> components;
    protected List<Integer> leaves;
    protected List<Integer> firstOrderLeaves;
    protected List<List> orderedLeaves;
    private Digraph G;

    public TarjanBlock(Digraph G) {
        super(G);
        this.G = G;
        this.computeSCCs();
        this.computeControlNode();
    }

    public Digraph getG() {
        return this.G;
    }

    public List<Integer> getLeaves() {
        return this.leaves;
    }

    public List<Integer> getFirstOrderLeaves() {
        return this.firstOrderLeaves;
    }

    public List<List> getOrderedLeaves() {
        return this.orderedLeaves;
    }

    private void computeControlNode() {
        List element;
        int M = this.components.size();
        this.controlNodes = new ArrayList<List>();
        int i = 0;
        while (i < M) {
            element = new ArrayList();
            this.controlNodes.add(element);
            ++i;
        }
        i = 0;
        while (i < this.G.V()) {
            for (int w : this.G.adj(i)) {
                int idd = this.id(w);
                element = this.components.get(idd);
                List element1 = this.controlNodes.get(idd);
                if (element.contains(i) || element1.contains(i)) continue;
                this.controlNodes.get(idd).add(i);
            }
            ++i;
        }
        System.gc();
    }

    public List<List> getControlnodes() {
        return this.controlNodes;
    }

    public List<List> getSCCs() {
        return this.components;
    }

    private void computeSCCs() {
        int M = this.count();
        this.components = new ArrayList<List>();
        int i = 0;
        while (i < M) {
            ArrayList element = new ArrayList();
            this.components.add(element);
            ++i;
        }
        int v = 0;
        while (v < this.G.V()) {
            this.components.get(this.id(v)).add(v);
            ++v;
        }
    }

    public void reArrangeSCCs() {
        List element;
        int half = 0;
        int size = this.components.size();
        int i = 0;
        while (i < size) {
            element = this.components.get(i);
            half = element.size();
            if (half > 30) {
                half /= 2;
                ArrayList<Integer> element1 = new ArrayList<Integer>();
                int j = 0;
                while (j < half) {
                    element1.add((Integer)element.get(0));
                    element.remove(0);
                    ++j;
                }
                this.components.add(element1);
                --i;
                ++size;
            }
            ++i;
        }
        int mergeIndex = -1;
        int i2 = 0;
        while (i2 < size) {
            element = this.components.get(i2);
            half = element.size();
            if (half < 10) {
                if (mergeIndex == -1) {
                    mergeIndex = i2;
                } else {
                    List element1 = this.components.get(mergeIndex);
                    int j = 0;
                    while (j < element1.size()) {
                        element.add((Integer)element1.get(j));
                        ++j;
                    }
                    this.components.remove(mergeIndex);
                    mergeIndex = -1;
                    i2 -= 2;
                    --size;
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.components.size()) {
            element = this.components.get(i2);
            int j = 0;
            while (j < element.size()) {
                this.id[((Integer)element.get((int)j)).intValue()] = i2;
                ++j;
            }
            ++i2;
        }
        this.computeControlNode();
    }

    public void checkExternalNodes() {
        int i = 0;
        while (i < this.components.size()) {
            List element;
            if (this.components.get(i).size() > 2 && (element = this.controlNodes.get(i)).size() > this.MAX_EXTERNAL_NODES) {
                ArrayList<Integer> externalSCC = new ArrayList<Integer>();
                Iterator iterator = element.iterator();
                while (iterator.hasNext()) {
                    int w = (Integer)iterator.next();
                    if (externalSCC.contains(this.id[w])) continue;
                    externalSCC.add(this.id[w]);
                }
                Collections.sort(externalSCC);
                element = this.components.get(i);
                int j = externalSCC.size() - 1;
                while (j >= 0) {
                    element.addAll(this.components.get((Integer)externalSCC.get(j)));
                    this.components.remove((Integer)externalSCC.get(j));
                    --j;
                }
                int k = 0;
                while (k < this.components.size()) {
                    element = this.components.get(k);
                    int j2 = 0;
                    while (j2 < element.size()) {
                        this.id[((Integer)element.get((int)j2)).intValue()] = k;
                        ++j2;
                    }
                    ++k;
                }
                this.computeControlNode();
                i = -1;
            }
            ++i;
        }
    }

    public int removingLeaves(Property property) {
        List child;
        List positiveIndex = property.getPositiveIndex();
        List negativeIndex = property.getNegativeIndex();
        this.leaves = new ArrayList<Integer>();
        this.firstOrderLeaves = new ArrayList<Integer>();
        this.orderedLeaves = new ArrayList<List>();
        int V = this.G.V();
        ArrayList children = new ArrayList();
        boolean newLeave = true;
        int v = 0;
        while (v < V) {
            child = new ArrayList<Integer>();
            Bag adj = (Bag)this.G.adj(v);
            Iterator iterator = adj.iterator();
            while (iterator.hasNext()) {
                int w = (Integer)iterator.next();
                child.add(w);
            }
            if (child.isEmpty() && !positiveIndex.contains(v) && !negativeIndex.contains(v)) {
                this.leaves.add(v);
                this.firstOrderLeaves.add(v);
            }
            children.add(child);
            ++v;
        }
        this.orderedLeaves.add(this.firstOrderLeaves);
        while (newLeave) {
            newLeave = false;
            ArrayList<Integer> element = new ArrayList<Integer>();
            int i = 0;
            while (i < this.leaves.size()) {
                int v2 = 0;
                while (v2 < V) {
                    child = (List)children.get(v2);
                    if (child.contains(this.leaves.get(i))) {
                        child.remove(this.leaves.get(i));
                    }
                    ++v2;
                }
                ++i;
            }
            v = 0;
            while (v < V) {
                child = (List)children.get(v);
                if (!this.leaves.contains(v) && child.isEmpty() && !positiveIndex.contains(v) && !negativeIndex.contains(v)) {
                    this.leaves.add(v);
                    element.add(v);
                    newLeave = true;
                }
                ++v;
            }
            if (!newLeave) continue;
            this.orderedLeaves.add(element);
        }
        Collections.sort(this.leaves);
        return this.leaves.size();
    }

    public int removingLeaves() {
        List child;
        this.leaves = new ArrayList<Integer>();
        this.firstOrderLeaves = new ArrayList<Integer>();
        this.orderedLeaves = new ArrayList<List>();
        int V = this.G.V();
        ArrayList children = new ArrayList();
        boolean newLeave = true;
        int v = 0;
        while (v < V) {
            child = new ArrayList<Integer>();
            Bag adj = (Bag)this.G.adj(v);
            Iterator iterator = adj.iterator();
            while (iterator.hasNext()) {
                int w = (Integer)iterator.next();
                child.add(w);
            }
            if (child.isEmpty()) {
                this.leaves.add(v);
                this.firstOrderLeaves.add(v);
            }
            children.add(child);
            ++v;
        }
        this.orderedLeaves.add(this.firstOrderLeaves);
        while (newLeave) {
            newLeave = false;
            ArrayList<Integer> element = new ArrayList<Integer>();
            int i = 0;
            while (i < this.leaves.size()) {
                int v2 = 0;
                while (v2 < V) {
                    child = (List)children.get(v2);
                    if (child.contains(this.leaves.get(i))) {
                        child.remove(this.leaves.get(i));
                    }
                    ++v2;
                }
                ++i;
            }
            v = 0;
            while (v < V) {
                child = (List)children.get(v);
                if (!this.leaves.contains(v) && child.isEmpty()) {
                    this.leaves.add(v);
                    element.add(v);
                    newLeave = true;
                }
                ++v;
            }
            if (!newLeave) continue;
            this.orderedLeaves.add(element);
        }
        Collections.sort(this.leaves);
        return this.leaves.size();
    }

    public static void main(String[] args) {
        String graphFile = "model/PBN_300-20150625-max2-2-dis5.txt.gra";
        TarjanBlock block = new TarjanBlock(new Digraph(new In(graphFile)));
        List<List> controlNodes = block.getControlnodes();
        List<List> SCCs = block.getSCCs();
        int i = 0;
        while (i < controlNodes.size()) {
            List element = SCCs.get(i);
            element = controlNodes.get(i);
            ++i;
        }
        block.removingLeaves();
        List<List> ordered = block.getOrderedLeaves();
        int i2 = 0;
        while (i2 < ordered.size()) {
            List leaves = ordered.get(i2);
            ++i2;
        }
    }
}

