/*
 * Decompiled with CFR 0.152.
 */
package SCC;

import SCC.Digraph;
import SCC.In;
import SCC.Queue;
import SCC.Stack;
import SCC.StdOut;
import SCC.TransitiveClosure;
import java.util.Iterator;

public class TarjanSCC {
    private boolean[] marked;
    protected int[] id;
    private int[] low;
    private int pre;
    private int count;
    private Stack<Integer> stack;

    public TarjanSCC(Digraph G) {
        this.marked = new boolean[G.V()];
        this.stack = new Stack();
        this.id = new int[G.V()];
        this.low = new int[G.V()];
        int v = 0;
        while (v < G.V()) {
            if (!this.marked[v]) {
                this.dfs(G, v);
            }
            ++v;
        }
        assert (this.check(G));
    }

    private void dfs(Digraph G, int v) {
        int w2;
        this.marked[v] = true;
        ++this.pre;
        int min = this.low[v];
        this.stack.push(v);
        for (int w2 : G.adj(v)) {
            if (!this.marked[w2]) {
                this.dfs(G, w2);
            }
            if (this.low[w2] >= min) continue;
            min = this.low[w2];
        }
        if (min < this.low[v]) {
            this.low[v] = min;
            return;
        }
        do {
            w2 = this.stack.pop();
            this.id[w2] = this.count++;
            this.low[w2] = G.V();
        } while (w2 != v);
    }

    public int count() {
        return this.count;
    }

    public boolean stronglyConnected(int v, int w) {
        return this.id[v] == this.id[w];
    }

    public int id(int v) {
        return this.id[v];
    }

    private boolean check(Digraph G) {
        TransitiveClosure tc = new TransitiveClosure(G);
        int v = 0;
        while (v < G.V()) {
            int w = 0;
            while (w < G.V()) {
                if (this.stronglyConnected(v, w) != (tc.reachable(v, w) && tc.reachable(w, v))) {
                    return false;
                }
                ++w;
            }
            ++v;
        }
        return true;
    }

    public static void main(String[] args) {
        In in = new In(args[0]);
        Digraph G = new Digraph(in);
        TarjanSCC scc = new TarjanSCC(G);
        int M = scc.count();
        StdOut.println(String.valueOf(M) + " components");
        Queue[] components = new Queue[M];
        int i = 0;
        while (i < M) {
            components[i] = new Queue();
            ++i;
        }
        int v = 0;
        while (v < G.V()) {
            components[scc.id(v)].enqueue(v);
            ++v;
        }
        i = 0;
        while (i < M) {
            Iterator iterator = components[i].iterator();
            while (iterator.hasNext()) {
                int v2 = (Integer)iterator.next();
                StdOut.print(String.valueOf(v2) + " ");
            }
            StdOut.println();
            ++i;
        }
    }
}

