/*
 * Decompiled with CFR 0.152.
 */
package SCC;

import SCC.Digraph;
import SCC.DirectedDFS;
import SCC.In;
import SCC.StdOut;

public class TransitiveClosure {
    private DirectedDFS[] tc;

    public TransitiveClosure(Digraph G) {
        this.tc = new DirectedDFS[G.V()];
        int v = 0;
        while (v < G.V()) {
            this.tc[v] = new DirectedDFS(G, v);
            ++v;
        }
    }

    public boolean reachable(int v, int w) {
        return this.tc[v].marked(w);
    }

    public static void main(String[] args) {
        In in = new In(args[0]);
        Digraph G = new Digraph(in);
        TransitiveClosure tc = new TransitiveClosure(G);
        StdOut.print("     ");
        int v = 0;
        while (v < G.V()) {
            StdOut.printf("%3d", v);
            ++v;
        }
        StdOut.println();
        StdOut.println("--------------------------------------------");
        v = 0;
        while (v < G.V()) {
            StdOut.printf("%3d: ", v);
            int w = 0;
            while (w < G.V()) {
                if (tc.reachable(v, w)) {
                    StdOut.printf("  T", new Object[0]);
                } else {
                    StdOut.printf("   ", new Object[0]);
                }
                ++w;
            }
            StdOut.println();
            ++v;
        }
    }
}

