/*
 * Decompiled with CFR 0.152.
 */
package analysis.influence;

import PBN.BDDPBN;
import PBN.BitSetPBN;
import PBN.Property;
import cern.colt.bitvector.BitVector;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import parser.Model;
import simulationMethod.SimulationMethod;
import userInterface.AssaLog;

public class LongtermInfluence {
    private BitSetPBN pbn;
    private SimulationMethod sm;
    private AssaLog assalog;

    public LongtermInfluence(BitSetPBN pbn, SimulationMethod sm, AssaLog assalog) {
        this.initialise(pbn, sm, assalog);
    }

    public void initialise(BitSetPBN pbn, SimulationMethod sm, AssaLog assalog) {
        this.pbn = pbn;
        this.sm = sm;
        this.assalog = assalog;
        assalog.println("The " + sm.getInstanceName() + " is used for computing steady-state probabilities.");
    }

    public double computeSensitivityNode(int targetNodeIndex) throws Exception {
        double result = 0.0;
        int[] cumNF = this.pbn.buildCumNf();
        ArrayList<Integer> sourceNodeIndex = new ArrayList<Integer>();
        int targetFunctionIndex = cumNF[targetNodeIndex];
        while (targetFunctionIndex < cumNF[targetNodeIndex + 1]) {
            BitSet elementVarF = this.pbn.getVarF().get(targetFunctionIndex);
            int fromIndex = 0;
            while ((fromIndex = elementVarF.nextSetBit(fromIndex)) != -1) {
                if (!sourceNodeIndex.contains(fromIndex)) {
                    sourceNodeIndex.add(fromIndex);
                }
                ++fromIndex;
            }
            ++targetFunctionIndex;
        }
        for (Integer e : sourceNodeIndex) {
            result += this.computeInfluenceNodeFast(e, targetNodeIndex);
        }
        Model model = null;
        if (this.pbn instanceof BDDPBN) {
            model = ((BDDPBN)this.pbn).getModel();
            List<String> names = model.getNames();
            this.assalog.println("The sensitivity of node " + names.get(targetNodeIndex) + " is " + result + ".\n");
        } else {
            this.assalog.println("The sensitivity of node " + targetNodeIndex + " is " + result + ".\n");
        }
        return result;
    }

    public double computeSensitivityFunction(int targetNodeIndex, int relativeTargetFunctionIndex) throws Exception {
        if (this.illegalFunction(targetNodeIndex, relativeTargetFunctionIndex)) {
            throw new Exception("The given target function index does not exist!");
        }
        int[] cumNF = this.pbn.buildCumNf();
        int targetFunctionIndex = cumNF[targetNodeIndex] + relativeTargetFunctionIndex;
        Model model = null;
        if (this.pbn instanceof BDDPBN) {
            model = ((BDDPBN)this.pbn).getModel();
            List<String> names = model.getNames();
            this.assalog.println("The " + relativeTargetFunctionIndex + "th function of node " + names.get(targetNodeIndex) + " corresponds to the " + targetFunctionIndex + "th function of the PBN.");
        } else {
            this.assalog.println("The " + relativeTargetFunctionIndex + "th function of node " + targetNodeIndex + " corresponds to the " + targetFunctionIndex + "th function of the PBN.");
        }
        return this.computeSensitivityFunction(targetFunctionIndex);
    }

    public double computeSensitivityFunction(int targetFunctionIndex) throws Exception {
        double result = 0.0;
        ArrayList<Integer> sourceNodeIndex = new ArrayList<Integer>();
        BitSet elementVarF = this.pbn.getVarF().get(targetFunctionIndex);
        int fromIndex = 0;
        while ((fromIndex = elementVarF.nextSetBit(fromIndex)) != -1) {
            if (!sourceNodeIndex.contains(fromIndex)) {
                sourceNodeIndex.add(fromIndex);
            }
            ++fromIndex;
        }
        for (Integer e : sourceNodeIndex) {
            result += this.computeInfluenceFunction(e, targetFunctionIndex);
        }
        this.assalog.println("The sensitivity of the " + targetFunctionIndex + "th function is " + result + ".\n");
        return result;
    }

    public double computeInfluenceNodeFast(int sourceNodeIndex, int targetNodeIndex) throws Exception {
        double result = 0.0;
        int[] cumNF = this.pbn.buildCumNf();
        int fromIndex = 0;
        int relativeIndex = -1;
        ArrayList<Property> properties = new ArrayList<Property>();
        double[] cijElement = this.pbn.getCij().get(targetNodeIndex);
        Model model = null;
        if (this.pbn instanceof BDDPBN) {
            model = ((BDDPBN)this.pbn).getModel();
            List<String> names = model.getNames();
            this.assalog.println("Start analysing the influence of node " + names.get(sourceNodeIndex) + " to node " + names.get(targetNodeIndex) + ".");
        } else {
            this.assalog.println("Start analysing the influence of node " + sourceNodeIndex + " to node " + targetNodeIndex + ".");
        }
        int[] cumPropertiesIndex = new int[cumNF[targetNodeIndex + 1] - cumNF[targetNodeIndex]];
        int count = 0;
        int previous = 0;
        int targetFunctionIndex = cumNF[targetNodeIndex];
        while (targetFunctionIndex < cumNF[targetNodeIndex + 1]) {
            cumPropertiesIndex[count] = previous + 0;
            boolean[] elementF = this.pbn.getF().get(targetFunctionIndex);
            BitSet elementVarF = this.pbn.getVarF().get(targetFunctionIndex);
            boolean[] checked = new boolean[elementF.length];
            int[] parentIndices = new int[elementVarF.cardinality()];
            fromIndex = 0;
            int countIndex = 0;
            relativeIndex = -1;
            while ((fromIndex = elementVarF.nextSetBit(fromIndex)) != -1) {
                if (fromIndex == sourceNodeIndex) {
                    relativeIndex = countIndex;
                }
                parentIndices[countIndex] = fromIndex++;
                ++countIndex;
            }
            if (relativeIndex != -1) {
                int length = this.pbn.getNv().get(targetFunctionIndex);
                BitVector bt = new BitVector(length);
                --length;
                int i = 0;
                while (i < elementF.length) {
                    if (!checked[i]) {
                        bt.putLongFromTo((long)i, 0, length);
                        bt.put(relativeIndex, !bt.get(relativeIndex));
                        boolean first = elementF[i];
                        int tmp = (int)bt.getLongFromTo(0, length);
                        boolean second = elementF[tmp];
                        checked[i] = true;
                        checked[tmp] = true;
                        if (first != second) {
                            Property property = new Property();
                            ArrayList<Integer> positiveIndex = new ArrayList<Integer>();
                            ArrayList<Integer> negativeIndex = new ArrayList<Integer>();
                            ArrayList<Integer> positiveIndex1 = new ArrayList<Integer>();
                            ArrayList<Integer> negativeIndex1 = new ArrayList<Integer>();
                            int j = 0;
                            while (j < relativeIndex) {
                                if (bt.get(j)) {
                                    positiveIndex.add(parentIndices[j]);
                                    positiveIndex1.add(parentIndices[j]);
                                } else {
                                    negativeIndex.add(parentIndices[j]);
                                    negativeIndex1.add(parentIndices[j]);
                                }
                                ++j;
                            }
                            if (bt.get(relativeIndex)) {
                                positiveIndex1.add(parentIndices[relativeIndex]);
                                negativeIndex.add(parentIndices[relativeIndex]);
                            } else {
                                positiveIndex.add(parentIndices[relativeIndex]);
                                negativeIndex1.add(parentIndices[relativeIndex]);
                            }
                            j = relativeIndex + 1;
                            while (j <= length) {
                                if (bt.get(j)) {
                                    positiveIndex.add(parentIndices[j]);
                                    positiveIndex1.add(parentIndices[j]);
                                } else {
                                    negativeIndex.add(parentIndices[j]);
                                    negativeIndex1.add(parentIndices[j]);
                                }
                                ++j;
                            }
                            property.setExpressions(positiveIndex, negativeIndex);
                            properties.add(property);
                            property = new Property();
                            property.setExpressions(positiveIndex1, negativeIndex1);
                            properties.add(property);
                            int n = count;
                            cumPropertiesIndex[n] = cumPropertiesIndex[n] + 2;
                        }
                    }
                    ++i;
                }
            }
            previous = cumPropertiesIndex[count];
            ++count;
            ++targetFunctionIndex;
        }
        this.sm.setExpressions(properties);
        if (properties.size() == 0) {
            return 0.0;
        }
        double[][] probabilities = this.sm.run(this.pbn, true);
        result = 0.0;
        count = 0;
        double tmpResult = 0.0;
        int i = 0;
        while (i < probabilities[0].length) {
            if (i < cumPropertiesIndex[count]) {
                tmpResult += probabilities[0][i];
            } else {
                result += tmpResult * cijElement[count];
                tmpResult = probabilities[0][i];
                ++count;
            }
            ++i;
        }
        this.assalog.println("The influence is " + (result += tmpResult * cijElement[count]) + ".\n");
        return result;
    }

    public double computeInfluenceNode(int sourceNodeIndex, int targetNodeIndex) throws Exception {
        double result = 0.0;
        int[] cumNF = this.pbn.buildCumNf();
        double[] cijElement = this.pbn.getCij().get(targetNodeIndex);
        Model model = null;
        String nodename = String.valueOf(sourceNodeIndex);
        if (this.pbn instanceof BDDPBN) {
            model = ((BDDPBN)this.pbn).getModel();
            List<String> names = model.getNames();
            nodename = names.get(sourceNodeIndex);
            this.assalog.println("Start analysing the influence of node " + names.get(sourceNodeIndex) + " to node " + names.get(targetNodeIndex) + ".");
        } else {
            this.assalog.println("Start analysing the influence of node " + sourceNodeIndex + " to node " + targetNodeIndex + ".");
        }
        int count = 0;
        int i = cumNF[targetNodeIndex];
        while (i < cumNF[targetNodeIndex + 1]) {
            this.assalog.println("The " + count + "th function of node " + nodename + " corresponds to the " + i + "th function of the PBN.");
            result += cijElement[count] * this.computeInfluenceFunction(sourceNodeIndex, i);
            ++count;
            ++i;
        }
        this.assalog.println("The influence is " + result + ".\n");
        return result;
    }

    public double computeInfluenceFunction(int sourceNodeIndex, int targetNodeIndex, int relativeTargetFunctionIndex) throws Exception {
        if (this.illegalFunction(targetNodeIndex, relativeTargetFunctionIndex)) {
            throw new Exception("The given target function index does not exist!");
        }
        int[] cumNF = this.pbn.buildCumNf();
        int targetFunctionIndex = cumNF[targetNodeIndex] + relativeTargetFunctionIndex;
        this.assalog.println("The " + relativeTargetFunctionIndex + "th function of node " + targetNodeIndex + " corresponds to the " + targetFunctionIndex + "th function of the PBN.");
        return this.computeInfluenceFunction(sourceNodeIndex, targetFunctionIndex);
    }

    public double computeInfluenceFunction(int sourceNodeIndex, int targetFunctionIndex) throws Exception {
        boolean[] elementF = this.pbn.getF().get(targetFunctionIndex);
        BitSet elementVarF = this.pbn.getVarF().get(targetFunctionIndex);
        int fromIndex = 0;
        int relativeIndex = -1;
        ArrayList<Property> properties = new ArrayList<Property>();
        boolean[] checked = new boolean[elementF.length];
        int[] parentIndices = new int[elementVarF.cardinality()];
        int count = 0;
        while ((fromIndex = elementVarF.nextSetBit(fromIndex)) != -1) {
            if (fromIndex == sourceNodeIndex) {
                relativeIndex = count;
            }
            parentIndices[count] = fromIndex++;
            ++count;
        }
        if (relativeIndex == -1) {
            Model model = null;
            if (this.pbn instanceof BDDPBN) {
                model = ((BDDPBN)this.pbn).getModel();
                List<String> names = model.getNames();
                this.assalog.println("The influence of node " + names.get(sourceNodeIndex) + " to the " + targetFunctionIndex + "th function is " + 0);
            } else {
                this.assalog.println("The influence of node " + sourceNodeIndex + " to the " + targetFunctionIndex + "th function is " + 0);
            }
            return 0.0;
        }
        int length = this.pbn.getNv().get(targetFunctionIndex);
        BitVector bt = new BitVector(length);
        --length;
        int i = 0;
        while (i < elementF.length) {
            if (!checked[i]) {
                bt.putLongFromTo((long)i, 0, length);
                bt.put(relativeIndex, !bt.get(relativeIndex));
                boolean first = elementF[i];
                int tmp = (int)bt.getLongFromTo(0, length);
                boolean second = elementF[tmp];
                checked[i] = true;
                checked[tmp] = true;
                if (first != second) {
                    Property property = new Property();
                    ArrayList<Integer> positiveIndex = new ArrayList<Integer>();
                    ArrayList<Integer> negativeIndex = new ArrayList<Integer>();
                    ArrayList<Integer> positiveIndex1 = new ArrayList<Integer>();
                    ArrayList<Integer> negativeIndex1 = new ArrayList<Integer>();
                    int j = 0;
                    while (j < relativeIndex) {
                        if (bt.get(j)) {
                            positiveIndex.add(parentIndices[j]);
                            positiveIndex1.add(parentIndices[j]);
                        } else {
                            negativeIndex.add(parentIndices[j]);
                            negativeIndex1.add(parentIndices[j]);
                        }
                        ++j;
                    }
                    if (bt.get(relativeIndex)) {
                        positiveIndex1.add(parentIndices[relativeIndex]);
                        negativeIndex.add(parentIndices[relativeIndex]);
                    } else {
                        positiveIndex.add(parentIndices[relativeIndex]);
                        negativeIndex1.add(parentIndices[relativeIndex]);
                    }
                    j = relativeIndex + 1;
                    while (j <= length) {
                        if (bt.get(j)) {
                            positiveIndex.add(parentIndices[j]);
                            positiveIndex1.add(parentIndices[j]);
                        } else {
                            negativeIndex.add(parentIndices[j]);
                            negativeIndex1.add(parentIndices[j]);
                        }
                        ++j;
                    }
                    property.setExpressions(positiveIndex, negativeIndex);
                    properties.add(property);
                    property = new Property();
                    property.setExpressions(positiveIndex1, negativeIndex1);
                    properties.add(property);
                }
            }
            ++i;
        }
        if (properties.size() == 0) {
            Model model = null;
            if (this.pbn instanceof BDDPBN) {
                model = ((BDDPBN)this.pbn).getModel();
                List<String> names = model.getNames();
                this.assalog.println("The influence of node " + names.get(sourceNodeIndex) + " to the " + targetFunctionIndex + "th function is " + 0);
            } else {
                this.assalog.println("The influence of node " + sourceNodeIndex + " to the " + targetFunctionIndex + "th function is " + 0);
            }
            return 0.0;
        }
        this.sm.setExpressions(properties);
        double[][] probabilities = this.sm.run(this.pbn, true);
        double result = 0.0;
        i = 0;
        while (i < probabilities[0].length) {
            result += probabilities[0][i];
            ++i;
        }
        Model model = null;
        if (this.pbn instanceof BDDPBN) {
            model = ((BDDPBN)this.pbn).getModel();
            List<String> names = model.getNames();
            this.assalog.println("The influence of node " + names.get(sourceNodeIndex) + " to the " + targetFunctionIndex + "th function is " + result + ".");
        } else {
            this.assalog.println("The influence of node " + sourceNodeIndex + " to the " + targetFunctionIndex + "th function is " + result + ".");
        }
        return result;
    }

    private boolean illegalFunction(int targetNodeIndex, int relativeFunctionIndex) {
        return relativeFunctionIndex < 0 || this.pbn.getNf()[targetNodeIndex] <= relativeFunctionIndex;
    }
}

