/*
 * Decompiled with CFR 0.152.
 */
package analysis.influence;

import PBN.BitSetPBN;
import PBN.Property;
import cern.colt.bitvector.BitVector;
import java.util.ArrayList;
import java.util.List;
import simulationMethod.SimulationMethod;
import userInterface.AssaLog;

public class LongtermSensitivity {
    private BitSetPBN pbn1;
    private BitSetPBN pbn2;
    private SimulationMethod sm;
    private AssaLog assalog;

    public LongtermSensitivity(BitSetPBN pbn1, BitSetPBN pbn2, SimulationMethod sm, AssaLog assalog) {
        this.initialise(pbn1, pbn2, sm, assalog);
    }

    public void initialise(BitSetPBN pbn1, BitSetPBN pbn2, SimulationMethod sm, AssaLog assalog) {
        this.pbn1 = pbn1;
        this.pbn2 = pbn2;
        this.sm = sm;
        this.assalog = assalog;
        assalog.println("The " + sm.getInstanceName() + " is used for computing steady-state probabilities.");
    }

    public double computeSensitivity(List<Integer> nodeIndices) throws Exception {
        int length = nodeIndices.size();
        if (length > 64) {
            throw new Exception("The required nodes are too much! Please reduce the number to smaller than 64.");
        }
        this.assalog.print("Start computing the long-run sensitivity in terms of nodes");
        for (Integer e : nodeIndices) {
            this.assalog.print(" " + e);
        }
        this.assalog.println(".");
        ArrayList<Property> properties = new ArrayList<Property>();
        BitVector bt = new BitVector(length);
        int i = 0;
        while ((double)i < Math.pow(2.0, length)) {
            bt.putLongFromTo((long)i, 0, length - 1);
            ArrayList<Integer> positiveIndex = new ArrayList<Integer>();
            ArrayList<Integer> negativeIndex = new ArrayList<Integer>();
            int j = 0;
            while (j < length) {
                if (bt.get(j)) {
                    positiveIndex.add(nodeIndices.get(j));
                } else {
                    negativeIndex.add(nodeIndices.get(j));
                }
                ++j;
            }
            Property property = new Property();
            property.setExpressions(positiveIndex, negativeIndex);
            properties.add(property);
            ++i;
        }
        this.sm.setExpressions(properties);
        double[][] result1 = this.sm.run(this.pbn1, true);
        double[][] result2 = this.sm.run(this.pbn2, true);
        double result = 0.0;
        i = 0;
        while (i < result1[0].length) {
            result += Math.abs(result1[0][i] - result2[0][i]);
            ++i;
        }
        this.assalog.println("The long-run sensitivity (with respect to assigned perturbations) is " + result + ".");
        return result;
    }
}

