/*
 * Decompiled with CFR 0.152.
 */
package attractor;

import PBN.BitSetPBN;
import PBN.BitSetPBNIO;
import SCC.Digraph;
import SCC.In;
import SCC.TarjanBlock;
import extra.FileCoding;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import userInterface.AssaLog;

public class Detect {
    private AssaLog assalog;
    private String finalSuffix = "_finial.ispl";
    private int MAX_NUM_STATE = 5000;
    private String MCMAS_PATH = null;
    private TarjanBlock block;
    private List<String> middleMCMAS;
    private String inputFile;
    private String graphFile;
    private String mcmasFile;
    private List<String> MCMAScommand1;
    private List<String> MCMAScommand2;
    private List<String> MCMAScommand3;
    private String[] default_command1 = new String[]{"-o", "1", "-d", "2", "-e", "2", "-steadystates", "-split", "1", "-printloops", "-compositional", "-paratran", "1"};
    private String[] default_command2 = new String[]{"-o", "1", "-d", "2", "-e", "3", "-steadystates", "-split", "1", "-printloops", "-compositional", "-paratran", "1"};
    private String[] default_command3 = new String[]{"-o", "1", "-d", "3", "-e", "2", "-steadystates", "-split", "1", "-paratran", "1"};
    private boolean rearrange;
    private boolean removeLeaves;
    private boolean removeFirstOrderLeaves;
    private boolean removeOrderedLeaves;
    private int maxNonLeaves = 50;
    private int orderNodes = 0;

    public Detect(String inputFile, String MCMAS_PATH) {
        this.inputFile = inputFile;
        this.MCMAS_PATH = MCMAS_PATH;
        this.MCMAScommand1 = new ArrayList<String>();
        this.MCMAScommand2 = new ArrayList<String>();
        this.MCMAScommand3 = new ArrayList<String>();
        this.setCommand(1, this.default_command1);
        this.setCommand(2, this.default_command2);
        this.setCommand(3, this.default_command3);
    }

    public Detect(String graphFile, String mcmasFile, String MCMAS_PATH) {
        this.MCMAScommand1 = new ArrayList<String>();
        this.MCMAScommand2 = new ArrayList<String>();
        this.MCMAScommand3 = new ArrayList<String>();
        this.mcmasFile = mcmasFile;
        this.graphFile = graphFile;
        this.MCMAS_PATH = MCMAS_PATH;
        this.setCommand(1, this.default_command1);
        this.setCommand(2, this.default_command2);
        this.setCommand(3, this.default_command3);
    }

    public void setCommand(int commandnum, String[] args) {
        switch (commandnum) {
            case 1: {
                this.MCMAScommand1.clear();
                this.MCMAScommand1.add(this.MCMAS_PATH);
                int i = 0;
                while (i < args.length) {
                    this.MCMAScommand1.add(args[i]);
                    ++i;
                }
                break;
            }
            case 2: {
                this.MCMAScommand2.clear();
                this.MCMAScommand2.add(this.MCMAS_PATH);
                int i = 0;
                while (i < args.length) {
                    this.MCMAScommand2.add(args[i]);
                    ++i;
                }
                break;
            }
            case 3: {
                this.MCMAScommand3.clear();
                this.MCMAScommand3.add(this.MCMAS_PATH);
                int i = 0;
                while (i < args.length) {
                    this.MCMAScommand3.add(args[i]);
                    ++i;
                }
                break;
            }
        }
    }

    public void setMaxNumState(int maxNumState) {
        this.MAX_NUM_STATE = maxNumState;
    }

    public void setCommand(int commandnum, List<String> args) {
        switch (commandnum) {
            case 1: {
                this.MCMAScommand1.clear();
                this.MCMAScommand1.add(this.MCMAS_PATH);
                int i = 0;
                while (i < args.size()) {
                    this.MCMAScommand1.add(args.get(i));
                    ++i;
                }
                break;
            }
            case 2: {
                this.MCMAScommand2.clear();
                this.MCMAScommand2.add(this.MCMAS_PATH);
                int i = 0;
                while (i < args.size()) {
                    this.MCMAScommand2.add(args.get(i));
                    ++i;
                }
                break;
            }
            case 3: {
                this.MCMAScommand3.clear();
                this.MCMAScommand3.add(this.MCMAS_PATH);
                int i = 0;
                while (i < args.size()) {
                    this.MCMAScommand3.add(args.get(i));
                    ++i;
                }
                break;
            }
        }
    }

    public void setRemoveLeaves(boolean removeLeaves) {
        this.removeLeaves = removeLeaves;
    }

    public void setRemoveFOLeaves(boolean removeFirstOrderLeaves) {
        this.removeFirstOrderLeaves = removeFirstOrderLeaves;
    }

    public void setRemoveOrderedLeaves(boolean removeOrderedLeaves) {
        this.removeOrderedLeaves = removeOrderedLeaves;
    }

    public void setOrderNode(int orderNodes) {
        this.orderNodes = orderNodes;
    }

    public void run(boolean rearrange, boolean largest) {
        int w;
        Iterator iterator;
        List element;
        this.rearrange = rearrange;
        if (rearrange) {
            this.finalSuffix = "_re" + this.finalSuffix;
        }
        BitSetPBNIO exp = new BitSetPBNIO(this.assalog);
        if (this.mcmasFile == null) {
            this.graphFile = String.valueOf(this.inputFile) + ".gra";
            try {
                BitSetPBN pbn = exp.loadPBN(this.inputFile);
                exp.exportPBNtoGraph(pbn, this.graphFile);
                switch (this.orderNodes) {
                    case 0: {
                        this.mcmasFile = String.valueOf(this.inputFile) + ".ispl";
                        exp.exportPBNtoMCMAS(pbn, this.mcmasFile);
                        break;
                    }
                    case 1: {
                        this.mcmasFile = String.valueOf(this.inputFile) + "_withorder.ispl";
                        exp.exportPBNtoMCMASWithOrder(pbn, this.mcmasFile);
                        break;
                    }
                    case 2: {
                        this.mcmasFile = String.valueOf(this.inputFile) + "_heuristic1.ispl";
                        exp.exportPBNtoMCMASHeuristic1(pbn, this.mcmasFile);
                        break;
                    }
                    default: {
                        this.mcmasFile = String.valueOf(this.inputFile) + ".ispl";
                        exp.exportPBNtoMCMAS(pbn, this.mcmasFile);
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.block = new TarjanBlock(new Digraph(new In(this.graphFile)));
        this.block.checkExternalNodes();
        List<List> controlNodes = this.block.getControlnodes();
        List<List> SCCs = this.block.getSCCs();
        int i = 0;
        while (i < controlNodes.size()) {
            element = SCCs.get(i);
            iterator = element.iterator();
            while (iterator.hasNext()) {
                w = (Integer)iterator.next();
                System.out.print(String.valueOf(w) + " ");
            }
            System.out.print("- ");
            element = controlNodes.get(i);
            iterator = element.iterator();
            while (iterator.hasNext()) {
                w = (Integer)iterator.next();
                System.out.print(String.valueOf(w) + " ");
            }
            System.out.println();
            ++i;
        }
        if (rearrange) {
            this.block.reArrangeSCCs();
            controlNodes = this.block.getControlnodes();
            SCCs = this.block.getSCCs();
            i = 0;
            while (i < controlNodes.size()) {
                element = SCCs.get(i);
                iterator = element.iterator();
                while (iterator.hasNext()) {
                    w = (Integer)iterator.next();
                    System.out.print(String.valueOf(w) + " ");
                }
                System.out.print("- ");
                element = controlNodes.get(i);
                iterator = element.iterator();
                while (iterator.hasNext()) {
                    w = (Integer)iterator.next();
                    System.out.print(String.valueOf(w) + " ");
                }
                System.out.println();
                ++i;
            }
        }
        try {
            String line;
            this.exportMCMAS(this.mcmasFile);
            String initialStates = this.computeInitialState(largest);
            this.exportFinialMCMAS(initialStates);
            InputStream is = this.getMCMASProcess(51, String.valueOf(this.mcmasFile) + this.finalSuffix, false).getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void exportFinialMCMAS(String initialStates) throws IOException {
        String tempString;
        BufferedReader reader = null;
        reader = new BufferedReader(new FileReader(this.mcmasFile));
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(String.valueOf(this.mcmasFile) + this.finalSuffix)), true);
        while ((tempString = reader.readLine()) != null) {
            if (tempString.contains("InitStates")) {
                pw.println(tempString);
                pw.println(String.valueOf(initialStates) + ";");
                tempString = reader.readLine();
                tempString = reader.readLine();
                pw.println(tempString);
                continue;
            }
            pw.println(tempString);
        }
        pw.close();
        reader.close();
    }

    private void exportMCMAS(String inputFile) throws IOException {
        System.out.println("Generating SCC seperated MCMAS files...");
        int line = 0;
        int index = 0;
        BufferedReader reader = null;
        int numLeaves = this.block.removingLeaves();
        Digraph G = this.block.getG();
        long time = System.currentTimeMillis();
        this.finalSuffix = "_" + time + this.finalSuffix;
        if (this.removeOrderedLeaves) {
            this.removeLeaves = true;
            ArrayList leaves = new ArrayList();
            this.middleMCMAS = new ArrayList<String>();
            int i = 0;
            while (i < this.block.getOrderedLeaves().size()) {
                String tempString;
                leaves.addAll(this.block.getOrderedLeaves().get(i));
                this.middleMCMAS.add(String.valueOf(inputFile) + "_" + time + "_removeLeaves_" + i + ".ispl");
                line = 0;
                reader = new BufferedReader(new FileReader(inputFile));
                PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(this.middleMCMAS.get(i))), true);
                while ((tempString = reader.readLine()) != null) {
                    if (line == 0) {
                        pw.println(tempString);
                        if (!tempString.contains("Vars")) continue;
                        int j = 0;
                        while (j < G.V()) {
                            if (!leaves.contains(j)) {
                                pw.println("\t\tn_" + j + ": boolean;");
                                index = j;
                            }
                            ++j;
                        }
                        line = 1;
                        continue;
                    }
                    if (line == 1 && tempString.contains("Vars")) {
                        pw.println(tempString);
                        line = 2;
                        continue;
                    }
                    if (line == 2) {
                        pw.println(tempString);
                        if (!tempString.contains("Evolution")) continue;
                        line = 3;
                        continue;
                    }
                    if (line == 3) {
                        String[] split = tempString.split("[_=]");
                        if (split.length > 1 && !leaves.contains(Integer.parseInt(split[1].trim()))) {
                            pw.println(tempString);
                            continue;
                        }
                        if (!tempString.contains("Evolution")) continue;
                        line = 4;
                        pw.println(tempString);
                        continue;
                    }
                    if (line == 4) {
                        pw.println(tempString);
                        if (!tempString.contains("Evaluation")) continue;
                        line = 5;
                        continue;
                    }
                    if (line == 5) {
                        pw.println("\t\tn_" + index + "_true if M.n_" + index + "=true;");
                        line = 6;
                        continue;
                    }
                    if (line == 6 && tempString.contains("InitStates")) {
                        pw.println("end Evaluation");
                        pw.println(tempString);
                        pw.println("\t\tM.n_" + index + "=true or M.n_" + index + "=false;");
                        line = 7;
                        continue;
                    }
                    if (line != 7 || !tempString.contains("InitStates")) continue;
                    pw.println(tempString);
                    pw.println("\nFormulae");
                    pw.println("AF n_" + index + "_true;");
                    pw.println("end Formulae");
                }
                pw.close();
                reader.close();
                ++i;
            }
            i = this.block.getOrderedLeaves().size() - 1;
            while (i > 0) {
                this.computeInitialStateLeaves(i, i - 1);
                --i;
            }
        } else if (this.removeFirstOrderLeaves) {
            String tempString;
            this.removeLeaves = true;
            List<Integer> leaves = this.block.getFirstOrderLeaves();
            this.middleMCMAS = new ArrayList<String>();
            this.middleMCMAS.add(String.valueOf(inputFile) + "_" + time + "_removeLeaves" + ".ispl");
            line = 0;
            reader = new BufferedReader(new FileReader(inputFile));
            PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(this.middleMCMAS.get(0))), true);
            while ((tempString = reader.readLine()) != null) {
                if (line == 0) {
                    pw.println(tempString);
                    if (!tempString.contains("Vars")) continue;
                    int i = 0;
                    while (i < G.V()) {
                        if (!leaves.contains(i)) {
                            pw.println("\t\tn_" + i + ": boolean;");
                            index = i;
                        }
                        ++i;
                    }
                    line = 1;
                    continue;
                }
                if (line == 1 && tempString.contains("Vars")) {
                    pw.println(tempString);
                    line = 2;
                    continue;
                }
                if (line == 2) {
                    pw.println(tempString);
                    if (!tempString.contains("Evolution")) continue;
                    line = 3;
                    continue;
                }
                if (line == 3) {
                    String[] split = tempString.split("[_=]");
                    if (split.length > 1 && !leaves.contains(Integer.parseInt(split[1].trim()))) {
                        pw.println(tempString);
                        continue;
                    }
                    if (!tempString.contains("Evolution")) continue;
                    line = 4;
                    pw.println(tempString);
                    continue;
                }
                if (line == 4) {
                    pw.println(tempString);
                    if (!tempString.contains("Evaluation")) continue;
                    line = 5;
                    continue;
                }
                if (line == 5) {
                    pw.println("\t\tn_" + index + "_true if M.n_" + index + "=true;");
                    line = 6;
                    continue;
                }
                if (line == 6 && tempString.contains("InitStates")) {
                    pw.println("end Evaluation");
                    pw.println(tempString);
                    pw.println("\t\tM.n_" + index + "=true or M.n_" + index + "=false;");
                    line = 7;
                    continue;
                }
                if (line != 7 || !tempString.contains("InitStates")) continue;
                pw.println(tempString);
                pw.println("\nFormulae");
                pw.println("AF n_" + index + "_true;");
                pw.println("end Formulae");
            }
            pw.close();
            reader.close();
            leaves = this.block.getLeaves();
            this.middleMCMAS.add(String.valueOf(inputFile) + "_" + time + "_removeALeaves" + ".ispl");
            line = 0;
            reader = new BufferedReader(new FileReader(inputFile));
            pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(this.middleMCMAS.get(1))), true);
            while ((tempString = reader.readLine()) != null) {
                if (line == 0) {
                    pw.println(tempString);
                    if (!tempString.contains("Vars")) continue;
                    int i = 0;
                    while (i < G.V()) {
                        if (!leaves.contains(i)) {
                            pw.println("\t\tn_" + i + ": boolean;");
                            index = i;
                        }
                        ++i;
                    }
                    line = 1;
                    continue;
                }
                if (line == 1 && tempString.contains("Vars")) {
                    pw.println(tempString);
                    line = 2;
                    continue;
                }
                if (line == 2) {
                    pw.println(tempString);
                    if (!tempString.contains("Evolution")) continue;
                    line = 3;
                    continue;
                }
                if (line == 3) {
                    String[] split = tempString.split("[_=]");
                    if (split.length > 1 && !leaves.contains(Integer.parseInt(split[1].trim()))) {
                        pw.println(tempString);
                        continue;
                    }
                    if (!tempString.contains("Evolution")) continue;
                    line = 4;
                    pw.println(tempString);
                    continue;
                }
                if (line == 4) {
                    pw.println(tempString);
                    if (!tempString.contains("Evaluation")) continue;
                    line = 5;
                    continue;
                }
                if (line == 5) {
                    pw.println("\t\tn_" + index + "_true if M.n_" + index + "=true;");
                    line = 6;
                    continue;
                }
                if (line == 6 && tempString.contains("InitStates")) {
                    pw.println("end Evaluation");
                    pw.println(tempString);
                    pw.println("\t\tM.n_" + index + "=true or M.n_" + index + "=false;");
                    line = 7;
                    continue;
                }
                if (line != 7 || !tempString.contains("InitStates")) continue;
                pw.println(tempString);
                pw.println("\nFormulae");
                pw.println("AF n_" + index + "_true;");
                pw.println("end Formulae");
            }
            pw.close();
            reader.close();
            this.computeInitialStateLeaves();
        } else if (this.removeLeaves || this.block.getG().V() - numLeaves < this.maxNonLeaves) {
            String tempString;
            List<Integer> leaves = this.block.getLeaves();
            this.removeLeaves = true;
            this.middleMCMAS = new ArrayList<String>();
            this.middleMCMAS.add(String.valueOf(inputFile) + "_" + time + "_removeLeaves" + ".ispl");
            line = 0;
            reader = new BufferedReader(new FileReader(inputFile));
            PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(this.middleMCMAS.get(0))), true);
            while ((tempString = reader.readLine()) != null) {
                if (line == 0) {
                    pw.println(tempString);
                    if (!tempString.contains("Vars")) continue;
                    int i = 0;
                    while (i < G.V()) {
                        if (!leaves.contains(i)) {
                            pw.println("\t\tn_" + i + ": boolean;");
                            index = i;
                        }
                        ++i;
                    }
                    line = 1;
                    continue;
                }
                if (line == 1 && tempString.contains("Vars")) {
                    pw.println(tempString);
                    line = 2;
                    continue;
                }
                if (line == 2) {
                    pw.println(tempString);
                    if (!tempString.contains("Evolution")) continue;
                    line = 3;
                    continue;
                }
                if (line == 3) {
                    String[] split = tempString.split("[_=]");
                    if (split.length > 1 && !leaves.contains(Integer.parseInt(split[1].trim()))) {
                        pw.println(tempString);
                        continue;
                    }
                    if (!tempString.contains("Evolution")) continue;
                    line = 4;
                    pw.println(tempString);
                    continue;
                }
                if (line == 4) {
                    pw.println(tempString);
                    if (!tempString.contains("Evaluation")) continue;
                    line = 5;
                    continue;
                }
                if (line == 5) {
                    pw.println("\t\tn_" + index + "_true if M.n_" + index + "=true;");
                    line = 6;
                    continue;
                }
                if (line == 6 && tempString.contains("InitStates")) {
                    pw.println("end Evaluation");
                    pw.println(tempString);
                    pw.println("\t\tM.n_" + index + "=true or M.n_" + index + "=false;");
                    line = 7;
                    continue;
                }
                if (line != 7 || !tempString.contains("InitStates")) continue;
                pw.println(tempString);
                pw.println("\nFormulae");
                pw.println("AF n_" + index + "_true;");
                pw.println("end Formulae");
            }
            pw.close();
            reader.close();
        } else {
            this.middleMCMAS = new ArrayList<String>();
            List<List> controlNodes = this.block.getControlnodes();
            List<List> SCCs = this.block.getSCCs();
            int i = 0;
            while (i < this.block.getSCCs().size()) {
                String tempString;
                line = 0;
                reader = new BufferedReader(new FileReader(inputFile));
                if (this.rearrange) {
                    this.middleMCMAS.add(String.valueOf(inputFile) + "_" + time + "_re_" + i + ".ispl");
                } else {
                    this.middleMCMAS.add(String.valueOf(inputFile) + "_" + time + "_" + i + ".ispl");
                }
                PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(this.middleMCMAS.get(i))), true);
                while ((tempString = reader.readLine()) != null) {
                    String[] split;
                    if (line == 0) {
                        pw.println(tempString);
                        if (!tempString.contains("Vars")) continue;
                        line = 1;
                        continue;
                    }
                    if (line == 1) {
                        if (tempString.contains("Vars")) {
                            pw.println(tempString);
                            line = 2;
                            continue;
                        }
                        List element = controlNodes.get(i);
                        List element1 = SCCs.get(i);
                        split = tempString.trim().split("[_:]");
                        int num = Integer.parseInt(split[1].trim());
                        if (!element.contains(num) && !element1.contains(num)) continue;
                        pw.println(tempString);
                        index = num;
                        continue;
                    }
                    if (line == 2) {
                        pw.println(tempString);
                        if (!tempString.contains("Evolution")) continue;
                        line = 3;
                        continue;
                    }
                    if (line == 3) {
                        split = tempString.split("[_=]");
                        if (split.length > 1 && this.block.id(Integer.parseInt(split[1].trim())) == i) {
                            pw.println(tempString);
                            continue;
                        }
                        if (!tempString.contains("Evolution")) continue;
                        line = 4;
                        pw.println(tempString);
                        continue;
                    }
                    if (line == 4) {
                        pw.println(tempString);
                        if (!tempString.contains("Evaluation")) continue;
                        line = 5;
                        continue;
                    }
                    if (line == 5) {
                        pw.println("\t\tn_" + index + "_true if M.n_" + index + "=true;");
                        line = 6;
                        continue;
                    }
                    if (line == 6 && tempString.contains("InitStates")) {
                        pw.println("end Evaluation");
                        pw.println(tempString);
                        pw.println("\t\tM.n_" + index + "=true or M.n_" + index + "=false;");
                        line = 7;
                        continue;
                    }
                    if (line != 7 || !tempString.contains("InitStates")) continue;
                    pw.println(tempString);
                    pw.println("\nFormulae");
                    pw.println("AF n_" + index + "_true;");
                    pw.println("end Formulae");
                }
                pw.close();
                reader.close();
                ++i;
            }
        }
        System.out.println("Finish generating SCC seperated MCMAS files. " + this.middleMCMAS.size() + " files are generated.");
    }

    private void computeInitialStateLeaves() throws IOException {
        String tempString;
        String line;
        Process process = null;
        String initialState = "";
        String lineState = "";
        String fileState = "";
        boolean readState = false;
        boolean two = true;
        boolean ignore = false;
        fileState = "";
        two = true;
        System.out.println("Computing loops for component 0 ...");
        System.out.println("\tNumber of nodes in this component is " + (this.block.getG().V() - this.block.getLeaves().size()) + ".");
        process = this.getMCMASProcess(this.block.getG().V() - this.block.getLeaves().size(), this.middleMCMAS.get(1), true);
        InputStream is = process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        int count = 0;
        ignore = false;
        while ((line = br.readLine()) != null) {
            if (line.contains("execution time")) {
                System.out.println(line);
            }
            if (!readState && line.contains("number of states in")) {
                readState = true;
                continue;
            }
            if (!readState) continue;
            if (line.trim().startsWith("(")) {
                if (!line.trim().endsWith("or")) {
                    line = String.valueOf(line) + " or ";
                }
                String[] spl = line.split("[ ()]");
                if (two) {
                    lineState = String.valueOf(lineState) + "((";
                    two = false;
                } else {
                    lineState = String.valueOf(lineState) + "(";
                }
                int j = 0;
                while (j < spl.length) {
                    lineState = spl[j].contains("or") ? String.valueOf(lineState) + ") " + spl[j] + " " : String.valueOf(lineState) + spl[j] + " ";
                    ++j;
                }
                if (!fileState.contains(lineState = String.valueOf(lineState) + "\n")) {
                    fileState = String.valueOf(fileState) + lineState;
                    ++count;
                }
                lineState = "";
                continue;
            }
            readState = false;
        }
        br.close();
        isr.close();
        is.close();
        process.destroy();
        if (fileState.endsWith("or \n")) {
            fileState = String.valueOf(fileState.substring(0, fileState.length() - 5)) + ") and \n";
        }
        System.out.println("\t" + count + " state(s) is/are added!");
        initialState = String.valueOf(initialState) + fileState;
        if (initialState.endsWith("and \n")) {
            initialState = initialState.substring(0, initialState.length() - 5);
        }
        BufferedReader reader = null;
        reader = new BufferedReader(new FileReader(this.middleMCMAS.get(0)));
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(String.valueOf(this.middleMCMAS.get(0)) + ".tmp")), true);
        while ((tempString = reader.readLine()) != null) {
            if (tempString.contains("InitStates")) {
                pw.println(tempString);
                pw.println(String.valueOf(initialState) + ";");
                tempString = reader.readLine();
                tempString = reader.readLine();
                pw.println(tempString);
                continue;
            }
            pw.println(tempString);
        }
        this.middleMCMAS.remove(1);
        Path source = Paths.get(String.valueOf(this.middleMCMAS.get(0)) + ".tmp", new String[0]);
        Path target = Paths.get(this.middleMCMAS.get(0), new String[0]);
        Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
        pw.close();
        reader.close();
    }

    private void computeInitialStateLeaves(int sourceIndex, int targetIndex) throws IOException {
        String tempString;
        String line;
        Process process = null;
        String initialState = "";
        String lineState = "";
        String fileState = "";
        boolean readState = false;
        boolean two = true;
        boolean ignore = false;
        List<List> ee = this.block.getOrderedLeaves();
        int num = this.block.getG().V();
        int i = 0;
        while (i <= sourceIndex) {
            num -= ee.get(i).size();
            ++i;
        }
        fileState = "";
        two = true;
        System.out.println("Computing loops for component " + sourceIndex + " ...");
        System.out.println("\tNumber of nodes in this component is " + num + ".");
        process = this.getMCMASProcess(num, this.middleMCMAS.get(sourceIndex), true);
        InputStream is = process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        int count = 0;
        ignore = false;
        while ((line = br.readLine()) != null) {
            if (line.contains("execution time")) {
                System.out.println(line);
            }
            if (!readState && line.contains("number of states in")) {
                readState = true;
                continue;
            }
            if (!readState) continue;
            if (line.trim().startsWith("(")) {
                if (!line.trim().endsWith("or")) {
                    line = String.valueOf(line) + " or ";
                }
                String[] spl = line.split("[ ()]");
                if (two) {
                    lineState = String.valueOf(lineState) + "((";
                    two = false;
                } else {
                    lineState = String.valueOf(lineState) + "(";
                }
                int j = 0;
                while (j < spl.length) {
                    lineState = spl[j].contains("or") ? String.valueOf(lineState) + ") " + spl[j] + " " : String.valueOf(lineState) + spl[j] + " ";
                    ++j;
                }
                if (!fileState.contains(lineState = String.valueOf(lineState) + "\n")) {
                    fileState = String.valueOf(fileState) + lineState;
                    ++count;
                }
                lineState = "";
                continue;
            }
            readState = false;
        }
        br.close();
        isr.close();
        is.close();
        process.destroy();
        if (fileState.endsWith("or \n")) {
            fileState = String.valueOf(fileState.substring(0, fileState.length() - 5)) + ") and \n";
        }
        System.out.println("\t" + count + " state(s) is/are added!");
        initialState = String.valueOf(initialState) + fileState;
        if (initialState.endsWith("and \n")) {
            initialState = initialState.substring(0, initialState.length() - 5);
        }
        BufferedReader reader = null;
        reader = new BufferedReader(new FileReader(this.middleMCMAS.get(targetIndex)));
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(String.valueOf(this.middleMCMAS.get(targetIndex)) + ".tmp")), true);
        while ((tempString = reader.readLine()) != null) {
            if (tempString.contains("InitStates")) {
                pw.println(tempString);
                pw.println(String.valueOf(initialState) + ";");
                tempString = reader.readLine();
                tempString = reader.readLine();
                pw.println(tempString);
                continue;
            }
            pw.println(tempString);
        }
        Path source = Paths.get(String.valueOf(this.middleMCMAS.get(targetIndex)) + ".tmp", new String[0]);
        Path target = Paths.get(this.middleMCMAS.get(targetIndex), new String[0]);
        Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
        target = Paths.get(this.middleMCMAS.get(sourceIndex), new String[0]);
        this.middleMCMAS.remove(sourceIndex);
        Files.deleteIfExists(target);
        pw.close();
        reader.close();
    }

    private String computeInitialState() throws IOException {
        Process process = null;
        String initialState = "";
        String lineState = "";
        String fileState = "";
        boolean readState = false;
        boolean two = true;
        boolean ignore = false;
        int numNode = 0;
        int i = 0;
        while (i < this.middleMCMAS.size()) {
            fileState = "";
            two = true;
            System.out.println("Computing loops for component " + i + " ...");
            numNode = this.removeOrderedLeaves ? this.block.getLeaves().size() : (this.removeFirstOrderLeaves ? this.block.getG().V() - this.block.getFirstOrderLeaves().size() : (this.removeLeaves ? this.block.getG().V() - this.block.getLeaves().size() : this.block.getControlnodes().get(i).size() + this.block.getSCCs().get(i).size()));
            System.out.println("\tNumber of nodes in this component is " + numNode + ".");
            if (this.removeLeaves || this.block.getSCCs().get(i).size() != 1) {
                String line;
                process = this.getMCMASProcess(numNode, this.middleMCMAS.get(i), true);
                InputStream is = process.getInputStream();
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                int count = 0;
                ignore = false;
                while ((line = br.readLine()) != null) {
                    String[] spl;
                    System.out.println(line);
                    if (line.contains("execution time")) {
                        System.out.println(line);
                    }
                    if (!readState && line.contains("number of states in")) {
                        line = line.replaceAll("\\*", "");
                        spl = line.split("[ ]");
                        if (!this.removeLeaves && Double.parseDouble(spl[spl.length - 1]) > (double)this.MAX_NUM_STATE) {
                            System.out.println("Too many attractor states (" + spl[spl.length - 1] + ") detected. Ignore this SCC!");
                            ignore = true;
                            break;
                        }
                        readState = true;
                        continue;
                    }
                    if (!readState) continue;
                    if (line.trim().startsWith("(")) {
                        if (!line.trim().endsWith("or")) {
                            line = String.valueOf(line) + " or ";
                        }
                        spl = line.split("[ ()]");
                        if (two) {
                            lineState = String.valueOf(lineState) + "((";
                            two = false;
                        } else {
                            lineState = String.valueOf(lineState) + "(";
                        }
                        int j = 0;
                        while (j < spl.length) {
                            if (spl[j].contains("or")) {
                                if (!this.removeLeaves) {
                                    lineState = lineState.substring(0, lineState.length() - 5);
                                }
                                lineState = String.valueOf(lineState) + ") " + spl[j] + " ";
                            } else if (this.removeLeaves) {
                                lineState = String.valueOf(lineState) + spl[j] + " ";
                            } else {
                                List element = this.block.getSCCs().get(i);
                                int k = 0;
                                while (k < element.size()) {
                                    if (spl[j].contains("n_" + element.get(k) + "=")) {
                                        lineState = String.valueOf(lineState) + spl[j] + " and ";
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                        if (!fileState.contains(lineState = String.valueOf(lineState) + "\n")) {
                            fileState = String.valueOf(fileState) + lineState;
                            ++count;
                        }
                        lineState = "";
                        continue;
                    }
                    readState = false;
                }
                br.close();
                isr.close();
                is.close();
                process.destroy();
                if (fileState.equals("")) {
                    System.out.println("No attractor detected in this component! Hence no attractors in the original network!");
                    System.exit(0);
                }
                if (fileState.endsWith("or \n")) {
                    fileState = String.valueOf(fileState.substring(0, fileState.length() - 5)) + ") and \n";
                }
                if (!ignore && count != (int)Math.pow(2.0, this.block.getSCCs().get(i).size())) {
                    System.out.println("\t" + count + " state(s) is/are added!");
                    initialState = String.valueOf(initialState) + fileState;
                }
            } else {
                System.out.println("\tSCC too small, ignore it!");
            }
            ++i;
        }
        if (initialState.endsWith("and \n")) {
            initialState = initialState.substring(0, initialState.length() - 5);
        }
        return initialState;
    }

    private String computeInitialState(boolean onlyLargest) throws IOException {
        String line;
        if (!onlyLargest) {
            return this.computeInitialState();
        }
        Process process = null;
        String initialState = "(";
        boolean readState = false;
        int largest = 0;
        int i = 0;
        int index = 0;
        while (index < this.middleMCMAS.size()) {
            if (this.block.getSCCs().get(index).size() > largest) {
                largest = this.block.getSCCs().get(index).size();
                i = index;
            }
            ++index;
        }
        System.out.println("Computing loops for SCC " + i + " ...");
        System.out.println("\tNumber of nodes in this SCC is " + (this.block.getControlnodes().get(i).size() + this.block.getSCCs().get(i).size()) + ".");
        process = this.getMCMASProcess(this.block.getControlnodes().get(i).size() + this.block.getSCCs().get(i).size(), this.middleMCMAS.get(i), true);
        InputStream is = process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
            if (!line.contains("execution time")) continue;
            if (!readState && line.contains("number of states in")) {
                readState = true;
                continue;
            }
            if (!readState) continue;
            if (line.trim().startsWith("(")) {
                if (!line.trim().endsWith("or")) {
                    line = String.valueOf(line) + " or ";
                }
                String[] spl = line.split("[ ()]");
                int j = 0;
                while (j < spl.length) {
                    if (spl[j].contains("or")) {
                        initialState = initialState.substring(0, initialState.length() - 5);
                        initialState = String.valueOf(initialState) + ") " + spl[j] + " ";
                    } else {
                        List element = this.block.getSCCs().get(i);
                        int k = 0;
                        while (k < element.size()) {
                            if (spl[j].contains("n_" + element.get(k) + "=")) {
                                initialState = String.valueOf(initialState) + spl[j] + " and ";
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                initialState = String.valueOf(initialState) + "\n";
                continue;
            }
            readState = false;
        }
        br.close();
        isr.close();
        is.close();
        process.destroy();
        if (initialState.endsWith("or \n")) {
            initialState = initialState.substring(0, initialState.length() - 5);
        }
        return initialState;
    }

    private Process getMCMASProcess(int size, String para, boolean compositional) throws IOException {
        Process process = null;
        if (!compositional) {
            String[] pa = new String[this.MCMAScommand3.size() + 1];
            int i = 0;
            while (i < this.MCMAScommand3.size()) {
                pa[i] = this.MCMAScommand3.get(i);
                ++i;
            }
            pa[this.MCMAScommand3.size()] = para;
            return new ProcessBuilder(pa).start();
        }
        if (size > 65) {
            String[] pa = new String[this.MCMAScommand2.size() + 1];
            int i = 0;
            while (i < this.MCMAScommand2.size()) {
                pa[i] = this.MCMAScommand2.get(i);
                ++i;
            }
            pa[this.MCMAScommand2.size()] = para;
            process = new ProcessBuilder(pa).start();
        } else {
            String[] pa = new String[this.MCMAScommand1.size() + 1];
            int i = 0;
            while (i < this.MCMAScommand1.size()) {
                pa[i] = this.MCMAScommand1.get(i);
                ++i;
            }
            pa[this.MCMAScommand1.size()] = para;
            process = new ProcessBuilder(pa).start();
        }
        return process;
    }

    public static void main(String[] args) {
        int count = 0;
        Detect d = null;
        boolean merge = false;
        boolean largestOnly = false;
        boolean removeLeaves = false;
        boolean removeFirstOrderLeaves = false;
        boolean removeOrderedLeaves = false;
        String inputFile = null;
        String mcmasPath = null;
        String graphFile = null;
        String mcmasFile = null;
        boolean fromMcmas = false;
        ArrayList<Integer> nums = new ArrayList<Integer>();
        ArrayList cmds = new ArrayList();
        int orderNodes = 0;
        int maxNumState = 5000;
        while (count < args.length) {
            if (args[count].equals("-o")) {
                graphFile = args[++count];
                mcmasFile = args[++count];
                ++count;
                continue;
            }
            if (args[count].equals("-a")) {
                inputFile = args[++count];
                ++count;
                continue;
            }
            if (args[count].equals("-maxState")) {
                maxNumState = Integer.parseInt(args[++count]);
                ++count;
                continue;
            }
            if (args[count].equals("-mc")) {
                inputFile = args[++count];
                fromMcmas = true;
                ++count;
                continue;
            }
            if (args[count].equals("-m")) {
                mcmasPath = args[++count];
                ++count;
                continue;
            }
            if (args[count].equals("-leaves")) {
                removeLeaves = true;
                ++count;
                continue;
            }
            if (args[count].equals("-foleaves")) {
                removeFirstOrderLeaves = true;
                ++count;
                continue;
            }
            if (args[count].equals("-orleaves")) {
                removeOrderedLeaves = true;
                ++count;
                continue;
            }
            if (args[count].equals("-largest")) {
                largestOnly = true;
                ++count;
                continue;
            }
            if (args[count].equals("-merge")) {
                merge = true;
                ++count;
                continue;
            }
            if (args[count].equals("-order")) {
                orderNodes = Integer.parseInt(args[++count]);
                ++count;
                continue;
            }
            if (args[count].equals("-cmd")) {
                nums.add(Integer.parseInt(args[++count]));
                ++count;
                ArrayList<String> cmd = new ArrayList<String>();
                while (count < args.length && !args[count].equals("-endcmd")) {
                    cmd.add(args[count]);
                    ++count;
                }
                cmds.add(cmd);
                ++count;
                continue;
            }
            System.out.println(String.valueOf(args[count]) + " is invalid parameters! Program will exit.");
            System.exit(0);
        }
        if (mcmasPath == null) {
            System.out.println("Invalid parameters! Program will exit.");
            System.exit(0);
        }
        if (fromMcmas) {
            graphFile = String.valueOf(inputFile) + ".gra";
            try {
                new FileCoding().MCMASToGra(inputFile, graphFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            d = new Detect(graphFile, inputFile, mcmasPath);
        } else if (inputFile != null) {
            d = new Detect(inputFile, mcmasPath);
        } else if (graphFile != null) {
            d = new Detect(graphFile, mcmasFile, mcmasPath);
        } else {
            System.out.println("Invalid parameters! Program will exit.");
            System.exit(0);
        }
        int i = 0;
        while (i < nums.size()) {
            d.setCommand((int)((Integer)nums.get(i)), (List)cmds.get(i));
            ++i;
        }
        d.setRemoveLeaves(removeLeaves);
        d.setRemoveFOLeaves(removeFirstOrderLeaves);
        d.setRemoveOrderedLeaves(removeOrderedLeaves);
        d.setOrderNode(orderNodes);
        d.setMaxNumState(maxNumState);
        d.run(merge, largestOnly);
    }
}

