/*
 * Decompiled with CFR 0.152.
 */
package chowliuTree;

import PBN.BitSetPBN;
import PBN.Property;
import chowliuTree.MutalI;
import chowliuTree.UF;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import simulationMethod.SimulationMethod;
import simulationMethod.TwostateMultiPropertyParallel;
import userInterface.AssaLog;

public class ChouLiu {
    private BitSetPBN pbn;
    private int[] parent;
    private double[] jointProbability;
    private double[] probability;
    private ArrayList<MutalI> I;
    private int[] indexi;
    private int[] indexj;
    AssaLog assalog;

    public ChouLiu(AssaLog assalog) {
        this.assalog = assalog;
    }

    public void setPBN(BitSetPBN pbn) {
        this.pbn = pbn;
        int n = pbn.getN();
        this.parent = new int[n];
        this.jointProbability = new double[2 * n * (n - 1)];
        this.I = new ArrayList();
        this.probability = new double[n];
        this.indexi = new int[n * (n - 1) / 2];
        this.indexj = new int[this.indexi.length];
    }

    public void constructParent(double precision, double confidence) throws Exception {
        int i;
        ArrayList<Integer> negativeIndex;
        ArrayList<Integer> positiveIndex;
        Property p;
        MutalI elementI;
        if (this.pbn == null) {
            throw new Exception("PBN is not set!");
        }
        int n = this.pbn.getN();
        this.assalog.println("Constructing Chou Liu tree...");
        TwostateMultiPropertyParallel ts = new TwostateMultiPropertyParallel(this.pbn, this.assalog);
        ts.setM(4);
        ArrayList<Property> properties = new ArrayList<Property>();
        int count = 0;
        int i2 = 0;
        while (i2 < n - 1) {
            int j = i2 + 1;
            while (j < n) {
                elementI = new MutalI();
                elementI.xi = i2;
                elementI.xj = j;
                this.I.add(elementI);
                p = new Property();
                positiveIndex = new ArrayList();
                negativeIndex = new ArrayList();
                negativeIndex.add(i2);
                negativeIndex.add(j);
                p.setExpressions(positiveIndex, negativeIndex);
                properties.add(p);
                p = new Property();
                positiveIndex = new ArrayList();
                negativeIndex = new ArrayList();
                negativeIndex.add(i2);
                positiveIndex.add(j);
                p.setExpressions(positiveIndex, negativeIndex);
                properties.add(p);
                p = new Property();
                positiveIndex = new ArrayList();
                negativeIndex = new ArrayList();
                positiveIndex.add(i2);
                negativeIndex.add(j);
                p.setExpressions(positiveIndex, negativeIndex);
                properties.add(p);
                p = new Property();
                positiveIndex = new ArrayList();
                negativeIndex = new ArrayList();
                positiveIndex.add(i2);
                positiveIndex.add(j);
                p.setExpressions(positiveIndex, negativeIndex);
                properties.add(p);
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < n) {
            p = new Property();
            positiveIndex = new ArrayList<Integer>();
            negativeIndex = new ArrayList<Integer>();
            negativeIndex.add(i2);
            p.setExpressions(positiveIndex, negativeIndex);
            properties.add(p);
            ++i2;
        }
        ((SimulationMethod)ts).setExpressions(properties);
        double[] para = new double[]{precision, confidence};
        ((SimulationMethod)ts).setParameters(para);
        double[][] result = ((SimulationMethod)ts).run(this.pbn, true);
        int i3 = 0;
        while (i3 < this.jointProbability.length) {
            this.jointProbability[i3] = result[0][i3];
            if (i3 > 2 && i3 % 4 == 3) {
                double sum = this.jointProbability[i3 - 3] + this.jointProbability[i3 - 2] + this.jointProbability[i3 - 1] + this.jointProbability[i3];
                this.jointProbability[i3 - 3] = this.jointProbability[i3 - 3] / sum;
                this.jointProbability[i3 - 2] = this.jointProbability[i3 - 2] / sum;
                this.jointProbability[i3 - 1] = this.jointProbability[i3 - 1] / sum;
                this.jointProbability[i3] = this.jointProbability[i3] / sum;
            }
            this.assalog.println("jointProbability[" + i3 + "]=" + this.jointProbability[i3]);
            ++i3;
        }
        count = this.jointProbability.length;
        i3 = 0;
        while (i3 < this.probability.length) {
            this.probability[i3] = result[0][count + i3];
            this.assalog.println("probability[" + i3 + "]=" + this.probability[i3]);
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.indexj.length) {
            int offset = i4 * 4;
            elementI = this.I.get(i4);
            elementI.I = this.jointProbability[offset] * Math.log(this.jointProbability[offset] / (this.probability[elementI.xi] * this.probability[elementI.xj]));
            elementI.I += this.jointProbability[++offset] * Math.log(this.jointProbability[offset] / (this.probability[elementI.xi] * (1.0 - this.probability[elementI.xj])));
            elementI.I += this.jointProbability[++offset] * Math.log(this.jointProbability[offset] / ((1.0 - this.probability[elementI.xi]) * this.probability[elementI.xj]));
            elementI.I += this.jointProbability[++offset] * Math.log(this.jointProbability[offset] / ((1.0 - this.probability[elementI.xi]) * (1.0 - this.probability[elementI.xj])));
            ++i4;
        }
        Collections.sort(this.I, new Comparator<MutalI>(){

            @Override
            public int compare(MutalI o1, MutalI o2) {
                double p1 = o1.I;
                double p2 = o2.I;
                if (p1 < p2) {
                    return 1;
                }
                if (p1 > p2) {
                    return -1;
                }
                return 0;
            }
        });
        ArrayList<MutalI> spanningTree = new ArrayList<MutalI>();
        UF uf = new UF(n);
        int i5 = 0;
        while (i5 < this.I.size()) {
            elementI = this.I.get(i5);
            this.assalog.println(String.valueOf(elementI.xi) + ", " + elementI.xj + " : " + elementI.I);
            if (!uf.connected(elementI.xi, elementI.xj)) {
                uf.union(elementI.xi, elementI.xj);
                spanningTree.add(elementI);
            }
            ++i5;
        }
        i5 = 0;
        while (i5 < this.parent.length) {
            this.parent[i5] = -1;
            ++i5;
        }
        i5 = 0;
        while (i5 < spanningTree.size()) {
            elementI = (MutalI)spanningTree.get(i5);
            this.assalog.println("spanning tree- " + elementI.xi + ", " + elementI.xj + " : " + elementI.I);
            ++i5;
        }
        ArrayList<Integer> nextParentList = new ArrayList<Integer>();
        nextParentList.add(0);
        while (nextParentList.size() > 0) {
            int nextNode = (Integer)nextParentList.get(0);
            nextParentList.remove(0);
            i = 0;
            while (i < spanningTree.size()) {
                elementI = (MutalI)spanningTree.get(i);
                if (elementI.xi == nextNode) {
                    if (this.parent[elementI.xj] == -1) {
                        this.parent[elementI.xj] = elementI.xi;
                    } else {
                        this.assalog.println("Something unexpected happened!");
                    }
                    spanningTree.remove(i);
                    --i;
                    nextParentList.add(elementI.xj);
                } else if (elementI.xj == nextNode) {
                    if (this.parent[elementI.xi] == -1) {
                        this.parent[elementI.xi] = elementI.xj;
                    } else {
                        this.assalog.println("Something unexpected happened!");
                    }
                    spanningTree.remove(i);
                    --i;
                    nextParentList.add(elementI.xi);
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.parent.length) {
            this.assalog.println("Node " + i + " -> Node " + this.parent[i]);
            ++i;
        }
        this.assalog.println("Chou Liu tree constructed.");
    }

    public double computeSteadyState(Property property) {
        List positiveIndex = property.getPositiveIndex();
        List negativeIndex = property.getNegativeIndex();
        int n = this.pbn.getN();
        double result = 1.0;
        int i = 0;
        while (i < this.parent.length) {
            int index;
            int xj;
            int xi;
            if (this.parent[i] == -1) {
                if (positiveIndex.contains(i)) {
                    result *= 1.0 - this.probability[i];
                } else if (negativeIndex.contains(i)) {
                    result *= this.probability[i];
                }
            } else if (positiveIndex.contains(i)) {
                if (positiveIndex.contains(this.parent[i])) {
                    if (i > this.parent[i]) {
                        xi = this.parent[i];
                        xj = i;
                    } else {
                        xi = i;
                        xj = this.parent[i];
                    }
                    index = xi * (n - 1 + n - xi) / 2 + xj - 1;
                    index = index * 4 + 3;
                    result = result * this.jointProbability[index] / (1.0 - this.probability[xj]);
                } else if (negativeIndex.contains(this.parent[i])) {
                    if (i > this.parent[i]) {
                        xi = this.parent[i];
                        xj = i;
                        index = xi * (n - 1 + n - xi) / 2 + xj - 1;
                        index = index * 4 + 1;
                    } else {
                        xi = i;
                        xj = this.parent[i];
                        index = xi * (n - 1 + n - xi) / 2 + xj - 1;
                        index = index * 4 + 2;
                    }
                    result = result * this.jointProbability[index] / this.probability[this.parent[i]];
                } else {
                    result *= 1.0 - this.probability[i];
                }
            } else if (negativeIndex.contains(i)) {
                if (positiveIndex.contains(this.parent[i])) {
                    if (i > this.parent[i]) {
                        xi = this.parent[i];
                        xj = i;
                        index = xi * (n - 1 + n - xi) / 2 + xj - 1;
                        index = index * 4 + 2;
                    } else {
                        xi = i;
                        xj = this.parent[i];
                        index = xi * (n - 1 + n - xi) / 2 + xj - 1;
                        index = index * 4 + 1;
                    }
                    result = result * this.jointProbability[index] / (1.0 - this.probability[this.parent[i]]);
                } else if (negativeIndex.contains(this.parent[i])) {
                    if (i > this.parent[i]) {
                        xi = this.parent[i];
                        xj = i;
                    } else {
                        xi = i;
                        xj = this.parent[i];
                    }
                    index = xi * (n - 1 + n - xi) / 2 + xj - 1;
                    result = result * this.jointProbability[index *= 4] / this.probability[xj];
                } else {
                    result *= this.probability[i];
                }
            }
            ++i;
        }
        return result;
    }
}

