/*
 * Decompiled with CFR 0.152.
 */
package extra;

import cern.colt.bitvector.BitVector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class FileCoding {
    public void MCMASToGra(String input, String output) throws IOException {
        String tempString;
        BufferedReader reader = null;
        reader = new BufferedReader(new FileReader(input));
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(output)), true);
        int line = 0;
        int numNodes = 0;
        int index = 0;
        ArrayList arrows = new ArrayList();
        while ((tempString = reader.readLine()) != null) {
            if (line == 0 && tempString.contains("Vars")) {
                line = 1;
                continue;
            }
            if (line == 1) {
                if (tempString.contains("Vars")) {
                    line = 2;
                    continue;
                }
                if (!tempString.contains("boolean")) continue;
                while (tempString.contains("boolean")) {
                    tempString = tempString.replaceFirst("boolean", "BOO");
                    ++numNodes;
                    ArrayList element = new ArrayList();
                    arrows.add(element);
                }
                continue;
            }
            if (line == 2 && tempString.contains("Evolution")) {
                line = 3;
                continue;
            }
            if (line != 3) continue;
            if (tempString.contains("Evolution")) break;
            tempString = tempString.trim();
            String[] spl = tempString.split("[= ();]");
            String[] spl2 = spl[0].split("_");
            int child = Integer.parseInt(spl2[1]);
            List element = (List)arrows.get(child);
            int i = 1;
            while (i < spl.length) {
                spl[i] = spl[i].trim();
                if (!(spl[i].equals("") || spl[i].equals("and") || spl[i].equals("or") || spl[i].equalsIgnoreCase("true") || spl[i].equalsIgnoreCase("false") || spl[i].equalsIgnoreCase("if") || element.contains(index = Integer.parseInt((spl2 = spl[i].split("_"))[1])))) {
                    element.add(index);
                }
                ++i;
            }
        }
        reader.close();
        int numEdge = 0;
        int i = 0;
        while (i < arrows.size()) {
            List element = (List)arrows.get(i);
            numEdge += element.size();
            ++i;
        }
        pw.println(numNodes);
        pw.println(numEdge);
        i = 0;
        while (i < arrows.size()) {
            List element = (List)arrows.get(i);
            int j = 0;
            while (j < element.size()) {
                pw.println(element.get(j) + " " + i);
                ++j;
            }
            ++i;
        }
        pw.close();
    }

    public void compareAttractor() throws IOException {
        int j;
        int i;
        boolean[] state;
        String tempString;
        String[] label = new String[]{"housekeeping", "FASL_2", "IL_1", "TNF", "UV", "UV_2", "FASL", "Glucagon", "Insulin", "smac_mimetics", "T2RL", "AdCy", "Apaf_1", "apopto", "apoptosis", "A20", "Bad", "Bad_14_3_3", "Bax", "Bcl_xl", "Bid", "BIR1_2", "c_IAP", "c_IAP_2", "CAD", "cAMP", "complex1", "comp1_IKKa", "cyt_c", "C3a_c_IAP", "C3ap20", "C3ap20_2", "C3a_XIAP", "C8a_2", "C8a_comp2", "C8a_DISCa", "C8a_DISCa_2", "C8a_FLIP", "C9a", "DISCa", "DISCa_2", "ERK1o2", "FADD", "FAS", "FAS_2", "FLIP", "FLIP_2", "gelsolin", "GR", "Grb2_SOS", "GSK_3", "I_kBb", "ICAD", "IKKdeact", "IR", "IRS", "IRS_P", "IRS_P2", "JNK", "MEK", "NIK", "P", "Pak1", "PARP", "PDK1", "PKA", "PKB", "PKC", "PIP3", "PI3K", "proC8", "P14_3_3", "p38", "Rac", "Raf", "Ras", "RIP", "RIP_deubi", "Shc", "smac", "smac_XIAP", "tBid", "TNFR_1", "TRADD", "TRAF2", "T2R", "XIAP", "XIAP_2", "IKKa", "I_kBa", "I_kBe", "complex2", "NF_kB", "C8a", "C3ap17", "C3ap17_2", "C6"};
        ArrayList<boolean[]> mcmas = new ArrayList<boolean[]>();
        ArrayList<boolean[]> genYsis = new ArrayList<boolean[]>();
        BufferedReader reader = null;
        reader = new BufferedReader(new FileReader("result/apoptosis/mcmas.txt"));
        while ((tempString = reader.readLine()) != null) {
            if (!tempString.contains("M.n")) continue;
            state = new boolean[97];
            String[] split = tempString.split("[ =_]");
            i = 0;
            while (i < split.length) {
                if (split[i].contains("M.n")) {
                    int index = Integer.parseInt(split[++i]);
                    state[index] = split[++i].contains("true");
                }
                ++i;
            }
            mcmas.add(state);
        }
        state = (boolean[])mcmas.get(0);
        i = 0;
        while (i < state.length) {
            System.out.print(String.valueOf(state[i]) + "\t");
            ++i;
        }
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream("mcmasRe.txt")), true);
        int i2 = 0;
        while (i2 < mcmas.size()) {
            state = (boolean[])mcmas.get(i2);
            int j2 = 0;
            while (j2 < state.length) {
                if (state[j2]) {
                    pw.print("T");
                } else {
                    pw.print("F");
                }
                ++j2;
            }
            pw.println();
            ++i2;
        }
        pw.close();
        System.out.println();
        File f = null;
        String inputFileFolder = "result/apoptosis/genYsis_2";
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        boolean start = false;
        boolean[] state1 = null;
        boolean[] state2 = null;
        boolean[] state3 = null;
        boolean[] state4 = null;
        boolean case2 = false;
        int i3 = 0;
        while (i3 < files.length) {
            if (files[i3].isFile()) {
                reader = new BufferedReader(new FileReader(files[i3]));
                start = false;
                block6: while ((tempString = reader.readLine()) != null) {
                    if (tempString.startsWith("Gene Name/State No.")) {
                        if (tempString.charAt(tempString.length() - 1) == '4') {
                            start = true;
                            state1 = new boolean[97];
                            state2 = new boolean[97];
                            state3 = new boolean[97];
                            state4 = new boolean[97];
                            case2 = false;
                            continue;
                        }
                        if (tempString.charAt(tempString.length() - 1) == '2') {
                            start = true;
                            state1 = new boolean[97];
                            state2 = new boolean[97];
                            case2 = true;
                            continue;
                        }
                        System.out.println(String.valueOf(tempString) + "\t" + files[i3].getName());
                        break;
                    }
                    if (!start) continue;
                    StringTokenizer st = new StringTokenizer(tempString);
                    String tmp = st.nextToken();
                    int j3 = 0;
                    while (j3 < label.length) {
                        if (label[j3].equalsIgnoreCase(tmp)) {
                            if (case2) {
                                tmp = st.nextToken();
                                if (Integer.parseInt(tmp) == 1) {
                                    state1[j3] = true;
                                    state2[j3] = true;
                                } else if (Integer.parseInt(tmp) == 0) {
                                    state1[j3] = false;
                                    state2[j3] = false;
                                } else {
                                    state1[j3] = true;
                                    state2[j3] = false;
                                }
                                tmp = st.nextToken();
                                if (Integer.parseInt(tmp) == 1) {
                                    state3[j3] = true;
                                    state4[j3] = true;
                                    continue block6;
                                }
                                if (Integer.parseInt(tmp) == 0) {
                                    state3[j3] = false;
                                    state4[j3] = false;
                                    continue block6;
                                }
                                state3[j3] = true;
                                state4[j3] = false;
                                continue block6;
                            }
                            state1[j3] = Integer.parseInt(st.nextToken()) == 1;
                            state2[j3] = Integer.parseInt(st.nextToken()) == 1;
                            state3[j3] = Integer.parseInt(st.nextToken()) == 1;
                            if (Integer.parseInt(st.nextToken()) == 1) {
                                state4[j3] = true;
                                continue block6;
                            }
                            state4[j3] = false;
                            continue block6;
                        }
                        ++j3;
                    }
                }
                genYsis.add(state1);
                genYsis.add(state2);
                genYsis.add(state3);
                genYsis.add(state4);
            }
            ++i3;
        }
        state1 = (boolean[])genYsis.get(0);
        i3 = 0;
        while (i3 < state1.length) {
            System.out.print(String.valueOf(state1[i3]) + "\t");
            ++i3;
        }
        pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream("genYsisRe.txt")), true);
        i3 = 0;
        while (i3 < genYsis.size()) {
            state = (boolean[])genYsis.get(i3);
            int j4 = 0;
            while (j4 < state.length) {
                if (state[j4]) {
                    pw.print("T");
                } else {
                    pw.print("F");
                }
                ++j4;
            }
            pw.println();
            ++i3;
        }
        pw.close();
        System.out.println();
        System.out.println(String.valueOf(mcmas.size()) + "\t" + genYsis.size());
        int[] mcmasIndex = new int[8896];
        int[] genYsisIndex = new int[9088];
        int i4 = 0;
        while (i4 < mcmasIndex.length) {
            mcmasIndex[i4] = -1;
            genYsisIndex[i4] = -1;
            ++i4;
        }
        i4 = mcmasIndex.length;
        while (i4 < genYsisIndex.length) {
            genYsisIndex[i4] = -1;
            ++i4;
        }
        boolean found = true;
        int i5 = 0;
        while (i5 < genYsis.size()) {
            state1 = (boolean[])genYsis.get(i5);
            j = 0;
            while (j < mcmas.size()) {
                if (mcmasIndex[j] == -1) {
                    state2 = (boolean[])mcmas.get(j);
                    found = true;
                    int k = 0;
                    while (k < 97) {
                        if (state1[k] != state2[k]) {
                            found = false;
                            break;
                        }
                        ++k;
                    }
                    if (found) {
                        mcmasIndex[j] = i5;
                        genYsisIndex[i5] = j;
                    }
                }
                ++j;
            }
            ++i5;
        }
        i5 = 0;
        while (i5 < mcmasIndex.length) {
            if (mcmasIndex[i5] == -1) {
                System.out.print("mcmas index " + i5 + ": ");
                state1 = (boolean[])mcmas.get(i5);
                j = 0;
                while (j < 97) {
                    System.out.print(String.valueOf(state1[j]) + "\t");
                    ++j;
                }
                System.out.println();
            }
            ++i5;
        }
        i5 = 0;
        while (i5 < genYsisIndex.length) {
            if (genYsisIndex[i5] == -1) {
                System.out.print("genYsis index " + i5 + ": ");
                state1 = (boolean[])genYsis.get(i5);
                j = 0;
                while (j < 97) {
                    System.out.print(String.valueOf(state1[j]) + "\t");
                    ++j;
                }
                System.out.println();
            }
            ++i5;
        }
    }

    public void replaceMCMASNodeName(String inputFileName, String outputFile) throws IOException {
        String tempString;
        String[] label = new String[]{"housekeeping", "FASL_2", "IL_1", "TNF", "UV", "UV_2", "FASL", "Glucagon", "Insulin", "smac_mimetics", "T2RL", "AdCy", "Apaf_1", "apopto", "apoptosis", "A20", "Bad", "Bad_14_3_3", "Bax", "Bcl_xl", "Bid", "BIR1_2", "c_IAP", "c_IAP_2", "CAD", "cAMP", "complex1", "comp1_IKKa", "cyt_c", "C3a_c_IAP", "C3ap20", "C3ap20_2", "C3a_XIAP", "C8a_2", "C8a_comp2", "C8a_DISCa", "C8a_DISCa_2", "C8a_FLIP", "C9a", "DISCa", "DISCa_2", "ERK1o2", "FADD", "FAS", "FAS_2", "FLIP", "FLIP_2", "gelsolin", "GR", "Grb2_SOS", "GSK_3", "I_kBb", "ICAD", "IKKdeact", "IR", "IRS", "IRS_P", "IRS_P2", "JNK", "MEK", "NIK", "P", "Pak1", "PARP", "PDK1", "PKA", "PKB", "PKC", "PIP3", "PI3K", "proC8", "P14_3_3", "p38", "Rac", "Raf", "Ras", "RIP", "RIP_deubi", "Shc", "smac", "smac_XIAP", "tBid", "TNFR_1", "TRADD", "TRAF2", "T2R", "XIAP", "XIAP_2", "IKKa", "I_kBa", "I_kBe", "complex2", "NF_kB", "C8a", "C3ap17", "C3ap17_2", "C6"};
        int[] order = new int[97];
        int i = 0;
        while (i < order.length) {
            order[i] = i;
            ++i;
        }
        i = 0;
        while (i < order.length) {
            int j = i + 1;
            while (j < order.length) {
                if (label[order[j]].contains(label[order[i]])) {
                    order[i] = order[i] ^ order[j];
                    order[j] = order[i] ^ order[j];
                    order[i] = order[i] ^ order[j];
                    --i;
                    break;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < order.length) {
            System.out.println(String.valueOf(order[i]) + "\t" + label[order[i]]);
            ++i;
        }
        String[] keywords = new String[]{"Semantics", "Agent", "Vars", "end", "Actions", "Protocol", "Evolution", "Evaluation", "InitStates", "Formulae"};
        boolean notDone = true;
        BufferedReader reader = null;
        reader = new BufferedReader(new FileReader(inputFileName));
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputFile)), true);
        while ((tempString = reader.readLine()) != null) {
            notDone = true;
            int i2 = 0;
            while (i2 < keywords.length) {
                if (tempString.contains(keywords[i2])) {
                    pw.println(tempString);
                    notDone = false;
                    break;
                }
                ++i2;
            }
            if (!notDone) continue;
            i2 = 0;
            while (i2 < order.length) {
                tempString = tempString.replace(label[order[i2]], "n_" + order[i2]);
                ++i2;
            }
            pw.println(tempString);
        }
        reader.close();
        pw.close();
    }

    public void convertToNumberCoding(String inputFileName, String outputFile) throws IOException {
        String tempString;
        ArrayList<String> labelList = new ArrayList<String>();
        BufferedReader reader = null;
        reader = new BufferedReader(new FileReader(inputFileName));
        boolean start = false;
        while ((tempString = reader.readLine()) != null) {
            if (!start && tempString.contains("Vars")) {
                start = true;
                continue;
            }
            if (!start) continue;
            if (tempString.contains("Vars")) break;
            tempString = tempString.trim();
            String[] spl = tempString.split("[:]");
            labelList.add(spl[0]);
        }
        reader.close();
        String[] label = new String[labelList.size()];
        int i = 0;
        while (i < label.length) {
            label[i] = (String)labelList.get(i);
            ++i;
        }
        int[] order = new int[label.length];
        int i2 = 0;
        while (i2 < order.length) {
            order[i2] = i2;
            ++i2;
        }
        i2 = 0;
        while (i2 < order.length) {
            int j = i2 + 1;
            while (j < order.length) {
                if (label[order[j]].contains(label[order[i2]])) {
                    order[i2] = order[i2] ^ order[j];
                    order[j] = order[i2] ^ order[j];
                    order[i2] = order[i2] ^ order[j];
                    --i2;
                    break;
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < order.length) {
            System.out.println(String.valueOf(order[i2]) + "\t" + label[order[i2]]);
            ++i2;
        }
        String[] keywords = new String[]{"Semantics", "Agent", "Vars", "end", "Actions", "Protocol", "Evolution", "Evaluation", "InitStates", "Formulae"};
        boolean notDone = true;
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputFile)), true);
        reader = new BufferedReader(new FileReader(inputFileName));
        while ((tempString = reader.readLine()) != null) {
            notDone = true;
            int i3 = 0;
            while (i3 < keywords.length) {
                if (tempString.contains(keywords[i3])) {
                    pw.println(tempString);
                    notDone = false;
                    break;
                }
                ++i3;
            }
            if (!notDone) continue;
            i3 = 0;
            while (i3 < order.length) {
                tempString = tempString.replace(label[order[i3]], "n_" + order[i3]);
                ++i3;
            }
            pw.println(tempString);
        }
        reader.close();
        pw.close();
    }

    public void generateApoptosisInitial(String fileName, String inputFileName, String[] args) throws Exception {
        String tempString;
        String before = "";
        String end = "";
        int numArgs = args.length;
        int totalFiles = (int)Math.pow(2.0, numArgs);
        BufferedReader reader = null;
        reader = new BufferedReader(new FileReader(inputFileName));
        while ((tempString = reader.readLine()) != null) {
            before = String.valueOf(before) + tempString + "\n";
            if (tempString.contains("InitStates")) break;
        }
        reader.readLine();
        while ((tempString = reader.readLine()) != null) {
            end = String.valueOf(end) + tempString + "\n";
        }
        reader.close();
        String sixteenZeroes = "00000000000000000";
        int i = 0;
        while (i < totalFiles) {
            String re = Integer.toBinaryString(i);
            if (re.length() < numArgs) {
                re = String.valueOf(sixteenZeroes.substring(0, numArgs - re.length())) + re;
            }
            if (!(re.charAt(0) == '0' || re.charAt(1) == '1' && re.charAt(6) == '1' || re.charAt(4) == '1' && re.charAt(5) == '1')) {
                File outfile = new File(String.valueOf(fileName) + "_" + i + ".ispl");
                PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outfile)), true);
                pw.println(before);
                pw.print("\t");
                int j = 0;
                while (j < numArgs) {
                    pw.print(args[j]);
                    if (re.charAt(j) == '0') {
                        pw.print("false ");
                    } else {
                        pw.print("true ");
                    }
                    ++j;
                }
                pw.println(";");
                pw.println(end);
                pw.close();
            }
            ++i;
        }
    }

    public void solve(String fileName, String outFileName) throws Exception {
        File file = new File(fileName);
        if (file.exists()) {
            System.out.println(file.getAbsolutePath());
        }
        BufferedReader reader = null;
        reader = new BufferedReader(new FileReader(file));
        String tempString = null;
        int line = 0;
        int flag = 0;
        String model = null;
        String property = null;
        String preModel = null;
        long sampleSize = 0L;
        File outfile = new File(outFileName);
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outfile)), true);
        while ((tempString = reader.readLine()) != null) {
            String[] spl;
            ++line;
            if (tempString.startsWith("PBN")) {
                spl = tempString.split(" ");
                model = spl[3].substring(16);
                property = spl[5].substring(6);
                if (preModel != null && preModel.equals(model)) {
                    flag = 1;
                } else {
                    pw.print("\n" + model);
                }
                preModel = model;
                continue;
            }
            if (tempString.startsWith("Avg. sample")) {
                spl = tempString.split("[\t ]");
                sampleSize = Long.parseLong(spl[spl.length - 1]);
                flag = 2;
                continue;
            }
            if (!tempString.startsWith("Avg. point")) continue;
            if (flag != 2) {
                throw new Exception("Error happens in line " + line);
            }
            spl = tempString.split("[\t ]");
            double distribution = Double.parseDouble(spl[spl.length - 1]);
            flag = 3;
            pw.print("\t" + sampleSize + "\t" + distribution);
        }
        pw.close();
    }

    public void optPBNtoMcmas(String fileName, String outFileName) throws Exception {
        File file = new File(fileName);
        if (file.exists()) {
            System.out.println(file.getAbsolutePath());
        }
        BufferedReader reader = null;
        reader = new BufferedReader(new FileReader(file));
        String tempString = null;
        int line = 0;
        boolean flag = false;
        Object model = null;
        Object property = null;
        Object preModel = null;
        long sampleSize = 0L;
        File outfile = new File(outFileName);
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outfile)), true);
        ArrayList var = new ArrayList();
        while ((tempString = reader.readLine()) != null) {
            ++line;
            if (tempString.trim().startsWith("%")) continue;
            String[] spl = tempString.split("'");
            if (spl.length > 1) {
                tempString = spl[1];
            }
            System.out.println(tempString);
        }
        pw.close();
    }

    public String processNotParentheses(String str) throws Exception {
        int start = (str = this.processNotNot(str)).indexOf("~(");
        if (start == -1) {
            return str;
        }
        int firstRight = str.indexOf(")", start);
        int firstLeft = str.indexOf("(", start + 2);
        while (firstLeft != -1 && firstLeft < firstRight) {
            firstRight = str.indexOf(")", firstRight + 1);
            firstLeft = str.indexOf("(", firstLeft + 1);
        }
        if (firstRight == -1) {
            throw new Exception("Illegal expression for string: " + str);
        }
        str = start > 0 && firstRight + 1 < str.length() ? String.valueOf(str.substring(0, start)) + this.addNot(str.substring(start + 2, firstRight)) + str.substring(firstRight + 1) : (firstRight + 1 < str.length() ? String.valueOf(this.addNot(str.substring(start + 2, firstRight))) + str.substring(firstRight + 1) : this.addNot(str.substring(start + 2, firstRight)));
        return this.processNotParentheses(str);
    }

    public String addNot(String str) throws Exception {
        str = this.processNotParentheses(str);
        String re = "~";
        boolean and = true;
        while (str != null) {
            and = true;
            int kor = str.indexOf("|");
            int kand = str.indexOf("&");
            int k = kor;
            if (kand == -1 && kor == -1) {
                re = String.valueOf(re) + "~" + str;
                return re;
            }
            if (kor == -1) {
                k = kand;
                and = false;
            } else if (kand != -1 && k > kand) {
                k = kand;
                and = false;
            }
            int kp = str.indexOf("(");
            while (kp != -1 && k < kp) {
                re = "~" + str.substring(0, k);
                re = and ? String.valueOf(re) + "&" : String.valueOf(re) + "|";
                str = str.substring(k + 1, str.length());
                and = true;
                kor = str.indexOf("|");
                kand = str.indexOf("&");
                k = kor;
                if (kand == -1 && kor == -1) {
                    re = String.valueOf(re) + "~" + str;
                    return re;
                }
                if (kor == -1) {
                    k = kand;
                    and = false;
                } else if (kand != -1 && k > kand) {
                    k = kand;
                    and = false;
                }
                kp = str.indexOf("(");
            }
            if (kp != -1) {
                int firstRight = str.indexOf(")", kp);
                int firstLeft = str.indexOf("(", kp + 1);
                while (firstLeft != -1 && firstLeft < firstRight) {
                    firstRight = str.indexOf(")", firstRight + 1);
                    firstLeft = str.indexOf("(", firstLeft + 1);
                }
                if (firstRight == -1) {
                    throw new Exception("Illegal expression for string: " + str);
                }
                re = String.valueOf(re) + "~" + str.substring(kp, firstRight + 1);
                if (str.length() > firstRight + 1) {
                    re = str.substring(firstRight + 1, firstRight + 2).equals("|") ? String.valueOf(re) + "&" : String.valueOf(re) + "|";
                    str = str.substring(firstRight + 2);
                    continue;
                }
                str = null;
                continue;
            }
            and = true;
            kor = str.indexOf("|");
            kand = str.indexOf("&");
            k = kor;
            if (kand == -1 && kor == -1) {
                re = String.valueOf(re) + "~" + str;
                return re;
            }
            if (kor == -1) {
                k = kand;
                and = false;
            } else if (kand != -1 && k > kand) {
                k = kand;
                and = false;
            }
            re = and ? String.valueOf(re) + "&" : String.valueOf(re) + "|";
            str = str.substring(k + 1, str.length());
        }
        return re;
    }

    public String processNotNot(String str) {
        str = str.trim();
        String[] spl = str.split("~~");
        String re = "";
        int i = 0;
        while (i < spl.length) {
            re = String.valueOf(re) + spl[i];
            ++i;
        }
        return re;
    }

    public void getCijFromFile() throws IOException {
        String prefix = "model/PBN_96_6_";
        BufferedReader reader = null;
        File outfile = new File("outCij.txt");
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outfile)), true);
        int i = 1;
        while (i < 101) {
            String modelFileName = String.valueOf(prefix) + i + ".txt";
            File file = new File(modelFileName);
            reader = new BufferedReader(new FileReader(file));
            int count = 0;
            while (count < 309) {
                reader.readLine();
                ++count;
            }
            pw.println(reader.readLine());
            reader.close();
            ++i;
        }
        pw.close();
    }

    public void solveAttractor(String inputFileFolder, String outputFileName) throws Exception {
        BufferedReader reader = null;
        File f = null;
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputFileName)), true);
        boolean first = true;
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                int j;
                String[] spl;
                String tempString;
                if (first) {
                    first = false;
                    reader = new BufferedReader(new FileReader(files[i]));
                    pw.print("fileName\tnum\t");
                    while ((tempString = reader.readLine()) != null) {
                        if (!tempString.contains("number of states in selfloops =")) continue;
                        spl = tempString.split("=");
                        if (spl[1].equals("0")) {
                            pw.print("no attractor");
                            first = true;
                        } else {
                            tempString = reader.readLine();
                            spl = tempString.split("[= ()]");
                            j = 0;
                            while (j < spl.length) {
                                if (!(spl[j].equalsIgnoreCase("false") || spl[j].equalsIgnoreCase("true") || spl[j].equalsIgnoreCase("and"))) {
                                    pw.print(String.valueOf(spl[j]) + "\t");
                                }
                                ++j;
                            }
                        }
                        pw.println();
                        break;
                    }
                    reader.close();
                }
                reader = new BufferedReader(new FileReader(files[i]));
                while ((tempString = reader.readLine()) != null) {
                    if (tempString.startsWith("model/PBN_96_initial_")) {
                        spl = tempString.split("[_. ]");
                        pw.print(String.valueOf(files[i].getName()) + "\t" + spl[3] + "\t");
                        continue;
                    }
                    if (!tempString.contains("number of states in selfloops =")) continue;
                    spl = tempString.split("[=]");
                    pw.print(String.valueOf(spl[1]) + "\t");
                    if (!spl[1].equals("0")) {
                        tempString = reader.readLine();
                        spl = tempString.split("[= ()]");
                        j = 0;
                        while (j < spl.length) {
                            if (spl[j].equalsIgnoreCase("false")) {
                                pw.print("false\t");
                            } else if (spl[j].equalsIgnoreCase("true")) {
                                pw.print("true\t");
                            }
                            ++j;
                        }
                    }
                    pw.println();
                    break;
                }
                reader.close();
            }
            ++i;
        }
        pw.close();
    }

    public void solveMultipleAttractor(String inputFileFolder, String outputFileName) throws Exception {
        BufferedReader reader = null;
        File f = null;
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputFileName)), true);
        boolean first = true;
        String header = "";
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                String[] spl;
                String tempString;
                if (first) {
                    reader = new BufferedReader(new FileReader(files[i]));
                    while ((tempString = reader.readLine()) != null) {
                        int j;
                        if (tempString.contains("number of states in selfloops =")) {
                            spl = tempString.split("=");
                            if (spl[1].trim().equals("0")) continue;
                            pw.print("fileName\tindex\t# states in attractor\t");
                            tempString = reader.readLine();
                            spl = tempString.split("[= ()]");
                            j = 0;
                            while (j < spl.length) {
                                if (!(spl[j].trim().equalsIgnoreCase("") || spl[j].equalsIgnoreCase("false") || spl[j].equalsIgnoreCase("true") || spl[j].equalsIgnoreCase("and"))) {
                                    pw.print(String.valueOf(spl[j]) + "\t");
                                }
                                ++j;
                            }
                            first = false;
                            pw.println();
                            break;
                        }
                        if (!tempString.contains("number of states in simple loop 0 =")) continue;
                        pw.print("fileName\tindex\t# states in attractor\t");
                        spl = tempString.split("=");
                        if (spl[1].startsWith("0")) {
                            pw.print("no attractor");
                            first = true;
                        } else {
                            tempString = reader.readLine();
                            spl = tempString.split("[= ()]");
                            j = 0;
                            while (j < spl.length) {
                                if (!(spl[j].equalsIgnoreCase("false") || spl[j].equalsIgnoreCase("true") || spl[j].equalsIgnoreCase("and") || spl[j].equalsIgnoreCase("or"))) {
                                    pw.print(String.valueOf(spl[j]) + "\t");
                                }
                                ++j;
                            }
                        }
                        pw.println();
                        first = false;
                        break;
                    }
                    reader.close();
                }
                if (!first) {
                    reader = new BufferedReader(new FileReader(files[i]));
                    while ((tempString = reader.readLine()) != null) {
                        int k;
                        int j;
                        int numSelf;
                        if (tempString.startsWith("model/")) {
                            spl = tempString.split("[_. ]");
                            header = String.valueOf(files[i].getName()) + "\t" + spl[4] + "\t";
                            continue;
                        }
                        if (tempString.contains("number of states in selfloops =")) {
                            spl = tempString.split("[=]");
                            numSelf = Integer.parseInt(spl[1].trim());
                            j = 0;
                            while (j < numSelf) {
                                if (j == 0) {
                                    pw.print(header);
                                }
                                tempString = reader.readLine();
                                spl = tempString.split("[= ()]");
                                pw.print("1\t");
                                k = 0;
                                while (k < spl.length) {
                                    if (spl[k].equalsIgnoreCase("false")) {
                                        pw.print("false\t");
                                    } else if (spl[k].equalsIgnoreCase("true")) {
                                        pw.print("true\t");
                                    }
                                    ++k;
                                }
                                pw.println();
                                ++j;
                            }
                            continue;
                        }
                        if (!tempString.contains("number of states in simple loop") || tempString.contains("total")) continue;
                        spl = tempString.split("[= ]");
                        numSelf = Integer.parseInt(spl[12].trim());
                        j = 0;
                        while (j < numSelf) {
                            if (j == 0) {
                                pw.print(String.valueOf(header) + numSelf + "\t");
                            } else {
                                pw.print(" \t \t \t");
                            }
                            tempString = reader.readLine();
                            spl = tempString.split("[= ()]");
                            k = 0;
                            while (k < spl.length) {
                                if (spl[k].equalsIgnoreCase("false")) {
                                    pw.print("false\t");
                                } else if (spl[k].equalsIgnoreCase("true")) {
                                    pw.print("true\t");
                                }
                                ++k;
                            }
                            pw.println();
                            ++j;
                        }
                    }
                    reader.close();
                }
            }
            ++i;
        }
        pw.close();
    }

    public void solveMultipleAttractor2(String inputFileFolder, String outputFileName) throws Exception {
        BufferedReader reader = null;
        File f = null;
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputFileName)), true);
        boolean first = true;
        String header = "";
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                String[] spl;
                String tempString;
                if (first) {
                    reader = new BufferedReader(new FileReader(files[i]));
                    while ((tempString = reader.readLine()) != null) {
                        int j;
                        if (tempString.contains("number of states in selfloops =")) {
                            spl = tempString.split("=");
                            if (spl[1].trim().equals("0")) continue;
                            pw.print("fileName\tindex\t# states in attractor\t");
                            tempString = reader.readLine();
                            spl = tempString.split("[= ()]");
                            j = 0;
                            while (j < spl.length) {
                                if (!(spl[j].trim().equalsIgnoreCase("") || spl[j].equalsIgnoreCase("false") || spl[j].equalsIgnoreCase("true") || spl[j].equalsIgnoreCase("and"))) {
                                    pw.print(String.valueOf(spl[j]) + "\t");
                                }
                                ++j;
                            }
                            first = false;
                            pw.println();
                            break;
                        }
                        if (!tempString.contains("number of states in simple SCCs =") || (spl = tempString.split("="))[1].trim().equals("0")) continue;
                        pw.print("fileName\tindex\t# states in attractor\t");
                        tempString = reader.readLine();
                        spl = tempString.split("[= ()]");
                        j = 0;
                        while (j < spl.length) {
                            if (!(spl[j].equalsIgnoreCase("false") || spl[j].equalsIgnoreCase("true") || spl[j].equalsIgnoreCase("and") || spl[j].equalsIgnoreCase("or"))) {
                                pw.print(String.valueOf(spl[j]) + "\t");
                            }
                            ++j;
                        }
                        pw.println();
                        first = false;
                        break;
                    }
                    reader.close();
                }
                if (!first) {
                    reader = new BufferedReader(new FileReader(files[i]));
                    while ((tempString = reader.readLine()) != null) {
                        int k;
                        int j;
                        int numSelf;
                        if (tempString.startsWith("model/")) {
                            spl = tempString.split("[_. ]");
                            header = String.valueOf(files[i].getName()) + "\t" + spl[4] + "\t";
                            continue;
                        }
                        if (tempString.contains("number of states in selfloops =")) {
                            spl = tempString.split("[=]");
                            numSelf = Integer.parseInt(spl[1].trim());
                            j = 0;
                            while (j < numSelf) {
                                if (j != 0) {
                                    pw.print(header);
                                }
                                tempString = reader.readLine();
                                spl = tempString.split("[= ()]");
                                pw.print("1\t");
                                k = 0;
                                while (k < spl.length) {
                                    if (spl[k].equalsIgnoreCase("false")) {
                                        pw.print("false\t");
                                    } else if (spl[k].equalsIgnoreCase("true")) {
                                        pw.print("true\t");
                                    }
                                    ++k;
                                }
                                pw.println();
                                ++j;
                            }
                            continue;
                        }
                        if (!tempString.contains("number of states in simple SCCs")) continue;
                        spl = tempString.split("[= ]");
                        numSelf = Integer.parseInt(spl[10].trim());
                        j = 0;
                        while (j < numSelf) {
                            if (j == 0) {
                                pw.print(String.valueOf(header) + numSelf + "\t");
                            } else {
                                pw.print(" \t \t \t");
                            }
                            tempString = reader.readLine();
                            spl = tempString.split("[= ()]");
                            k = 0;
                            while (k < spl.length) {
                                if (spl[k].equalsIgnoreCase("false")) {
                                    pw.print("false\t");
                                } else if (spl[k].equalsIgnoreCase("true")) {
                                    pw.print("true\t");
                                }
                                ++k;
                            }
                            pw.println();
                            ++j;
                        }
                    }
                    reader.close();
                }
            }
            ++i;
        }
        pw.close();
    }

    public void solve2(String inputFileFolder, String outputFile) throws IOException {
        double[][] result = new double[18][4];
        BufferedReader reader = null;
        File f = null;
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputFile)), true);
        String model = null;
        int loop = 1;
        int index1 = 0;
        int index2 = 0;
        int i = 0;
        while (i < files.length) {
            String tempString;
            reader = new BufferedReader(new FileReader(files[i]));
            while ((tempString = reader.readLine()) != null) {
                String[] spl;
                if (loop == 1 && tempString.startsWith("Finish")) {
                    model = tempString.substring(25);
                    pw.println(model);
                    loop = 2;
                    continue;
                }
                if (tempString.contains("precision=0.0050")) {
                    index2 = 0;
                    if (tempString.startsWith("Node=15")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=20")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=30")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=50")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=80")) {
                        index1 = 4;
                        continue;
                    }
                    if (!tempString.startsWith("Node=100")) continue;
                    index1 = 5;
                    continue;
                }
                if (tempString.contains("Skart result:")) {
                    reader.readLine();
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 3][index2] = Double.parseDouble(spl[3]);
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 3 + 1][index2] = Double.parseDouble(spl[2]);
                    reader.readLine();
                    reader.readLine();
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 3 + 2][index2] = Double.parseDouble(spl[4]);
                    continue;
                }
                if (tempString.contains("Two state result:")) {
                    reader.readLine();
                    reader.readLine();
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 3][index2 + 1] = Double.parseDouble(spl[3]);
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 3 + 1][index2 + 1] = Double.parseDouble(spl[2]);
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 3 + 2][index2 + 1] = Double.parseDouble(spl[4]);
                    continue;
                }
                if (!tempString.contains("precision=5.0E-4")) continue;
                index2 = 2;
                if (tempString.startsWith("Node=15")) {
                    index1 = 0;
                    continue;
                }
                if (tempString.startsWith("Node=20")) {
                    index1 = 1;
                    continue;
                }
                if (tempString.startsWith("Node=30")) {
                    index1 = 2;
                    continue;
                }
                if (tempString.startsWith("Node=50")) {
                    index1 = 3;
                    continue;
                }
                if (tempString.startsWith("Node=80")) {
                    index1 = 4;
                    continue;
                }
                if (!tempString.startsWith("Node=100")) continue;
                index1 = 5;
            }
            ++i;
        }
        i = 0;
        while (i < 18) {
            int j = 0;
            while (j < 4) {
                pw.print(String.valueOf(result[i][j]) + "\t");
                ++j;
            }
            pw.println();
            if ((i + 1) % 3 == 0) {
                pw.println();
            }
            ++i;
        }
        pw.close();
    }

    public void solveParallel(String inputFileFolder, String outputFile) throws Exception {
        double[][] result = new double[9][72];
        BufferedReader reader = null;
        File f = null;
        int[] numNode = new int[]{80, 100, 200, 500, 1000, 2000};
        int[] numChain = new int[]{2, 5, 10, 20, 40, 60, 80};
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputFile)), true);
        Object model = null;
        int loop = 1;
        int index1 = 0;
        boolean index2 = false;
        int row1 = 0;
        int row2 = 0;
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                String tempString;
                reader = new BufferedReader(new FileReader(files[i]));
                loop = 1;
                while ((tempString = reader.readLine()) != null) {
                    String[] spl;
                    if (loop == 1 && tempString.startsWith("Run the Gelman method")) {
                        loop = 2;
                        spl = tempString.split("[-_ ]");
                        switch (Integer.parseInt(spl[9])) {
                            case 80: {
                                row1 = 0;
                                break;
                            }
                            case 100: {
                                row1 = 1;
                                break;
                            }
                            case 200: {
                                row1 = 2;
                                break;
                            }
                            case 500: {
                                row1 = 3;
                                break;
                            }
                            case 1000: {
                                row1 = 4;
                                break;
                            }
                            case 2000: {
                                row1 = 5;
                                break;
                            }
                            default: {
                                throw new Exception("errow in " + spl);
                            }
                        }
                        if (spl[11].equalsIgnoreCase("sparse")) {
                            row2 = 0;
                            continue;
                        }
                        if (spl[11].equalsIgnoreCase("between")) {
                            row2 = 1;
                            continue;
                        }
                        row2 = 2;
                        continue;
                    }
                    if (loop == 2 && tempString.contains("m=")) {
                        spl = tempString.split("[=, ]");
                        switch (Integer.parseInt(spl[1])) {
                            case 2: {
                                index1 = 1;
                                break;
                            }
                            case 5: {
                                index1 = 2;
                                break;
                            }
                            case 10: {
                                index1 = 3;
                                break;
                            }
                            case 20: {
                                index1 = 4;
                                break;
                            }
                            case 30: {
                                index1 = 5;
                                break;
                            }
                            case 40: {
                                index1 = 6;
                                break;
                            }
                            case 60: {
                                index1 = 7;
                                break;
                            }
                            case 80: {
                                index1 = 8;
                                break;
                            }
                            default: {
                                throw new Exception("errow in " + spl);
                            }
                        }
                        result[index1][row1 * 12 + row2 * 4 + 1] = Double.parseDouble(spl[15]);
                        continue;
                    }
                    if (loop == 2 && tempString.startsWith("precision=")) {
                        spl = tempString.split("[=, ]");
                        result[index1][row1 * 12 + row2 * 4] = Double.parseDouble(spl[4]);
                        spl = spl[8].split("s");
                        result[index1][row1 * 12 + row2 * 4 + 2] = Double.parseDouble(spl[0]);
                        result[index1][row1 * 12 + row2 * 4 + 3] = result[index1][row1 * 12 + row2 * 4 + 2] / result[index1][row1 * 12 + row2 * 4 + 1];
                        loop = 1;
                        continue;
                    }
                    if (loop == 1 && tempString.startsWith("Performing the two state Markov chain approach")) {
                        loop = 2;
                        spl = tempString.split("[-_ ]");
                        switch (Integer.parseInt(spl[13])) {
                            case 80: {
                                row1 = 0;
                                break;
                            }
                            case 100: {
                                row1 = 1;
                                break;
                            }
                            case 200: {
                                row1 = 2;
                                break;
                            }
                            case 500: {
                                row1 = 3;
                                break;
                            }
                            case 1000: {
                                row1 = 4;
                                break;
                            }
                            case 2000: {
                                row1 = 5;
                                break;
                            }
                            default: {
                                throw new Exception("errow in " + spl);
                            }
                        }
                        if (spl[15].equalsIgnoreCase("sparse")) {
                            row2 = 0;
                            continue;
                        }
                        if (spl[15].equalsIgnoreCase("between")) {
                            row2 = 1;
                            continue;
                        }
                        row2 = 2;
                        continue;
                    }
                    if (loop != 2 || !tempString.startsWith("Sample size")) continue;
                    spl = tempString.split("[\t ]");
                    result[0][row1 * 12 + row2 * 4 + 1] = Double.parseDouble(spl[2]);
                    tempString = reader.readLine();
                    spl = tempString.split("[\t ]");
                    result[0][row1 * 12 + row2 * 4] = Double.parseDouble(spl[1]);
                    tempString = reader.readLine();
                    spl = tempString.split("[\t ]");
                    spl = spl[3].split("[s]");
                    result[0][row1 * 12 + row2 * 4 + 2] = Double.parseDouble(spl[0]);
                    result[0][row1 * 12 + row2 * 4 + 3] = result[0][row1 * 12 + row2 * 4 + 2] / result[0][row1 * 12 + row2 * 4 + 1];
                    loop = 1;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 72) {
                pw.print(String.valueOf(result[i][j]) + "\t");
                ++j;
            }
            pw.println();
            ++i;
        }
        pw.close();
    }

    public void solveParallelSkart(String inputFileFolder, String outputFile) throws Exception {
        double[][] result = new double[9][72];
        BufferedReader reader = null;
        File f = null;
        int[] numNode = new int[]{80, 100, 200, 500, 1000, 2000};
        int[] numChain = new int[]{2, 5, 10, 20, 40, 60, 80};
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputFile)), true);
        Object model = null;
        int loop = 1;
        int index1 = 0;
        boolean index2 = false;
        int row1 = 0;
        int row2 = 0;
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                String tempString;
                reader = new BufferedReader(new FileReader(files[i]));
                loop = 1;
                while ((tempString = reader.readLine()) != null) {
                    String[] spl;
                    if (loop == 1 && tempString.startsWith("Performing the Skart method (parallel version)")) {
                        loop = 2;
                        spl = tempString.split("[-_ ]");
                        switch (Integer.parseInt(spl[13])) {
                            case 80: {
                                row1 = 0;
                                break;
                            }
                            case 100: {
                                row1 = 1;
                                break;
                            }
                            case 200: {
                                row1 = 2;
                                break;
                            }
                            case 500: {
                                row1 = 3;
                                break;
                            }
                            case 1000: {
                                row1 = 4;
                                break;
                            }
                            case 2000: {
                                row1 = 5;
                                break;
                            }
                            default: {
                                throw new Exception("errow in " + spl);
                            }
                        }
                        if (spl[15].startsWith("sparse")) {
                            row2 = 0;
                            continue;
                        }
                        if (spl[15].startsWith("between")) {
                            row2 = 1;
                            continue;
                        }
                        if (spl[15].startsWith("dense")) {
                            row2 = 2;
                            continue;
                        }
                        throw new Exception("Illegal values");
                    }
                    if (loop == 2 && tempString.contains("number of chains=")) {
                        spl = tempString.split("[=, ]");
                        switch (Integer.parseInt(spl[spl.length - 1])) {
                            case 2: {
                                index1 = 1;
                                break;
                            }
                            case 5: {
                                index1 = 2;
                                break;
                            }
                            case 10: {
                                index1 = 3;
                                break;
                            }
                            case 20: {
                                index1 = 4;
                                break;
                            }
                            case 30: {
                                index1 = 5;
                                break;
                            }
                            case 40: {
                                index1 = 6;
                                break;
                            }
                            case 60: {
                                index1 = 7;
                                break;
                            }
                            case 80: {
                                index1 = 8;
                                break;
                            }
                            default: {
                                throw new Exception("errow in " + spl);
                            }
                        }
                        loop = 3;
                        continue;
                    }
                    if (loop == 3 && tempString.startsWith("the average value")) {
                        spl = tempString.split("[\t ]");
                        result[index1][row1 * 12 + row2 * 4] = Double.parseDouble(spl[3]);
                        continue;
                    }
                    if (loop == 3 && tempString.startsWith("the sample size")) {
                        spl = tempString.split("[\t ]");
                        result[index1][row1 * 12 + row2 * 4 + 1] = Double.parseDouble(spl[4]);
                        continue;
                    }
                    if (loop == 3 && tempString.startsWith("the time cost")) {
                        spl = tempString.split("[\t ]");
                        result[index1][row1 * 12 + row2 * 4 + 2] = Double.parseDouble(spl[4]);
                        result[index1][row1 * 12 + row2 * 4 + 3] = result[index1][row1 * 12 + row2 * 4 + 2] / result[index1][row1 * 12 + row2 * 4 + 1];
                        loop = 1;
                        continue;
                    }
                    if (loop == 1 && tempString.startsWith("Performing the Skart method on")) {
                        loop = 3;
                        spl = tempString.split("[-_ ]");
                        switch (Integer.parseInt(spl[10])) {
                            case 80: {
                                row1 = 0;
                                break;
                            }
                            case 100: {
                                row1 = 1;
                                break;
                            }
                            case 200: {
                                row1 = 2;
                                break;
                            }
                            case 500: {
                                row1 = 3;
                                break;
                            }
                            case 1000: {
                                row1 = 4;
                                break;
                            }
                            case 2000: {
                                row1 = 5;
                                break;
                            }
                            default: {
                                throw new Exception("errow in " + spl);
                            }
                        }
                        if (spl[12].startsWith("sparse")) {
                            row2 = 0;
                            continue;
                        }
                        if (spl[12].startsWith("between")) {
                            row2 = 1;
                            continue;
                        }
                        if (spl[12].startsWith("dense")) {
                            row2 = 2;
                            continue;
                        }
                        throw new Exception("Illegal values");
                    }
                    if (loop != 3 || !tempString.startsWith("Sample size")) continue;
                    spl = tempString.split("[\t ]");
                    result[0][row1 * 12 + row2 * 4 + 1] = Double.parseDouble(spl[2]);
                    tempString = reader.readLine();
                    spl = tempString.split("[\t ]");
                    result[0][row1 * 12 + row2 * 4] = Double.parseDouble(spl[1]);
                    reader.readLine();
                    tempString = reader.readLine();
                    spl = tempString.split("[\t ]");
                    spl = spl[3].split("[s]");
                    result[0][row1 * 12 + row2 * 4 + 2] = Double.parseDouble(spl[0]);
                    result[0][row1 * 12 + row2 * 4 + 3] = result[0][row1 * 12 + row2 * 4 + 2] / result[0][row1 * 12 + row2 * 4 + 1];
                    loop = 1;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 72) {
                pw.print(String.valueOf(result[i][j]) + "\t");
                ++j;
            }
            pw.println();
            ++i;
        }
        pw.close();
    }

    public void solve3(String inputFileFolder, String outputFile) throws IOException {
        int outputFileNum = 10;
        int outputRowNum = 55;
        int outputColumnNum = 12;
        double[][][] result = new double[outputRowNum][outputColumnNum][outputFileNum];
        BufferedReader reader = null;
        File f = null;
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        PrintWriter[] pw = new PrintWriter[outputFileNum];
        int i = 0;
        while (i < outputFileNum) {
            pw[i] = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(String.valueOf(outputFile) + "_" + i + ".out")), true);
            ++i;
        }
        Object model = null;
        int loop = 1;
        int index1 = -1;
        int index2 = -1;
        int index3 = -1;
        int i2 = 0;
        while (i2 < files.length) {
            String tempString;
            reader = new BufferedReader(new FileReader(files[i2]));
            while ((tempString = reader.readLine()) != null) {
                String[] spl;
                if (tempString.startsWith("test PBN")) {
                    if (tempString.endsWith("-1.txt")) {
                        index3 = 0;
                    } else if (tempString.endsWith("-2.txt")) {
                        index3 = 1;
                    } else if (tempString.endsWith("-3.txt")) {
                        index3 = 2;
                    } else if (tempString.endsWith("-4.txt")) {
                        index3 = 3;
                    } else if (tempString.endsWith("-5.txt")) {
                        index3 = 4;
                    } else if (tempString.endsWith("-6.txt")) {
                        index3 = 5;
                    } else if (tempString.endsWith("-7.txt")) {
                        index3 = 6;
                    } else if (tempString.endsWith("-8.txt")) {
                        index3 = 7;
                    } else if (tempString.endsWith("-9.txt")) {
                        index3 = 8;
                    } else if (tempString.endsWith("-10.txt")) {
                        index3 = 9;
                    } else {
                        System.out.println("Error in determining output file number. Processing file name: " + files[i2].getName());
                        break;
                    }
                    tempString.contains("model/PBN_200");
                    loop = 2;
                    continue;
                }
                if (tempString.contains("precision=0.01")) {
                    index2 = 0;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=20,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=50,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=300,")) {
                        index1 = 7;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 8;
                        continue;
                    }
                    if (tempString.startsWith("Node=1000,")) {
                        index1 = 9;
                        continue;
                    }
                    if (!tempString.startsWith("Node=1500,")) continue;
                    index1 = 10;
                    continue;
                }
                if (tempString.contains("precision=0.0050")) {
                    index2 = 2;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=20,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=50,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=300,")) {
                        index1 = 7;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 8;
                        continue;
                    }
                    if (tempString.startsWith("Node=1000,")) {
                        index1 = 9;
                        continue;
                    }
                    if (!tempString.startsWith("Node=1500,")) continue;
                    index1 = 10;
                    continue;
                }
                if (tempString.contains("precision=0.0010")) {
                    index2 = 4;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=20,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=50,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=300,")) {
                        index1 = 7;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 8;
                        continue;
                    }
                    if (tempString.startsWith("Node=1000,")) {
                        index1 = 9;
                        continue;
                    }
                    if (!tempString.startsWith("Node=1500,")) continue;
                    index1 = 10;
                    continue;
                }
                if (tempString.contains("precision=5.0E-4")) {
                    index2 = 6;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=20,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=50,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=300,")) {
                        index1 = 7;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 8;
                        continue;
                    }
                    if (tempString.startsWith("Node=1000,")) {
                        index1 = 9;
                        continue;
                    }
                    if (!tempString.startsWith("Node=1500,")) continue;
                    index1 = 10;
                    continue;
                }
                if (tempString.contains("precision=1.0E-4")) {
                    index2 = 8;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=20,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=50,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=300,")) {
                        index1 = 7;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 8;
                        continue;
                    }
                    if (tempString.startsWith("Node=1000,")) {
                        index1 = 9;
                        continue;
                    }
                    if (!tempString.startsWith("Node=1500,")) continue;
                    index1 = 10;
                    continue;
                }
                if (tempString.contains("precision=5.0E-5")) {
                    index2 = 10;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=20,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=50,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=300,")) {
                        index1 = 7;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 8;
                        continue;
                    }
                    if (tempString.startsWith("Node=1000,")) {
                        index1 = 9;
                        continue;
                    }
                    if (!tempString.startsWith("Node=1500,")) continue;
                    index1 = 10;
                    continue;
                }
                if (tempString.contains("Skart result:")) {
                    if (index1 == -1 || index2 == -1 || index3 == -1) {
                        System.out.println("Error happens in file " + files[i2].getName());
                    }
                    reader.readLine();
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 5][index2][index3] = Double.parseDouble(spl[3]);
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 5 + 1][index2][index3] = Double.parseDouble(spl[2]);
                    reader.readLine();
                    reader.readLine();
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 5 + 2][index2][index3] = Double.parseDouble(spl[4]);
                    reader.readLine();
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 5 + 3][index2][index3] = Double.parseDouble(spl[3]);
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 5 + 4][index2][index3] = Double.parseDouble(spl[3]);
                    continue;
                }
                if (!tempString.contains("Two state result:")) continue;
                reader.readLine();
                reader.readLine();
                tempString = reader.readLine();
                if (tempString == null) break;
                spl = tempString.split("[\t ]");
                result[index1 * 5][index2 + 1][index3] = Double.parseDouble(spl[3]);
                tempString = reader.readLine();
                if (tempString == null) break;
                spl = tempString.split("[\t ]");
                result[index1 * 5 + 1][index2 + 1][index3] = Double.parseDouble(spl[2]);
                tempString = reader.readLine();
                if (tempString == null) break;
                spl = tempString.split("[\t ]");
                result[index1 * 5 + 2][index2 + 1][index3] = Double.parseDouble(spl[4]);
                reader.readLine();
                tempString = reader.readLine();
                if (tempString == null) break;
                spl = tempString.split("[\t ]");
                result[index1 * 5 + 3][index2 + 1][index3] = Double.parseDouble(spl[2]);
            }
            ++i2;
        }
        int k = 0;
        while (k < outputFileNum) {
            int i3 = 0;
            while (i3 < outputRowNum) {
                int j = 0;
                while (j < outputColumnNum) {
                    pw[k].print(String.valueOf(result[i3][j][k]) + "\t");
                    ++j;
                }
                pw[k].println();
                if ((i3 + 1) % 5 == 0) {
                    pw[k].println();
                }
                ++i3;
            }
            pw[k].close();
            ++k;
        }
    }

    public void solve4(String inputFileFolder, String outputFile, boolean twostatebetter) throws Exception {
        int outputFileNum = 3;
        int outputRowNum = 45;
        int outputColumnNum = 12;
        double[][][] result = new double[outputRowNum][outputColumnNum][outputFileNum];
        BufferedReader reader = null;
        File f = null;
        boolean ignore = false;
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        PrintWriter[] pw = new PrintWriter[outputFileNum];
        int i = 0;
        while (i < outputFileNum) {
            pw[i] = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(String.valueOf(outputFile) + "_" + i + ".out")), true);
            ++i;
        }
        PrintWriter pwmc = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(String.valueOf(outputFile) + "_mc.out")), true);
        Object model = null;
        int loop = 1;
        int index1 = -1;
        int index2 = -1;
        int index3 = -1;
        int i2 = 0;
        while (i2 < files.length) {
            String tempString;
            reader = new BufferedReader(new FileReader(files[i2]));
            while ((tempString = reader.readLine()) != null) {
                String[] spl;
                if (tempString.startsWith("Finish loading")) {
                    ignore = false;
                    if (tempString.contains("-dense")) {
                        index3 = 0;
                    } else if (tempString.contains("-between")) {
                        index3 = 1;
                    } else if (tempString.contains("-sparse")) {
                        index3 = 2;
                    } else {
                        System.out.println("Error in determining output file number. Processing file name: " + files[i2].getName());
                        break;
                    }
                    loop = 2;
                    continue;
                }
                if (tempString.contains("precision=0.01")) {
                    index2 = 0;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=150,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=300,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=400,")) {
                        index1 = 7;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 8;
                        continue;
                    }
                    throw new Exception("index1 cannot be determined!");
                }
                if (tempString.contains("precision=0.0050")) {
                    index2 = 2;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=150,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=300,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=400,")) {
                        index1 = 7;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 8;
                        continue;
                    }
                    throw new Exception("index1 cannot be determined!");
                }
                if (tempString.contains("precision=0.0010")) {
                    index2 = 4;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=150,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=300,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=400,")) {
                        index1 = 7;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 8;
                        continue;
                    }
                    throw new Exception("index1 cannot be determined!");
                }
                if (tempString.contains("precision=5.0E-4")) {
                    index2 = 6;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=150,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=300,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=400,")) {
                        index1 = 7;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 8;
                        continue;
                    }
                    throw new Exception("index1 cannot be determined!");
                }
                if (tempString.contains("precision=1.0E-4")) {
                    index2 = 8;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=150,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=300,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=400,")) {
                        index1 = 7;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 8;
                        continue;
                    }
                    throw new Exception("index1 cannot be determined!");
                }
                if (tempString.contains("precision=8.0E-5")) {
                    index2 = 10;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=150,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=300,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=400,")) {
                        index1 = 7;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 8;
                        continue;
                    }
                    throw new Exception("index1 cannot be determined!");
                }
                if (tempString.contains("precision=0.5")) {
                    ignore = true;
                    continue;
                }
                if (!ignore && tempString.contains("Skart result:")) {
                    if (index1 == -1 || index2 == -1 || index3 == -1) {
                        System.out.println("Error happens in file " + files[i2].getName());
                    }
                    reader.readLine();
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 5][index2][index3] = Double.parseDouble(spl[3]);
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 5 + 1][index2][index3] = Double.parseDouble(spl[2]);
                    reader.readLine();
                    reader.readLine();
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 5 + 2][index2][index3] = Double.parseDouble(spl[4]);
                    reader.readLine();
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 5 + 3][index2][index3] = Double.parseDouble(spl[3]);
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 5 + 4][index2][index3] = Double.parseDouble(spl[3]);
                    continue;
                }
                if (ignore || !tempString.contains("Two state result:")) continue;
                reader.readLine();
                reader.readLine();
                tempString = reader.readLine();
                if (tempString == null) break;
                spl = tempString.split("[\t ]");
                result[index1 * 5][index2 + 1][index3] = Double.parseDouble(spl[3]);
                tempString = reader.readLine();
                if (tempString == null) break;
                spl = tempString.split("[\t ]");
                result[index1 * 5 + 1][index2 + 1][index3] = Double.parseDouble(spl[2]);
                tempString = reader.readLine();
                if (tempString == null) break;
                spl = tempString.split("[\t ]");
                result[index1 * 5 + 2][index2 + 1][index3] = Double.parseDouble(spl[4]);
                reader.readLine();
                tempString = reader.readLine();
                if (tempString == null) break;
                spl = tempString.split("[\t ]");
                result[index1 * 5 + 3][index2 + 1][index3] = Double.parseDouble(spl[2]);
            }
            ++i2;
        }
        int k = 0;
        while (k < outputFileNum) {
            int i3 = 0;
            while (i3 < outputRowNum) {
                int j = 0;
                while (j < outputColumnNum) {
                    pw[k].print(String.valueOf(result[i3][j][k]) + "\t");
                    ++j;
                }
                pw[k].println();
                if ((i3 + 1) % 5 == 0) {
                    pw[k].println();
                }
                ++i3;
            }
            pw[k].close();
            ++k;
        }
        double nodeNum = 0.0;
        double precision = 0.0;
        double density = 0.0;
        double LARGE = 1.1;
        double DIFF = 10.0;
        int k2 = 0;
        while (k2 < outputFileNum) {
            switch (k2) {
                case 0: {
                    density = 0.9;
                    break;
                }
                case 1: {
                    density = 0.5;
                    break;
                }
                case 2: {
                    density = 0.1;
                }
            }
            int i4 = 0;
            while (i4 < outputRowNum) {
                switch (i4 / 5) {
                    case 0: {
                        nodeNum = 15.0;
                        break;
                    }
                    case 1: {
                        nodeNum = 30.0;
                        break;
                    }
                    case 2: {
                        nodeNum = 80.0;
                        break;
                    }
                    case 3: {
                        nodeNum = 100.0;
                        break;
                    }
                    case 4: {
                        nodeNum = 150.0;
                        break;
                    }
                    case 5: {
                        nodeNum = 200.0;
                        break;
                    }
                    case 6: {
                        nodeNum = 300.0;
                        break;
                    }
                    case 7: {
                        nodeNum = 400.0;
                        break;
                    }
                    case 8: {
                        nodeNum = 500.0;
                    }
                }
                int j = 0;
                while (j < outputColumnNum) {
                    switch (j / 2) {
                        case 0: {
                            precision = 0.01;
                            break;
                        }
                        case 1: {
                            precision = 0.005;
                            break;
                        }
                        case 2: {
                            precision = 0.001;
                            break;
                        }
                        case 3: {
                            precision = 5.0E-4;
                            break;
                        }
                        case 4: {
                            precision = 1.0E-4;
                            break;
                        }
                        case 5: {
                            precision = 8.0E-5;
                        }
                    }
                    double probability = (result[i4 + 1][j][k2] + result[i4 + 1][j + 1][k2]) / 2.0;
                    pwmc.println(String.valueOf(nodeNum) + "\t" + precision + "\t" + probability + "\t" + density + "\t" + result[i4 + 2][j][k2] + "\t" + result[i4 + 2][j + 1][k2]);
                    j += 2;
                }
                i4 += 5;
            }
            ++k2;
        }
        pwmc.close();
    }

    public void solve5(String inputFileFolder, String outputFile, boolean twostatebetter) throws Exception {
        int outputFileNum = 3;
        int outputRowNum = 40;
        int outputColumnNum = 12;
        double[][][] result = new double[outputRowNum][outputColumnNum][outputFileNum];
        BufferedReader reader = null;
        File f = null;
        boolean ignore = false;
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        PrintWriter[] pw = new PrintWriter[outputFileNum];
        int i = 0;
        while (i < outputFileNum) {
            pw[i] = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(String.valueOf(outputFile) + "_" + i + ".out")), true);
            ++i;
        }
        PrintWriter pwmc = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(String.valueOf(outputFile) + "_mc.out")), true);
        Object model = null;
        int loop = 1;
        int index1 = -1;
        int index2 = -1;
        int index3 = -1;
        int i2 = 0;
        while (i2 < files.length) {
            String tempString;
            reader = new BufferedReader(new FileReader(files[i2]));
            while ((tempString = reader.readLine()) != null) {
                String[] spl;
                if (tempString.startsWith("Finish loading")) {
                    ignore = false;
                    if (tempString.contains("-dense")) {
                        index3 = 0;
                    } else if (tempString.contains("-between")) {
                        index3 = 1;
                    } else if (tempString.contains("-sparse")) {
                        index3 = 2;
                    } else {
                        System.out.println("Error in determining output file number. Processing file name: " + files[i2].getName());
                        break;
                    }
                    loop = 2;
                    continue;
                }
                if (tempString.contains("precision=0.01")) {
                    index2 = 0;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=1000,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=2000,")) {
                        index1 = 7;
                        continue;
                    }
                    throw new Exception("index1 cannot be determined!");
                }
                if (tempString.contains("precision=0.0050")) {
                    index2 = 2;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=1000,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=2000,")) {
                        index1 = 7;
                        continue;
                    }
                    throw new Exception("index1 cannot be determined!");
                }
                if (tempString.contains("precision=0.0010")) {
                    index2 = 4;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=1000,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=2000,")) {
                        index1 = 7;
                        continue;
                    }
                    throw new Exception("index1 cannot be determined!");
                }
                if (tempString.contains("precision=5.0E-4")) {
                    index2 = 6;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=1000,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=2000,")) {
                        index1 = 7;
                        continue;
                    }
                    throw new Exception("index1 cannot be determined!");
                }
                if (tempString.contains("precision=1.0E-4")) {
                    index2 = 8;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=1000,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=2000,")) {
                        index1 = 7;
                        continue;
                    }
                    throw new Exception("index1 cannot be determined!");
                }
                if (tempString.contains("precision=8.0E-5")) {
                    index2 = 10;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=1000,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=2000,")) {
                        index1 = 7;
                        continue;
                    }
                    throw new Exception("index1 cannot be determined!");
                }
                if (tempString.contains("precision=0.5")) {
                    ignore = true;
                    continue;
                }
                if (!ignore && tempString.contains("Skart result:")) {
                    if (index1 == -1 || index2 == -1 || index3 == -1) {
                        System.out.println("Error happens in file " + files[i2].getName());
                    }
                    reader.readLine();
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 5][index2][index3] = Double.parseDouble(spl[3]);
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 5 + 1][index2][index3] = Double.parseDouble(spl[2]);
                    reader.readLine();
                    reader.readLine();
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 5 + 2][index2][index3] = Double.parseDouble(spl[4]);
                    reader.readLine();
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 5 + 3][index2][index3] = Double.parseDouble(spl[3]);
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 5 + 4][index2][index3] = Double.parseDouble(spl[3]);
                    continue;
                }
                if (ignore || !tempString.contains("Two state result:")) continue;
                reader.readLine();
                reader.readLine();
                tempString = reader.readLine();
                if (tempString == null) break;
                spl = tempString.split("[\t ]");
                result[index1 * 5][index2 + 1][index3] = Double.parseDouble(spl[3]);
                tempString = reader.readLine();
                if (tempString == null) break;
                spl = tempString.split("[\t ]");
                result[index1 * 5 + 1][index2 + 1][index3] = Double.parseDouble(spl[2]);
                tempString = reader.readLine();
                if (tempString == null) break;
                spl = tempString.split("[\t ]");
                result[index1 * 5 + 2][index2 + 1][index3] = Double.parseDouble(spl[4]);
                reader.readLine();
                tempString = reader.readLine();
                if (tempString == null) break;
                spl = tempString.split("[\t ]");
                result[index1 * 5 + 3][index2 + 1][index3] = Double.parseDouble(spl[2]);
            }
            ++i2;
        }
        int k = 0;
        while (k < outputFileNum) {
            int i3 = 0;
            while (i3 < outputRowNum) {
                int j = 0;
                while (j < outputColumnNum) {
                    pw[k].print(String.valueOf(result[i3][j][k]) + "\t");
                    ++j;
                }
                pw[k].println();
                if ((i3 + 1) % 5 == 0) {
                    pw[k].println();
                }
                ++i3;
            }
            pw[k].close();
            ++k;
        }
        double nodeNum = 0.0;
        double precision = 0.0;
        double density = 0.0;
        double LARGE = 1.1;
        double DIFF = 10.0;
        int k2 = 0;
        while (k2 < outputFileNum) {
            switch (k2) {
                case 0: {
                    density = 0.9;
                    break;
                }
                case 1: {
                    density = 0.5;
                    break;
                }
                case 2: {
                    density = 0.1;
                }
            }
            int i4 = 0;
            while (i4 < outputRowNum) {
                switch (i4 / 5) {
                    case 0: {
                        nodeNum = 15.0;
                        break;
                    }
                    case 1: {
                        nodeNum = 30.0;
                        break;
                    }
                    case 2: {
                        nodeNum = 80.0;
                        break;
                    }
                    case 3: {
                        nodeNum = 100.0;
                        break;
                    }
                    case 4: {
                        nodeNum = 200.0;
                        break;
                    }
                    case 5: {
                        nodeNum = 500.0;
                        break;
                    }
                    case 6: {
                        nodeNum = 1000.0;
                        break;
                    }
                    case 7: {
                        nodeNum = 2000.0;
                    }
                }
                int j = 0;
                while (j < outputColumnNum) {
                    switch (j / 2) {
                        case 0: {
                            precision = 0.01;
                            break;
                        }
                        case 1: {
                            precision = 0.005;
                            break;
                        }
                        case 2: {
                            precision = 0.001;
                            break;
                        }
                        case 3: {
                            precision = 5.0E-4;
                            break;
                        }
                        case 4: {
                            precision = 1.0E-4;
                            break;
                        }
                        case 5: {
                            precision = 8.0E-5;
                        }
                    }
                    double probability = (result[i4 + 1][j][k2] + result[i4 + 1][j + 1][k2]) / 2.0;
                    pwmc.println(String.valueOf(nodeNum) + "\t" + precision + "\t" + probability + "\t" + density + "\t" + result[i4 + 2][j][k2] + "\t" + result[i4 + 2][j + 1][k2]);
                    j += 2;
                }
                i4 += 5;
            }
            ++k2;
        }
        pwmc.close();
    }

    public void solve6(String inputFileFolder, String outputFile, boolean twostatebetter) throws Exception {
        int outputFileNum = 3;
        int outputRowNum = 50;
        int outputColumnNum = 14;
        double[][][] result = new double[outputRowNum][outputColumnNum][outputFileNum];
        BufferedReader reader = null;
        File f = null;
        boolean ignore = false;
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        PrintWriter[] pw = new PrintWriter[outputFileNum];
        int i = 0;
        while (i < outputFileNum) {
            pw[i] = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(String.valueOf(outputFile) + "_" + i + ".out")), true);
            ++i;
        }
        PrintWriter pwmc = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(String.valueOf(outputFile) + "_mc.out")), true);
        Object model = null;
        int loop = 1;
        int index1 = -1;
        int index2 = -1;
        int index3 = -1;
        int i2 = 0;
        while (i2 < files.length) {
            String tempString;
            reader = new BufferedReader(new FileReader(files[i2]));
            while ((tempString = reader.readLine()) != null) {
                String[] spl;
                if (tempString.startsWith("Finish loading")) {
                    ignore = false;
                    if (tempString.contains("-dense")) {
                        index3 = 0;
                    } else if (tempString.contains("-between")) {
                        index3 = 1;
                    } else if (tempString.contains("-sparse")) {
                        index3 = 2;
                    } else {
                        System.out.println("Error in determining output file number. Processing file name: " + files[i2].getName());
                        break;
                    }
                    loop = 2;
                    continue;
                }
                if (tempString.contains("precision=0.01")) {
                    index2 = 0;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=20,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=50,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 7;
                        continue;
                    }
                    if (tempString.startsWith("Node=1000,")) {
                        index1 = 8;
                        continue;
                    }
                    if (tempString.startsWith("Node=2000,")) {
                        index1 = 9;
                        continue;
                    }
                    throw new Exception("index1 cannot be determined!");
                }
                if (tempString.contains("precision=0.0050")) {
                    index2 = 2;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=20,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=50,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 7;
                        continue;
                    }
                    if (tempString.startsWith("Node=1000,")) {
                        index1 = 8;
                        continue;
                    }
                    if (tempString.startsWith("Node=2000,")) {
                        index1 = 9;
                        continue;
                    }
                    throw new Exception("index1 cannot be determined!");
                }
                if (tempString.contains("precision=0.0010")) {
                    index2 = 4;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=20,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=50,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 7;
                        continue;
                    }
                    if (tempString.startsWith("Node=1000,")) {
                        index1 = 8;
                        continue;
                    }
                    if (tempString.startsWith("Node=2000,")) {
                        index1 = 9;
                        continue;
                    }
                    throw new Exception("index1 cannot be determined!");
                }
                if (tempString.contains("precision=5.0E-4")) {
                    index2 = 6;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=20,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=50,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 7;
                        continue;
                    }
                    if (tempString.startsWith("Node=1000,")) {
                        index1 = 8;
                        continue;
                    }
                    if (tempString.startsWith("Node=2000,")) {
                        index1 = 9;
                        continue;
                    }
                    throw new Exception("index1 cannot be determined!");
                }
                if (tempString.contains("precision=1.0E-4")) {
                    index2 = 8;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=20,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=50,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 7;
                        continue;
                    }
                    if (tempString.startsWith("Node=1000,")) {
                        index1 = 8;
                        continue;
                    }
                    if (tempString.startsWith("Node=2000,")) {
                        index1 = 9;
                        continue;
                    }
                    throw new Exception("index1 cannot be determined!");
                }
                if (tempString.contains("precision=8.0E-5")) {
                    index2 = 10;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=20,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=50,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 7;
                        continue;
                    }
                    if (tempString.startsWith("Node=1000,")) {
                        index1 = 8;
                        continue;
                    }
                    if (tempString.startsWith("Node=2000,")) {
                        index1 = 9;
                        continue;
                    }
                    throw new Exception("index1 cannot be determined!");
                }
                if (tempString.contains("precision=5.0E-5")) {
                    index2 = 12;
                    if (tempString.startsWith("Node=15,")) {
                        index1 = 0;
                        continue;
                    }
                    if (tempString.startsWith("Node=20,")) {
                        index1 = 1;
                        continue;
                    }
                    if (tempString.startsWith("Node=30,")) {
                        index1 = 2;
                        continue;
                    }
                    if (tempString.startsWith("Node=50,")) {
                        index1 = 3;
                        continue;
                    }
                    if (tempString.startsWith("Node=80,")) {
                        index1 = 4;
                        continue;
                    }
                    if (tempString.startsWith("Node=100,")) {
                        index1 = 5;
                        continue;
                    }
                    if (tempString.startsWith("Node=200,")) {
                        index1 = 6;
                        continue;
                    }
                    if (tempString.startsWith("Node=500,")) {
                        index1 = 7;
                        continue;
                    }
                    if (tempString.startsWith("Node=1000,")) {
                        index1 = 8;
                        continue;
                    }
                    if (tempString.startsWith("Node=2000,")) {
                        index1 = 9;
                        continue;
                    }
                    throw new Exception("index1 cannot be determined!");
                }
                if (tempString.contains("precision=0.5")) {
                    ignore = true;
                    continue;
                }
                if (!ignore && tempString.contains("Skart result:")) {
                    if (index1 == -1 || index2 == -1 || index3 == -1) {
                        System.out.println("Error happens in file " + files[i2].getName());
                    }
                    reader.readLine();
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 5][index2][index3] = Double.parseDouble(spl[3]);
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 5 + 1][index2][index3] = Double.parseDouble(spl[2]);
                    reader.readLine();
                    reader.readLine();
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 5 + 2][index2][index3] = Double.parseDouble(spl[4]);
                    reader.readLine();
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 5 + 3][index2][index3] = Double.parseDouble(spl[3]);
                    tempString = reader.readLine();
                    if (tempString == null) break;
                    spl = tempString.split("[\t ]");
                    result[index1 * 5 + 4][index2][index3] = Double.parseDouble(spl[3]);
                    continue;
                }
                if (ignore || !tempString.contains("Two state result:")) continue;
                reader.readLine();
                reader.readLine();
                tempString = reader.readLine();
                if (tempString == null) break;
                spl = tempString.split("[\t ]");
                result[index1 * 5][index2 + 1][index3] = Double.parseDouble(spl[3]);
                tempString = reader.readLine();
                if (tempString == null) break;
                spl = tempString.split("[\t ]");
                result[index1 * 5 + 1][index2 + 1][index3] = Double.parseDouble(spl[2]);
                tempString = reader.readLine();
                if (tempString == null) break;
                spl = tempString.split("[\t ]");
                result[index1 * 5 + 2][index2 + 1][index3] = Double.parseDouble(spl[4]);
                reader.readLine();
                tempString = reader.readLine();
                if (tempString == null) break;
                spl = tempString.split("[\t ]");
                result[index1 * 5 + 3][index2 + 1][index3] = Double.parseDouble(spl[2]);
            }
            ++i2;
        }
        int k = 0;
        while (k < outputFileNum) {
            int i3 = 0;
            while (i3 < outputRowNum) {
                int j = 0;
                while (j < outputColumnNum) {
                    pw[k].print(String.valueOf(result[i3][j][k]) + "\t");
                    ++j;
                }
                pw[k].println();
                if ((i3 + 1) % 5 == 0) {
                    pw[k].println();
                }
                ++i3;
            }
            pw[k].close();
            ++k;
        }
        double nodeNum = 0.0;
        double precision = 0.0;
        double density = 0.0;
        double LARGE = 1.1;
        double DIFF = 10.0;
        int k2 = 0;
        while (k2 < outputFileNum) {
            switch (k2) {
                case 0: {
                    density = 0.9;
                    break;
                }
                case 1: {
                    density = 0.5;
                    break;
                }
                case 2: {
                    density = 0.1;
                }
            }
            int i4 = 0;
            while (i4 < outputRowNum) {
                switch (i4 / 5) {
                    case 0: {
                        nodeNum = 15.0;
                        break;
                    }
                    case 1: {
                        nodeNum = 20.0;
                        break;
                    }
                    case 2: {
                        nodeNum = 30.0;
                        break;
                    }
                    case 3: {
                        nodeNum = 50.0;
                        break;
                    }
                    case 4: {
                        nodeNum = 80.0;
                        break;
                    }
                    case 5: {
                        nodeNum = 100.0;
                        break;
                    }
                    case 6: {
                        nodeNum = 200.0;
                        break;
                    }
                    case 7: {
                        nodeNum = 500.0;
                        break;
                    }
                    case 8: {
                        nodeNum = 1000.0;
                        break;
                    }
                    case 9: {
                        nodeNum = 2000.0;
                    }
                }
                int j = 0;
                while (j < outputColumnNum) {
                    switch (j / 2) {
                        case 0: {
                            precision = 0.01;
                            break;
                        }
                        case 1: {
                            precision = 0.005;
                            break;
                        }
                        case 2: {
                            precision = 0.001;
                            break;
                        }
                        case 3: {
                            precision = 5.0E-4;
                            break;
                        }
                        case 4: {
                            precision = 1.0E-4;
                            break;
                        }
                        case 5: {
                            precision = 8.0E-5;
                            break;
                        }
                        case 6: {
                            precision = 5.0E-5;
                        }
                    }
                    double probability = (result[i4 + 1][j][k2] + result[i4 + 1][j + 1][k2]) / 2.0;
                    pwmc.println(String.valueOf(nodeNum) + "\t" + precision + "\t" + probability + "\t" + density + "\t" + result[i4 + 2][j][k2] + "\t" + result[i4 + 2][j + 1][k2]);
                    j += 2;
                }
                i4 += 5;
            }
            ++k2;
        }
        pwmc.close();
    }

    public void solvePBN96(String inputFileFolder, String outputFileName) throws Exception {
        BufferedReader reader = null;
        File f = null;
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputFileName)), true);
        boolean lineDone = true;
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                String tempString;
                reader = new BufferedReader(new FileReader(files[i]));
                while ((tempString = reader.readLine()) != null) {
                    String[] spl;
                    if (tempString.startsWith("PBN node96 test")) {
                        if (!lineDone) {
                            throw new Exception("Not finishing the previous line.");
                        }
                        lineDone = false;
                        spl = tempString.split("[\t= ]");
                        pw.print(String.valueOf(spl[4]) + "\t" + spl[7] + "\t");
                        continue;
                    }
                    if (tempString.startsWith("Finish loading PBN model")) continue;
                    if (tempString.startsWith("precision=")) {
                        if (lineDone) {
                            throw new Exception("Error in determine precision.");
                        }
                        spl = tempString.split("[\t=, ]");
                        pw.print(String.valueOf(spl[1]) + "\t");
                        continue;
                    }
                    if (tempString.startsWith("Avg. sample size")) {
                        if (lineDone) {
                            throw new Exception("Error in determine sample size.");
                        }
                        spl = tempString.split("[\t= ]");
                        pw.print(String.valueOf(spl[3]) + "\t");
                        continue;
                    }
                    if (tempString.startsWith("Avg. point")) {
                        if (lineDone) {
                            throw new Exception("Error in determine point.");
                        }
                        spl = tempString.split("[\t= ]");
                        pw.print(String.valueOf(spl[2]) + "\t");
                        continue;
                    }
                    if (tempString.startsWith("Cpu time cost")) {
                        if (lineDone) {
                            throw new Exception("Error in determine time cost.");
                        }
                        spl = tempString.split("[\t= ]");
                        pw.println(String.valueOf(spl[3]) + "\t");
                        lineDone = true;
                        continue;
                    }
                    if (!tempString.startsWith("The selection probability of N")) continue;
                    if (lineDone) {
                        throw new Exception("Error in determine selection probability.");
                    }
                    spl = tempString.split("[\t= ]");
                    pw.print(String.valueOf(spl[8]) + "\t");
                }
                if (!lineDone) {
                    pw.println();
                    lineDone = true;
                }
            }
            ++i;
        }
    }

    public void solvePBN96_2(String inputFileFolder, String outputFileName) throws Exception {
        BufferedReader reader = null;
        File f = null;
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputFileName)), true);
        String[][] output = new String[160][6];
        boolean lineDone = true;
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                String tempString;
                reader = new BufferedReader(new FileReader(files[i]));
                while ((tempString = reader.readLine()) != null) {
                    String[] spl;
                    if (tempString.startsWith("Finish loading PBN model")) {
                        if (!lineDone) {
                            throw new Exception("Not finishing the previous line.");
                        }
                        lineDone = false;
                        spl = tempString.split("[\t= ]");
                        if (spl.length > 6) {
                            pw.print(String.valueOf(spl[5]) + "\t" + spl[8] + "\t");
                            continue;
                        }
                        spl = files[i].getName().split("-");
                        pw.print(String.valueOf(spl[0]) + "\t" + spl[1] + "\t");
                        continue;
                    }
                    if (tempString.startsWith("precision=")) {
                        if (lineDone) {
                            throw new Exception("Error in determine precision.");
                        }
                        spl = tempString.split("[\t=, ]");
                        pw.print(String.valueOf(spl[1]) + "\t");
                        continue;
                    }
                    if (tempString.startsWith("Avg. sample size")) {
                        if (lineDone) {
                            throw new Exception("Error in determine sample size.");
                        }
                        spl = tempString.split("[\t= ]");
                        pw.print(String.valueOf(spl[3]) + "\t");
                        continue;
                    }
                    if (tempString.startsWith("Avg. point")) {
                        if (lineDone) {
                            throw new Exception("Error in determine point.");
                        }
                        spl = tempString.split("[\t= ]");
                        pw.print(String.valueOf(spl[2]) + "\t");
                        continue;
                    }
                    if (tempString.startsWith("Cpu time cost")) {
                        if (lineDone) {
                            throw new Exception("Error in determine time cost.");
                        }
                        spl = tempString.split("[\t= ]");
                        pw.println(String.valueOf(spl[3]) + "\t");
                        lineDone = true;
                        continue;
                    }
                    if (!tempString.startsWith("The selection probability of N")) continue;
                    if (lineDone) {
                        throw new Exception("Error in determine selection probability.");
                    }
                    spl = tempString.split("[\t= ]");
                    pw.print(String.valueOf(spl[8]) + "\t");
                }
                if (!lineDone) {
                    pw.println();
                    lineDone = true;
                }
            }
            ++i;
        }
    }

    public void solvePBN96_parallel(String inputFileFolder, String outputFileName) throws Exception {
        BufferedReader reader = null;
        File f = null;
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputFileName)), true);
        String[][] output = new String[160][6];
        boolean lineDone = true;
        String timecost = null;
        String model = null;
        String property = null;
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                String tempString;
                reader = new BufferedReader(new FileReader(files[i]));
                while ((tempString = reader.readLine()) != null) {
                    String[] spl;
                    if (tempString.startsWith("PBN node96 test")) {
                        if (!lineDone) {
                            throw new Exception("Not finishing the previous line.");
                        }
                        lineDone = false;
                        spl = tempString.split("[\t= ]");
                        model = spl[4];
                        pw.print(String.valueOf(spl[4]) + "\t");
                        continue;
                    }
                    if (tempString.startsWith("Total time cost")) {
                        spl = tempString.split("[ ]");
                        timecost = spl[3];
                        continue;
                    }
                    if (!tempString.startsWith("Property ")) continue;
                    spl = tempString.split("[: ]");
                    pw.print("property_96_3_all_" + spl[1] + "\t");
                    property = spl[1];
                    tempString = reader.readLine();
                    spl = tempString.split("[\t=, ]");
                    pw.println(String.valueOf(tempString) + "\t" + timecost);
                    if (property.equals("7")) {
                        lineDone = true;
                        continue;
                    }
                    pw.print(String.valueOf(model) + "\t");
                }
            }
            ++i;
        }
    }

    public void solveMcmas(String inputFileFolder, String outputFileName) throws Exception {
        BufferedReader reader = null;
        File f = null;
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputFileName)), true);
        boolean lineDone = true;
        double[][] results = new double[32][4];
        int[][] statesNum = new int[32][2];
        int times1 = 0;
        int row = 0;
        int column = 0;
        int i = 0;
        while (i < files.length) {
            String tempString;
            reader = new BufferedReader(new FileReader(files[i]));
            while ((tempString = reader.readLine()) != null) {
                String[] spl;
                if (tempString.startsWith("model/")) {
                    spl = tempString.split("[\\s\\._-]");
                    if (spl[1].equals("50")) {
                        times1 = 0;
                    } else if (spl[1].equals("60")) {
                        times1 = 1;
                    } else if (spl[1].equals("70")) {
                        times1 = 2;
                    } else if (spl[1].equals("80")) {
                        times1 = 3;
                    } else if (spl[1].equals("90")) {
                        times1 = 4;
                    } else if (spl[1].equals("100")) {
                        times1 = 5;
                    } else if (spl[1].equals("150")) {
                        times1 = 6;
                    } else if (spl[1].equals("200")) {
                        times1 = 7;
                    }
                    int times2 = spl[3].equals("max2") ? 0 : 1;
                    int times3 = spl[4].equals("dis1") ? 0 : 1;
                    row = times1 * 4 + times2 * 2 + times3;
                    if (spl[5].equals("force")) {
                        column = 3;
                        continue;
                    }
                    if (spl[5].equals("ispl")) {
                        column = 0;
                        continue;
                    }
                    if (spl[5].equals("withorder")) {
                        column = 1;
                        continue;
                    }
                    if (!spl[5].equals("heuristic1")) continue;
                    column = 2;
                    continue;
                }
                if (tempString.contains("number of states in selfloops =")) {
                    spl = tempString.split("[ ]");
                    statesNum[row][0] = (int)Double.parseDouble(spl[spl.length - 1]);
                    continue;
                }
                if (tempString.contains(" number of simple loops")) {
                    spl = tempString.split("[ ]");
                    statesNum[row][1] = Integer.parseInt(spl[spl.length - 1]);
                    continue;
                }
                if (!tempString.startsWith("execution time")) continue;
                spl = tempString.split("[ ]");
                results[row][column] = Double.parseDouble(spl[spl.length - 1]);
            }
            ++i;
        }
        i = 0;
        while (i < 32) {
            pw.println(String.valueOf(statesNum[i][0]) + "\t" + statesNum[i][1] + "\t" + results[i][0] + "\t" + results[i][1] + "\t" + results[i][2] + "\t" + results[i][3]);
            ++i;
        }
        pw.println();
    }

    public void solveMcmasDirectOutput(String inputFileFolder, String outputFileName) throws Exception {
        BufferedReader reader = null;
        File f = null;
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputFileName)), true);
        boolean lineDone = true;
        double[][] results = new double[32][4];
        int[][] statesNum = new int[32][2];
        boolean times1 = false;
        boolean row = false;
        boolean column = false;
        pw.println("fileName\tmodelName\tselfloopState\tsimpleLoops\tTime");
        int i = 0;
        while (i < files.length) {
            if (files[i].getName().endsWith(".gen")) {
                String tempString;
                pw.print(String.valueOf(files[i].getName()) + "\t");
                reader = new BufferedReader(new FileReader(files[i]));
                while ((tempString = reader.readLine()) != null) {
                    String[] spl;
                    if (tempString.startsWith("model/")) {
                        spl = tempString.split("[ ]");
                        pw.print(String.valueOf(spl[0]) + "\t");
                        continue;
                    }
                    if (tempString.contains("number of states in selfloops =")) {
                        spl = tempString.split("[=]");
                        pw.print(String.valueOf(spl[1]) + "\t");
                        continue;
                    }
                    if (tempString.contains(" number of simple loops")) {
                        spl = tempString.split("[=]");
                        pw.print(String.valueOf(spl[1]) + "\t");
                        continue;
                    }
                    if (!tempString.startsWith("execution time")) continue;
                    spl = tempString.split("[=]");
                    pw.print(spl[1]);
                }
                pw.println();
            }
            ++i;
        }
    }

    public void solveMcmasDirectOutput_2(String inputFileFolder, String outputFileName) throws Exception {
        BufferedReader reader = null;
        File f = null;
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputFileName)), true);
        ArrayList<String[]> output = new ArrayList<String[]>();
        boolean lineDone = true;
        double[][] results = new double[32][4];
        int[][] statesNum = new int[32][2];
        boolean times1 = false;
        boolean row = false;
        boolean column = false;
        String name = null;
        String[] tmp = null;
        int index = 0;
        int count = 4;
        pw.println("modelName\tselfloopState\tsimpleLoops\tTime\tWithOrder\tForce\tHeuristic1");
        int i = 0;
        while (i < files.length) {
            if (files[i].getName().endsWith(".gen")) {
                String tempString;
                reader = new BufferedReader(new FileReader(files[i]));
                while ((tempString = reader.readLine()) != null) {
                    String[] spl;
                    if (tempString.startsWith("model/")) {
                        if (tempString.contains("BN-Expression")) {
                            spl = tempString.split("[ -]");
                            name = String.valueOf(spl[0]) + "-Expression" + "-" + spl[2] + "-" + spl[3];
                            if (spl.length > 4) {
                                name = String.valueOf(name) + "." + spl[4];
                            }
                            index = spl[1].toLowerCase().contains("withorder") ? 1 : (spl[1].toLowerCase().contains("force") ? 2 : (spl[1].toLowerCase().contains("heuristic1") ? 3 : 0));
                        } else if (tempString.contains("PBN")) {
                            spl = tempString.split("[ -.]");
                            name = String.valueOf(spl[0]) + "-" + spl[1] + "-" + spl[2] + "-" + spl[3];
                            count = 4;
                            while (spl.length > count) {
                                if (spl[count].contains("ispl") || spl[count].contains("withorder") || spl[count].contains("force") || spl[count].contains("heuristic1")) break;
                                name = String.valueOf(name) + spl[count];
                                ++count;
                            }
                            index = tempString.toLowerCase().contains("withorder") ? 1 : (tempString.toLowerCase().contains("force") ? 2 : (tempString.toLowerCase().contains("heuristic1") ? 3 : 0));
                        }
                        boolean found = false;
                        for (String[] element : output) {
                            if (!element[0].startsWith(name) && !name.startsWith(element[0])) continue;
                            found = true;
                            tmp = element;
                            break;
                        }
                        if (found) continue;
                        String[] ele = new String[7];
                        ele[0] = name;
                        output.add(ele);
                        tmp = ele;
                        continue;
                    }
                    if (tempString.contains("number of states in selfloops =")) {
                        spl = tempString.split("[=]");
                        if (tmp[1] != null && !tmp[1].equals("")) {
                            if (tmp[1].equals(spl[1])) continue;
                            System.out.println("Error " + name + "\t" + index);
                            continue;
                        }
                        tmp[1] = spl[1];
                        continue;
                    }
                    if (tempString.contains("number of states in simple SCCs") || tempString.contains("number of simple loops")) {
                        spl = tempString.split("[=]");
                        if (tmp[2] != null && !tmp[2].equals("")) {
                            if (tmp[2].equals(spl[1])) continue;
                            System.out.println("Error " + name + "\t" + index);
                            continue;
                        }
                        tmp[2] = spl[1];
                        continue;
                    }
                    if (!tempString.startsWith("execution time")) continue;
                    spl = tempString.split("[=]");
                    tmp[index + 3] = spl[1];
                }
            }
            ++i;
        }
        for (String[] element : output) {
            pw.println(String.valueOf(element[0]) + "\t" + element[1] + "\t" + element[2] + "\t" + element[3] + "\t" + element[4] + "\t" + element[5] + "\t" + element[6] + "\t");
        }
    }

    public void solveGenYsis(String inputFileFolder, String outputFileName) throws Exception {
        BufferedReader reader = null;
        File f = null;
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputFileName)), true);
        boolean lineDone = false;
        String[][] results = new String[32][2];
        String name = null;
        int times1 = 0;
        int row = 0;
        boolean column = false;
        int i = 0;
        while (i < files.length) {
            String tempString;
            reader = new BufferedReader(new FileReader(files[i]));
            while ((tempString = reader.readLine()) != null) {
                String[] spl;
                if (tempString.contains("States of the attractor 1")) {
                    spl = tempString.split("[\\s/]");
                    name = spl[12];
                    lineDone = true;
                    if ((spl = spl[12].split("[-_]"))[1].equals("50")) {
                        times1 = 0;
                    } else if (spl[1].equals("60")) {
                        times1 = 1;
                    } else if (spl[1].equals("70")) {
                        times1 = 2;
                    } else if (spl[1].equals("80")) {
                        times1 = 3;
                    } else if (spl[1].equals("90")) {
                        times1 = 4;
                    } else if (spl[1].equals("100")) {
                        times1 = 5;
                    } else if (spl[1].equals("150")) {
                        times1 = 6;
                    } else if (spl[1].equals("200")) {
                        times1 = 7;
                    }
                    int times2 = spl[3].equals("max2") ? 0 : 1;
                    int times3 = spl[4].equals("dis1") ? 0 : 1;
                    row = times1 * 4 + times2 * 2 + times3;
                    continue;
                }
                if (!lineDone || !tempString.startsWith("user")) continue;
                lineDone = false;
                spl = tempString.split("[\\s\t]");
                results[row][1] = spl[1];
                results[row][0] = name;
            }
            ++i;
        }
        i = 0;
        while (i < 32) {
            pw.println(String.valueOf(results[i][0]) + "\t" + results[i][1]);
            ++i;
        }
        pw.println();
    }

    public void solveGenYsisDirectOutput(String inputFileFolder, String outputFileName) throws Exception {
        BufferedReader reader = null;
        File f = null;
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputFileName)), true);
        boolean lineDone = false;
        String[][] results = new String[32][2];
        Object name = null;
        boolean times1 = false;
        boolean row = false;
        boolean column = false;
        int i = 0;
        while (i < files.length) {
            if (files[i].getName().endsWith("ysis2")) {
                String tempString;
                reader = new BufferedReader(new FileReader(files[i]));
                while ((tempString = reader.readLine()) != null) {
                    String[] spl;
                    if (!lineDone && tempString.contains("States of the attractor")) {
                        lineDone = true;
                        spl = tempString.split("[ ]");
                        pw.print(String.valueOf(spl[spl.length - 1]) + "\t");
                        continue;
                    }
                    if (!lineDone || !tempString.startsWith("user")) continue;
                    lineDone = false;
                    spl = tempString.split("[\t]");
                    pw.print(String.valueOf(spl[1]) + "\t");
                }
                pw.println();
            }
            ++i;
        }
    }

    public void solveGenYsisDirectOutput_2(String inputFileFolder, String outputFileName) throws Exception {
        BufferedReader reader = null;
        File f = null;
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputFileName)), true);
        boolean lineDone = false;
        String[][] results = new String[32][2];
        Object name = null;
        boolean times1 = false;
        boolean row = false;
        boolean column = false;
        String time = "";
        int i = 0;
        while (i < files.length) {
            if (files[i].getName().endsWith("ysis2")) {
                String tempString;
                time = "timeout";
                reader = new BufferedReader(new FileReader(files[i]));
                while ((tempString = reader.readLine()) != null) {
                    String[] spl;
                    if (tempString.contains("-p 1 -f")) {
                        spl = tempString.split("[ ]");
                        pw.print(String.valueOf(spl[spl.length - 1]) + "\t" + time);
                        continue;
                    }
                    if (!tempString.contains("user")) continue;
                    spl = tempString.split("[u]");
                    time = spl[0];
                }
                pw.println();
            }
            ++i;
        }
    }

    public void combine(String inputfolder, String outputname, String key) throws IOException {
        BufferedReader reader = null;
        File f = null;
        f = new File(inputfolder);
        File[] files = f.listFiles();
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputname)), true);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                File[] innerfiles;
                File[] fileArray2 = innerfiles = file.listFiles();
                int n3 = innerfiles.length;
                int n4 = 0;
                while (n4 < n3) {
                    File innerfile = fileArray2[n4];
                    if (innerfile.getName().equals(key)) {
                        String src;
                        reader = new BufferedReader(new FileReader(innerfile));
                        while ((src = reader.readLine()) != null) {
                            pw.println(src);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        pw.close();
    }

    public void generateProperty(int size, String outputname) throws FileNotFoundException {
        BitVector bt = new BitVector(size);
        String firstline = null;
        String secondline = null;
        long max = (long)Math.pow(2.0, size);
        long i = 0L;
        while (i < max) {
            PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(String.valueOf(outputname) + "_" + i)), true);
            bt.putLongFromTo(i, 0, size - 1);
            firstline = "";
            secondline = "";
            int j = 0;
            while (j < size) {
                if (bt.get(j)) {
                    firstline = String.valueOf(firstline) + j + " ";
                } else {
                    secondline = String.valueOf(secondline) + j + " ";
                }
                ++j;
            }
            if (firstline.equals("")) {
                firstline = "-1";
            }
            if (secondline.equals("")) {
                secondline = "-1";
            }
            pw.println(firstline);
            pw.println(secondline);
            pw.close();
            ++i;
        }
    }

    public void solveIntial(String inputFileFolder, String outputname) throws IOException {
        long[][] result = new long[1024][1024];
        double[] dis = new double[1024];
        BufferedReader reader = null;
        File f = null;
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputname)), true);
        int index1 = 0;
        int index2 = 0;
        int i = 0;
        while (i < files.length) {
            String tempString;
            reader = new BufferedReader(new FileReader(files[i]));
            while ((tempString = reader.readLine()) != null) {
                String[] spl;
                if (tempString.startsWith("Finish loading PBN model.")) {
                    spl = tempString.split(" ");
                    spl = spl[6].split("_");
                    index1 = Integer.parseInt(spl[1]);
                    continue;
                }
                if (tempString.startsWith("initial state=")) {
                    spl = tempString.split("=");
                    index2 = Integer.parseInt(spl[1]);
                    continue;
                }
                if (tempString.startsWith("Avg. sample size")) {
                    spl = tempString.split("[\t ]");
                    result[index1][index2] = Long.parseLong(spl[3]);
                    continue;
                }
                if (!tempString.startsWith("Avg. point")) continue;
                spl = tempString.split("[\t ]");
                dis[index1] = Double.parseDouble(spl[2]);
            }
            ++i;
        }
        i = 0;
        while (i < 1024) {
            pw.print(String.valueOf(dis[i]) + "\t");
            ++i;
        }
        pw.println();
        i = 0;
        while (i < 1024) {
            int j = 0;
            while (j < 1024) {
                pw.print(String.valueOf(result[j][i]) + "\t");
                ++j;
            }
            pw.println();
            ++i;
        }
        pw.close();
    }

    public void solveIntial(String inputFileFolder, String outputname, int nodenumber) throws IOException {
        int num = (int)Math.pow(2.0, nodenumber);
        long[][] result = new long[num][num];
        double[] dis = new double[num];
        BufferedReader reader = null;
        File f = null;
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputname)), true);
        int index1 = 0;
        int index2 = 0;
        int i = 0;
        while (i < files.length) {
            String tempString;
            reader = new BufferedReader(new FileReader(files[i]));
            while ((tempString = reader.readLine()) != null) {
                String[] spl;
                if (tempString.startsWith("Finish loading PBN model.")) {
                    spl = tempString.split(" ");
                    spl = spl[6].split("_");
                    index1 = Integer.parseInt(spl[1]);
                    continue;
                }
                if (tempString.startsWith("initial state=")) {
                    spl = tempString.split("=");
                    index2 = Integer.parseInt(spl[1]);
                    continue;
                }
                if (tempString.startsWith("Avg. sample size")) {
                    spl = tempString.split("[\t ]");
                    result[index1][index2] = Long.parseLong(spl[3]);
                    continue;
                }
                if (!tempString.startsWith("Avg. point")) continue;
                spl = tempString.split("[\t ]");
                dis[index1] = Double.parseDouble(spl[2]);
            }
            ++i;
        }
        i = 0;
        while (i < num) {
            pw.print(String.valueOf(dis[i]) + "\t");
            ++i;
        }
        pw.println();
        i = 0;
        while (i < num) {
            int j = 0;
            while (j < num) {
                pw.print(String.valueOf(result[j][i]) + "\t");
                ++j;
            }
            pw.println();
            ++i;
        }
        pw.close();
    }

    public void solveGelman(String inputFileFolder, String outputname) throws NumberFormatException, IOException {
        BufferedReader reader = null;
        File f = null;
        f = new File(inputFileFolder);
        File[] files = f.listFiles();
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputname)), true);
        int i = 0;
        while (i < files.length) {
            String tempString;
            reader = new BufferedReader(new FileReader(files[i]));
            while ((tempString = reader.readLine()) != null) {
                if (!tempString.startsWith("The Gelman full")) continue;
                String[] spl = tempString.split(" ");
                pw.print(String.valueOf(spl[7]) + "\t" + spl[9] + "\t");
                tempString = reader.readLine();
                spl = tempString.split(" ");
                pw.println(String.valueOf(spl[2]) + "\t" + spl[3] + "\t" + spl[5] + "\t");
            }
            ++i;
        }
        pw.close();
    }

    public void generateProperty(String outputname, int nodeNumber) throws NumberFormatException, IOException {
        BitVector bv = new BitVector(nodeNumber);
        int i = 0;
        while ((double)i < Math.pow(2.0, nodeNumber)) {
            PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(String.valueOf(outputname) + "_" + nodeNumber + "_" + i)), true);
            bv.clear();
            bv.putLongFromTo((long)i, 0, nodeNumber - 1);
            String tempString = "";
            String tempString2 = "";
            int j = 0;
            while (j < nodeNumber) {
                if (bv.get(j)) {
                    tempString = String.valueOf(tempString) + j + " ";
                } else {
                    tempString2 = String.valueOf(tempString2) + j + " ";
                }
                ++j;
            }
            if (tempString == "" && tempString2 == "") {
                System.out.println("Error");
            }
            if (tempString == "") {
                tempString = "-1";
            }
            if (tempString2 == "") {
                tempString2 = "-1";
            }
            pw.println(tempString);
            pw.println(tempString2);
            pw.close();
            ++i;
        }
    }

    public void generatePara(String name, int num, int iterations) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(name)), true);
        int[] m = new int[]{5, 10, 15, 20, 30, 50, 100};
        int j = 0;
        while (j < m.length) {
            int i = 0;
            while ((double)i < Math.pow(2.0, num)) {
                pw.println("-tsge model/PBN_vegelman_" + num + ".txt 0.001 0.95 property/property_" + num + "_" + i + " " + iterations + " " + m[j]);
                ++i;
            }
            ++j;
        }
        pw.close();
    }

    public void generatePara2(String name, int iterations) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(name)), true);
        int[] m = new int[]{5, 10, 15, 20, 30, 50, 100};
        int k = 0;
        while (k < m.length) {
            int j = 5;
            while (j < 11) {
                int i = 0;
                while ((double)i < Math.pow(2.0, j)) {
                    pw.println("-venbs model/PBN_vegelman_" + j + ".txt property/property_" + j + "_" + i + " 0.001 " + iterations + " " + m[k]);
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        pw.close();
    }

    public static void main(String[] args) {
        try {
            new FileCoding().solveMultipleAttractor("result/apoptosis/initialRestricted/97_originalBNV7", "result/apoptosis/initialRestricted/97_originalBNV7/out.txt");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

