/*
 * Decompiled with CFR 0.152.
 */
package extra;

import extra.Simulate;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadLocalRandom;

public class TestParallel {
    public static void main(String[] args) {
        ForkJoinPool pool = new ForkJoinPool();
        int length = 400000;
        int size = 1;
        if (args != null && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-core")) {
                    size = Integer.parseInt(args[++i]);
                } else if (args[i].equals("-length")) {
                    length = Integer.parseInt(args[++i]);
                }
                ++i;
            }
        }
        Simulate parallelSimulate = new Simulate(0, --size, null, length);
        parallelSimulate.reinitialize();
        parallelSimulate.initial(length / (size + 1), size);
        long time = System.nanoTime();
        pool.invoke(parallelSimulate);
        System.out.println("Running " + (size + 1) + " cores, time: " + (double)(System.nanoTime() - time) / 1.0E9);
        parallelSimulate.reinitialize();
        parallelSimulate.initial(length / (size + 1), size);
        time = System.nanoTime();
        pool.invoke(parallelSimulate);
        System.out.println("Running " + (size + 1) + " cores, time: " + (double)(System.nanoTime() - time) / 1.0E9);
        parallelSimulate.reinitialize();
        parallelSimulate.initial(length / (size + 1), size);
        time = System.nanoTime();
        pool.invoke(parallelSimulate);
        System.out.println("Running " + (size + 1) + " cores, time: " + (double)(System.nanoTime() - time) / 1.0E9);
        TestParallel ts = new TestParallel();
        time = System.nanoTime();
        ts.sequential(length);
        System.out.println("Running sequential, time: " + (double)(System.nanoTime() - time) / 1.0E9);
    }

    public void sequential(int length) {
        double local = 0.0;
        int j = 0;
        while (j < 1000) {
            int i = 0;
            while (i < length) {
                local += ThreadLocalRandom.current().nextDouble();
                ++i;
            }
            ++j;
        }
    }
}

