/*
 * Decompiled with CFR 0.152.
 */
package jdd;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jdd.JDDNode;

public class DebugJDD {
    public static final boolean debugEnabled = false;
    protected static HashMap<Integer, StackTraceElement[]> stackTraces;
    protected static HashMap<Integer, Integer> localCounters;
    protected static HashMap<Long, List<Integer>> instances;

    static {
        try {
            System.loadLibrary("jdd");
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println(e);
            System.exit(1);
        }
    }

    private static native int DebugJDD_GetRefCount(long var0);

    protected static void addToSet(JDDNode node, int count) {
        long ptr;
        if (instances == null) {
            instances = new HashMap();
            localCounters = new HashMap();
            stackTraces = new HashMap();
        }
        int hc = System.identityHashCode(node);
        if (instances.containsKey(node.ptr())) {
            ptr = node.ptr();
            instances.get(ptr).add(hc);
        } else {
            ptr = node.ptr();
            LinkedList<Integer> al = new LinkedList<Integer>();
            al.add(hc);
            instances.put(ptr, al);
        }
        localCounters.put(hc, count);
        StackTraceElement[] st = Thread.currentThread().getStackTrace();
        int num = st.length - 2;
        StackTraceElement[] creator = new StackTraceElement[num];
        int i = 0;
        while (i < num) {
            creator[i] = st[i + 2];
            ++i;
        }
        stackTraces.put(hc, creator);
    }

    protected static void decrement(JDDNode node) {
        int hc = System.identityHashCode(node);
        int newValue = localCounters.get(hc) - 1;
        int cuddRefCount = DebugJDD.DebugJDD_GetRefCount(node.ptr());
        assert (cuddRefCount > 0);
        assert (cuddRefCount - 1 >= newValue);
        if (newValue < 0 && cuddRefCount == newValue) {
            System.out.println("Dereferencing node " + node + " too often. Printing stack trace where it was created.");
            int i = 0;
            StackTraceElement[] stackTraceElementArray = stackTraces.get(hc);
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement st = stackTraceElementArray[n2];
                if (i++ > 5) break;
                System.out.println("  " + st.toString());
                ++n2;
            }
            assert (false);
        }
        localCounters.put(hc, newValue);
    }

    protected static void increment(JDDNode node) {
        int hc = System.identityHashCode(node);
        int newValue = localCounters.get(hc) + 1;
        int cuddRefCount = DebugJDD.DebugJDD_GetRefCount(node.ptr());
        assert (cuddRefCount + 1 >= newValue);
        localCounters.put(hc, newValue);
    }

    public static void endLifeCycle() {
        Iterator<Long> itt = instances.keySet().iterator();
        while (itt.hasNext()) {
            Long ptr = itt.next();
            Iterator<Integer> it = instances.get(ptr).iterator();
            while (it.hasNext()) {
                int localRefCount = localCounters.get(it.next());
                if (localRefCount == 0) continue;
                it.remove();
            }
            if (!instances.get(ptr).isEmpty()) continue;
            itt.remove();
        }
        for (Long ptr : instances.keySet()) {
            int cuddRefCount = DebugJDD.DebugJDD_GetRefCount(ptr);
            if (cuddRefCount == 0) continue;
            boolean hasSuspicious = false;
            for (Integer hc : instances.get(ptr)) {
                int localRefCount = localCounters.get(hc);
                if (localRefCount <= 0) continue;
                hasSuspicious = true;
                break;
            }
            if (!hasSuspicious) continue;
            System.out.println("WARNING: there are nodes with nonzero references, printing debug info. Note that the stack traces below are from moments JDDNodes were created. The actual problem can be elsewhere where the node is used");
            System.out.println("Node " + new JDDNode(ptr, false) + " has " + cuddRefCount + " reference(s), printing out stack traces of suspicious node instances:");
            boolean first = true;
            block4: for (Integer hc : instances.get(ptr)) {
                int localRefCount = localCounters.get(hc);
                if (localRefCount == 0) continue;
                if (!first) {
                    System.out.println(" &");
                } else {
                    first = false;
                }
                int i = 0;
                StackTraceElement[] stackTraceElementArray = stackTraces.get(hc);
                int n = stackTraceElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement st = stackTraceElementArray[n2];
                    if (i++ > 8) continue block4;
                    System.out.println("  " + st.toString());
                    ++n2;
                }
            }
        }
    }

    public static int getRefCount(JDDNode n) {
        return DebugJDD.DebugJDD_GetRefCount(n.ptr());
    }
}

