/*
 * Decompiled with CFR 0.152.
 */
package jdd;

import java.util.List;
import jdd.JDDNode;
import jdd.JDDVars;
import jdd.JDDVectorConsumer;
import parser.Expression;

public class JDD {
    public static final int PLUS = 1;
    public static final int MINUS = 2;
    public static final int TIMES = 3;
    public static final int DIVIDE = 4;
    public static final int MIN = 5;
    public static final int MAX = 6;
    public static final int EQUALS = 7;
    public static final int NOTEQUALS = 8;
    public static final int GREATERTHAN = 9;
    public static final int GREATERTHANEQUALS = 10;
    public static final int LESSTHAN = 11;
    public static final int LESSTHANEQUALS = 12;
    public static final int FLOOR = 13;
    public static final int CEIL = 14;
    public static final int POW = 15;
    public static final int MOD = 16;
    public static final int LOGXY = 17;
    public static final int ZERO_ONE = 1;
    public static final int LOW = 2;
    public static final int NORMAL = 3;
    public static final int HIGH = 4;
    public static final int LIST = 5;
    public static final int CMU = 1;
    public static final int BOULDER = 2;
    public static JDDNode ZERO;
    public static JDDNode ONE;
    public static JDDNode PLUS_INFINITY;
    public static JDDNode MINUS_INFINITY;
    public static boolean CUDDInitialised;

    static {
        try {
            System.loadLibrary("jdd");
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println(e);
            System.exit(1);
        }
        CUDDInitialised = false;
    }

    public static native long GetCUDDManager();

    private static native void DD_SetOutputStream(long var0);

    private static native long DD_GetOutputStream();

    private static native void DD_InitialiseCUDD();

    private static native void DD_InitialiseCUDD(long var0, double var2);

    private static native void DD_SetCUDDMaxMem(long var0);

    private static native void DD_SetCUDDEpsilon(double var0);

    private static native void DD_CloseDownCUDD(boolean var0);

    private static native void DD_Ref(long var0);

    private static native void DD_Deref(long var0);

    private static native void DD_PrintCacheInfo();

    private static native long DD_Create();

    private static native long DD_Constant(double var0);

    private static native long DD_PlusInfinity();

    private static native long DD_MinusInfinity();

    private static native long DD_Var(int var0);

    private static native long DD_Not(long var0);

    private static native long DD_Or(long var0, long var2);

    private static native long DD_And(long var0, long var2);

    private static native long DD_Xor(long var0, long var2);

    private static native long DD_Implies(long var0, long var2);

    private static native long DD_Apply(int var0, long var1, long var3);

    private static native long DD_MonadicApply(int var0, long var1);

    private static native long DD_Restrict(long var0, long var2);

    private static native long DD_ITE(long var0, long var2, long var4);

    private static native long DD_PermuteVariables(long var0, long var2, long var4, int var6);

    private static native long DD_SwapVariables(long var0, long var2, long var4, int var6);

    private static native long DD_VariablesGreaterThan(long var0, long var2, int var4);

    private static native long DD_VariablesGreaterThanEquals(long var0, long var2, int var4);

    private static native long DD_VariablesLessThan(long var0, long var2, int var4);

    private static native long DD_VariablesLessThanEquals(long var0, long var2, int var4);

    private static native long DD_VariablesEquals(long var0, long var2, int var4);

    private static native long DD_ThereExists(long var0, long var2, int var4);

    private static native long DD_ForAll(long var0, long var2, int var4);

    private static native long DD_SumAbstract(long var0, long var2, int var4);

    private static native long DD_ProductAbstract(long var0, long var2, int var4);

    private static native long DD_MinAbstract(long var0, long var2, int var4);

    private static native long DD_MaxAbstract(long var0, long var2, int var4);

    private static native long DD_GreaterThan(long var0, double var2);

    private static native long DD_GreaterThanEquals(long var0, double var2);

    private static native long DD_LessThan(long var0, double var2);

    private static native long DD_LessThanEquals(long var0, double var2);

    private static native long DD_Equals(long var0, double var2);

    private static native long DD_Interval(long var0, double var2, double var4);

    private static native long DD_RoundOff(long var0, int var2);

    private static native boolean DD_EqualSupNorm(long var0, long var2, double var4);

    private static native double DD_FindMin(long var0);

    private static native double DD_FindMax(long var0);

    private static native long DD_RestrictToFirst(long var0, long var2, int var4);

    private static native int DD_GetNumNodes(long var0);

    private static native int DD_GetNumTerminals(long var0);

    private static native double DD_GetNumMinterms(long var0, int var2);

    private static native double DD_GetNumPaths(long var0);

    private static native void DD_PrintInfo(long var0, int var2);

    private static native void DD_PrintInfoBrief(long var0, int var2);

    private static native void DD_PrintSupport(long var0);

    private static native void DD_PrintSupportNames(long var0, List<String> var2);

    private static native long DD_GetSupport(long var0);

    private static native void DD_PrintTerminals(long var0);

    private static native void DD_PrintTerminalsAndNumbers(long var0, int var2);

    private static native long DD_SetVectorElement(long var0, long var2, int var4, long var5, double var7);

    private static native long DD_SetMatrixElement(long var0, long var2, int var4, long var5, int var7, long var8, long var10, double var12);

    private static native long DD_Set3DMatrixElement(long var0, long var2, int var4, long var5, int var7, long var8, int var10, long var11, long var13, long var15, double var17);

    private static native double DD_GetVectorElement(long var0, long var2, int var4, long var5);

    private static native long DD_Identity(long var0, long var2, int var4);

    private static native long DD_Transpose(long var0, long var2, long var4, int var6);

    private static native long DD_MatrixMultiply(long var0, long var2, long var4, int var6, int var7);

    private static native void DD_PrintVector(long var0, long var2, int var4, int var5);

    private static native void DD_PrintMatrix(long var0, long var2, int var4, long var5, int var7, int var8);

    private static native void DD_PrintVectorFiltered(long var0, long var2, long var4, int var6, int var7);

    private static native void DD_ExportDDToDotFile(long var0, String var2);

    private static native void DD_ExportDDToDotFileLabelled(long var0, String var2, List<String> var3);

    private static native void DD_ExportMatrixToPPFile(long var0, long var2, int var4, long var5, int var7, String var8);

    private static native void DD_Export3dMatrixToPPFile(long var0, long var2, int var4, long var5, int var7, long var8, int var10, String var11);

    private static native void DD_ExportMatrixToMatlabFile(long var0, long var2, int var4, long var5, int var7, String var8, String var9);

    private static native void DD_ExportMatrixToSpyFile(long var0, long var2, int var4, long var5, int var7, int var8, String var9);

    private static native void DD_ReduceHeap(int var0, int var1);

    public static void SetOutputStream(long fp) {
        JDD.DD_SetOutputStream(fp);
    }

    public static long GetOutputStream() {
        return JDD.DD_GetOutputStream();
    }

    public static void InitialiseCUDD() {
        if (!CUDDInitialised) {
            JDD.DD_InitialiseCUDD();
            ZERO = JDD.Constant(0.0);
            ONE = JDD.Constant(1.0);
            PLUS_INFINITY = JDD.PlusInfinity();
            MINUS_INFINITY = JDD.MinusInfinity();
            CUDDInitialised = true;
        }
    }

    public static void InitialiseCUDD(long max_mem, double epsilon) {
        if (!CUDDInitialised) {
            JDD.DD_InitialiseCUDD(max_mem, epsilon);
            ZERO = JDD.Constant(0.0);
            ONE = JDD.Constant(1.0);
            PLUS_INFINITY = JDD.PlusInfinity();
            MINUS_INFINITY = JDD.MinusInfinity();
            CUDDInitialised = true;
        }
    }

    public static void SetCUDDMaxMem(long max_mem) {
        JDD.DD_SetCUDDMaxMem(max_mem);
    }

    public static void SetCUDDEpsilon(double epsilon) {
        JDD.DD_SetCUDDEpsilon(epsilon);
    }

    public static void CloseDownCUDD() {
        JDD.CloseDownCUDD(true);
    }

    public static void CloseDownCUDD(boolean check) {
        JDD.Deref(ZERO);
        JDD.Deref(ONE);
        JDD.Deref(PLUS_INFINITY);
        JDD.Deref(MINUS_INFINITY);
        JDD.DD_CloseDownCUDD(check);
        CUDDInitialised = false;
    }

    public static void Ref(JDDNode dd) {
        JDD.DD_Ref(dd.ptr());
    }

    public static void Deref(JDDNode dd) {
        JDD.DD_Deref(dd.ptr());
    }

    public static void PrintCacheInfo() {
        JDD.DD_PrintCacheInfo();
    }

    public static JDDNode Create() {
        return new JDDNode(JDD.DD_Create());
    }

    public static JDDNode Constant(double value) {
        if (Double.isInfinite(value)) {
            return value > 0.0 ? JDD.PlusInfinity() : JDD.MinusInfinity();
        }
        return new JDDNode(JDD.DD_Constant(value));
    }

    public static JDDNode PlusInfinity() {
        return new JDDNode(JDD.DD_PlusInfinity());
    }

    public static JDDNode MinusInfinity() {
        return new JDDNode(JDD.DD_MinusInfinity());
    }

    public static JDDNode Var(int i) {
        return new JDDNode(JDD.DD_Var(i));
    }

    public static JDDNode Not(JDDNode dd) {
        return new JDDNode(JDD.DD_Not(dd.ptr()));
    }

    public static JDDNode Or(JDDNode dd1, JDDNode dd2) {
        return new JDDNode(JDD.DD_Or(dd1.ptr(), dd2.ptr()));
    }

    public static JDDNode And(JDDNode dd1, JDDNode dd2) {
        return new JDDNode(JDD.DD_And(dd1.ptr(), dd2.ptr()));
    }

    public static JDDNode Xor(JDDNode dd1, JDDNode dd2) {
        return new JDDNode(JDD.DD_Xor(dd1.ptr(), dd2.ptr()));
    }

    public static JDDNode Implies(JDDNode dd1, JDDNode dd2) {
        return new JDDNode(JDD.DD_Implies(dd1.ptr(), dd2.ptr()));
    }

    public static JDDNode Apply(int op, JDDNode dd1, JDDNode dd2) {
        return new JDDNode(JDD.DD_Apply(op, dd1.ptr(), dd2.ptr()));
    }

    public static JDDNode MonadicApply(int op, JDDNode dd) {
        return new JDDNode(JDD.DD_MonadicApply(op, dd.ptr()));
    }

    public static JDDNode Restrict(JDDNode dd, JDDNode cube) {
        return new JDDNode(JDD.DD_Restrict(dd.ptr(), cube.ptr()));
    }

    public static JDDNode ITE(JDDNode dd1, JDDNode dd2, JDDNode dd3) {
        return new JDDNode(JDD.DD_ITE(dd1.ptr(), dd2.ptr(), dd3.ptr()));
    }

    public static boolean AreInterecting(JDDNode dd1, JDDNode dd2) {
        JDD.Ref(dd1);
        JDD.Ref(dd2);
        JDDNode tmp = JDD.And(dd1, dd2);
        boolean res = !tmp.equals(ZERO);
        JDD.Deref(tmp);
        return res;
    }

    public static boolean IsContainedIn(JDDNode dd1, JDDNode dd2) {
        JDD.Ref(dd1);
        JDD.Ref(dd2);
        JDDNode tmp = JDD.And(dd1, dd2);
        boolean res = tmp.equals(dd1);
        JDD.Deref(tmp);
        return res;
    }

    public static JDDNode PermuteVariables(JDDNode dd, JDDVars old_vars, JDDVars new_vars) {
        return new JDDNode(JDD.DD_PermuteVariables(dd.ptr(), old_vars.array(), new_vars.array(), old_vars.n()));
    }

    public static JDDNode SwapVariables(JDDNode dd, JDDVars old_vars, JDDVars new_vars) {
        return new JDDNode(JDD.DD_SwapVariables(dd.ptr(), old_vars.array(), new_vars.array(), old_vars.n()));
    }

    public static JDDNode VariablesGreaterThan(JDDVars x_vars, JDDVars y_vars) {
        return new JDDNode(JDD.DD_VariablesGreaterThan(x_vars.array(), y_vars.array(), x_vars.n()));
    }

    public static JDDNode VariablesGreaterThanEquals(JDDVars x_vars, JDDVars y_vars) {
        return new JDDNode(JDD.DD_VariablesGreaterThanEquals(x_vars.array(), y_vars.array(), x_vars.n()));
    }

    public static JDDNode VariablesLessThan(JDDVars x_vars, JDDVars y_vars) {
        return new JDDNode(JDD.DD_VariablesLessThan(x_vars.array(), y_vars.array(), x_vars.n()));
    }

    public static JDDNode VariablesLessThanEquals(JDDVars x_vars, JDDVars y_vars) {
        return new JDDNode(JDD.DD_VariablesLessThanEquals(x_vars.array(), y_vars.array(), x_vars.n()));
    }

    public static JDDNode VariablesEquals(JDDVars x_vars, JDDVars y_vars) {
        return new JDDNode(JDD.DD_VariablesEquals(x_vars.array(), y_vars.array(), x_vars.n()));
    }

    public static JDDNode ThereExists(JDDNode dd, JDDVars vars) {
        return new JDDNode(JDD.DD_ThereExists(dd.ptr(), vars.array(), vars.n()));
    }

    public static JDDNode ForAll(JDDNode dd, JDDVars vars) {
        return new JDDNode(JDD.DD_ForAll(dd.ptr(), vars.array(), vars.n()));
    }

    public static JDDNode SumAbstract(JDDNode dd, JDDVars vars) {
        return new JDDNode(JDD.DD_SumAbstract(dd.ptr(), vars.array(), vars.n()));
    }

    public static JDDNode ProductAbstract(JDDNode dd, JDDVars vars) {
        return new JDDNode(JDD.DD_ProductAbstract(dd.ptr(), vars.array(), vars.n()));
    }

    public static JDDNode MinAbstract(JDDNode dd, JDDVars vars) {
        return new JDDNode(JDD.DD_MinAbstract(dd.ptr(), vars.array(), vars.n()));
    }

    public static JDDNode MaxAbstract(JDDNode dd, JDDVars vars) {
        return new JDDNode(JDD.DD_MaxAbstract(dd.ptr(), vars.array(), vars.n()));
    }

    public static JDDNode GreaterThan(JDDNode dd, double threshold) {
        return new JDDNode(JDD.DD_GreaterThan(dd.ptr(), threshold));
    }

    public static JDDNode GreaterThanEquals(JDDNode dd, double threshold) {
        return new JDDNode(JDD.DD_GreaterThanEquals(dd.ptr(), threshold));
    }

    public static JDDNode LessThan(JDDNode dd, double threshold) {
        return new JDDNode(JDD.DD_LessThan(dd.ptr(), threshold));
    }

    public static JDDNode LessThanEquals(JDDNode dd, double threshold) {
        return new JDDNode(JDD.DD_LessThanEquals(dd.ptr(), threshold));
    }

    public static JDDNode Equals(JDDNode dd, double value) {
        return new JDDNode(JDD.DD_Equals(dd.ptr(), value));
    }

    public static JDDNode Interval(JDDNode dd, double lower, double upper) {
        return new JDDNode(JDD.DD_Interval(dd.ptr(), lower, upper));
    }

    public static JDDNode RoundOff(JDDNode dd, int places) {
        return new JDDNode(JDD.DD_RoundOff(dd.ptr(), places));
    }

    public static boolean EqualSupNorm(JDDNode dd1, JDDNode dd2, double epsilon) {
        return JDD.DD_EqualSupNorm(dd1.ptr(), dd2.ptr(), epsilon);
    }

    public static double FindMin(JDDNode dd) {
        return JDD.DD_FindMin(dd.ptr());
    }

    public static double FindMax(JDDNode dd) {
        return JDD.DD_FindMax(dd.ptr());
    }

    public static JDDNode RestrictToFirst(JDDNode dd, JDDVars vars) {
        return new JDDNode(JDD.DD_RestrictToFirst(dd.ptr(), vars.array(), vars.n()));
    }

    public static int GetNumNodes(JDDNode dd) {
        return JDD.DD_GetNumNodes(dd.ptr());
    }

    public static int GetNumTerminals(JDDNode dd) {
        return JDD.DD_GetNumTerminals(dd.ptr());
    }

    public static double GetNumMinterms(JDDNode dd, int num_vars) {
        return JDD.DD_GetNumMinterms(dd.ptr(), num_vars);
    }

    public static String GetNumMintermsString(JDDNode dd, int num_vars) {
        double minterms = JDD.GetNumMinterms(dd, num_vars);
        if (minterms <= 9.223372036854776E18) {
            return "" + (long)minterms;
        }
        return "" + minterms;
    }

    public static double GetNumPaths(JDDNode dd) {
        return JDD.DD_GetNumPaths(dd.ptr());
    }

    public static String GetNumPathsString(JDDNode dd) {
        double paths = JDD.GetNumPaths(dd);
        if (paths <= 9.223372036854776E18) {
            return "" + (long)paths;
        }
        return "" + paths;
    }

    public static void PrintInfo(JDDNode dd, int num_vars) {
        JDD.DD_PrintInfo(dd.ptr(), num_vars);
    }

    public static void PrintInfoBrief(JDDNode dd, int num_vars) {
        JDD.DD_PrintInfoBrief(dd.ptr(), num_vars);
    }

    public static String GetInfoString(JDDNode dd, int num_vars) {
        return String.valueOf(JDD.GetNumNodes(dd)) + " nodes (" + JDD.GetNumTerminals(dd) + " terminal), " + JDD.GetNumMintermsString(dd, num_vars) + " minterms";
    }

    public static String GetInfoBriefString(JDDNode dd, int num_vars) {
        return "[" + JDD.GetNumNodes(dd) + "," + JDD.GetNumTerminals(dd) + "," + JDD.GetNumMintermsString(dd, num_vars) + "]";
    }

    public static void PrintSupport(JDDNode dd) {
        JDD.DD_PrintSupport(dd.ptr());
    }

    public static void PrintSupportNames(JDDNode dd, List<String> varNames) {
        JDD.DD_PrintSupportNames(dd.ptr(), varNames);
    }

    public static JDDNode GetSupport(JDDNode dd) {
        return new JDDNode(JDD.DD_GetSupport(dd.ptr()));
    }

    public static void PrintTerminals(JDDNode dd) {
        JDD.DD_PrintTerminals(dd.ptr());
    }

    public static String GetTerminalsString(JDDNode dd) {
        return JDD.GetTerminalsString(dd, 0, false);
    }

    public static void PrintTerminalsAndNumbers(JDDNode dd, int num_vars) {
        JDD.DD_PrintTerminalsAndNumbers(dd.ptr(), num_vars);
    }

    public static String GetTerminalsAndNumbersString(JDDNode dd, int num_vars) {
        return JDD.GetTerminalsString(dd, num_vars, true);
    }

    public static String GetTerminalsString(JDDNode dd, int num_vars, boolean and_numbers) {
        double count = 0.0;
        String s = "";
        JDD.Ref(dd);
        JDDNode tmp = dd;
        double min = JDD.FindMin(tmp);
        while (!tmp.equals(MINUS_INFINITY)) {
            double max = JDD.FindMax(tmp);
            s = String.valueOf(s) + max + " ";
            JDD.Ref(tmp);
            JDDNode tmp2 = JDD.Equals(tmp, max);
            if (and_numbers) {
                double num = JDD.GetNumMinterms(tmp2, num_vars);
                count += num;
                s = String.valueOf(s) + "(" + (long)num + ") ";
            }
            tmp = JDD.ITE(tmp2, JDD.MinusInfinity(), tmp);
        }
        JDD.Deref(tmp);
        if (and_numbers) {
            if (count < (double)(1 << num_vars)) {
                s = String.valueOf(s) + "-inf (" + ((double)(1 << num_vars) - count) + ")";
            }
        } else if (min == Double.NEGATIVE_INFINITY) {
            s = String.valueOf(s) + "-inf";
        }
        return s;
    }

    public static JDDNode SetVectorElement(JDDNode dd, JDDVars vars, long index, double value) {
        return new JDDNode(JDD.DD_SetVectorElement(dd.ptr(), vars.array(), vars.n(), index, value));
    }

    public static JDDNode SetMatrixElement(JDDNode dd, JDDVars rvars, JDDVars cvars, long rindex, long cindex, double value) {
        return new JDDNode(JDD.DD_SetMatrixElement(dd.ptr(), rvars.array(), rvars.n(), cvars.array(), cvars.n(), rindex, cindex, value));
    }

    public static JDDNode Set3DMatrixElement(JDDNode dd, JDDVars rvars, JDDVars cvars, JDDVars lvars, long rindex, long cindex, long lindex, double value) {
        return new JDDNode(JDD.DD_Set3DMatrixElement(dd.ptr(), rvars.array(), rvars.n(), cvars.array(), cvars.n(), lvars.array(), lvars.n(), rindex, cindex, lindex, value));
    }

    public static double GetVectorElement(JDDNode dd, JDDVars vars, long index) {
        return JDD.DD_GetVectorElement(dd.ptr(), vars.array(), vars.n(), index);
    }

    public static JDDNode Identity(JDDVars rvars, JDDVars cvars) {
        return new JDDNode(JDD.DD_Identity(rvars.array(), cvars.array(), rvars.n()));
    }

    public static JDDNode Transpose(JDDNode dd, JDDVars rvars, JDDVars cvars) {
        return new JDDNode(JDD.DD_Transpose(dd.ptr(), rvars.array(), cvars.array(), rvars.n()));
    }

    public static JDDNode MatrixMultiply(JDDNode dd1, JDDNode dd2, JDDVars vars, int method) {
        return new JDDNode(JDD.DD_MatrixMultiply(dd1.ptr(), dd2.ptr(), vars.array(), vars.n(), method));
    }

    public static void PrintVector(JDDNode dd, JDDVars vars) {
        JDD.DD_PrintVector(dd.ptr(), vars.array(), vars.n(), 3);
    }

    public static void PrintVector(JDDNode dd, JDDVars vars, int accuracy) {
        JDD.DD_PrintVector(dd.ptr(), vars.array(), vars.n(), accuracy);
    }

    public static void PrintMatrix(JDDNode dd, JDDVars rvars, JDDVars cvars) {
        JDD.DD_PrintMatrix(dd.ptr(), rvars.array(), rvars.n(), cvars.array(), cvars.n(), 3);
    }

    public static void PrintMatrix(JDDNode dd, JDDVars rvars, JDDVars cvars, int accuracy) {
        JDD.DD_PrintMatrix(dd.ptr(), rvars.array(), rvars.n(), cvars.array(), cvars.n(), accuracy);
    }

    public static void PrintVectorFiltered(JDDNode dd, JDDNode filter, JDDVars vars) {
        JDD.DD_PrintVectorFiltered(dd.ptr(), filter.ptr(), vars.array(), vars.n(), 3);
    }

    public static void PrintVectorFiltered(JDDNode dd, JDDNode filter, JDDVars vars, int accuracy) {
        JDD.DD_PrintVectorFiltered(dd.ptr(), filter.ptr(), vars.array(), vars.n(), accuracy);
    }

    public static void TraverseVector(JDDNode dd, JDDVars vars, JDDVectorConsumer vc, int code) {
        JDD.TraverseVectorRec(dd, vars, 0, 0L, vc, code);
    }

    private static void TraverseVectorRec(JDDNode dd, JDDVars vars, int varStart, long count, JDDVectorConsumer vc, int code) {
        if (dd.equals(ZERO)) {
            return;
        }
        if (varStart == vars.getNumVars()) {
            vc.setElement(count, dd.getValue(), code);
        } else {
            JDD.Ref(dd);
            JDD.Ref(vars.getVar(varStart));
            JDDNode n = JDD.Restrict(dd, JDD.Not(vars.getVar(varStart)));
            JDD.Ref(dd);
            JDD.Ref(vars.getVar(varStart));
            JDDNode s = JDD.Restrict(dd, vars.getVar(varStart));
            JDD.TraverseVectorRec(n, vars, varStart + 1, count, vc, code);
            JDD.TraverseVectorRec(s, vars, varStart + 1, count + (1L << vars.getNumVars() - varStart - 1), vc, code);
            JDD.Deref(n);
            JDD.Deref(s);
        }
    }

    public static void ExportDDToDotFile(JDDNode dd, String filename) {
        JDD.DD_ExportDDToDotFile(dd.ptr(), filename);
    }

    public static void ExportDDToDotFileLabelled(JDDNode dd, String filename, List<String> varNames) {
        JDD.DD_ExportDDToDotFileLabelled(dd.ptr(), filename, varNames);
    }

    public static void ExportMatrixToPPFile(JDDNode dd, JDDVars rvars, JDDVars cvars, String filename) {
        JDD.DD_ExportMatrixToPPFile(dd.ptr(), rvars.array(), rvars.n(), cvars.array(), cvars.n(), filename);
    }

    public static void Export3dMatrixToPPFile(JDDNode dd, JDDVars rvars, JDDVars cvars, JDDVars nvars, String filename) {
        JDD.DD_Export3dMatrixToPPFile(dd.ptr(), rvars.array(), rvars.n(), cvars.array(), cvars.n(), nvars.array(), nvars.n(), filename);
    }

    public static void ExportMatrixToMatlabFile(JDDNode dd, JDDVars rvars, JDDVars cvars, String name, String filename) {
        JDD.DD_ExportMatrixToMatlabFile(dd.ptr(), rvars.array(), rvars.n(), cvars.array(), cvars.n(), name, filename);
    }

    public static void ExportMatrixToSpyFile(JDDNode dd, JDDVars rvars, JDDVars cvars, int depth, String filename) {
        JDD.DD_ExportMatrixToSpyFile(dd.ptr(), rvars.array(), rvars.n(), cvars.array(), cvars.n(), depth, filename);
    }

    public static JDDNode DD_CreateFromExpression(Expression exp) {
        JDDNode res = null;
        block0 : switch (exp.getType()) {
            case 0: {
                res = JDD.Var(exp.getID());
                break;
            }
            case 1: {
                Expression child = exp.getLeftChild();
                res = JDD.DD_CreateFromExpression(child);
                res = JDD.Not(res);
                break;
            }
            case 2: {
                Expression child = exp.getLeftChild();
                res = JDD.DD_CreateFromExpression(child);
                break;
            }
            case 3: {
                JDDNode dd1 = JDD.DD_CreateFromExpression(exp.getLeftChild());
                JDDNode dd2 = JDD.DD_CreateFromExpression(exp.getRightChild());
                switch (exp.getOperator()) {
                    case 1: {
                        res = JDD.And(dd1, dd2);
                        break block0;
                    }
                    case 2: {
                        res = JDD.Or(dd1, dd2);
                        break block0;
                    }
                    case 3: {
                        res = JDD.Xor(dd1, dd2);
                    }
                }
            }
        }
        return res;
    }

    public static void ReduceHeap(int reorderType, int min) {
        JDD.DD_ReduceHeap(reorderType, min);
    }
}

