/*
 * Decompiled with CFR 0.152.
 */
package jdd;

import jdd.DebugJDD;

public class JDDNode {
    private long ptr;

    static {
        try {
            System.loadLibrary("jdd");
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println(e);
            System.exit(1);
        }
    }

    private native boolean DDN_IsConstant(long var1);

    private native int DDN_GetIndex(long var1);

    private native double DDN_GetValue(long var1);

    private native long DDN_GetThen(long var1);

    private native long DDN_GetElse(long var1);

    public JDDNode(long p, boolean increased_reference) {
        this.ptr = p;
    }

    public JDDNode(long p) {
        this(p, true);
    }

    public JDDNode(JDDNode dd) {
        this(dd.ptr());
    }

    public long ptr() {
        return this.ptr;
    }

    public boolean isConstant() {
        return this.DDN_IsConstant(this.ptr);
    }

    public int getIndex() {
        return this.DDN_GetIndex(this.ptr);
    }

    public double getValue() {
        return this.DDN_GetValue(this.ptr);
    }

    public JDDNode getThen() {
        assert (!this.isConstant());
        return new JDDNode(this.DDN_GetThen(this.ptr), false);
    }

    public JDDNode getElse() {
        assert (!this.isConstant());
        return new JDDNode(this.DDN_GetElse(this.ptr), false);
    }

    public boolean equals(Object o) {
        return o instanceof JDDNode && ((JDDNode)o).ptr == this.ptr;
    }

    public int hashCode() {
        return (int)this.ptr;
    }

    public String toString() {
        String result = "" + this.ptr;
        if (this.ptr != 0L) {
            if (this.isConstant()) {
                result = String.valueOf(result) + " value=" + this.getValue();
            }
            result = String.valueOf(result) + " references=" + DebugJDD.getRefCount(this);
        }
        return result;
    }
}

