/*
 * Decompiled with CFR 0.152.
 */
package jdd;

import functionLib.AssaException;
import jdd.DebugJDD;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import parser.Error;
import parser.Expression;
import parser.Model;
import userInterface.AssaConsoleLog;

public class JDDTest {
    public static void main(String[] args) {
        JDDNode a = null;
        JDDNode b = null;
        JDDNode c = null;
        JDDNode cube = null;
        JDDNode d = null;
        JDDNode e = null;
        System.out.println("\nTest program for JDD\n====================");
        JDD.InitialiseCUDD();
        JDDVars vars = new JDDVars();
        AssaConsoleLog assalog = new AssaConsoleLog();
        Model m = new Model(assalog);
        try {
            m.loadModel("model/highLevel.pbn");
        }
        catch (AssaException | Error ee) {
            ee.printStackTrace();
        }
        for (Expression ee : m.getFunctions()) {
            vars.addVar(JDD.DD_CreateFromExpression(ee));
        }
        int i = 0;
        while (i < vars.getNumVars()) {
            b = JDD.Var(0);
            c = JDD.Var(1);
            System.out.println("b=" + DebugJDD.getRefCount(b) + ", c=" + DebugJDD.getRefCount(c));
            d = JDD.Not(b);
            System.out.println("b=" + DebugJDD.getRefCount(b) + ", c=" + DebugJDD.getRefCount(c) + ", d=" + DebugJDD.getRefCount(d));
            e = JDD.And(d, c);
            System.out.println("e=" + DebugJDD.getRefCount(e) + ", d=" + DebugJDD.getRefCount(d) + ", c=" + DebugJDD.getRefCount(c));
            b = JDD.Var(2);
            System.out.println("b=" + DebugJDD.getRefCount(b));
            cube = JDD.And(e, b);
            System.out.println("e=" + DebugJDD.getRefCount(e) + ", b=" + DebugJDD.getRefCount(b) + ", cube=" + DebugJDD.getRefCount(cube) + ", c=" + DebugJDD.getRefCount(c));
            a = vars.getVar(i);
            JDD.Ref(a);
            System.out.println("a=" + DebugJDD.getRefCount(a));
            System.out.println("Number nodes=" + JDD.GetNumNodes(a) + ", Number terminals=" + JDD.GetNumTerminals(a) + ", Number path=" + JDD.GetNumPaths(a));
            JDD.ExportDDToDotFile(a, "Num_" + i + ".dot");
            b = JDD.Restrict(a, cube);
            System.out.println("b=" + DebugJDD.getRefCount(b) + ", a=" + DebugJDD.getRefCount(a) + ", cube=" + DebugJDD.getRefCount(cube));
            System.out.println(String.valueOf(b.isConstant()) + " " + b.getValue());
            JDD.Deref(b);
            System.out.println("b=" + DebugJDD.getRefCount(b) + ", a=" + DebugJDD.getRefCount(a) + ", cube=" + DebugJDD.getRefCount(cube));
            ++i;
        }
        m.close();
        vars.derefAll();
        System.out.println("a=" + DebugJDD.getRefCount(a) + ", b=" + DebugJDD.getRefCount(b) + "c=" + DebugJDD.getRefCount(c) + "cube=" + DebugJDD.getRefCount(cube));
        JDD.CloseDownCUDD();
        System.out.println();
    }
}

