/*
 * Decompiled with CFR 0.152.
 */
package jdd;

import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;

public class JDDVars {
    private Vector vars = new Vector();
    private long array = 0L;
    private boolean arrayBuilt = false;

    static {
        try {
            System.loadLibrary("jdd");
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println(e);
            System.exit(1);
        }
    }

    private native long DDV_BuildArray();

    private native void DDV_FreeArray(long var1);

    private native int DDV_GetIndex(long var1);

    public void addVar(JDDNode var) {
        this.vars.addElement(var);
        if (this.arrayBuilt) {
            this.DDV_FreeArray(this.array);
        }
        this.arrayBuilt = false;
    }

    public void addVars(JDDVars ddv) {
        this.vars.addAll(ddv.vars);
        if (this.arrayBuilt) {
            this.DDV_FreeArray(this.array);
        }
        this.arrayBuilt = false;
    }

    public void removeVars(JDDVars ddv) {
        this.vars.removeAll(ddv.vars);
        if (this.arrayBuilt) {
            this.DDV_FreeArray(this.array);
        }
        this.arrayBuilt = false;
    }

    public int getNumVars() {
        return this.vars.size();
    }

    public JDDNode getVar(int i) {
        return (JDDNode)this.vars.elementAt(i);
    }

    public long getVarPtr(int i) {
        return ((JDDNode)this.vars.elementAt(i)).ptr();
    }

    public int getVarIndex(int i) {
        return this.DDV_GetIndex(((JDDNode)this.vars.elementAt(i)).ptr());
    }

    public int getMinVarIndex() {
        int n = this.vars.size();
        if (n == 0) {
            return -1;
        }
        int min = this.getVarIndex(0);
        int i = 1;
        while (i < n) {
            int j = this.getVarIndex(i);
            if (j < min) {
                min = j;
            }
            ++i;
        }
        return min;
    }

    public int getMaxVarIndex() {
        int n = this.vars.size();
        if (n == 0) {
            return -1;
        }
        int max = this.getVarIndex(0);
        int i = 1;
        while (i < n) {
            int j = this.getVarIndex(i);
            if (j > max) {
                max = j;
            }
            ++i;
        }
        return max;
    }

    public void refAll() {
        int i = 0;
        while (i < this.vars.size()) {
            JDD.Ref((JDDNode)this.vars.elementAt(i));
            ++i;
        }
    }

    public void derefAll() {
        int i = 0;
        while (i < this.vars.size()) {
            JDD.Deref((JDDNode)this.vars.elementAt(i));
            ++i;
        }
    }

    public long array() {
        if (this.arrayBuilt) {
            return this.array;
        }
        this.array = this.DDV_BuildArray();
        this.arrayBuilt = true;
        return this.array;
    }

    public int n() {
        return this.vars.size();
    }

    public String toString() {
        String s = "{";
        int i = 0;
        while (i < this.vars.size() - 1) {
            s = String.valueOf(s) + this.getVarIndex(i) + ", ";
            ++i;
        }
        if (this.vars.size() > 0) {
            s = String.valueOf(s) + this.getVarIndex(this.vars.size() - 1);
        }
        s = String.valueOf(s) + "}";
        return s;
    }
}

