/*
 * Decompiled with CFR 0.152.
 */
package parallel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RecursiveAction;
import parameterEstimation.particleSwarm.Particle;
import parameterEstimation.particleSwarm.estiPBN.PBNFitnessFunction;

public class EvaluateParticle
extends RecursiveAction {
    PBNFitnessFunction[] fitnessFunction;
    Particle[] particles;
    double[] fits;
    protected List<Double>[][] fittedData;
    int minIndex;
    int maxIndex;
    int numberParticlesPerCore;

    public EvaluateParticle(PBNFitnessFunction[] fitnessFunction, Particle[] particles, double[] fits, List<Double>[][] fittedData, int minIndex, int maxIndex, int numberParticlesPerCore) {
        this.fitnessFunction = fitnessFunction;
        this.particles = particles;
        this.fits = fits;
        this.fittedData = fittedData;
        this.minIndex = minIndex;
        this.maxIndex = maxIndex;
        this.numberParticlesPerCore = numberParticlesPerCore;
    }

    @Override
    protected void compute() {
        if (this.maxIndex - this.minIndex >= this.numberParticlesPerCore) {
            this.maxIndex -= this.numberParticlesPerCore;
            EvaluateParticle.invokeAll(new EvaluateParticle(this.fitnessFunction, this.particles, this.fits, this.fittedData, this.minIndex, this.maxIndex, this.numberParticlesPerCore), new EvaluateParticle(this.fitnessFunction, this.particles, this.fits, this.fittedData, this.maxIndex + 1, this.maxIndex + this.numberParticlesPerCore, this.numberParticlesPerCore));
        } else {
            try {
                int i = this.minIndex;
                while (i <= this.maxIndex) {
                    this.fits[i] = this.fitnessFunction[i].evaluate(this.particles[i]);
                    List<Double>[] tmp = this.fitnessFunction[i].getLastFittedData();
                    int j = 0;
                    while (j < tmp.length) {
                        this.fittedData[i][j] = new ArrayList<Double>();
                        for (Double d : tmp[j]) {
                            this.fittedData[i][j].add(d);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

