/*
 * Decompiled with CFR 0.152.
 */
package parallel;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import javax.imageio.ImageIO;

public class ForkBlur
extends RecursiveAction {
    private int[] mSource;
    private int mStart;
    private int mLength;
    private int[] mDestination;
    private int mBlurWidth = 15;
    protected static int sThreshold = 10000;

    public ForkBlur(int[] src, int start, int length, int[] dst) {
        this.mSource = src;
        this.mStart = start;
        this.mLength = length;
        this.mDestination = dst;
    }

    protected void computeDirectly() {
        int sidePixels = (this.mBlurWidth - 1) / 2;
        int index = this.mStart;
        while (index < this.mStart + this.mLength) {
            int dpixel;
            float rt = 0.0f;
            float gt = 0.0f;
            float bt = 0.0f;
            int mi = -sidePixels;
            while (mi <= sidePixels) {
                int mindex = Math.min(Math.max(mi + index, 0), this.mSource.length - 1);
                int pixel = this.mSource[mindex];
                rt += (float)((pixel & 0xFF0000) >> 16) / (float)this.mBlurWidth;
                gt += (float)((pixel & 0xFF00) >> 8) / (float)this.mBlurWidth;
                bt += (float)((pixel & 0xFF) >> 0) / (float)this.mBlurWidth;
                ++mi;
            }
            this.mDestination[index] = dpixel = 0xFF000000 | (int)rt << 16 | (int)gt << 8 | (int)bt << 0;
            ++index;
        }
    }

    @Override
    protected void compute() {
        if (this.mLength < sThreshold) {
            this.computeDirectly();
            return;
        }
        int split = this.mLength / 2;
        ForkBlur.invokeAll(new ForkBlur(this.mSource, this.mStart, split, this.mDestination), new ForkBlur(this.mSource, this.mStart + split, this.mLength - split, this.mDestination));
    }

    public static void main(String[] args) throws Exception {
        String srcName = "red-tulips.jpg";
        File srcFile = new File(srcName);
        BufferedImage image = ImageIO.read(srcFile);
        System.out.println("Source image: " + srcName);
        BufferedImage blurredImage = ForkBlur.blur(image);
        String dstName = "blurred-tulips.jpg";
        File dstFile = new File(dstName);
        ImageIO.write((RenderedImage)blurredImage, "jpg", dstFile);
        System.out.println("Output image: " + dstName);
    }

    public static BufferedImage blur(BufferedImage srcImage) {
        int w = srcImage.getWidth();
        int h = srcImage.getHeight();
        int[] src = srcImage.getRGB(0, 0, w, h, null, 0, w);
        int[] dst = new int[src.length];
        System.out.println("Array size is " + src.length);
        System.out.println("Threshold is " + sThreshold);
        int processors = Runtime.getRuntime().availableProcessors();
        System.out.println(String.valueOf(Integer.toString(processors)) + " processor" + (processors != 1 ? "s are " : " is ") + "available");
        ForkBlur fb = new ForkBlur(src, 0, src.length, dst);
        ForkJoinPool pool = new ForkJoinPool();
        long startTime = System.currentTimeMillis();
        pool.invoke(fb);
        long endTime = System.currentTimeMillis();
        System.out.println("Image blur took " + (endTime - startTime) + " milliseconds.");
        BufferedImage dstImage = new BufferedImage(w, h, 2);
        dstImage.setRGB(0, 0, w, h, dst, 0, w);
        return dstImage;
    }
}

