/*
 * Decompiled with CFR 0.152.
 */
package parallel;

import PBN.StateBit;
import java.util.List;
import java.util.concurrent.RecursiveAction;
import simulationMethod.ParallelEngine;

public class Simulate
extends RecursiveAction {
    private List<List> trajectories;
    private long steps;
    private int minIndex;
    private int maxIndex;
    private ParallelEngine engine;
    private StateBit[] initialState;

    public Simulate(List<List> trajectories, long steps, int minIndex, int maxIndex, ParallelEngine engine, StateBit[] initialState) {
        this.trajectories = trajectories;
        this.steps = steps;
        this.minIndex = minIndex;
        this.maxIndex = maxIndex;
        this.engine = engine;
        this.initialState = initialState;
    }

    public void setSteps(int steps) {
        this.steps = steps;
    }

    public void setSteps(long steps) {
        this.steps = steps;
    }

    public void setMinIndex(int minIndex) {
        this.minIndex = minIndex;
    }

    public void setMaxIndex(int maxIndex) {
        this.maxIndex = maxIndex;
    }

    @Override
    protected void compute() {
        if (this.maxIndex - this.minIndex > 0) {
            --this.maxIndex;
            Simulate.invokeAll(new Simulate(this.trajectories, this.steps, this.minIndex, this.maxIndex, this.engine, this.initialState), new Simulate(this.trajectories, this.steps, this.maxIndex + 1, this.maxIndex + 1, this.engine, this.initialState));
        } else {
            try {
                this.initialState[this.maxIndex] = this.engine.simulate(this.steps, this.initialState[this.maxIndex], this.maxIndex);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

