/*
 * Decompiled with CFR 0.152.
 */
package parallel;

import java.util.Arrays;
import java.util.concurrent.RecursiveAction;

class SortTask
extends RecursiveAction {
    private static final long serialVersionUID = 1L;
    final long[] array;
    final int lo;
    final int hi;
    static final int THRESHOLD = 10000;

    SortTask(long[] array, int lo, int hi) {
        this.array = array;
        this.lo = lo;
        this.hi = hi;
    }

    SortTask(long[] array) {
        this(array, 0, array.length);
    }

    @Override
    protected void compute() {
        if (this.hi - this.lo < 10000) {
            this.sortSequentially(this.lo, this.hi);
        } else {
            int mid = this.lo + this.hi >>> 1;
            SortTask.invokeAll(new SortTask(this.array, this.lo, mid), new SortTask(this.array, mid, this.hi));
            this.merge(this.lo, mid, this.hi);
        }
    }

    void sortSequentially(int lo, int hi) {
        Arrays.sort(this.array, lo, hi);
    }

    void merge(int lo, int mid, int hi) {
        long[] buf = Arrays.copyOfRange(this.array, lo, mid);
        int i = 0;
        int j = lo;
        int k = mid;
        while (i < buf.length) {
            this.array[j] = k == hi || buf[i] < this.array[k] ? buf[i++] : this.array[k++];
            ++j;
        }
    }
}

