/*
 * Decompiled with CFR 0.152.
 */
package parameterEstimation.particleSwarm;

import parameterEstimation.particleSwarm.Particle;

public abstract class FitnessFunction {
    protected boolean maximize;

    public FitnessFunction() {
        this.maximize = true;
    }

    public FitnessFunction(boolean maximize) {
        this.maximize = maximize;
    }

    public abstract double evaluate(double[] var1);

    public double evaluate(Particle particle) {
        double[] position = particle.getPosition();
        double fit = this.evaluate(position);
        particle.setFitness(fit, this.maximize);
        return fit;
    }

    public boolean isBetterThan(double fitness, double otherValue) {
        return this.maximize ? otherValue > fitness : otherValue < fitness;
    }

    public boolean isMaximize() {
        return this.maximize;
    }

    public void setMaximize(boolean maximize) {
        this.maximize = maximize;
    }
}

