/*
 * Decompiled with CFR 0.152.
 */
package parameterEstimation.particleSwarm;

import java.util.Collection;
import java.util.HashMap;
import parameterEstimation.particleSwarm.Particle;
import parameterEstimation.particleSwarm.Swarm;

public abstract class Neighborhood {
    HashMap<Particle, Collection<Particle>> neighborhoods = new HashMap();
    HashMap<Particle, Particle> bestInNeighborhood = new HashMap();

    public abstract Collection<Particle> calcNeighbours(Particle var1);

    public Particle getBestParticle(Particle p) {
        return this.bestInNeighborhood.get(p);
    }

    public double[] getBestPosition(Particle p) {
        Particle bestp = this.getBestParticle(p);
        if (bestp == null) {
            return null;
        }
        return bestp.getBestPosition();
    }

    public Collection<Particle> getNeighbours(Particle p) {
        Collection<Particle> neighs = this.neighborhoods.get(p);
        if (neighs == null) {
            neighs = this.calcNeighbours(p);
        }
        return neighs;
    }

    public void init(Swarm swarm) {
        for (Particle p : swarm) {
            Collection<Particle> neigh = this.getNeighbours(p);
            this.neighborhoods.put(p, neigh);
        }
    }

    public void update(Swarm swarm, Particle p) {
        Particle pbest = this.getBestParticle(p);
        if (pbest == null || swarm.getFitnessFunction().isBetterThan(pbest.getBestFitness(), p.getBestFitness())) {
            Collection<Particle> neigh = this.getNeighbours(p);
            for (Particle pp : neigh) {
                this.bestInNeighborhood.put(pp, p);
            }
        }
    }
}

