/*
 * Decompiled with CFR 0.152.
 */
package parameterEstimation.particleSwarm;

import java.util.ArrayList;
import java.util.Collection;
import parameterEstimation.particleSwarm.Neighborhood;
import parameterEstimation.particleSwarm.Particle;
import parameterEstimation.particleSwarm.Swarm;

public class Neighborhood1D
extends Neighborhood {
    int size;
    boolean circular;
    ArrayList<Particle> array1d;

    public Neighborhood1D(int size, boolean circular) {
        this.size = size;
        this.circular = circular;
        this.array1d = new ArrayList();
    }

    @Override
    public Collection<Particle> calcNeighbours(Particle p) {
        ArrayList<Particle> neigh = new ArrayList<Particle>();
        int idx = this.findIndex(p);
        int i = idx - this.size;
        while (i <= idx + this.size) {
            Particle pp = this.getParticle(i);
            if (pp != null && pp != p) {
                neigh.add(pp);
            }
            ++i;
        }
        return neigh;
    }

    int findIndex(Particle p) {
        int i = 0;
        while (i < this.array1d.size()) {
            if (p == this.array1d.get(i)) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException("Cannot find particle. This should never happen!\n" + p);
    }

    Particle getParticle(int idx) {
        int arraySize = this.array1d.size();
        if (idx >= 0 && idx < this.array1d.size()) {
            return this.array1d.get(idx);
        }
        if (!this.circular) {
            return null;
        }
        if (idx >= arraySize) {
            idx %= arraySize;
        } else if (idx < 0) {
            idx += arraySize;
        }
        return this.array1d.get(idx);
    }

    @Override
    public void init(Swarm swarm) {
        for (Particle p : swarm) {
            this.array1d.add(p);
        }
        super.init(swarm);
    }
}

