/*
 * Decompiled with CFR 0.152.
 */
package parameterEstimation.particleSwarm;

import java.util.List;
import parameterEstimation.particleSwarm.FitnessFunction;
import parameterEstimation.particleSwarm.Particle;
import parameterEstimation.particleSwarm.ParticleUpdateAdaptive;
import parameterEstimation.particleSwarm.ParticleUpdateSimple;
import parameterEstimation.particleSwarm.Swarm;
import parameterEstimation.particleSwarm.VariablesUpdate;
import parameterEstimation.particleSwarm.estiPBN.PBNFitnessFunction;
import parameterEstimation.particleSwarm.estiPBN.PBNParticle;

public class PBNSwarm
extends Swarm {
    protected int[] cumPositionIndex;
    protected List<Double>[] bestFittedData;

    public PBNSwarm(int numberOfParticles, Particle sampleParticle, FitnessFunction fitnessFunction, boolean adaptive) {
        if (sampleParticle == null) {
            throw new RuntimeException("Sample particle can't be null!");
        }
        if (numberOfParticles <= 0) {
            throw new RuntimeException("Number of particles should be greater than zero.");
        }
        this.globalIncrement = DEFAULT_GLOBAL_INCREMENT;
        this.inertia = DEFAULT_INERTIA;
        this.particleIncrement = DEFAULT_PARTICLE_INCREMENT;
        this.numberOfEvaliations = 0;
        this.numberOfParticles = numberOfParticles;
        this.sampleParticle = sampleParticle;
        this.fitnessFunction = fitnessFunction;
        this.bestFitness = Double.NaN;
        this.bestParticleIndex = -1;
        this.particleUpdate = adaptive ? new ParticleUpdateAdaptive(sampleParticle) : new ParticleUpdateSimple(sampleParticle);
        this.variablesUpdate = new VariablesUpdate();
        this.neighborhood = null;
        this.neighborhoodIncrement = 0.0;
        this.particlesList = null;
    }

    @Override
    public void init() {
        int i;
        int dim;
        this.particles = new Particle[this.numberOfParticles];
        if (this.maxPosition == null) {
            throw new RuntimeException("maxPosition array is null!");
        }
        if (this.minPosition == null) {
            throw new RuntimeException("maxPosition array is null!");
        }
        if (this.maxVelocity == null) {
            dim = this.sampleParticle.getDimension();
            this.maxVelocity = new double[dim];
            i = 0;
            while (i < dim) {
                this.maxVelocity[i] = (this.maxPosition[i] - this.minPosition[i]) / 2.0;
                ++i;
            }
        }
        if (this.minVelocity == null) {
            dim = this.sampleParticle.getDimension();
            this.minVelocity = new double[dim];
            i = 0;
            while (i < dim) {
                this.minVelocity[i] = -this.maxVelocity[i];
                ++i;
            }
        }
        this.cumPositionIndex = ((PBNFitnessFunction)this.fitnessFunction).getCumPositionIndex();
        int i2 = 0;
        while (i2 < this.numberOfParticles) {
            this.particles[i2] = (Particle)this.sampleParticle.selfFactory();
            this.particles[i2].init(this.maxPosition, this.minPosition, this.maxVelocity, this.minVelocity);
            ++i2;
        }
        if (this.neighborhood != null) {
            this.neighborhood.init(this);
        }
    }

    public void initialPosition(double[] position) {
        int i = 0;
        while (i < this.numberOfParticles) {
            double[] newPosition = (double[])position.clone();
            this.particles[i].setPosition(newPosition);
            ++i;
        }
    }

    @Override
    public void evaluate() {
        if (this.particles == null) {
            throw new RuntimeException("No particles in this swarm! May be you need to call Swarm.init() method");
        }
        if (this.fitnessFunction == null) {
            throw new RuntimeException("No fitness function in this swarm! May be you need to call Swarm.setFitnessFunction() method");
        }
        if (Double.isNaN(this.bestFitness)) {
            this.bestFitness = this.fitnessFunction.isMaximize() ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            this.bestParticleIndex = -1;
        }
        int i = 0;
        while (i < this.particles.length) {
            double fit = this.fitnessFunction.evaluate(this.particles[i]);
            ++this.numberOfEvaliations;
            if (this.fitnessFunction.isBetterThan(this.bestFitness, fit)) {
                this.bestFitness = fit;
                this.bestFittedData = ((PBNFitnessFunction)this.fitnessFunction).getLastFittedData();
                this.bestParticleIndex = i;
                if (this.bestPosition == null) {
                    this.bestPosition = new double[this.sampleParticle.getDimension()];
                }
                this.particles[this.bestParticleIndex].copyPosition(this.bestPosition);
            }
            if (this.neighborhood != null) {
                this.neighborhood.update(this, this.particles[i]);
            }
            ++i;
        }
    }

    @Override
    public void update() {
        this.particleUpdate.begin(this);
        int i = 0;
        while (i < this.particles.length) {
            this.particleUpdate.update(this, this.particles[i]);
            this.particles[i].applyConstraints(this.minPosition, this.maxPosition, this.minVelocity, this.maxVelocity);
            ((PBNParticle)this.particles[i]).applyMoreConstraints(this.cumPositionIndex, i);
            ++i;
        }
        this.particleUpdate.end(this);
    }

    public List<Double>[] getBestFittedData() {
        return this.bestFittedData;
    }
}

