/*
 * Decompiled with CFR 0.152.
 */
package parameterEstimation.particleSwarm;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import parallel.EvaluateParticle;
import parameterEstimation.particleSwarm.FitnessFunction;
import parameterEstimation.particleSwarm.PBNSwarm;
import parameterEstimation.particleSwarm.Particle;
import parameterEstimation.particleSwarm.estiPBN.PBNFitnessFunction;

public class PBNSwarmParallel
extends PBNSwarm {
    protected double[] fits;
    protected List<Double>[][] fittedData;
    protected int numParticlesPerCore;
    protected PBNFitnessFunction[] PBNFitnessFunctions;
    private EvaluateParticle evaluateParticle;
    private ForkJoinPool pool;

    public PBNSwarmParallel(int numberOfParticles, Particle sampleParticle, FitnessFunction fitnessFunction, int cores, boolean adaptive) {
        super(numberOfParticles, sampleParticle, fitnessFunction, adaptive);
        if (cores == 0) {
            cores = Runtime.getRuntime().availableProcessors();
        }
        this.numParticlesPerCore = (int)Math.ceil((double)numberOfParticles / (double)cores);
    }

    @Override
    public void init() {
        super.init();
        this.fits = new double[this.numberOfParticles];
        this.fittedData = new ArrayList[this.numberOfParticles][((PBNFitnessFunction)this.fitnessFunction).getBestFittedData().length];
        this.pool = new ForkJoinPool();
        this.PBNFitnessFunctions = new PBNFitnessFunction[this.numberOfParticles];
        int i = 0;
        while (i < this.numberOfParticles) {
            try {
                this.PBNFitnessFunctions[i] = ((PBNFitnessFunction)this.fitnessFunction).clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.evaluateParticle = new EvaluateParticle(this.PBNFitnessFunctions, this.particles, this.fits, this.fittedData, 0, this.numberOfParticles - 1, this.numParticlesPerCore);
    }

    @Override
    public void evaluate() {
        if (this.particles == null) {
            throw new RuntimeException("No particles in this swarm! May be you need to call Swarm.init() method");
        }
        if (this.fitnessFunction == null) {
            throw new RuntimeException("No fitness function in this swarm! May be you need to call Swarm.setFitnessFunction() method");
        }
        if (Double.isNaN(this.bestFitness)) {
            this.bestFitness = this.fitnessFunction.isMaximize() ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            this.bestParticleIndex = -1;
        }
        this.evaluateParticle.reinitialize();
        this.pool.invoke(this.evaluateParticle);
        this.numberOfEvaliations += this.numberOfParticles;
        int i = 0;
        while (i < this.particles.length) {
            if (this.numberOfEvaliations == this.numberOfParticles) {
                this.particles[i].setFirstFitness(this.fits[i]);
            }
            if (this.fitnessFunction.isBetterThan(this.bestFitness, this.fits[i])) {
                this.bestFitness = this.fits[i];
                this.bestFittedData = this.fittedData[i];
                this.bestParticleIndex = i;
                if (this.bestPosition == null) {
                    this.bestPosition = new double[this.sampleParticle.getDimension()];
                }
                this.particles[this.bestParticleIndex].copyPosition(this.bestPosition);
            }
            if (this.neighborhood != null) {
                this.neighborhood.update(this, this.particles[i]);
            }
            ++i;
        }
    }
}

