/*
 * Decompiled with CFR 0.152.
 */
package parameterEstimation.particleSwarm;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class Particle {
    double bestFitness;
    double[] bestPosition;
    double firstFitness;
    double fitness;
    protected double[] position;
    protected double[] velocity;

    public Particle() {
        throw new RuntimeException("You probably need to implement your own 'Particle' class");
    }

    public Particle(int dimension) {
        this.allocate(dimension);
    }

    public Particle(Particle sampleParticle) {
        int dimension = sampleParticle.getDimension();
        this.allocate(dimension);
    }

    public void allocate(int dimension) {
        this.position = new double[dimension];
        this.bestPosition = new double[dimension];
        this.velocity = new double[dimension];
        this.bestFitness = Double.NaN;
        this.fitness = Double.NaN;
        int i = 0;
        while (i < this.position.length) {
            this.bestPosition[i] = Double.NaN;
            ++i;
        }
    }

    public void applyConstraints(double[] minPosition, double[] maxPosition, double[] minVelocity, double[] maxVelocity) {
        block25: {
            int i;
            block26: {
                block24: {
                    if (minPosition == null || maxPosition == null || minVelocity == null || maxVelocity == null) break block24;
                    int i2 = 0;
                    while (i2 < this.position.length) {
                        if (!Double.isNaN(minPosition[i2])) {
                            double d = this.position[i2] = minPosition[i2] > this.position[i2] ? minPosition[i2] : this.position[i2];
                        }
                        if (!Double.isNaN(maxPosition[i2])) {
                            double d = this.position[i2] = maxPosition[i2] < this.position[i2] ? maxPosition[i2] : this.position[i2];
                        }
                        if (!Double.isNaN(minVelocity[i2])) {
                            double d = this.velocity[i2] = minVelocity[i2] > this.velocity[i2] ? minVelocity[i2] : this.velocity[i2];
                        }
                        if (!Double.isNaN(maxVelocity[i2])) {
                            this.velocity[i2] = maxVelocity[i2] < this.velocity[i2] ? maxVelocity[i2] : this.velocity[i2];
                        }
                        ++i2;
                    }
                    break block25;
                }
                if (minPosition != null && maxPosition != null) {
                    i = 0;
                    while (i < this.position.length) {
                        if (!Double.isNaN(minPosition[i])) {
                            double d = this.position[i] = minPosition[i] > this.position[i] ? minPosition[i] : this.position[i];
                        }
                        if (!Double.isNaN(maxPosition[i])) {
                            this.position[i] = maxPosition[i] < this.position[i] ? maxPosition[i] : this.position[i];
                        }
                        ++i;
                    }
                } else {
                    if (minPosition != null) {
                        i = 0;
                        while (i < this.position.length) {
                            if (!Double.isNaN(minPosition[i])) {
                                this.position[i] = minPosition[i] > this.position[i] ? minPosition[i] : this.position[i];
                            }
                            ++i;
                        }
                    }
                    if (maxPosition != null) {
                        i = 0;
                        while (i < this.position.length) {
                            if (!Double.isNaN(maxPosition[i])) {
                                this.position[i] = maxPosition[i] < this.position[i] ? maxPosition[i] : this.position[i];
                            }
                            ++i;
                        }
                    }
                }
                if (minVelocity == null || maxVelocity == null) break block26;
                i = 0;
                while (i < this.velocity.length) {
                    if (!Double.isNaN(minVelocity[i])) {
                        double d = this.velocity[i] = minVelocity[i] > this.velocity[i] ? minVelocity[i] : this.velocity[i];
                    }
                    if (!Double.isNaN(maxVelocity[i])) {
                        this.velocity[i] = maxVelocity[i] < this.velocity[i] ? maxVelocity[i] : this.velocity[i];
                    }
                    ++i;
                }
                break block25;
            }
            if (minVelocity != null) {
                i = 0;
                while (i < this.velocity.length) {
                    if (!Double.isNaN(minVelocity[i])) {
                        this.velocity[i] = minVelocity[i] > this.velocity[i] ? minVelocity[i] : this.velocity[i];
                    }
                    ++i;
                }
            }
            if (maxVelocity == null) break block25;
            i = 0;
            while (i < this.velocity.length) {
                if (!Double.isNaN(maxVelocity[i])) {
                    this.velocity[i] = maxVelocity[i] < this.velocity[i] ? maxVelocity[i] : this.velocity[i];
                }
                ++i;
            }
        }
    }

    public void copyPosition(double[] positionCopy) {
        int i = 0;
        while (i < this.position.length) {
            positionCopy[i] = this.position[i];
            ++i;
        }
    }

    public void copyPosition2Best() {
        int i = 0;
        while (i < this.position.length) {
            this.bestPosition[i] = this.position[i];
            ++i;
        }
    }

    public double getBestFitness() {
        return this.bestFitness;
    }

    public double[] getBestPosition() {
        return this.bestPosition;
    }

    public int getDimension() {
        return this.position.length;
    }

    public double getFitness() {
        return this.fitness;
    }

    public double[] getPosition() {
        return this.position;
    }

    public double[] getVelocity() {
        return this.velocity;
    }

    public void init(double[] maxPosition, double[] minPosition, double[] maxVelocity, double[] minVelocity) {
        int i = 0;
        while (i < this.position.length) {
            if (Double.isNaN(maxPosition[i])) {
                throw new RuntimeException("maxPosition[" + i + "] is NaN!");
            }
            if (Double.isInfinite(maxPosition[i])) {
                throw new RuntimeException("maxPosition[" + i + "] is Infinite!");
            }
            if (Double.isNaN(minPosition[i])) {
                throw new RuntimeException("minPosition[" + i + "] is NaN!");
            }
            if (Double.isInfinite(minPosition[i])) {
                throw new RuntimeException("minPosition[" + i + "] is Infinite!");
            }
            if (Double.isNaN(maxVelocity[i])) {
                throw new RuntimeException("maxVelocity[" + i + "] is NaN!");
            }
            if (Double.isInfinite(maxVelocity[i])) {
                throw new RuntimeException("maxVelocity[" + i + "] is Infinite!");
            }
            if (Double.isNaN(minVelocity[i])) {
                throw new RuntimeException("minVelocity[" + i + "] is NaN!");
            }
            if (Double.isInfinite(minVelocity[i])) {
                throw new RuntimeException("minVelocity[" + i + "] is Infinite!");
            }
            this.position[i] = (maxPosition[i] - minPosition[i]) * Math.random() + minPosition[i];
            this.velocity[i] = (maxVelocity[i] - minVelocity[i]) * Math.random() + minVelocity[i];
            this.bestPosition[i] = Double.NaN;
            ++i;
        }
    }

    public Object selfFactory() {
        Constructor<?> cons;
        Class<?> cl = this.getClass();
        try {
            cons = cl.getConstructor(null);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        try {
            return cons.newInstance(null);
        }
        catch (IllegalArgumentException e1) {
            throw new RuntimeException(e1);
        }
        catch (InstantiationException e1) {
            throw new RuntimeException(e1);
        }
        catch (IllegalAccessException e1) {
            throw new RuntimeException(e1);
        }
        catch (InvocationTargetException e1) {
            throw new RuntimeException(e1);
        }
    }

    public void setBestFitness(double bestFitness) {
        this.bestFitness = bestFitness;
    }

    public void setBestPosition(double[] bestPosition) {
        this.bestPosition = bestPosition;
    }

    public void setFitness(double fitness, boolean maximize) {
        this.fitness = fitness;
        if (maximize && fitness > this.bestFitness || !maximize && fitness < this.bestFitness || Double.isNaN(this.bestFitness)) {
            this.copyPosition2Best();
            this.bestFitness = fitness;
        }
    }

    public void setFirstFitness(double firstFitness) {
        this.firstFitness = firstFitness;
    }

    public void setPosition(double[] position) {
        this.position = position;
    }

    public void setVelocity(double[] velocity) {
        this.velocity = velocity;
    }

    public String toString() {
        int i;
        String str = "fitness: " + this.fitness + "\tbest fitness: " + this.bestFitness;
        if (this.position != null) {
            str = String.valueOf(str) + "\n\tPosition:\t";
            i = 0;
            while (i < this.position.length) {
                str = String.valueOf(str) + this.position[i] + "\t";
                ++i;
            }
        }
        if (this.velocity != null) {
            str = String.valueOf(str) + "\n\tVelocity:\t";
            i = 0;
            while (i < this.velocity.length) {
                str = String.valueOf(str) + this.velocity[i] + "\t";
                ++i;
            }
        }
        if (this.bestPosition != null) {
            str = String.valueOf(str) + "\n\tBest:\t";
            i = 0;
            while (i < this.bestPosition.length) {
                str = String.valueOf(str) + this.bestPosition[i] + "\t";
                ++i;
            }
        }
        str = String.valueOf(str) + "\n";
        return str;
    }
}

