/*
 * Decompiled with CFR 0.152.
 */
package parameterEstimation.particleSwarm;

import parameterEstimation.particleSwarm.Particle;
import parameterEstimation.particleSwarm.ParticleUpdate;
import parameterEstimation.particleSwarm.Swarm;

public class ParticleUpdateAdaptive
extends ParticleUpdate {
    double[] rlocal;
    double[] rglobal;
    double[] rneighborhood;

    public ParticleUpdateAdaptive(Particle particle) {
        super(particle);
        this.rlocal = new double[particle.getDimension()];
        this.rglobal = new double[particle.getDimension()];
        this.rneighborhood = new double[particle.getDimension()];
    }

    @Override
    public void begin(Swarm swarm) {
        int dim = swarm.getSampleParticle().getDimension();
        int i = 0;
        while (i < dim) {
            this.rlocal[i] = Math.random();
            this.rglobal[i] = Math.random();
            this.rneighborhood[i] = Math.random();
            ++i;
        }
    }

    @Override
    public void end(Swarm swarm) {
    }

    @Override
    public void update(Swarm swarm, Particle particle) {
        double[] position = particle.getPosition();
        double[] velocity = particle.getVelocity();
        double[] globalBestPosition = swarm.getBestPosition();
        double[] particleBestPosition = particle.getBestPosition();
        double[] neighBestPosition = swarm.getNeighborhoodBestPosition(particle);
        int tmp = swarm.particlesList.indexOf(particle);
        if (tmp < 0) {
            tmp = 0;
        }
        int i = 0;
        while (i < position.length) {
            velocity[i] = swarm.inertias[tmp] * velocity[i] + this.rlocal[i] * swarm.getParticleIncrement() * (particleBestPosition[i] - position[i]) + this.rneighborhood[i] * swarm.getNeighborhoodIncrement() * (neighBestPosition[i] - position[i]) + this.rglobal[i] * swarm.getGlobalIncrement() * (globalBestPosition[i] - position[i]);
            int n = i;
            position[n] = position[n] + velocity[i];
            ++i;
        }
    }
}

