/*
 * Decompiled with CFR 0.152.
 */
package parameterEstimation.particleSwarm;

import parameterEstimation.particleSwarm.Particle;
import parameterEstimation.particleSwarm.ParticleUpdate;
import parameterEstimation.particleSwarm.Swarm;
import parameterEstimation.particleSwarm.SwarmRepulsive;

public class ParticleUpdateRepulsive
extends ParticleUpdate {
    double[] rlocal;
    double[] rother;
    double[] rneighborhood;
    double randRand;

    public ParticleUpdateRepulsive(Particle particle) {
        super(particle);
        this.rlocal = new double[particle.getDimension()];
        this.rother = new double[particle.getDimension()];
        this.rneighborhood = new double[particle.getDimension()];
    }

    @Override
    public void begin(Swarm swarm) {
        this.randRand = Math.random();
        int dim = swarm.getSampleParticle().getDimension();
        int i = 0;
        while (i < dim) {
            this.rlocal[i] = Math.random();
            this.rother[i] = Math.random();
            this.rneighborhood[i] = Math.random();
            ++i;
        }
    }

    @Override
    public void update(Swarm swarm, Particle particle) {
        double[] position = particle.getPosition();
        double[] velocity = particle.getVelocity();
        double[] particleBestPosition = particle.getBestPosition();
        double[] maxVelocity = swarm.getMaxVelocity();
        double[] minVelocity = swarm.getMinVelocity();
        SwarmRepulsive swarmRepulsive = (SwarmRepulsive)swarm;
        int randOtherParticle = (int)(Math.random() * (double)swarm.size());
        double[] otherParticleBestPosition = swarm.getParticle(randOtherParticle).getBestPosition();
        double[] neighBestPosition = swarm.getNeighborhoodBestPosition(particle);
        int i = 0;
        while (i < position.length) {
            position[i] = position[i] + velocity[i];
            double randVelocity = velocity[i] = (maxVelocity[i] - minVelocity[i]) * Math.random() + minVelocity[i];
            velocity[i] = swarmRepulsive.getInertia() * velocity[i] + this.rlocal[i] * swarmRepulsive.getParticleIncrement() * (particleBestPosition[i] - position[i]) + this.rneighborhood[i] * swarm.getNeighborhoodIncrement() * (neighBestPosition[i] - position[i]) + this.rother[i] * swarmRepulsive.getOtherParticleIncrement() * (otherParticleBestPosition[i] - position[i]) + this.randRand * swarmRepulsive.getRandomIncrement() * randVelocity;
            ++i;
        }
    }
}

