/*
 * Decompiled with CFR 0.152.
 */
package parameterEstimation.particleSwarm;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import parameterEstimation.particleSwarm.FitnessFunction;
import parameterEstimation.particleSwarm.Neighborhood;
import parameterEstimation.particleSwarm.Particle;
import parameterEstimation.particleSwarm.ParticleUpdate;
import parameterEstimation.particleSwarm.ParticleUpdateSimple;
import parameterEstimation.particleSwarm.VariablesUpdate;

public class Swarm
implements Iterable<Particle> {
    public static double DEFAULT_GLOBAL_INCREMENT = 0.9;
    public static double DEFAULT_INERTIA = 0.95;
    public static int DEFAULT_NUMBER_OF_PARTICLES = 25;
    public static double DEFAULT_PARTICLE_INCREMENT = 0.1;
    public static double VELOCITY_GRAPH_FACTOR = 10.0;
    double bestFitness;
    int bestParticleIndex;
    double[] bestPosition;
    FitnessFunction fitnessFunction;
    double globalIncrement;
    double inertia;
    double[] inertias;
    double Fkn = 0.5;
    double[] maxPosition;
    double[] maxVelocity;
    double[] minPosition;
    double[] minVelocity;
    int numberOfEvaliations;
    int numberOfParticles;
    double particleIncrement;
    Particle[] particles;
    ParticleUpdate particleUpdate;
    Particle sampleParticle;
    VariablesUpdate variablesUpdate;
    Neighborhood neighborhood;
    double neighborhoodIncrement;
    ArrayList<Particle> particlesList;

    public Swarm() {
    }

    public Swarm(int numberOfParticles, Particle sampleParticle, FitnessFunction fitnessFunction) {
        if (sampleParticle == null) {
            throw new RuntimeException("Sample particle can't be null!");
        }
        if (numberOfParticles <= 0) {
            throw new RuntimeException("Number of particles should be greater than zero.");
        }
        this.globalIncrement = DEFAULT_GLOBAL_INCREMENT;
        this.inertia = DEFAULT_INERTIA;
        this.particleIncrement = DEFAULT_PARTICLE_INCREMENT;
        this.numberOfEvaliations = 0;
        this.numberOfParticles = numberOfParticles;
        this.sampleParticle = sampleParticle;
        this.fitnessFunction = fitnessFunction;
        this.bestFitness = Double.NaN;
        this.bestParticleIndex = -1;
        this.particleUpdate = new ParticleUpdateSimple(sampleParticle);
        this.variablesUpdate = new VariablesUpdate();
        this.neighborhood = null;
        this.neighborhoodIncrement = 0.0;
        this.particlesList = null;
    }

    public void evaluate() {
        if (this.particles == null) {
            throw new RuntimeException("No particles in this swarm! May be you need to call Swarm.init() method");
        }
        if (this.fitnessFunction == null) {
            throw new RuntimeException("No fitness function in this swarm! May be you need to call Swarm.setFitnessFunction() method");
        }
        if (Double.isNaN(this.bestFitness)) {
            this.bestFitness = this.fitnessFunction.isMaximize() ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            this.bestParticleIndex = -1;
        }
        int i = 0;
        while (i < this.particles.length) {
            double fit = this.fitnessFunction.evaluate(this.particles[i]);
            ++this.numberOfEvaliations;
            if (this.fitnessFunction.isBetterThan(this.bestFitness, fit)) {
                this.bestFitness = fit;
                this.bestParticleIndex = i;
                if (this.bestPosition == null) {
                    this.bestPosition = new double[this.sampleParticle.getDimension()];
                }
                this.particles[this.bestParticleIndex].copyPosition(this.bestPosition);
            }
            if (this.neighborhood != null) {
                this.neighborhood.update(this, this.particles[i]);
            }
            ++i;
        }
    }

    public void evolve() {
        if (this.particles == null) {
            this.init();
        }
        this.evaluate();
        this.update();
        this.variablesUpdate.update(this);
    }

    public double getBestFitness() {
        return this.bestFitness;
    }

    public Particle getBestParticle() {
        return this.particles[this.bestParticleIndex];
    }

    public int getBestParticleIndex() {
        return this.bestParticleIndex;
    }

    public double[] getBestPosition() {
        return this.bestPosition;
    }

    public FitnessFunction getFitnessFunction() {
        return this.fitnessFunction;
    }

    public double getGlobalIncrement() {
        return this.globalIncrement;
    }

    public double getInertia() {
        return this.inertia;
    }

    public double[] getMaxPosition() {
        return this.maxPosition;
    }

    public double[] getMaxVelocity() {
        return this.maxVelocity;
    }

    public double[] getMinPosition() {
        return this.minPosition;
    }

    public double[] getMinVelocity() {
        return this.minVelocity;
    }

    public Neighborhood getNeighborhood() {
        return this.neighborhood;
    }

    public double[] getNeighborhoodBestPosition(Particle particle) {
        if (this.neighborhood == null) {
            return particle.getPosition();
        }
        double[] d = this.neighborhood.getBestPosition(particle);
        if (d == null) {
            return particle.getPosition();
        }
        return d;
    }

    public double getNeighborhoodIncrement() {
        return this.neighborhoodIncrement;
    }

    public int getNumberOfEvaliations() {
        return this.numberOfEvaliations;
    }

    public int getNumberOfParticles() {
        return this.numberOfParticles;
    }

    public Particle getParticle(int i) {
        return this.particles[i];
    }

    public double getParticleIncrement() {
        return this.particleIncrement;
    }

    public Particle[] getParticles() {
        return this.particles;
    }

    public ParticleUpdate getParticleUpdate() {
        return this.particleUpdate;
    }

    public Particle getSampleParticle() {
        return this.sampleParticle;
    }

    public VariablesUpdate getVariablesUpdate() {
        return this.variablesUpdate;
    }

    public void init() {
        int i;
        int dim;
        this.particles = new Particle[this.numberOfParticles];
        if (this.maxPosition == null) {
            throw new RuntimeException("maxPosition array is null!");
        }
        if (this.minPosition == null) {
            throw new RuntimeException("maxPosition array is null!");
        }
        if (this.maxVelocity == null) {
            dim = this.sampleParticle.getDimension();
            this.maxVelocity = new double[dim];
            i = 0;
            while (i < dim) {
                this.maxVelocity[i] = (this.maxPosition[i] - this.minPosition[i]) / 2.0;
                ++i;
            }
        }
        if (this.minVelocity == null) {
            dim = this.sampleParticle.getDimension();
            this.minVelocity = new double[dim];
            i = 0;
            while (i < dim) {
                this.minVelocity[i] = -this.maxVelocity[i];
                ++i;
            }
        }
        int i2 = 0;
        while (i2 < this.numberOfParticles) {
            this.particles[i2] = (Particle)this.sampleParticle.selfFactory();
            this.particles[i2].init(this.maxPosition, this.minPosition, this.maxVelocity, this.minVelocity);
            ++i2;
        }
        if (this.neighborhood != null) {
            this.neighborhood.init(this);
        }
    }

    @Override
    public Iterator<Particle> iterator() {
        if (this.particlesList == null) {
            this.particlesList = new ArrayList(this.particles.length);
            int i = 0;
            while (i < this.particles.length) {
                this.particlesList.add(this.particles[i]);
                ++i;
            }
        }
        return this.particlesList.iterator();
    }

    public void setBestParticleIndex(int bestParticle) {
        this.bestParticleIndex = bestParticle;
    }

    public void setBestPosition(double[] bestPosition) {
        this.bestPosition = bestPosition;
    }

    public void setFitnessFunction(FitnessFunction fitnessFunction) {
        this.fitnessFunction = fitnessFunction;
    }

    public void setGlobalIncrement(double globalIncrement) {
        this.globalIncrement = globalIncrement;
    }

    public void setInertia(double inertia) {
        this.inertia = inertia;
        this.inertias = new double[this.numberOfParticles];
        int i = 0;
        while (i < this.inertias.length) {
            this.inertias[i] = inertia;
            ++i;
        }
    }

    public void setMaxMinVelocity(double maxVelocity) {
        if (this.sampleParticle == null) {
            throw new RuntimeException("Need to set sample particle before calling this method (use Swarm.setSampleParticle() method)");
        }
        int dim = this.sampleParticle.getDimension();
        this.maxVelocity = new double[dim];
        this.minVelocity = new double[dim];
        int i = 0;
        while (i < dim) {
            this.maxVelocity[i] = maxVelocity;
            this.minVelocity[i] = -maxVelocity;
            ++i;
        }
    }

    public void setMaxPosition(double maxPosition) {
        if (this.sampleParticle == null) {
            throw new RuntimeException("Need to set sample particle before calling this method (use Swarm.setSampleParticle() method)");
        }
        int dim = this.sampleParticle.getDimension();
        this.maxPosition = new double[dim];
        int i = 0;
        while (i < dim) {
            this.maxPosition[i] = maxPosition;
            ++i;
        }
    }

    public void setMaxPosition(double[] maxPosition) {
        this.maxPosition = maxPosition;
    }

    public void setMaxVelocity(double[] maxVelocity) {
        this.maxVelocity = maxVelocity;
    }

    public void setMinPosition(double minPosition) {
        if (this.sampleParticle == null) {
            throw new RuntimeException("Need to set sample particle before calling this method (use Swarm.setSampleParticle() method)");
        }
        int dim = this.sampleParticle.getDimension();
        this.minPosition = new double[dim];
        int i = 0;
        while (i < dim) {
            this.minPosition[i] = minPosition;
            ++i;
        }
    }

    public void setMinPosition(double[] minPosition) {
        this.minPosition = minPosition;
    }

    public void setMinVelocity(double[] minVelocity) {
        this.minVelocity = minVelocity;
    }

    public void setNeighborhood(Neighborhood neighborhood) {
        this.neighborhood = neighborhood;
    }

    public void setNeighborhoodIncrement(double neighborhoodIncrement) {
        this.neighborhoodIncrement = neighborhoodIncrement;
    }

    public void setNumberOfEvaliations(int numberOfEvaliations) {
        this.numberOfEvaliations = numberOfEvaliations;
    }

    public void setNumberOfParticles(int numberOfParticles) {
        this.numberOfParticles = numberOfParticles;
    }

    public void setParticleIncrement(double particleIncrement) {
        this.particleIncrement = particleIncrement;
    }

    public void setParticles(Particle[] particle) {
        this.particles = particle;
        this.particlesList = null;
    }

    public void setParticleUpdate(ParticleUpdate particleUpdate) {
        this.particleUpdate = particleUpdate;
    }

    public void setSampleParticle(Particle sampleParticle) {
        this.sampleParticle = sampleParticle;
    }

    public void setVariablesUpdate(VariablesUpdate variablesUpdate) {
        this.variablesUpdate = variablesUpdate;
    }

    public void setInitilParticlesPosition(double[] position) {
        int i = 0;
        while (i < this.particles.length) {
            this.particles[i].setPosition(position);
            ++i;
        }
    }

    public void show(Graphics graphics, Color foreground, int width, int height, int dim0, int dim1, boolean showVelocity) {
        graphics.setColor(foreground);
        if (this.particles != null) {
            double scalePosW = (double)width / (this.maxPosition[dim0] - this.minPosition[dim0]);
            double scalePosH = (double)height / (this.maxPosition[dim1] - this.minPosition[dim1]);
            double minPosW = this.minPosition[dim0];
            double minPosH = this.minPosition[dim1];
            double scaleVelW = (double)width / (VELOCITY_GRAPH_FACTOR * (this.maxVelocity[dim0] - this.minVelocity[dim0]));
            double scaleVelH = (double)height / (VELOCITY_GRAPH_FACTOR * (this.maxVelocity[dim1] - this.minVelocity[dim1]));
            double minVelW = this.minVelocity[dim0] + (this.maxVelocity[dim0] - this.minVelocity[dim0]) / 2.0;
            double minVelH = this.minVelocity[dim1] + (this.maxVelocity[dim1] - this.minVelocity[dim1]) / 2.0;
            int i = 0;
            while (i < this.particles.length) {
                double[] pos = this.particles[i].getPosition();
                double[] vel = this.particles[i].getVelocity();
                int x = (int)(scalePosW * (pos[dim0] - minPosW));
                int y = height - (int)(scalePosH * (pos[dim1] - minPosH));
                graphics.drawRect(x - 1, y - 1, 3, 3);
                if (showVelocity) {
                    int vx = (int)(scaleVelW * (vel[dim0] - minVelW));
                    int vy = (int)(scaleVelH * (vel[dim1] - minVelH));
                    graphics.drawLine(x, y, x + vx, y + vy);
                }
                ++i;
            }
        }
    }

    public int size() {
        return this.particles.length;
    }

    public String toString() {
        int i;
        String str = "";
        if (this.particles != null) {
            str = String.valueOf(str) + "Swarm size: " + this.particles.length + "\n";
        }
        if (this.minPosition != null && this.maxPosition != null) {
            str = String.valueOf(str) + "Position ranges:\t";
            i = 0;
            while (i < this.maxPosition.length) {
                str = String.valueOf(str) + "[" + this.minPosition[i] + ", " + this.maxPosition[i] + "]\t";
                ++i;
            }
        }
        if (this.minVelocity != null && this.maxVelocity != null) {
            str = String.valueOf(str) + "\nVelocity ranges:\t";
            i = 0;
            while (i < this.maxVelocity.length) {
                str = String.valueOf(str) + "[" + this.minVelocity[i] + ", " + this.maxVelocity[i] + "]\t";
                ++i;
            }
        }
        if (this.sampleParticle != null) {
            str = String.valueOf(str) + "\nSample particle: " + this.sampleParticle;
        }
        if (this.particles != null) {
            str = String.valueOf(str) + "\nParticles:";
            i = 0;
            while (i < this.particles.length) {
                str = String.valueOf(str) + "\n\tParticle: " + i + "\t";
                str = String.valueOf(str) + this.particles[i].toString();
                ++i;
            }
        }
        str = String.valueOf(str) + "\n";
        return str;
    }

    public String toStringStats() {
        String stats = "";
        if (!Double.isNaN(this.bestFitness)) {
            stats = String.valueOf(stats) + "Best fitness: " + this.bestFitness + "\nBest position: \t[";
            int i = 0;
            while (i < this.bestPosition.length) {
                stats = String.valueOf(stats) + this.bestPosition[i] + (i < this.bestPosition.length - 1 ? ", " : "");
                ++i;
            }
            stats = String.valueOf(stats) + "]\nTotal number of evaluations: " + this.numberOfEvaliations + "\n";
        }
        return stats;
    }

    public void update() {
        this.particleUpdate.begin(this);
        int i = 0;
        while (i < this.particles.length) {
            this.particleUpdate.update(this, this.particles[i]);
            this.particles[i].applyConstraints(this.minPosition, this.maxPosition, this.minVelocity, this.maxVelocity);
            ++i;
        }
        this.particleUpdate.end(this);
    }
}

