/*
 * Decompiled with CFR 0.152.
 */
package parameterEstimation.particleSwarm.estiPBN;

import PBN.BitSetPBN;
import PBN.BitSetPBNIO;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import parameterEstimation.particleSwarm.PBNSwarm;
import parameterEstimation.particleSwarm.PBNSwarmParallel;
import parameterEstimation.particleSwarm.Particle;
import parameterEstimation.particleSwarm.estiPBN.PBNFitnessFunction;
import parameterEstimation.particleSwarm.estiPBN.PBNParticle;
import userInterface.AssaConsoleLog;
import userInterface.AssaLog;

public class Estimate {
    private double stopThreshold = 0.0;
    private boolean dynamicPrecisions;
    private AssaLog assalog;

    public Estimate(AssaLog assalog) {
        this.assalog = assalog;
    }

    public void setStopThreshold(double stopThreshold) {
        this.stopThreshold = stopThreshold;
    }

    public void run(String[] fileName, String parameterFile, String propertyFile, double precision, double confidence, int simulationMethod, int m, boolean parallel, int evaluateMethod, int numberParticles, int numberIterations, int startPolicy, boolean adaptive) throws Exception {
        this.assalog.println("Parameter esimation is called. Loading models now.");
        ArrayList<BitSetPBN> pbns = new ArrayList<BitSetPBN>();
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        int i = 0;
        while (i < fileName.length) {
            BitSetPBN pbn = io.loadPBN(fileName[i]);
            pbns.add(pbn);
            ++i;
        }
        PBNFitnessFunction fitnessFunction = new PBNFitnessFunction(this.assalog);
        fitnessFunction.setEvaluateMethod(evaluateMethod);
        fitnessFunction.setPBNs(pbns);
        fitnessFunction.setParameterIndices(parameterFile);
        fitnessFunction.setProperties(propertyFile);
        fitnessFunction.setSimulationMethod(precision, confidence, simulationMethod, m);
        fitnessFunction.setMaximize(false);
        PBNParticle particle = new PBNParticle(fitnessFunction.getCumPositionIndex()[fitnessFunction.getCumPositionIndex().length - 1]);
        particle.setPosition(fitnessFunction.getLastPostion());
        PBNSwarm swarm = parallel ? new PBNSwarmParallel(numberParticles, particle, fitnessFunction, m, adaptive) : new PBNSwarm(numberParticles, particle, fitnessFunction, adaptive);
        swarm.setInertia(0.95);
        swarm.setMaxPosition(1.0);
        swarm.setMinPosition(0.0);
        swarm.setMaxMinVelocity(0.5);
        swarm.init();
        switch (startPolicy) {
            case 0: {
                break;
            }
            case 1: {
                swarm.initialPosition(fitnessFunction.getLastPostion());
                break;
            }
        }
        long start = System.nanoTime();
        i = 0;
        while (i < numberIterations) {
            this.assalog.println("Starting iteration " + i + "...");
            swarm.evolve();
            this.assalog.println(swarm.toStringStats());
            if (this.stopThreshold > swarm.getBestFitness()) break;
            ++i;
        }
        Particle[] particles = swarm.getParticles();
        int i2 = 0;
        while (i2 < swarm.getNumberOfParticles()) {
            ((PBNParticle)particles[i2]).closePW();
            ++i2;
        }
        start = System.nanoTime() - start;
        this.assalog.println("Finish estimation. Total number of iterations: " + swarm.getNumberOfEvaliations() / swarm.getNumberOfParticles() + ". Time cost: " + (double)start / 1.0E9 + " s.");
        List<Double>[] bestFittedData = swarm.getBestFittedData();
        List<Double>[] measurementData = fitnessFunction.getMeasurementData();
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(8);
        df.setMinimumFractionDigits(8);
        int i3 = 0;
        while (i3 < bestFittedData.length) {
            this.assalog.println("\nModel " + i3 + ":");
            this.assalog.print("measured:\t");
            int j = 0;
            while (j < measurementData[i3].size()) {
                this.assalog.print(String.valueOf(df.format(measurementData[i3].get(j))) + "\t");
                ++j;
            }
            this.assalog.print("\nfitted:  \t");
            j = 0;
            while (j < bestFittedData[i3].size()) {
                this.assalog.print(String.valueOf(df.format(bestFittedData[i3].get(j))) + "\t");
                ++j;
            }
            this.assalog.println();
            ++i3;
        }
    }

    public void run(String parameterFile) {
    }

    public static void main(String[] args) {
        Estimate est = new Estimate(new AssaConsoleLog());
        long start = System.currentTimeMillis();
        String[] fileName = new String[]{"PBN_50.txt"};
        String parameterFile = "parameters.txt";
        String propertyFile = "properties.txt";
        try {
            est.run(fileName, parameterFile, propertyFile, 0.01, 0.95, 0, 2, false, 0, 10, 10, 0, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

